package edu.jhu.ece.iacl.algorithms.thickness.grid;

import javax.vecmath.Point3f;

import edu.jhu.ece.iacl.jist.structures.data.Indexable;

/**
 * Graph node that can have no more than six neighbors
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class SimpleThicknessNode implements Indexable<SimpleThicknessNode>, Cloneable{
	public int i,j,k;
	private int index;
	private double innerLength=-1;
	private double outerLength=-1;
	public byte label;
	private Point3f innerPoint;
	private Point3f outerPoint;
	private Point3f location;
	private int chain=0;
	public SimpleThicknessNode(int i,int j,int k){
		this.i=i;
		this.j=j;
		this.k=k;
		location=new Point3f(i,j,k);
		outerPoint=new Point3f();
		innerPoint=new Point3f();
	}
	public SimpleThicknessNode(Point3f p){
		location=p;
		this.i=(int)Math.floor(p.x);this.j=(int)Math.floor(p.y);this.k=(int)Math.floor(p.z);

		outerPoint=new Point3f();
		innerPoint=new Point3f();
	}

	public double getNormalizedLength(){
		if(innerLength==-1||outerLength==-1){
			return 0;
		} else {
			double val=innerLength/(innerLength+outerLength);
			if(Double.isNaN(val)||Double.isInfinite(val)){
				return 0;
			} else {
				return val;
			}
		}
	}
	public SimpleThicknessNode clone(){
		SimpleThicknessNode dat=new SimpleThicknessNode(i,j,k);
		dat.index=index;
		dat.label=label;
		dat.chain=chain;
		dat.innerLength=innerLength;
		dat.outerLength=outerLength;
		dat.innerPoint=new Point3f(innerPoint);
		dat.outerPoint=new Point3f(outerPoint);

		return dat;
	}
	public Point3f getLocation(){
		return location;
	}
	public double getThickness(){
		if(innerLength==-1||outerLength==-1){
			return -1;
		} else {
			return innerLength+outerLength;
		}
	}
	public void setCorrespodence(Point3f p){
		if(EmbeddedNode.compareToInner){
			innerPoint=p;
		} else {
			outerPoint=p;
		}
	}
	public Point3f getCorrespodence(){
		if(EmbeddedNode.compareToInner){
			return innerPoint;
		} else {
			return outerPoint;
		}
	}
	public void setLength(double len){
		if(EmbeddedNode.compareToInner){
			innerLength=len;
		} else {
			outerLength=len;
		}
	}
	public double getLength(){
		if(EmbeddedNode.compareToInner){
			return innerLength;
		} else {
			return outerLength;
		}
	}
	public static void setCompareInnerLength(boolean c){
		EmbeddedNode.compareToInner=c;
	}
	public int getColumn() {
		return j;
	}
	public int getIndex() {
		return index;
	}
	public int getRow() {
		return i;
	}
	public int getSlice() {
		return k;
	}
	public void setIndex(int index) {
		this.index=index;
	}
	public void setRefPosition(int i, int j, int k) {
		this.i=i;
		this.j=j;
		this.k=k;
		location=new Point3f(i,j,k);
	}
	public void setLocation(Point3f p){
		location=p;
	}
	/*
	public boolean equals(Object obj){
		if(obj instanceof CorticalThicknessData){
			return location.equals(((CorticalThicknessData)obj).getLocation());
		} else return false;
	}
	*/
	public int compareTo(SimpleThicknessNode data) {
		return (int)Math.signum(getLength()-data.getLength());
	}
	public String toString(){
		return "("+i+","+j+","+k+","+chain+")";
	}
	/*
	public int compareTo(CorticalThicknessData data) {
		return (int)Math.signum(data.getLength()-getLength());
	}
*/
	public int getChainIndex() {
		return chain;
	}
	public void setChainIndex(int chainIndex) {
		chain=chainIndex;
	}
	public Double getValue() {
		return getLength();
	}
	public void setValue(Comparable len) {
		setLength((Double)len);
	}

}
