package edu.jhu.ece.iacl.algorithms.topology;

import edu.jhmi.rad.medic.libraries.ObjectProcessing;
import edu.jhu.ece.iacl.algorithms.VersionUtil;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataInt;

public class ConnectivityCheck extends AbstractCalculation{
	public static String getVersion() {
		return VersionUtil.parseRevisionNumber("$Revision: 1.1 $");
	}



	private ImageData vol;
	private int fgMax;
	private int bgMax;
	private int euler;
	public ConnectivityCheck(ImageData vol){
		this.vol=vol;
	}
	public ImageDataInt check(int rule,float val){
		int rows=vol.getRows();
		int cols=vol.getCols();
		int slices=vol.getSlices();
		ImageDataInt result=new ImageDataInt(rows,cols,slices);
		boolean[][][] fgmask=new boolean[rows][cols][slices];
		boolean[][][] bgmask=new boolean[rows][cols][slices];
		setLabel("Connectivity Check");
		setTotalUnits(5);
		for(int i=0;i<rows;i++){
			for(int j=0;j<cols;j++){
				for(int k=0;k<slices;k++){
					fgmask[i][j][k]=(vol.getFloat(i, j, k)>val);
					bgmask[i][j][k]=!fgmask[i][j][k];

				}
			}
		}
		incrementCompletedUnits();
		int[][][] labelsfg=null;
		int[][][] labelsbg=null;
		switch(rule){
			case ConnectivityRule.CONNECT_6_18:
				labelsfg=ObjectProcessing.connected6Object3D(fgmask);
				incrementCompletedUnits();
				labelsbg=ObjectProcessing.connected18Object3D(bgmask);
				incrementCompletedUnits();
				euler=ObjectProcessing.eulerCharacteristic(fgmask, rows,cols,slices, 6, 18);
				incrementCompletedUnits();
				break;
			case ConnectivityRule.CONNECT_6_26:
				labelsfg=ObjectProcessing.connected6Object3D(fgmask);
				incrementCompletedUnits();
				labelsbg=ObjectProcessing.connected26Object3D(bgmask);
				incrementCompletedUnits();
				euler=ObjectProcessing.eulerCharacteristic(fgmask, rows,cols,slices, 6, 26);
				incrementCompletedUnits();

				break;
			case ConnectivityRule.CONNECT_18_6:
				labelsfg=ObjectProcessing.connected18Object3D(fgmask);
				incrementCompletedUnits();
				labelsbg=ObjectProcessing.connected6Object3D(bgmask);
				incrementCompletedUnits();
				euler=ObjectProcessing.eulerCharacteristic(fgmask, rows,cols,slices, 18, 6);
				incrementCompletedUnits();

				break;
			case ConnectivityRule.CONNECT_26_6:
				labelsfg=ObjectProcessing.connected26Object3D(fgmask);
				incrementCompletedUnits();
				labelsbg=ObjectProcessing.connected6Object3D(bgmask);
				incrementCompletedUnits();
				euler=ObjectProcessing.eulerCharacteristic(fgmask, rows,cols,slices, 26, 6);
				incrementCompletedUnits();

				break;
		}
		fgMax=0;
		bgMax=0;
		if(labelsfg!=null&&labelsbg!=null){
			int[][][] resultMat=result.toArray3d();
			for(int i=0;i<rows;i++){
				for(int j=0;j<cols;j++){
					for(int k=0;k<slices;k++){
						if(fgmask[i][j][k]){
							resultMat[i][j][k]=labelsfg[i][j][k];
							fgMax=Math.max(labelsfg[i][j][k],fgMax);
						} else {
							resultMat[i][j][k]=-labelsbg[i][j][k];
							bgMax=Math.max(labelsbg[i][j][k],bgMax);
						}
					}
				}
			}
		}
		markCompleted();
		result.setName(vol.getName()+"_conn");
		return result;
	}
	public int getForegroundComponents(){
		return fgMax;
	}
	public int getBackgroundComponents(){
		return bgMax;
	}
	public int getEulerCharacteristic(){
		return euler;
	}
	public static final String toString(int rule){
        switch(rule){
    	case ConnectivityRule.CONNECT_18_6:
    		return "18-6";
    	case ConnectivityRule.CONNECT_6_18:
    		return "6-18";
    	case ConnectivityRule.CONNECT_26_6:
    		return "26-6";
    	case ConnectivityRule.CONNECT_6_26:
    		return "6-26";
    	default:
    		return "INVALID";
        }
	}
}
