package edu.jhu.ece.iacl.plugins.segmentation.cruise;

import java.awt.Dimension;
//import java.util.ArrayList;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;

import edu.jhmi.rad.medic.utilities.CropParameters;
import edu.jhmi.rad.medic.utilities.CubicVolumeCropper;
import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.plugins.classification.MedicAlgorithmToads08;
import edu.jhu.ece.iacl.plugins.measure.thickness.MedicAlgorithmThickness;
import edu.jhu.ece.iacl.plugins.segmentation.gdm.MedicAlgorithmNestedTGDM;
import edu.jhu.ece.iacl.plugins.topology.MedicAlgorithmTopologyCorrection;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
//import edu.jhu.ece.iacl.jist.structures.image.VoxelType;


public class MedicAlgorithmCRUISE extends ProcessingAlgorithm{
	MedicAlgorithmToads08 toads;
	MedicAlgorithmAnatomicallyConsistentEnhance ace;
	MedicAlgorithmNestedTGDM tgdm;
	MedicAlgorithmGradVecFlow gvfCentral;
	MedicAlgorithmTopologyCorrection topoCorrect;
	MedicAlgorithmThickness thickness;
	ParamPointInteger offset;
	ParamPointInteger dim;
	ParamCollection cropParams;
	ParamSurface uncroppedInnerSurf,uncroppedCentralSurf,uncroppedOuterSurf;
	ParamVolume croppedGM,croppedWM,croppedInitWM,uncroppedInner,uncroppedCentral,uncroppedOuter,uncroppedEnhancedGM;

	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	
	protected void createInputParameters(ParamCollection inputParams) {
		gvfCentral = new MedicAlgorithmGradVecFlow();
		gvfCentral.getInput().getFirstChildByName("Volume").setHidden(true);		
		toads = new MedicAlgorithmToads08();
		toads.getInput().getFirstChildByName("Output images").setHidden(true);
		toads.getInput().getFirstChildByName("Scale Output by 255").setHidden(true);
		((ParamOption)toads.getInput().getFirstChildByName("Output images")).setValue(2);

		topoCorrect = new MedicAlgorithmTopologyCorrection();
		topoCorrect.getInput().getFirstChildByName("Volume").setHidden(true);
		topoCorrect.getInput().getFirstChildByName("Mask").setHidden(true);
		topoCorrect.getInput().getFirstChildByName("Connectivity (Foreground,Background)").setHidden(true);
		((ParamOption)topoCorrect.getInput().getFirstChildByName("Propagation Direction")).setValue(1);
		ace = new MedicAlgorithmAnatomicallyConsistentEnhance();
		tgdm = new MedicAlgorithmNestedTGDM();
		thickness = new MedicAlgorithmThickness();
		thickness.getInput().getFirstChildByName("Inner Level Set").setHidden(true);
		thickness.getInput().getFirstChildByName("Outer Level Set").setHidden(true);
//		thickness.getInput().getFirstChildByName("Approximation Method").setHidden(true);
		((ParamOption)thickness.getInput().getFirstChildByName("Approximation Method")).setValue("Level Set Subtraction");

		
		inputParams.add(toads.getInput());
		inputParams.add(topoCorrect.getInput());
		inputParams.add(gvfCentral.getInput());
		
		inputParams.add(ace.getInput());
		inputParams.add(tgdm.getInput());
		inputParams.add(thickness.getInput());
		tgdm.getInput().getFirstChildByName("Connectivity (Foreground,Background)").setHidden(true);
		tgdm.getInput().getFirstChildByName("Data").setHidden(true);
		((ParamInteger)tgdm.getInput().getFirstChildByName("Iterations for Initial Smoothing")).setValue(6);
		((ParamDouble)tgdm.getInput().getFirstChildByName("Initial Smoothing Curvature Force")).setValue(1);
		ace.getInput().getFirstChildByName("Gray Matter").setHidden(true);
		ace.getInput().getFirstChildByName("White Matter").setHidden(true);
		
		inputParams.setName("CRUISE");
		inputParams.setLabel("CRUISE");

		this.setPreferredSize(new Dimension(400,562));

		inputParams.setPackage("IACL");
		inputParams.setCategory("Segmentation.CRUISE");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
		info.add(ReferencedPapers.cruise);
		info.add(PrinceGroupAuthors.xiaoHan);
		info.add(PrinceGroupAuthors.dzungPham);
		info.add(PrinceGroupAuthors.chenyangXu);
		info.add(PrinceGroupAuthors.duyguTosun);
		info.add(PrinceGroupAuthors.pierreLouisBazin);
    	info.add(PrinceGroupAuthors.blakeLucas);
    	info.setDescription("TOADS-CRUISE pipeline generating cortical surfaces and thickness statistics.");
    	info.setLongDescription("Full TOADS-CRUISE pipeline. It takes a 3D volume, does  cortical segmentation using TOADS2007. Then an Anatomically Consistent Enhancement(ACE) is done to remove partial voluming in the deep sulci. The cortical surfaces are generated by a Topology Preserving Geoemtric Deformable Model(TGDM).");
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {

		outputParams.add(toads.getOutput());
		outputParams.add(topoCorrect.getOutput());
		outputParams.add(gvfCentral.getOutput());

		outputParams.add(ace.getOutput());
		outputParams.add(tgdm.getOutput());
		
		tgdm.getOutput().getFirstChildByName("Inner Surface").setHidden(true);
		tgdm.getOutput().getFirstChildByName("Central Surface").setHidden(true);
		tgdm.getOutput().getFirstChildByName("Outer Surface").setHidden(true);
		tgdm.getOutput().getFirstChildByName("Inner Level Set").setHidden(true);
		tgdm.getOutput().getFirstChildByName("Central Level Set").setHidden(true);
		tgdm.getOutput().getFirstChildByName("Outer Level Set").setHidden(true);
		
		cropParams=new ParamCollection("uncropped");
		cropParams.setLabel("Cropping");
//		cropParams.add(croppedInitWM=new ParamVolume("Cropped Initial WM"));
//		cropParams.add(croppedGM=new ParamVolume("Cropped GM"));
//		cropParams.add(croppedWM=new ParamVolume("Cropped WM"));
		cropParams.add(uncroppedEnhancedGM=new ParamVolume("Uncropped ACE enhanced GM"));
		cropParams.add(uncroppedInnerSurf=new ParamSurface("TGDM Inner Surface"));
		cropParams.add(uncroppedCentralSurf=new ParamSurface("TGDM Central Surface"));
		cropParams.add(uncroppedOuterSurf=new ParamSurface("TGDM Outer Surface"));
		cropParams.add(uncroppedInner=new ParamVolume("TGDM Inner Level Set"));
		cropParams.add(uncroppedCentral=new ParamVolume("TGDM Central Level Set"));
		cropParams.add(uncroppedOuter=new ParamVolume("TGDM Outer Level Set"));
		cropParams.add(offset=new ParamPointInteger("Offset"));
		cropParams.add(dim=new ParamPointInteger("Dimension"));
		outputParams.add(cropParams);
		outputParams.add(thickness.getOutput());
		outputParams.setName("cruise");
		outputParams.setLabel("CRUISE");
	}

	@Override
	protected void execute(CalculationMonitor monitor) {
		ImageData iso=((ParamVolume)toads.getInput().getFirstChildByName("Image to segment")).getImageData();
		int rows=iso.getRows();
		int cols=iso.getCols();
		int slices=iso.getSlices();
		CubicVolumeCropper cropper=new CubicVolumeCropper();
		int conn=((ParamOption)toads.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).getIndex();
		toads.runAlgorithm(monitor);
		((ParamOption)tgdm.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).setValue(conn);
	
		ImageData gm=((ParamVolume)toads.getOutput().getFirstChildByName("Cortical GM Membership")).getImageData();
		ImageData wmfill=((ParamVolume)toads.getOutput().getFirstChildByName("Filled WM Membership")).getImageData();
//		ImageData wmmask=((ParamVolume)toads.getOutput().getFirstChildByName("WM mask")).getImageData();
		
		//Connectivity rule is reversed for topology correction!
		int bcon=0;
		switch(conn){
			case 0:bcon=1;break;
			case 1:bcon=0;break;
			case 2:bcon=3;break;
			case 3:bcon=2;break;
		}
		((ParamOption)topoCorrect.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).setValue(bcon);
		((ParamVolume)topoCorrect.getInput().getFirstChildByName("Volume")).setValue(wmfill);
		
		topoCorrect.runAlgorithm(monitor);
		ImageData mask=((ParamVolume)topoCorrect.getOutput().getFirstChildByName("Topologically Correct Volume")).getImageData();

		gm=cropper.crop(gm,0, 5);
//		croppedGM.setValue(gm);
		CropParameters crops=cropper.getLastCropParams();
		wmfill=cropper.crop(wmfill,crops);
//		croppedWM.setValue(wmfill);
		mask=cropper.crop(mask,crops);
//		croppedInitWM.setValue(mask);
		((ParamVolume)ace.getInput().getFirstChildByName("Gray Matter")).setValue(gm);
		((ParamVolume)ace.getInput().getFirstChildByName("White Matter")).setValue(wmfill);
		ace.runAlgorithm(monitor);
		ImageData thinnedcsf=((ParamVolume)ace.getOutput().getFirstChildByName("Thinned Skeleton")).getImageData();
		ImageData enhancedgm=((ParamVolume)ace.getOutput().getFirstChildByName("Enhanced GM")).getImageData();
		((ParamVolume)gvfCentral.getInput().getFirstChildByName("Volume")).setValue(enhancedgm);
		gvfCentral.runAlgorithm(monitor);		
		ImageData gmvecfield=((ParamVolume)gvfCentral.getOutput().getFirstChildByName("Vector Field")).getImageData();


		((ParamVolume)tgdm.getInput().getFirstChildByName("Initial Level Set")).setValue(mask);
		((ParamVolume)tgdm.getInput().getFirstChildByName("White Matter Membership")).setValue(wmfill);
		((ParamVolume)tgdm.getInput().getFirstChildByName("ACE Gray Matter Membership")).setValue(enhancedgm);	
		((ParamVolume)tgdm.getInput().getFirstChildByName("Gray Matter Membership")).setValue(gm);
		
		((ParamVolume)tgdm.getInput().getFirstChildByName(("Thinned ACE Skeleton"))).setValue(thinnedcsf);
		((ParamVolume)tgdm.getInput().getFirstChildByName(("Gradient Vector Field"))).setValue(gmvecfield);
		tgdm.runAlgorithm(monitor);
		EmbeddedSurface surf=((ParamSurface)tgdm.getOutput().getFirstChildByName("Inner Surface")).getSurface();
		if(surf!=null){
			Point3f offset = new Point3f(crops.xmin, crops.ymin, crops.zmin);
			surf.translate(offset);
			uncroppedInnerSurf.setValue(surf);
		}
		surf=((ParamSurface)tgdm.getOutput().getFirstChildByName("Central Surface")).getSurface();
		if(surf!=null){
			Point3f offset = new Point3f(crops.xmin, crops.ymin, crops.zmin);
			surf.translate(offset);
			uncroppedCentralSurf.setValue(surf);
		}
		surf=((ParamSurface)tgdm.getOutput().getFirstChildByName("Outer Surface")).getSurface();
		if(surf!=null){
			Point3f offset = new Point3f(crops.xmin, crops.ymin, crops.zmin);
			surf.translate(offset);
			uncroppedOuterSurf.setValue(surf);
		}
		
		ImageDataMipav inner=new ImageDataMipav(((ParamVolume)tgdm.getOutput().getFirstChildByName("Inner Level Set")).getImageData());
		ImageDataMipav central=new ImageDataMipav(((ParamVolume)tgdm.getOutput().getFirstChildByName("Central Level Set")).getImageData());
		ImageDataMipav outer=new ImageDataMipav(((ParamVolume)tgdm.getOutput().getFirstChildByName("Outer Level Set")).getImageData());
		Point3i d=new Point3i(crops.getCroppedRows(),crops.getCroppedCols(),crops.getCroppedSlices());
		Point3i off=new Point3i(crops.xmin,crops.ymin,crops.zmin);
		CropParameters uncrop=new CropParameters(rows,cols,slices,1,off.x,d.x+off.x-1,off.y,d.y+off.y-1,off.z,d.z+off.z-1,20);
		CropParameters uncrop2=new CropParameters(rows,cols,slices,1,off.x,d.x+off.x-1,off.y,d.y+off.y-1,off.z,d.z+off.z-1,0);

		uncroppedInner.setValue(cropper.uncrop(inner,uncrop));
		uncroppedCentral.setValue(cropper.uncrop(central,uncrop));
		uncroppedOuter.setValue(cropper.uncrop(outer,uncrop));
		uncroppedEnhancedGM.setValue(cropper.uncrop(enhancedgm,uncrop2));
				
		offset.setValue(off);
		dim.setValue(d);
		
		ImageData inner1=((ParamVolume)tgdm.getOutput().getFirstChildByName("Inner Level Set")).getImageData();
		ImageData outer1=((ParamVolume)tgdm.getOutput().getFirstChildByName("Outer Level Set")).getImageData();
		((ParamVolume)thickness.getInput().getFirstChildByName("Inner Level Set")).setValue(inner1);
		((ParamVolume)thickness.getInput().getFirstChildByName("Outer Level Set")).setValue(outer1);
		thickness.runAlgorithm(monitor);
	}

}


