/**
 * 
 */
package edu.jhu.ece.iacl.plugins.topology;

import java.util.List;

import edu.jhmi.rad.medic.algorithms.AlgorithmObjectTopology;
import edu.jhmi.rad.medic.methods.MultipleToadAtlas;
import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipavWrapper;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataUByte;

import gov.nih.mipav.model.structures.ModelImage;
import gov.nih.mipav.model.structures.ModelStorageBase;
import gov.nih.mipav.view.ViewUserInterface;
import gov.nih.mipav.view.dialogs.JDialogBase;

/**
 * @author Blake Lucas (bclucas@jhu.edu)
 */
public class MedicAlgorithmObjectTopology extends ProcessingAlgorithm {
	private String type = "-- topology measures --";
	private static final String[] types = { "Euler", "Connectivity", "Well_Composed", "Critical_Points", "T-erosion", "TL-erosion",
			"T-dilation", "TL-dilation", "T-objects", "T-enveloppe", "Add_Points", "Remove_Points", "ID_Objects",
			"Main_Object", "C-wrapping", "Find_Slices", "Boundaries", "Full_Euler", "Full_Euler_4", "Full_Composed_4",
			"Distance_function", "Voronoi_FT", "Distance_smoothing", "Curvature", "Convexity_score",
			"Structure_measurements", "Full_structure" };
	private String[] opt = { "3D", "2D" };
	private static String[] val = { "26", "18", "6", "8", "4" };
	private static String[] bk = { "6", "18", "26", "4", "8" };
	private ParamVolume origVol, resultVol;
	private ParamOption algoSelection;
	private ParamDouble threshold;
	private ParamOption fgConn;
	private ParamOption bgConn;
	private ParamInteger iters;
	private ParamBoolean reverse;

	private static final String revnum = AlgorithmObjectTopology.get_version();

	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(origVol = new ParamVolume("Original Volume"));
		inputParams.add(algoSelection = new ParamOption("Algorithm Method", types));
		inputParams.add(threshold=new ParamDouble("Threshold",0.5));
		inputParams.add(reverse=new ParamBoolean("Reverse FG/BG",false));
		inputParams.add(fgConn = new ParamOption("Foreground Connectivity", val));
		inputParams.add(bgConn = new ParamOption("Background Connectivity", bk));
		inputParams.add(iters = new ParamInteger("Iterations", 0,10000,1));

		inputParams.setName("object_topology");
		inputParams.setLabel("Object Topology");

		inputParams.setPackage("IACL");
		inputParams.setCategory("Measurement.Volume");

		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.setVersion(revnum);
		info.setEditable(false);
		info.add(PrinceGroupAuthors.pierreLouisBazin);
		info.add(PrinceGroupAuthors.blakeLucas);
		info.setDescription("Compute various metrics as they relate to connectivity.");
		info.setLongDescription("This is a wrapper around Pilou's object topology metric algorithm.");
		
		info.setStatus(DevelopmentStatus.RC);
	}

	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(resultVol = new ParamVolume("Result Volume"));
	}

	protected class ObjectTopologyWrapper extends AbstractCalculation {
		private AlgorithmObjectTopologyWrapper algo = null;
		private ModelImage image; // source image
		private ModelImage resultImage = null; // result image
		private int destExtents[];
		// parameters
		private int objId = 1;
		private int bgId = 0;
		private int dimension = 3;
		private int objConnect = 26;
		private int bgConnect = 6;
		private int iterations = 1;

		public ObjectTopologyWrapper() {
			setLabel("Object Topology");
		}

		public void execute() {
			ImageDataMipav vol=new ImageDataMipav(origVol.getImageData());
			int rows,cols,slices;
			ImageDataUByte mask=new ImageDataUByte(rows=vol.getRows(),cols=vol.getCols(),slices=vol.getSlices());
			mask.setName(vol.getName()+"_mask");
			float thresh=threshold.getFloat();
			if(reverse.getValue()){
				objId=0;
				bgId=1;
			}
			for(int i=0;i<rows;i++){
				for(int j=0;j<cols;j++){
					for(int k=0;k<slices;k++){
						mask.set(i, j, k, (vol.getFloat(i, j, k)<=thresh)?1:0);
					}
				}
			}
			iterations=iters.getInt();
			objConnect=Integer.parseInt(fgConn.getValue());
			bgConnect=Integer.parseInt(bgConn.getValue());
			type=algoSelection.getValue();

			System.out.println(mask.toString());
			image=mask.getModelImageCopy();
			String name = (image.getImageName()+ "_tf");
			destExtents = new int[3];
			destExtents[0] = image.getExtents()[0];
			destExtents[1] = image.getExtents()[1];
			destExtents[2] = image.getExtents()[2];
			if (type.equals("Distance_function") || type.equals("Curvature") || type.equals("Voronoi_FT")
					|| type.equals("Distance_smoothing") || type.equals("Convexity_score")) {
				resultImage = new ModelImage(ModelStorageBase.FLOAT, destExtents, (image
						.getImageName()+ "_OT"));
			} else {
				resultImage = new ModelImage(ModelStorageBase.BYTE, destExtents, (image
						.getImageName()+ "_OT"));
			}
			// Create algorithm
			algo = new AlgorithmObjectTopologyWrapper(resultImage, image, type, objId, bgId, iterations, dimension,
					objConnect, bgConnect);
			algo.setObserver(this);
			algo.run();
			resultVol.setValue(new ImageDataMipavWrapper(resultImage));
			markCompleted();
			image.disposeLocal();
		}
	}

	protected class AlgorithmObjectTopologyWrapper extends AlgorithmObjectTopology {
		/**
		 * @param destImage_
		 * @param srcImage_
		 * @param type_
		 * @param objId_
		 * @param bgId_
		 * @param iter_
		 * @param dim_
		 * @param co_
		 * @param cb_
		 */
		public AlgorithmObjectTopologyWrapper(ModelImage destImage_, ModelImage srcImage_, String type_, int objId_,
				int bgId_, int iter_, int dim_, int co_, int cb_) {
			super(destImage_, srcImage_, type_, objId_, bgId_, iter_, dim_, co_, cb_);
			// TODO Auto-generated constructor stub
		}

		protected AbstractCalculation observer;

		public void setObserver(AbstractCalculation observer) {
			this.observer = observer;
		}

		public void runAlgorithm() {
			observer.setTotalUnits(100);
			super.runAlgorithm();
			observer.markCompleted();
		}

		/**
		 * Notifies all listeners that have registered interest for notification
		 * on this event type.
		 * 
		 * @param value
		 *            the value of the progress bar.
		 */
		protected void fireProgressStateChanged(int value) {
			super.fireProgressStateChanged(value);
			observer.setCompletedUnits(value);
		}

		/**
		 * Updates listeners of progress status. Without actually changing the
		 * numerical value
		 * 
		 * @param imageName
		 *            the name of the image
		 * @param message
		 *            the new message to display
		 */
		protected void fireProgressStateChanged(String imageName, String message) {
			super.fireProgressStateChanged(imageName, message);
			observer.setLabel(message);
		}
	}

	public void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		ObjectTopologyWrapper objTopo = new ObjectTopologyWrapper();
		monitor.observe(objTopo);
		objTopo.execute();
	}
}
