package edu.jhu.ece.iacl.algorithms.graphics.locator.kdtree;

/**
 * A bounding box edge is used to split a bounding box in half along its major
 * axis.
 * 
 * @author Blake Lucas
 * 
 */
public class BBoxEdge implements Comparable<BBoxEdge> {
	private double val;
	private boolean start;
	private BBox box;
	/**
	 * Get bounding box
	 * @return bounding box
	 */
	public BBox getBox() {
		return box;
	}
	/**
	 * Get metric for bounding box edge
	 * @return metric
	 */
	public double getValue() {
		return val;
	}
	/**
	 * Is this edge the minimum bounding box edge
	 * @return true if minimum
	 */
	public boolean isMin() {
		return start;
	}
	/**
	 * Set bounding box
	 * @param b bounding box
	 * @param dim dimension (X->0,Y->1,Z->2)
	 * @param start true if minimum edge
	 */
	public void set(BBox b, int dim, boolean start) {
		box = b;
		this.start = start;
		if (b == null)
			return;
		switch (dim) {
		case 0:
			val = (start) ? b.getMin().x : b.getMax().x;
			break;
		case 1:
			val = (start) ? b.getMin().y : b.getMax().y;
			break;
		case 2:
			val = (start) ? b.getMin().z : b.getMax().z;
			break;
		default:
			val = 0;
		}
	}
	/**
	 * Constructor
	 */
	public BBoxEdge() {
		box = null;
		val = 0;
		start = true;
	}

	public BBoxEdge clone() {
		BBoxEdge e = new BBoxEdge();
		e.val = val;
		e.start = start;
		e.box = box;
		return e;
	}
	/**
	 * Comapre bounding box edges by metric.
	 */
	public int compareTo(BBoxEdge e1) {
		if (this.val == e1.val) {
			if (this.start && !e1.start) {
				return -1;
			} else if (!this.start && e1.start) {
				return 1;
			} else {
				return 0;
			}
		} else {
			return (int) Math.signum(this.val - e1.val);
		}
	}

}
