package edu.jhu.ece.iacl.plugins.mapping;

import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.thickness.ClosestPointThickness;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamSurface;


public class MedicAlgorithmInterSurfPointMap extends ProcessingAlgorithm{
	private ParamSurface source,target,targetMapped,sourceMapped;
	private static final String cvsversion = "$Revision: 1.1 $".replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String revnum = ClosestPointThickness.getVersion();
	private static final String shortDescription = "Find closest point on opposing surface and record its location and face id.\n"
	+ "Algorithm Version: " + revnum + "\n"
	+ "GUI Version:" + cvsversion + "\n";
	private static final String longDescription = "This mapping method works best on partially inflated surfaces that have been affine and deformably registered. The surface generated by this method is intended to be used by remesh or remap coupled surfaces.";


	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(source=new ParamSurface("Source"));
		inputParams.add(target=new ParamSurface("Target"));


		inputParams.setPackage("IACL");
		inputParams.setCategory("Mapping.Point");
		inputParams.setLabel("Inter-Surface Point Map");
		inputParams.setName("Inter-Surface_Point_Map");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.add(PrinceGroupAuthors.blakeLucas);
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}


	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(sourceMapped=new ParamSurface("Mapped Source"));
		outputParams.add(targetMapped=new ParamSurface("Mapped Target"));
	}


	protected void execute(CalculationMonitor monitor) {
		ClosestPointThickness closestPoint = new ClosestPointThickness(0, 0, 0);
		monitor.observe(closestPoint);
		closestPoint.solve(source.getSurface(), target.getSurface());
		sourceMapped.setValue(closestPoint.getInnerSurface());
		targetMapped.setValue(closestPoint.getOuterSurface());
	}
}
