/*
 *
 */
package edu.jhu.ece.iacl.plugins.registration;

import java.util.ArrayList;
import java.util.List;

import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
import edu.jhu.ece.iacl.algorithms.icp.IterativeClosestPointRegistration;
import edu.jhu.ece.iacl.algorithms.icp.IterativeClosestPointRegistration.DegreesOfFreedom;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;

import Jama.Matrix;


/*
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class MedicAlgorithmIterativeClosestPointBatch extends ProcessingAlgorithm{
	ParamSurfaceCollection sourceSurfList;
	ParamSurface targetSurf;
	ParamSurfaceCollection transSurfList;
	ParamInteger levels;
	ParamDouble retainAmount;
	ParamDouble errorThresh;
	ParamOption degOfFreedom;
	ParamMatrix transMat;
	ParamBoolean initWithPCA;
	ParamInteger maxIters;

	private static final String cvsversion = "$Revision: 1.1 $".replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String revnum = IterativeClosestPointRegistration.getVersion();
	private static final String shortDescription = "A surface-to-surface global registration algorithm.\n"
		+ "Algorithm Version: " + revnum + "\n"
		+ "GUI Version:" + cvsversion + "\n";
	private static final String longDescription = "";


	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(sourceSurfList = new ParamSurfaceCollection("Source Surface List"));
		inputParams.add(targetSurf = new ParamSurface("Target Surface"));
		inputParams.add(degOfFreedom = new ParamOption("Degrees of Freedom", new String[]{"Translation", "Rigid", "Rigid and Global Scale", "Affine"}));
		degOfFreedom.setValue(1);
		inputParams.add(levels = new ParamInteger("Multi-Resolution Levels", 1, 10000, 6));
		inputParams.add(retainAmount = new ParamDouble("Trimmed Least Sqrs Retainment", 0, 1, 0.75));
		inputParams.add(errorThresh = new ParamDouble("Error Threshold", 0, 1000000, 5E-3));
		inputParams.add(maxIters = new ParamInteger("Max Iterations", 0, 1000000, 20));
		inputParams.add(initWithPCA = new ParamBoolean("Start with PCA Alignment", true));


		inputParams.setPackage("IACL");
		inputParams.setCategory("Registration.Surface");
		inputParams.setLabel("Iterative Closest Point Surface Registration");
		inputParams.setName("Iterative_Closest_Point_Surface_Registration");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.add(PrinceGroupAuthors.blakeLucas);
		info.add(ReferencedPapers.trimmedICP);
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}


	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(transSurfList = new ParamSurfaceCollection("Transformed Source Surface"));
		outputParams.add(transMat = new ParamMatrix("Transformation Matrix", 4, 4));
	}


	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		List<EmbeddedSurface> sourceList;
		sourceList = sourceSurfList.getSurfaceList();
		ArrayList<EmbeddedSurface> outputList = new ArrayList<EmbeddedSurface>();
			for (int i = 0; i < sourceList.size(); i++){
			IterativeClosestPointRegistration icp = new IterativeClosestPointRegistration();
			monitor.observe(icp);
			EmbeddedSurface currentSurface = sourceList.get(i);
			EmbeddedSurface transSurf = icp.solve(currentSurface, targetSurf.getSurface(), DegreesOfFreedom.values()[degOfFreedom.getIndex()], levels.getInt(), retainAmount.getDouble(), errorThresh.getDouble(), maxIters.getInt(), initWithPCA.getValue());
			transSurf.setName(currentSurface.getName() + targetSurf.getSurface().getName());
			Matrix m = icp.getTransformationMatrix();
			outputList.add(transSurf);
			transMat.setValue(m);
		}
		transSurfList.setValue(outputList);
	}
}
