cmake_minimum_required(VERSION 2.8)

FIND_PACKAGE ( Java )

# Since not all dashboard are running cmake 2.8.1, let's set the legacy variable
IF("${CMAKE_MAJOR_VERSION}.${CMAKE_MINOR_VERSION}.${CMAKE_PATCH_VERSION}" VERSION_LESS "2.8.1")
  SET(Java_JAVA_EXECUTABLE ${JAVA_RUNTIME})
  SET(Java_JAVAC_EXECUTABLE ${JAVA_COMPILE})
  SET(Java_JAR_EXECUTABLE ${JAVA_ARCHIVE})
ENDIF()

IF(NOT Java_JAR_EXECUTABLE)
  MESSAGE(STATUS "Skipping Jarring stuff up  - Set Java_JAR_EXECUTABLE variable to fix the problem")
  RETURN()
ENDIF()

if (NOT sourceDir)
  message ( FATAL_ERROR "Variable sourceDir not defined" )
endif (NOT sourceDir)

MESSAGE(STATUS "**********JarExtract.cmake: CMAKE_CURRENT_BINARY_DIR =  ${CMAKE_CURRENT_BINARY_DIR}, CMAKE_CURRENT_SOURCE_DIR = ${CMAKE_CURRENT_SOURCE_DIR}\nCMAKE_SOURCE_DIR = ${CMAKE_SOURCE_DIR}, CMAKE_BINARY_DIR = ${CMAKE_BINARY_DIR}")
MESSAGE(STATUS "sourceDir = ${sourceDir}")

# have to extract the lib .jar files so that we can have just .class files in the big jar file
#file(GLOB_RECURSE BaseLibJarList RELATIVE ${CMAKE_BINARY_DIR}/jist/JIST/lib *.jar)
#file(GLOB_RECURSE PluginLibJarList RELATIVE ${CMAKE_BINARY_DIR}/jistPlugins/JIST/lib *.jar)
#file(GLOB_RECURSE BaseLibJarList ${sourceDir}/../../../ *.jar)

set (LibJarList
${sourceDir}/../../../jist/JIST/lib/commons-cli-1.2.jar
${sourceDir}/../../../jist/JIST/lib/drmaa.jar
${sourceDir}/../../../jist/JIST/lib/jgraph-5.12.2.1.jar
${sourceDir}/../../../jist/JIST/lib/opencsv-1.8.jar
${sourceDir}/../../../jist/JIST/lib/xom-1.2.1.jar
${sourceDir}/../../../jist/JIST/lib/xpp3-1.1.4c.jar
${sourceDir}/../../../jist/JIST/lib/xstream-1.1.3.jar
${sourceDir}/../../../jistPlugins/JIST/lib/arpack_combo-0.1.jar
${sourceDir}/../../../jistPlugins/JIST/lib/core.jar
${sourceDir}/../../../jistPlugins/JIST/lib/custom-plugins-library.jar
${sourceDir}/../../../jistPlugins/JIST/lib/jsci-astro-0.943.jar
${sourceDir}/../../../jistPlugins/JIST/lib/jsci-beans-0.943.jar
${sourceDir}/../../../jistPlugins/JIST/lib/jsci-bio-0.943.jar
${sourceDir}/../../../jistPlugins/JIST/lib/jsci-core-0.943.jar
${sourceDir}/../../../jistPlugins/JIST/lib/jsci-instr-0.943.jar
${sourceDir}/../../../jistPlugins/JIST/lib/jsci-mathmlimpl-0.943.jar
${sourceDir}/../../../jistPlugins/JIST/lib/jsci-sci-0.943.jar
${sourceDir}/../../../jistPlugins/JIST/lib/jsci-wavelet-0.943.jar
${sourceDir}/../../../jistPlugins/JIST/lib/jsci-xtra-0.943.jar
${sourceDir}/../../../jistPlugins/JIST/lib/mtj-0.9.12.jar
${sourceDir}/../../../jistPlugins/JIST/lib/netlib-java-0.9.1.jar
${sourceDir}/../../../jistPlugins/JIST/lib/opale-v1b8.jar
${sourceDir}/../../../jistPlugins/JIST/lib/ptolemy-ptII7-0-1.jar
${sourceDir}/../../../jistPlugins/JIST/lib/quickhull3d.jar
)
#message (STATUS "JarExtract.cmake: LibJarList=\n${LibJarList}")
file(MAKE_DIRECTORY  ${CMAKE_CURRENT_BINARY_DIR}/jarextract)

foreach (jarfile ${LibJarList}) 
  message (STATUS "JarExtract.cmake: jarfile = ${jarfile}")
  # skip any SPECTRE_SUPER.jar that was already created and was globbed into the list
  if (NOT ${jarfile} STREQUAL ${CMAKE_CURRENT_BINARY_DIR}/SPECTRE_SUPER.jar)
    execute_process(
        COMMAND ${Java_JAR_EXECUTABLE} xf ${jarfile}
        WORKING_DIRECTORY  ${CMAKE_CURRENT_BINARY_DIR}/jarextract
    )
  endif()
endforeach()

# now remove the META-INF dir
message(STATUS "********JarExtract.cmake; removing directory ${CMAKE_CURRENT_BINARY_DIR}/jarextract/META-INF")
execute_process(
  COMMAND ${CMAKE_COMMAND} -E remove_directory "${CMAKE_CURRENT_BINARY_DIR}/jarextract/META-INF"
)
