package edu.jhmi.rad.medic.floatvoi;

import edu.jhmi.rad.medic.visualization.framework.DrawParam;
import edu.jhmi.rad.medic.visualization.framework.OpenGLHelper;
import edu.jhmi.rad.medic.visualization.models.*;
import edu.jhmi.rad.medic.visualization.primitives.*;
import edu.jhmi.rad.medic.visualization.ui.ProgressBarDialog;

import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;

import gov.nih.mipav.view.ViewJComponentEditImage;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;


import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.FPSAnimator;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

/**
 * @author Bhaskar Kishore (bhaskar@jhu.edu)
 */
@SuppressWarnings("serial")
public class JSurfaceFrame extends JFrame implements WindowListener, ActionListener, GLEventListener, ChangeListener, MouseMotionListener, MouseListener,  MouseWheelListener {
	private JDialogFloatVoi jdvf;
	private TriangleMesh mesh;
	private Container c;
	private JMenuItem saveDistanceMenuItem;
	private GLU glu;
  	private JSlider opacitySlider;
  	private JPanel renderPanel;
  	private JCheckBoxMenuItem bBoxCheck;
  	private JCheckBoxMenuItem edgeCheck;
  	private JCheckBoxMenuItem drawOutline;
  	private JMenuItem computeOutline;
  	private JMenuItem outlineColorSelect;
  	private ArrayList<JRadioButtonMenuItem> lineSize;
  	private Vector<Vector<Line>> linesPerSlice;
  	private JCheckBoxMenuItem bEnableAntiAlias;
  	
  	private GLCanvas canvas;
  	private Animator animator;
	private FPSAnimator fpsAnimator;
  	private Point3f[] bBox;
  	private int mouseButton = 1;
	private boolean windowClosed = false;
	
	private int lineDrawWidth = 1;

  	private final int HEIGHT 	= 350;
	private final int WIDTH		= 300;

	private final int GLWIDTH	= 300;
	private final int GLHEIGHT 	= 300;

  	private Color outlineColor = Color.cyan;

  	private float eyeZ = 0.0f;

  	//Rotation Stuff
  	private Matrix4f LastRotMat = new Matrix4f();
  	private Matrix4f CurRotMat	= new Matrix4f();
  	private float[] mat			= new float[16];
  	private final Object lock	= new Object();
  	private ArcBall arcBall		= new ArcBall(GLWIDTH, GLHEIGHT);

  	private GLUquadric quadric;
  	ViewJComponentEditImage image;
  	int[] extents;
  	
  	float position[] = new float[]{0.0f, 0.0f, 500.0f,  0.0f};


	public JSurfaceFrame(JDialogFloatVoi pvar, TriangleMesh mvar, ViewJComponentEditImage iimage, int[] iextents) {
		super();		
		mesh = mvar;
		jdvf = pvar;

		extents = iextents;
		image= iimage;

		bBox = new Point3f[2];

		mesh.computeBoundingBox();

		bBox[0] = mesh.getBoundingBox().getMinCoords();
		bBox[1] = mesh.getBoundingBox().getMaxCoords();
		linesPerSlice = new Vector<Vector<Line>>();


		eyeZ = 300.f;
		guiSetup();
		glSetup();
		pack();
		setVisible(true);
		addWindowListener(this);
		setSize(WIDTH, HEIGHT);
	}

	protected void finalize() {
		System.out.println("Finalizer");

	}

	private void guiSetup() {
		c = getContentPane();
		c.setLayout( new BorderLayout() );

		JPopupMenu.setDefaultLightWeightPopupEnabled(false);
		//Setup menu bar
		JMenuBar menuBar = new JMenuBar();
		JMenu menu  = new JMenu("File");
		JMenu menu2 = new JMenu("View");
		JMenu menu3 = new JMenu("Outline");

		menu2.setMnemonic(KeyEvent.VK_V);
		menu.setMnemonic(KeyEvent.VK_F);

		// Add Save
		saveDistanceMenuItem = new JMenuItem("Save Distance Computation", KeyEvent.VK_S);
		saveDistanceMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, ActionEvent.ALT_MASK));
		saveDistanceMenuItem.addActionListener(this);
		menu.add(saveDistanceMenuItem);
		if(jdvf != null)
			menuBar.add(menu);

		computeOutline = new  JMenuItem("Compute Outline");
		computeOutline.addActionListener(this);
		menu3.add(computeOutline);

		drawOutline = new JCheckBoxMenuItem("Show Outline");
		drawOutline.addActionListener(this);
		menu3.add(drawOutline);
		
		outlineColorSelect = new JMenuItem("Change Color", KeyEvent.VK_C);
		outlineColorSelect.addActionListener(this);
		outlineColorSelect.setForeground(outlineColor);
		menu3.add(outlineColorSelect);
		
		menu3.addSeparator();
		
		bEnableAntiAlias = new JCheckBoxMenuItem("Enable Anti-Alias");
		//bEnableAntiAlias.addActionListener(this);
		menu3.add(bEnableAntiAlias);
		
		menu3.addSeparator();
		ButtonGroup sizeGroup = new ButtonGroup();
		lineSize = new ArrayList<JRadioButtonMenuItem>();
		for(int i = 0 ; i < 5; ++i) {
			JRadioButtonMenuItem button = new JRadioButtonMenuItem ("Line Width : " + (i+1));
			sizeGroup.add(button);
			menu3.add(button);
			button.addActionListener(this);
			lineSize.add(button);
		}
		lineSize.get(0).setSelected(true);
		
		bBoxCheck = new JCheckBoxMenuItem("Show Bounding Box");
		bBoxCheck.addActionListener(this);
		bBoxCheck.setSelected(true);
		menu2.add(bBoxCheck);

		edgeCheck = new JCheckBoxMenuItem("Show Edges");
		edgeCheck.addActionListener(this);
		menu2.add(edgeCheck);
		menuBar.add(menu2);
		if(image != null)
			menuBar.add(menu3);

		setJMenuBar(menuBar);

		if(jdvf != null)
			jdvf.addWindowListener(this);
		addWindowListener(this);
		setTitle(mesh.getName());

		JPanel optionsPanel = new JPanel();
		optionsPanel.setLayout(new FlowLayout());
		optionsPanel.setPreferredSize(new Dimension(WIDTH, HEIGHT-GLHEIGHT));

		opacitySlider = new JSlider(JSlider.HORIZONTAL, 0, 100, 100);
		opacitySlider.setMajorTickSpacing(10);
		opacitySlider.setMinorTickSpacing(5);
		opacitySlider.setPaintTicks(true);
		opacitySlider.setPaintLabels(true);
		opacitySlider.addChangeListener(this);

		optionsPanel.add(new JLabel("Opacity :"));
		optionsPanel.add(opacitySlider);

		c.add(optionsPanel, BorderLayout.NORTH);
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
	}

	private void glSetup() {
		renderPanel = new JPanel();
		renderPanel.setLayout( new BorderLayout() );
		renderPanel.setOpaque(false);
    	renderPanel.setPreferredSize( new Dimension(GLWIDTH, GLHEIGHT));
    	GLProfile glprofile = GLProfile.getDefault();
        GLCapabilities glcapabilities = new GLCapabilities( glprofile );
        canvas = new GLCanvas( glcapabilities );
	         
//        gCap.setAlphaBits(8);
//        gCap.setHardwareAccelerated(true);
//        gCap.setDoubleBuffered(true);	        
	    	
	    animator = new Animator(canvas);
		fpsAnimator = new FPSAnimator(canvas, 2);
	    canvas.getContext();

    	canvas.addGLEventListener(this);
		renderPanel.add(canvas, BorderLayout.CENTER);
		c.add(renderPanel, BorderLayout.CENTER);
	}

	public void display(GLAutoDrawable drawable) {
		GL2 gl = drawable.getGL().getGL2();
	    float mat_torus[] = { 0.25f, 0.25f, 0.25f, (float) opacitySlider.getValue() / 100.f };

	    gl.glClear(GL2.GL_COLOR_BUFFER_BIT | GL2.GL_DEPTH_BUFFER_BIT);
	    gl.glLoadIdentity();
		gl.glLightfv(GL2.GL_LIGHT0, GL2.GL_POSITION, position, 0);
	    glu.gluLookAt(0.0, 0.0, eyeZ, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);

	    // Draw Surface
	    gl.glPushMatrix();
	    synchronized(lock) {
	    	CurRotMat.get(mat);
	    }

	    gl.glMultMatrixf(mat, 0);
	    gl.glPushMatrix();
	    gl.glTranslatef(-(bBox[0].x + (bBox[1].x - bBox[0].x) /2.f),
	    				-(bBox[0].y + (bBox[1].y - bBox[0].y) /2.f),
	   					-(bBox[0].z + (bBox[1].z - bBox[0].z) /2.f));

	   	drawVOI(gl);

	   	if((float) opacitySlider.getValue() / 100.f < 0.9f) {

		   	// Pass 1
		   	gl.glBlendFunc(GL2.GL_SRC_ALPHA, GL2.GL_ONE_MINUS_SRC_ALPHA);

		   	gl.glEnable(GL2.GL_BLEND); //Enable alpha blending
		   	gl.glLightModelf(GL2.GL_LIGHT_MODEL_TWO_SIDE, GL2.GL_TRUE);
		    gl.glMaterialfv(GL2.GL_FRONT_AND_BACK, GL2.GL_DIFFUSE, mat_torus, 0);
		   	gl.glEnable(GL2.GL_CULL_FACE);
		    gl.glCullFace(GL2.GL_FRONT);
		    mesh.drawGL(drawable);

		    // Pass 2
		   gl.glBlendFunc(GL2.GL_SRC_ALPHA, GL2.GL_ONE_MINUS_SRC_ALPHA);
		    gl.glCullFace(GL2.GL_BACK);
		    mesh.drawGL(drawable);
		    gl.glDisable(GL2.GL_BLEND); //Enable alpha blending

		    gl.glLightModelf(GL2.GL_LIGHT_MODEL_TWO_SIDE, GL2.GL_FALSE);
	   	}
	   	else {
	   		gl.glMaterialfv(GL2.GL_FRONT_AND_BACK, GL2.GL_DIFFUSE, mat_torus, 0);
		   	gl.glEnable(GL2.GL_CULL_FACE);
	    	gl.glCullFace(GL2.GL_BACK);
	    	mesh.drawGL(drawable);
	   	}

	    if(edgeCheck.isSelected()) {
	    	gl.glDisable(GL2.GL_LIGHTING);
	    	gl.glColor3f(0.0f, 0.0f, 1.0f);
	    	mesh.setDrawParam(new DrawParam("Edges", "true"));
	    	mesh.drawGL(drawable);
	    	mesh.setDrawParam(new DrawParam("Edges", "false"));
	    	gl.glColor3f(1.0f, 1.0f, 1.0f);
	    	gl.glEnable(GL2.GL_LIGHTING);
	    }

		// Draw Bounding Box
        if(bBoxCheck.isSelected()) {
        	gl.glDisable(GL2.GL_LIGHTING);
        	mesh.getBoundingBox().drawGL(drawable);
        	gl.glEnable(GL2.GL_LIGHTING);
        }

               gl.glPopMatrix();

		gl.glPopMatrix();
	    gl.glFlush();
	}

	public void drawVOI(GL2 gl) {
		if(jdvf == null)
			return;
		float mat_voi[] = { 0.25f, 0.25f, 0.25f, 1.0f};
		Color voiColor;
		int sel, hover;
		sel = jdvf.getSelectedVOI();
		hover = jdvf.getHoverVOI();
		for(int i = 0; i < jdvf.voiVector.size(); ++i) {
			// Get the VOI Object
			FVOI f = jdvf.voiVector.get(i);
			// Get the color for the group
			voiColor = jdvf.getGroupColor(f.GroupID);
			// If the VOI is selected in the modelimage frame then highlight it
			if(i == sel || i == hover) {
				mat_voi[1] = mat_voi[0] = 1.0f;
				mat_voi[2] = 0.0f;
			}
			else {
				mat_voi[0] = (float) voiColor.getRed() / 255.0f;
				mat_voi[1] = (float) voiColor.getGreen() / 255.0f;
				mat_voi[2] = (float) voiColor.getBlue() / 255.0f;
			}
			gl.glEnable ( GL2.GL_COLOR_MATERIAL ) ;
			gl.glColor3f(mat_voi[0], mat_voi[1], mat_voi[2]);
			gl.glMaterialfv(GL2.GL_FRONT, GL2.GL_DIFFUSE, mat_voi, 0);
			// Draw voi as sphere
			gl.glPushMatrix();
				gl.glTranslatef(f.x, f.y , f.z);
				glu.gluSphere(quadric, 2.0f, 10, 10);
			gl.glPopMatrix();
			gl.glDisable( GL2.GL_COLOR_MATERIAL ) ;
			gl.glColor3f(1.0f, 1.0f, 1.0f);
		}
	}


 	public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
 		init(drawable);
 	}

 	public void init(GLAutoDrawable drawable) {
 		GL2 gl = drawable.getGL().getGL2();
 		
 		OpenGLHelper.CheckSupport(drawable);
	    glu = new GLU();

	    quadric = glu.gluNewQuadric();

	    LastRotMat.setIdentity();
	    CurRotMat.setIdentity();
	    CurRotMat.get(mat);
	    
	    eyeZ = Math.abs(bBox[1].z - bBox[0].z) * 2.5f;
	    	    
		float whiteSpecularLight[] = new float[]{1.0f, 1.0f, 1.0f};
		float blackAmbientLight[] = new float[]{0.50f, 0.50f, 0.50f};
		float whiteDiffuseLight[] = new float[]{1.0f, 1.0f, 1.0f}; 
		


		gl.glLightfv(GL2.GL_LIGHT0, GL2.GL_SPECULAR, whiteSpecularLight,0);
		gl.glLightfv(GL2.GL_LIGHT0, GL2.GL_AMBIENT, blackAmbientLight,0);
		gl.glLightfv(GL2.GL_LIGHT0, GL2.GL_DIFFUSE, whiteDiffuseLight,0);
		
		gl.glColorMaterial ( GL2.GL_FRONT_AND_BACK, GL2.GL_DIFFUSE ) ;
		
		gl.glDepthFunc(GL2.GL_LEQUAL);               // The Type Of Depth Testing To Do
		

	    float mat_ambient[] =
	    { 0.4f, 0.4f, 0.4f, 0.15f };
	    float mat_specular[] =
	    { 0.3f, 0.3f, 0.3f, 0.4f };
	    float mat_shininess[] =
	    { 2.0f };

	    gl.glMaterialfv(GL2.GL_FRONT_AND_BACK, GL2.GL_AMBIENT, mat_ambient, 0);
	    gl.glMaterialfv(GL2.GL_FRONT_AND_BACK, GL2.GL_SPECULAR, mat_specular, 0);
	    gl.glMaterialfv(GL2.GL_FRONT_AND_BACK, GL2.GL_SHININESS, mat_shininess, 0);

		gl.glLightModeli(GL2.GL_LIGHT_MODEL_TWO_SIDE,1);
		gl.glEnable(GL2.GL_LIGHTING);
		gl.glEnable(GL2.GL_LIGHT0);
		
		
		gl.glClearColor(0.3f,0.3f,0.42f,1.0f);
	    
	    gl.glDepthFunc(GL2.GL_LESS);
	    gl.glEnable(GL2.GL_DEPTH_TEST);
	    gl.glShadeModel(GL2.GL_SMOOTH);	    
//	    drawable.addMouseMotionListener(this);
//	    drawable.addMouseListener(this);
//	    drawable.addMouseWheelListener(this);
	    canvas.addMouseMotionListener(this);
	    canvas.addMouseListener(this);
	    canvas.addMouseWheelListener(this);
	    animator.start();
 	}

 	public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
 		GL2 gl = drawable.getGL().getGL2();
	    gl.glViewport(0, 0, width, height);
	    gl.glMatrixMode(GL2.GL_PROJECTION);
	    gl.glLoadIdentity();
	    glu.gluPerspective(45.0, (float) width / (float) height, 1.0, 1000.0);
	    gl.glMatrixMode(GL2.GL_MODELVIEW);
	    gl.glLoadIdentity();
	    arcBall.setBounds((float) width, (float) height);
 	}

 	public void computeIntersections() {
 		new Thread( new Runnable() {
      				public void run() {
      			ProgressBarDialog pb = new ProgressBarDialog("Computing ...", "...", 0, 100);
      			
		 		int num_Slices = (int) extents[2];
		 		Vector<Line> lines;
		 		pb.setVisible(true);
		 		System.out.println("Intersection 1");
		 		for(int i = 0; i < num_Slices; ++i) {
		 			pb.setMessage("Computing Intersection for Slice : " + i + "/" + num_Slices);
		 			Vector3f point = new Vector3f(extents[0] / 2.0f , extents[1] / 2.0f, (float) i);
					Vector3f normal = new Vector3f(0,0,1);
					lines = mesh.intersectPlane(point, normal);
		 			linesPerSlice.addElement(lines);
		 			pb.setValue((int) ( (float) i  * 100.0f / (float) num_Slices));
		 		}
		 		pb.dispose();
      	}
 		}).start();
 		computeOutline.setEnabled(false);
 		drawOutline.setSelected(true);
 	}

 	public void drawOutline(ViewJComponentEditImage editImage) {
	 	if(windowClosed)
	 		return;
 		int slice = editImage.getSlice();
 		if(slice < linesPerSlice.size()) {

			Vector<Line> lines = linesPerSlice.get(slice);
			if(lines == null || !drawOutline.isSelected())
				return;
			float xRes = editImage.getZoomX() * editImage.getResolutionX();
			float yRes = editImage.getZoomY() * editImage.getResolutionY();
			Graphics g = editImage.getGraphics();
			Graphics2D g2 = (Graphics2D) g;
			
			Object aliasVal		= g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
			Object renderVal	= g2.getRenderingHint(RenderingHints.KEY_RENDERING);
			Object interVal		= g2.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
			
			if(bEnableAntiAlias.isSelected()) {
				 g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
						 RenderingHints.VALUE_ANTIALIAS_ON);
				g2.setRenderingHint(RenderingHints.KEY_RENDERING,
						RenderingHints.VALUE_RENDER_QUALITY);	        
				g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION,
					RenderingHints.VALUE_INTERPOLATION_BICUBIC);				
			}
			
			g2.setColor(outlineColor);
			Line l;			
			Stroke original = g2.getStroke();
			
			g2.setStroke(new BasicStroke(lineDrawWidth));
			for(int i = 0; i < lines.size(); ++i) {
				l = lines.get(i);
				g2.drawLine((int)(l.p1.x * xRes), (int)(l.p1.y * yRes), (int)(l.p2.x * xRes), (int)(l.p2.y * yRes));
			}
			
			g2.setStroke(original);
			
			if(bEnableAntiAlias.isSelected()) {
				// Restore original values;
				g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
						aliasVal);
				g2.setRenderingHint(RenderingHints.KEY_RENDERING,
						renderVal);	        
				g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION,
					interVal);
			}
		}
 	}

 	private void computeDistances() {
 		JFileChooser fc	= new JFileChooser();
		fc.setFileSelectionMode(JFileChooser.FILES_ONLY );
		fc.setSelectedFile(new File( mesh.getName() +"-distances.csv"));
		int returnVal = fc.showSaveDialog(this);
		if(returnVal == JFileChooser.APPROVE_OPTION) {
			File file =fc.getSelectedFile();
			// Write out file
			try {
				BufferedWriter out = new BufferedWriter(new FileWriter(file));
				VOIGroup group;
				out.write("Group Name,VOI ID,X Coord,Y Coord,Z Coord,Distance\r\n");
				for(int i = 0; i < jdvf.groupVector.size(); ++i) {
					group = (VOIGroup) jdvf.groupVector.get(i).getUserObject();
					for(int k = 0; k < jdvf.voiVector.size(); ++k) {
						FVOI f = jdvf.voiVector.get(k);
						if(f.GroupID == group.GroupID) {
							out.write("" + group.GroupName + "," + f.VOINumber + "," + f.x + "," + f.y + "," + f.z + "," + mesh.computeDistance2(new Point3f(f)) + "\r\n");
						}
					}
				}
				out.close();
				JOptionPane.showMessageDialog(null, "Distance Computation completed.");
			}
			catch(IOException ioe) {
				JOptionPane.showMessageDialog(null, "Unable to write to distance file. Reason : " + ioe.getMessage());
				ioe.printStackTrace();
			}
		}
 	}

 	private void startDrag(Point pt) {
 		synchronized(lock) {
 			LastRotMat.set(CurRotMat);
 		}
 		arcBall.click(pt);
 	}

 	private void drag(Point pt) {
 		Quat4f curQuat = new Quat4f();
 		arcBall.drag(pt, curQuat);
 		synchronized(lock) {
 			CurRotMat.setRotation(curQuat);
 			CurRotMat.mul(CurRotMat, LastRotMat);
 		}
 	}


	public void mouseDragged(MouseEvent e) {
		if(mouseButton == MouseEvent.BUTTON1) {
			if(!animator.isAnimating()) {
				animator.start();
				//if(fpsAnimator.isAnimating())
				//	fpsAnimator.stop();
			}
			drag(e.getPoint());
			return;
		}
		if(mouseButton == MouseEvent.BUTTON2) {

		}
	}

	public void mousePressed(MouseEvent e)	{
		mouseButton = e.getButton();
		if(mouseButton == MouseEvent.BUTTON1)
			startDrag(e.getPoint());
	}

	public void mouseWheelMoved(MouseWheelEvent e) {
		eyeZ += 3.0f * (float) e.getWheelRotation();

	}


	public void mouseClicked(MouseEvent e) {
		if(e.getButton() == MouseEvent.BUTTON3) {
			// Reset the matrices
			LastRotMat.setIdentity();
			CurRotMat.setIdentity();
			canvas.display();
		}
	}

	public void mouseReleased(MouseEvent e) {

		/*
		animator.stop();
		if(!fpsAnimator.isAnimating())
			fpsAnimator.start();
		*/
	}

	@SuppressWarnings("static-access")
	public void actionPerformed(ActionEvent e) {
		Object source = e.getSource();
		if(edgeCheck == source || bBoxCheck == source)
			canvas.display();
		if(computeOutline == source)
			computeIntersections();
		if(outlineColorSelect == source) {
			JColorChooser colorChooser	= new JColorChooser();
			colorChooser.setColor(outlineColor);
			Color newColor = colorChooser.showDialog(null, "Choose Outline Color", colorChooser.getColor());
			if(newColor != null) {
				outlineColor = newColor;
				outlineColorSelect.setForeground(outlineColor);
			}
		}
		if(saveDistanceMenuItem == source)
			computeDistances();
		if(source instanceof JRadioButtonMenuItem) {
			if(lineSize.contains(source)) {
				int index = lineSize.indexOf(source);
				lineDrawWidth = index + 1;
			}
		}
	}

	public void windowClosing(WindowEvent e) {
		try {
			System.out.println("Closing 3D window ");
			if(e.getSource()  != jdvf && jdvf != null)
				jdvf.removeWindowListener(this);
			if(animator.isAnimating())
				animator.stop();
			if(fpsAnimator.isAnimating())
				fpsAnimator.stop();		
			//glContext.destroy();
			canvas = null;
			dispose();
			mesh = null;
			windowClosed = true;
			dispose();
		}
		catch(Exception e1) {
			// Suppressed
		}
		System.gc();
	}

	public void windowClosed(WindowEvent e) {
		//windowClosing(e);
	}

	public void stateChanged(ChangeEvent e) 		{}
	public void mouseMoved(MouseEvent e) 			{}
 	public void mouseEntered(MouseEvent e)			{}
 	public void mouseExited(MouseEvent e)			{}
	public void windowActivated(WindowEvent e)		{}
 	public void windowDeactivated(WindowEvent e)	{}
 	public void windowDeiconified(WindowEvent e)	{}
	public void windowIconified(WindowEvent e)		{}
 	public void windowOpened(WindowEvent e)			{}

	public void dispose(GLAutoDrawable arg0) {
		
	}

}
