package edu.jhmi.rad.medic.visualization.framework;

import edu.jhmi.rad.medic.visualization.framework.Disposable;
import edu.jhmi.rad.medic.visualization.primitives.DrawableBoundingBox;
//import edu.jhmi.rad.medic.visualization.scene.SceneNode;

import javax.media.opengl.GLAutoDrawable;
import javax.swing.JPanel;

/**
 * @author Bhaskar Kishore (bhaskar@jhu.edu)
 */
public class MedicDrawable implements Disposable {
	public static enum ModelType {NONE, SURFACE, VOLUMETRIC, POINT_SET, FIBER_COLLECTION};
	protected boolean m_IsInitialized = false;
	protected String m_Name	= "Not Set";
	protected DrawableBoundingBox m_BoundingBox = null;
	//protected SceneNode	m_SelfSceneNode = null;
	
	public MedicDrawable(String name) {
		m_Name = name;		
	}
	
	public MedicDrawable() {		
	}
	
	/*
	 * Called by a master draw routine.
	 *	@param	glAutoDrawable	GL drawing object
	 */
	public void drawGL(GLAutoDrawable glAutoDrawable) {}
	
	/*
	 * Called by a master draw routine. This function is only called
	 * if drawable notifies that it will handle transparency blending
	 * by it self.
	 * 	@param	glAutoDrawable	GL drawing object
	 * 	@param	opacity			Opacity of object
	 */
	public void drawGL(GLAutoDrawable glAutoDrawable, float opacity) {}
		
	/*
	 * Requests the drawable to free any resources it is using. Drawable must comply by freeing resources.
	 */
	 public void dispose() {}
	
	/*
	 * Sets the drawing parameters for this object. DrawParams are open ended with 
	 * no pre-set limitations.
	 *	@param	drawParams		Drawing parameters for this object
	 */
	public void setDrawParam(DrawParam drawParams) {}
	
	/*
	 * Called for setting up the bounding box for this object.
	 */
	public void computeBoundingBox() {}
	
	/*
	 * Used for retrieving the bounding-box for this object.
	 *	@return					Bounding box for this object
	 */
	public DrawableBoundingBox getBoundingBox() {
		return m_BoundingBox;
	}
	
	/*
	 * Called after ctor and before any other routine. Allows object to compute
	 * things essential for it. Ex. Per vertex normals for surfaces
	 */
	public void preCompute() {}
	
	/*
	 * Gets the name of the drawable
	 */
	public String getName() {
		return m_Name;
	}
	
	public void setName(String name) {
		m_Name = name;
	}
	
	/*
	 * Gets the type name of the object
	 */
	public ModelType getType() {
		return ModelType.NONE;
	}
	
	/*
	 * Gets the JPanel for model properties
	 */
	public JPanel getModelPanel() {
		return null;
	}	
	
	public boolean IsBlendingByModel() {
		return false;
	}
	
	/*
	 * Initialization routine - Called by framework to ensure that 
	 * drawable has been initialized.
	 * 
	 */
	public void init(GLAutoDrawable glAutoDrawable) {		
	}
	
	public boolean isInit() {
		return m_IsInitialized;
	}
	
//	public void setSceneNode(SceneNode node) {
//		m_SelfSceneNode = node;
//	}
//	
//	public SceneNode getSceneNode() {
//		return m_SelfSceneNode;
//	}
	
	public String toString() {
		return m_Name;
	}
}