package edu.jhmi.rad.medic.visualization.primitives;

import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.vecmath.Point3f;

import edu.jhmi.rad.medic.visualization.framework.MedicPrimitive;
import edu.jhmi.rad.medic.visualization.framework.OpenGLHelper.GLDrawStyle;

/**
 * @author Bhaskar Kishore (bhaskar@jhu.edu)
 */
public class DrawableBoundingBox extends BoundingBox implements MedicPrimitive {

	public DrawableBoundingBox() {
		super();
	}
	
	public DrawableBoundingBox(Point3f min, Point3f max) {
		super(min, max);		
	}
	
	public DrawableBoundingBox(BoundingBox b) {
		super(b);
	}
	
	/*
	 * Draws the wire-frame bounding box for this surface.
	 *	@param	drawable	Object containing the active openGL reference
	 */
	public void drawGL(GLAutoDrawable drawable) {
		GL2 gl = drawable.getGL().getGL2();
		gl.glBegin(GL.GL_LINE_LOOP);
    		gl.glVertex3f(minCoords.x, minCoords.y, minCoords.z);
    		gl.glVertex3f(maxCoords.x, minCoords.y, minCoords.z);
    		gl.glVertex3f(maxCoords.x, maxCoords.y, minCoords.z);        		
    		gl.glVertex3f(minCoords.x, maxCoords.y, minCoords.z);        		
    	gl.glEnd();
    	
    	gl.glBegin(GL.GL_LINE_LOOP);
    		gl.glVertex3f(minCoords.x, minCoords.y, minCoords.z);
    		gl.glVertex3f(minCoords.x, minCoords.y, maxCoords.z);
    		gl.glVertex3f(maxCoords.x, minCoords.y, maxCoords.z);        		
    		gl.glVertex3f(maxCoords.x, minCoords.y, minCoords.z);        		
    	gl.glEnd();
    	
    	gl.glBegin(GL.GL_LINE_LOOP);
    		gl.glVertex3f(minCoords.x, minCoords.y, minCoords.z);
    		gl.glVertex3f(maxCoords.x, minCoords.y, minCoords.z);
    		gl.glVertex3f(maxCoords.x, maxCoords.y, minCoords.z);        		
    		gl.glVertex3f(minCoords.x, maxCoords.y, minCoords.z);        		
    	gl.glEnd();
    	
    	gl.glBegin(GL.GL_LINE_LOOP);
    		gl.glVertex3f(maxCoords.x, maxCoords.y, maxCoords.z);
    		gl.glVertex3f(minCoords.x, maxCoords.y, maxCoords.z);
    		gl.glVertex3f(minCoords.x, maxCoords.y, minCoords.z);        		
    		gl.glVertex3f(maxCoords.x, maxCoords.y, minCoords.z);        		
    	gl.glEnd();
    	
		gl.glBegin(GL.GL_LINE_LOOP);
    		gl.glVertex3f(maxCoords.x, maxCoords.y, maxCoords.z);
    		gl.glVertex3f(maxCoords.x, minCoords.y, maxCoords.z);
    		gl.glVertex3f(maxCoords.x, minCoords.y, minCoords.z);        		
    		gl.glVertex3f(maxCoords.x, maxCoords.y, minCoords.z);        		
    	gl.glEnd();        	
    	
    	gl.glBegin(GL.GL_LINE_LOOP);
    		gl.glVertex3f(maxCoords.x, maxCoords.y, maxCoords.z);
    		gl.glVertex3f(minCoords.x, maxCoords.y, maxCoords.z);
    		gl.glVertex3f(minCoords.x, minCoords.y, maxCoords.z);        		
    		gl.glVertex3f(maxCoords.x, minCoords.y, maxCoords.z);        		
    	gl.glEnd(); 
	}


	public void setDrawTextureCoordinates(boolean value) {
		// Ignore
	}

	public void setDrawStyle(GLDrawStyle style) {
		// TODO Auto-generated method stub
		
	}
}
