package edu.jhmi.rad.medic.visualization.structures;

import java.awt.Color;

/**
 * @author Bhaskar Kishore (bhaskar@jhu.edu)
 */
public class LookUpTable {
	private float m_Min;
	private float m_Max;
	
	public LookUpTable(float min, float max) {
		m_Min = min;
		m_Max = max;
	}
		
	public Color getColor(float value)
	{
		float power = (value - m_Min) * 0.8f / (m_Max - m_Min);
	    double H = power * 0.4; // Hue (note 0.4 = Green, see huge chart below)
	    double S = 0.9; // Saturation
	    double B = 0.9; // Brightness
	    return Color.getHSBColor((float)H, (float)S, (float)B);
	}

}
