package edu.jhmi.rad.medic.visualization.structures;

import java.nio.FloatBuffer;

import com.jogamp.common.nio.Buffers;


import edu.jhmi.rad.medic.visualization.framework.Disposable;

/**
 * @author Bhaskar Kishore (bhaskar@jhu.edu)
 */
public class ScalarFloatData implements Disposable {
	private FloatBuffer m_DataBuffer;
	
	public ScalarFloatData(int count) {
		m_DataBuffer = Buffers.newDirectFloatBuffer(count);
	}
	
	public void dispose() {
		m_DataBuffer.clear();
		m_DataBuffer = null;
	}
	
	public int capacity() {
		return m_DataBuffer.capacity();
	}
		
	public void addDataPoint(float f) {
		m_DataBuffer.put(f);
	}
	
	public float getDataPoint(int index) {
		return m_DataBuffer.get(index);
	}
	
	public float[] getData() {
		m_DataBuffer.rewind();
		return m_DataBuffer.array();
	}
}
