package edu.jhu.ece.iacl.algorithms.graphics.edit;

import java.util.Hashtable;

import javax.vecmath.Point3f;

import edu.jhu.ece.iacl.algorithms.VersionUtil;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface.Edge;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface.EdgeSplit;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface.Face;

/**
 * Up-sample a surface by a factor of 2.
 * 
 * @author Blake Lucas
 * 
 */
public class Tessellate extends AbstractCalculation {
	public static String getVersion() {
		return VersionUtil.parseRevisionNumber("$Revision: 1.6 $");
	}

	public Tessellate() {
		super();
		setLabel("Tessellate");
	}

	public Tessellate(AbstractCalculation parent) {
		super(parent);
		setLabel("Tessellate");
	}

	public EmbeddedSurface solve(EmbeddedSurface surf) {
		Edge[] edges = EmbeddedSurface.buildEdgeTable(surf);
		Hashtable<Long, EmbeddedSurface.Edge> hash = EmbeddedSurface
				.buildEdgeHash(edges);
		int vertCount = surf.getVertexCount();
		Point3f[] newVerts = new Point3f[vertCount + edges.length];
		double[][] newValues = null;
		double[][] data = surf.getVertexData();
		if (data != null) {
			newValues = new double[vertCount + edges.length][data[0].length];
		}

		for (int i = 0; i < vertCount; i++) {
			newVerts[i] = surf.getVertex(i);
			for (int k = 0; k < data[i].length; k++) {
				newValues[i][k] = data[i][k];
			}
		}
		int j = 0;
		int index;
		setTotalUnits(edges.length + surf.getFaceCount());
		for (int i = 0; i < edges.length; i++) {
			Edge e = edges[i];
			index = vertCount + (j++);
			newVerts[index] = surf.midPoint(e);
			if (data != null)
				newValues[index] = surf.midValues(e);
			edges[i] = new EdgeSplit(e, index);
			hash.put(e.hashCodeLong(), edges[i]);
			incrementCompletedUnits();
		}
		int faceCount = surf.getFaceCount() * 4;
		Face[] faces = EmbeddedSurface.buildFaceTable(surf, edges, hash);
		int[] newIndexes = new int[faceCount * 3];
		j = 0;
		for (int i = 0; i < faces.length; i++) {
			Face f = faces[i];
			int[] verts = f.getVertexes();
			newIndexes[j++] = verts[0];
			newIndexes[j++] = ((EdgeSplit) f.edges[0]).mid;
			newIndexes[j++] = ((EdgeSplit) f.edges[2]).mid;
			newIndexes[j++] = verts[1];
			newIndexes[j++] = ((EdgeSplit) f.edges[1]).mid;
			newIndexes[j++] = ((EdgeSplit) f.edges[0]).mid;
			newIndexes[j++] = verts[2];
			newIndexes[j++] = ((EdgeSplit) f.edges[2]).mid;
			newIndexes[j++] = ((EdgeSplit) f.edges[1]).mid;
			newIndexes[j++] = ((EdgeSplit) f.edges[0]).mid;
			newIndexes[j++] = ((EdgeSplit) f.edges[1]).mid;
			newIndexes[j++] = ((EdgeSplit) f.edges[2]).mid;
			incrementCompletedUnits();
		}
		markCompleted();
		if (data != null) {
			EmbeddedSurface newSurf = new EmbeddedSurface(newVerts, newIndexes,
					newValues);
			newSurf.setName(surf.getName() + "_tess");
			return newSurf;
		} else {
			EmbeddedSurface newSurf = new EmbeddedSurface(newVerts, newIndexes);
			newSurf.setName(surf.getName() + "_tess");
			return newSurf;
		}
	}
}
