package edu.jhu.ece.iacl.algorithms.graphics.map;

import edu.jhu.ece.iacl.algorithms.graphics.surf.ProgressiveSurface;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;

/**
 * Decimate a surface to reduce vertex count. A vertex mapping is maintained so
 * decimated vertices can be related back to the original surface.
 * 
 * @author Blake Lucas
 * 
 */
public class DownSampleSphericalMap extends ProgressiveSurface {
	public DownSampleSphericalMap() {

	}

	/**
	 * Down-sample surface to specified maximum decimation amount
	 * 
	 * @param refSurface
	 *            reference surface to decimate
	 * @param surface
	 *            surface to reflect decimation and embed
	 * @param maxDecimation
	 *            maximum decimation amount [0,1]
	 * @return {decimated reference surface with down-sampled vertex
	 *         data,reflection surface with index vertex data}
	 */
	public EmbeddedSurface[] solve(EmbeddedSurface refSurface,
			EmbeddedSurface surface, double maxDecimation) {
		init(refSurface, false);
		setCollapseMethod(CollapseMethod.EDGE);
		setMetric(VertexMetric.SURFACE_DISTANCE);
		int vertCount = refSurface.getVertexCount();
		double[][] vertData = new double[vertCount][1];
		for (int i = 0; i < vertCount; i++) {
			vertData[i][0] = i;
		}
		surface.setVertexData(vertData);
		refSurface.setVertexData(vertData);
		decimate(-1, maxDecimation);
		return new EmbeddedSurface[] { createSurface(), createSurface(surface) };
	}
}
