package edu.jhu.ece.iacl.algorithms.graphics.surf;

import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3f;

import edu.jhu.ece.iacl.algorithms.graphics.GeometricUtilities;

/**
 * Spherical arc to interpolate between two locations on a unit sphere using arc
 * length, which is analogous to angle for a unit sphere.
 * 
 * @author Blake Lucas
 * 
 */
public class SphericalArc {
	protected Matrix3d R;
	protected Vector3f st;
	/**
	 * Constructor
	 * @param start start point on sphere
	 * @param end end point on sphere
	 */
	public SphericalArc(Vector3f start, Vector3f end) {
		Vector3f v = new Vector3f();
		v.cross(end, start);
		v.normalize();
		R = GeometricUtilities.rotateInverseMatrix3d(Math.atan2(v.y, v.x), Math
				.acos(v.z)
				+ Math.PI * 0.5);
		st = GeometricUtilities.multMatrix(R, start);
		R.invert();
	}
	/**
	 * Interpolate angle between two points on a sphere
	 * @param theta angle
	 * @return interpolated position
	 */
	public Vector3f interpolate(double theta) {
		float cos = (float) Math.cos(theta);
		float sin = (float) Math.sin(theta);
		Vector3f p = new Vector3f(st.x * cos + st.y * sin, -st.x * sin + st.y
				* cos, 0);
		return GeometricUtilities.multMatrix(R, p);
	}
}
