package edu.jhu.ece.iacl.algorithms.tgdm;

import java.util.LinkedList;

import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

import edu.jhu.ece.iacl.algorithms.VersionUtil;
import edu.jhu.ece.iacl.algorithms.graphics.GeometricUtilities;
import edu.jhu.ece.iacl.algorithms.graphics.locator.balltree.BallTree;
import edu.jhu.ece.iacl.algorithms.graphics.locator.balltree.PointBall;
import edu.jhu.ece.iacl.algorithms.graphics.map.SphericalMapCorrection;
import edu.jhu.ece.iacl.algorithms.graphics.utilities.rbf.RadialBasisFuncDouble4D;
import edu.jhu.ece.iacl.algorithms.graphics.utilities.rbf.RadialFunctionType;
import edu.jhu.ece.iacl.algorithms.tgdm.GenericTGDM.NBPoint;
import edu.jhu.ece.iacl.algorithms.tgdm.ProfileTGDM.Tracking;
import edu.jhu.ece.iacl.algorithms.volume.DistanceField;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedPointSet;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.image.MaskVolume6;

public class CoupledForceTGDM extends TrackingTGDM{
	public static String getVersion() {
		return VersionUtil.parseRevisionNumber("$Revision: 1.5 $");
	}



	protected EmbeddedPointSet shellPointSet;
	protected BallTree balltree;
	protected int NearestNeighbors=12;
	protected AuxiliaryForceTGDM auxTGDM;
	protected boolean nearestNeighborCacheEnabled=true;
	protected int TREE_DEPTH=13;
	ImageDataFloat finalPhi,finalAuxPhi;
	public CoupledForceTGDM(AbstractCalculation parent, int rule) {
		super(parent, rule);
		auxTGDM=new AuxiliaryForceTGDM(this,rule);
	}

	public CoupledForceTGDM(int rule) {
		super(rule);
		auxTGDM=new AuxiliaryForceTGDM(this,rule);
	}
	public EmbeddedPointSet getShell(){
		return shellPointSet;
	}
	protected void endTGDM(ProfileTGDM profile){
		super.endTGDM(profile);
		shellPointSet=balltree.getPointSet();
	}
	protected void initTGDM(ProfileTGDM profile){
		super.initTGDM(profile);

	}


	protected void execute(ProfileTGDM profile) {
		int maxOuterIters = profile.getOuterIters();
		int maxInnerIters = profile.getInternalIters();
		this.setTotalUnits((maxOuterIters - 1) * profile.getInternalIters()
				+ profile.getFinalInternalIters());
		//initialize
		initTGDM(profile);
		auxTGDM.initTGDM(profile);
		int outerIter,innerIter;
		for (outerIter = 1; outerIter <= maxOuterIters; outerIter++) {
			//Change parameters if this is the last iteration
			if (outerIter == maxOuterIters) {
				maxInnerIters = profile.getFinalInternalIters();
				timeStep = profile.getFinalDeltaT();
				maxSignedDist = profile.getFinalMaxSignDist();
				
				auxTGDM.timeStep = profile.getFinalDeltaT();
				auxTGDM.maxSignedDist = profile.getFinalMaxSignDist();
			}
			//initialize narrow band
			initNarrowBand(profile);
			auxTGDM.initNarrowBand(profile);
			//inner iteration
			for (innerIter = 1; innerIter <= maxInnerIters; innerIter++) {
				System.out.println("INNER ITERATION "+innerIter);
				if (mineHit||auxTGDM.mineHit){
					System.out.println("LANDMIE HIT! "+mineHit+" "+auxTGDM.mineHit);
					break;
				}
				for (NBPoint p : narrowBand) {
					validateUpdatePoint(p, profile,updatePoint(p,profile));
				} 
				updateNarrowBand(profile);
				incrementCompletedUnits();
				for (NBPoint p : auxTGDM.narrowBand) {
					auxTGDM.validateUpdatePoint(p, profile,auxTGDM.updatePoint(p,profile));
				} 
				auxTGDM.updateNarrowBand(profile);
			} 
			//end of narrowband
			endNarrowBand(profile);

			System.out.println("Completed " + (innerIter - 1) + " iterations");
			auxTGDM.endNarrowBand(profile);
		}
		endTGDM(profile);
		markCompleted();
		auxTGDM.endTGDM(profile);
	}
	public EmbeddedSurface getFinalAuxilarySurface(){
		return auxTGDM.getFinalSurface();
	}
	public void setAuxiliarySphericalMap(EmbeddedSurface surf){
		auxTGDM.setSphericalMap(surf);
	}
	public void setMapInterpolationEnabled(boolean mapInterpolationEnabled) {
		super.setMapInterpolationEnabled(mapInterpolationEnabled);
		auxTGDM.setMapInterpolationEnabled(mapInterpolationEnabled);
	}

	public void setPdeEnabled(boolean pdeEnabled) {
		super.setPdeEnabled(pdeEnabled);
		auxTGDM.setPdeEnabled(pdeEnabled);
	}
	public void setTracking(Tracking tracking) {
		super.setTracking(tracking);
		auxTGDM.setTracking(tracking);
	}
	public void solveCoupledSmoothSurface(ImageData sourceInner,ImageData sourceOuter,
			float curvatureForce, float externalForce,
			float pressureForce, int maxiters) {
		rows = sourceInner.getRows();
		cols = sourceInner.getCols();
		slices = sourceInner.getSlices();
		df = new DistanceField(this);
		ImageDataFloat phi = new ImageDataFloat(sourceInner);
		float maxDist=DistanceField.maxSignedDistance(phi.toArray3d());
		if(maxDist<8){
			phi=df.solve(phi, 8);
		}
		float[][][] Phi = phi.toArray3d();

		SmoothCortexProfile profile;
		innerBound = null;
		outerBound = null;
		skeletalBound = null;

		this.advectionForces = null;
		regionForces = null;
		implicitLevelSet = Phi;
		profile = new SmoothCortexProfile(-curvatureForce,0,0, 0, maxiters);

		phi = new ImageDataFloat(sourceOuter);
		maxDist=DistanceField.maxSignedDistance(phi.toArray3d());
		if(maxDist<8){
			phi=df.solve(phi, 8);
		}
		Phi = phi.toArray3d();
		auxTGDM.initPhi = new float[rows][cols][slices];
		for (int x = 0; x < rows; x++) {
			for (int y = 0; y < cols; y++) {
				for (int z = 0; z < slices; z++) {
					auxTGDM.initPhi[x][y][z] = Phi[x][y][z];
				}
			}
		}
		
		auxTGDM.innerBound = null;
		auxTGDM.outerBound = null;
		auxTGDM.skeletalBound = null;
		auxTGDM.advectionForces = null;
		auxTGDM.regionForces = null;
		auxTGDM.implicitLevelSet = Phi;
		
		execute(profile);// fphi.toArray3d()
		finalPhi = new ImageDataFloat(implicitLevelSet);
		finalPhi.setName(sourceInner.getName()+ "_smooth");

		finalAuxPhi = new ImageDataFloat(auxTGDM.implicitLevelSet);
		finalAuxPhi.setName(sourceOuter.getName() + "_smooth");
		
		if (tracking == Tracking.SPHERE) {
			SphericalMapCorrection harmonic = new SphericalMapCorrection(this,
					0.8f, 0.1f, 5);
			harmonic.solve(initSurf, finalSurf, 0);
		}
		
		initSurf.setName(sourceInner.getName() + "_init");
		finalSurf.setName(sourceInner.getName() + "_smooth");
		
		auxTGDM.finalSurf.setName(sourceOuter.getName() + "_smooth");
		auxTGDM.initSurf.setName(sourceOuter.getName()+ "_init");

	}
	public void solveCoupledRegisterSurface(ImageData sourceInner,ImageData sourceOuter,
			ImageData target,float curvatureForce, float externalForce,
			float pressureForce, int maxiters, boolean exactMatch) {
		rows = target.getRows();
		cols = target.getCols();
		slices = target.getSlices();
		df = new DistanceField(this);
		ImageDataFloat phi = new ImageDataFloat(sourceInner);
		float[][][] Phi = phi.toArray3d();
		float[][][] VpM = (new ImageDataFloat(target)).toArray3d();
		RegisterCortexProfile profile;
		innerBound = null;
		outerBound = null;
		skeletalBound = null;

		this.advectionForces = null;
		regionForces = VpM;
		implicitLevelSet = Phi;
		profile = new RegisterCortexProfile(-curvatureForce,externalForce, -pressureForce, 0, maxiters);

		phi = new ImageDataFloat(sourceOuter);
		Phi = phi.toArray3d();
		auxTGDM.initPhi = new float[rows][cols][slices];
		for (int x = 0; x < rows; x++) {
			for (int y = 0; y < cols; y++) {
				for (int z = 0; z < slices; z++) {
					auxTGDM.initPhi[x][y][z] = Phi[x][y][z];
				}
			}
		}
		
		auxTGDM.innerBound = null;
		auxTGDM.outerBound = null;
		auxTGDM.skeletalBound = null;
		auxTGDM.advectionForces = null;
		auxTGDM.regionForces = VpM;
		auxTGDM.implicitLevelSet = Phi;
		
		execute(profile);// fphi.toArray3d()
		finalPhi = new ImageDataFloat(implicitLevelSet);
		finalPhi.setName(sourceInner.getName() + "_reg");

		finalAuxPhi = new ImageDataFloat(auxTGDM.implicitLevelSet);
		finalAuxPhi.setName(sourceOuter.getName() + "_reg");
		
		if (tracking == Tracking.SPHERE) {
			SphericalMapCorrection harmonic = new SphericalMapCorrection(this,
					0.8f, 0.1f, 5);
			harmonic.solve(initSurf, finalSurf, 0);
		}
		
		initSurf.setName(sourceInner.getName() + "_init");
		finalSurf.setName(sourceInner.getName()+ "_reg");
		
		auxTGDM.finalSurf.setName(sourceOuter.getName() + "_reg");
		auxTGDM.initSurf.setName(sourceOuter.getName()+ "_init");

	}
	public ImageData getFinalLevelSet(){
		return finalPhi;
	}
	public ImageData getFinalAuxilaryLevelSet(){
		return finalAuxPhi;
	}

	protected void initNarrowBand(ProfileTGDM profile){
		super.initNarrowBand(profile);
		if(tracking!=Tracking.OFF){
			balltree=new BallTree(TREE_DEPTH);
			Point3d[] pts=new Point3d[narrowBand.size()];
			int i=0;
			for(NBPoint pt:narrowBand){
				pts[i++]=new Point3d(Qx[pt.x][pt.y][pt.z],Qy[pt.x][pt.y][pt.z],Qz[pt.x][pt.y][pt.z]);
			}
			balltree.init(pts);
		}
	}
	protected void updateNarrowBand(ProfileTGDM profile) {
		super.updateNarrowBand(profile);
		int i=0;
		if (!pdeEnabled)return;
		if(tracking!=Tracking.OFF){
			if(!nearestNeighborCacheEnabled){
				for(NBPoint pt:narrowBand){
					Point3d q=new Point3d(Qx[pt.x][pt.y][pt.z],Qy[pt.x][pt.y][pt.z],Qz[pt.x][pt.y][pt.z]);
					balltree.update(i++, q);
				}
			}
		}
	}
	
}
