package edu.jhu.ece.iacl.algorithms.thickness.grid;

import java.util.ArrayList;

import javax.vecmath.Point3f;
/**
 *  Node that lies inside shell on rectilinear grid and has more than six neighbors
 */
public abstract class ExtendedGridNode extends GridNode implements ExtendedNode{
	protected double normalizedLength=-1;
	protected ArrayList<EmbeddedNode> neighbors;
	public static final int[] nbhd26X=new int[]{0,  0,  1, -1, 0,  0, 1, -1, -1,  1, 1, -1, -1,  1, 1, -1, -1,  1, 0,  0,  1, -1, 0,  0,  1, -1}; 
	public static final int[] nbhd26Y=new int[]{1, -1,  0,  0, 0,  0, 1,  1, -1, -1, 1,  1, -1, -1, 1,  1, -1, -1, 1, -1,  0,  0, 1, -1,  0,  0};
	public static final int[] nbhd26Z=new int[]{0,  0,  0,  0, 1, -1, 0,  0,  0,  0, 1,  1,  1,  1,-1, -1, -1 ,-1, 1,  1,  1,  1,-1, -1, -1, -1};

	public static final int[] nbhd18X=new int[]{0,  0,  1, -1, 0,  0, 1, -1, -1,  1, 0,  0,  1, -1, 0,  0,  1, -1}; 
	public static final int[] nbhd18Y=new int[]{1, -1,  0,  0, 0,  0, 1,  1, -1, -1, 1, -1,  0,  0, 1, -1,  0,  0};
	public static final int[] nbhd18Z=new int[]{0,  0,  0,  0, 1, -1, 0,  0,  0,  0, 1,  1,  1,  1,-1, -1, -1, -1};

	public static final int[] nbhd6X=new int[]{0,  0,  1, -1, 0,  0}; 
	public static final int[] nbhd6Y=new int[]{1, -1,  0,  0, 0,  0};
	public static final int[] nbhd6Z=new int[]{0,  0,  0,  0, 1, -1};

	public static int getPosition(ExtendedNode pivot,ExtendedNode nbhr){
		Point3f pivotLoc=pivot.getLocation();
		Point3f nbhrLoc=nbhr.getLocation();
		pivotLoc.sub(nbhrLoc);
		int x=(int)Math.signum(pivotLoc.x);
		int y=(int)Math.signum(pivotLoc.y);
		int z=(int)Math.signum(pivotLoc.z);
		for(int i=0;i<nbhdX.length;i++){
			if(nbhdX[i]==x&&nbhdY[i]==y&&nbhdZ[i]==z){
				return i;
			}
		} 
		return -1;
	}
	public ExtendedGridNode(){
		super();
		neighbors=new ArrayList<EmbeddedNode>();
	}
	public void connect(EmbeddedNode node){
		if(!neighbors.contains(node))neighbors.add(node);
		if(!node.getNeighbors().contains(this))node.getNeighbors().add(this);
	}
	public void connect(EmbeddedNode node,int pos){
		super.connect(node, pos);
		/*
		if(pos>=0&&pos<nbhd.length){
			if(nbhd[pos]!=null){
				if(!nbhd[pos].getNeighbors().remove(this)){
					System.err.println("COULD NOT REMOVE "+this);
				}
				if(!neighbors.remove(nbhd[pos])){
					System.err.println("COULD NOT REMOVE "+nbhd[pos]);
				}
			}
			super.connect(node, pos);
		}
		
		if(node!=null&&!neighbors.contains(node)){
			if(!neighbors.contains(node))neighbors.add(node);
			if(!node.getNeighbors().contains(this))node.getNeighbors().add(this);
		}
		*/
	}
	public void disconnect(){
		super.disconnect();
		for(EmbeddedNode node:neighbors){
			node.getNeighbors().remove(this);
		}
	}
	public ArrayList<EmbeddedNode> getNeighbors(){
		return neighbors;
	}
	public int getConnectivity(){
		return neighbors.size();
	}

	public Double getValue() {
		return getLength();
	}
	public void setValue(Comparable len) {
		setLength((Double)len);
	}
}
