package edu.jhu.ece.iacl.algorithms.thickness.grid;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

/**
 * Interior node with more than six neighbors
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class ExtendedInsideNode extends ExtendedGridNode{
	private double innerLength=0;
	private double outerLength=0;
	protected Point3f innerPoint;
	protected Point3f outerPoint;	
	public byte marchingLabel;

	protected Vector3f tanget;
	protected Vector3f grad;
	public ExtendedInsideNode(int i,int j,int k,byte label){
		super();
		this.i=i;this.j=j;this.k=k;
		innerLength=0;
		outerLength=0;
		grad=new Vector3f();
		outerPoint=new Point3f();
		innerPoint=new Point3f();
		this.regionLabel=label;
	}
	public Vector3f getTanget(){
		return tanget;
	}
	public void setTanget(Vector3f v){
		this.tanget=v;
	}
	public double getThickness(){
		return innerLength+outerLength;
	}
	public double getInnerLength(){
		return innerLength;
	}
	public double getOuterLength(){
		return outerLength;
	}

	public double getNormalizedLength(){
		if(normalizedLength<0){
			return innerLength/(innerLength+outerLength);
		} else {
			return normalizedLength;
		}
	}
	public Point3f getInnerPoint(){return innerPoint;}
	public Point3f getOuterPoint(){return outerPoint;}
	public void setCorrespodence(Point3f p){
		if(compareToInner){
			innerPoint=p;
		} else {
			outerPoint=p;
		}
	}
	public Point3f getCorrespodence(){
		if(compareToInner){
			return innerPoint;
		} else {
			return outerPoint;
		}
	}
	public void setLength(double inner,double outer){
			innerLength=inner;
			outerLength=outer;
	}
	public void setLength(double len){
		if(compareToInner){
			innerLength=len;
		} else {
			outerLength=len;
		}
	}
	public double getLength(){
		if(compareToInner){
			return innerLength;
		} else {
			return outerLength;
		}
	}
	public byte getMarchingLabel(){
		return marchingLabel;
	}
	public void setMarchingLabel(byte label){
		this.marchingLabel=label;
	}
	public Vector3f getGradient() {
		return grad;
	}
	public void setGradient(Vector3f g) {
		this.grad=g;
	}
	public void connect(BoundaryNode node) {
		neighbors.add(node);
	}


	
}
