package edu.jhu.ece.iacl.algorithms.thickness.grid;

import java.util.ArrayList;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

/**
 * Abstract node that can have more than six neighbors
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public interface ExtendedNode {
	public ArrayList<EmbeddedNode> getNeighbors();
	public void connect(EmbeddedNode node);
	public void disconnect();
	//public EmbeddedNode clone();
	public Point3f getLocation();
	public double getThickness();
	public double getInnerLength();
	public double getOuterLength();
	public double getNormalizedLength();
	public void setCorrespodence(Point3f p);
	public Point3f getCorrespodence();
	public void setLength(double inner,double outer);
	public void setLength(double len);
	public double getLength();
	public void setRefPosition(int i, int j, int k);
	public void setLocation(Point3f p);
	public Point3f getInnerPoint();
	public Point3f getOuterPoint();
	public byte getMarchingLabel();
	public void setMarchingLabel(byte label);
	public Vector3f getTanget();
	public void setTanget(Vector3f v);
	public Vector3f getGradient();
	public void setGradient(Vector3f v);
}
