package edu.jhu.ece.iacl.algorithms.thickness.grid;

import javax.vecmath.Point3f;
/**
 * Generic node that lies in rectilinear graph
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public abstract class GridNode extends EmbeddedNode{
	public Point3f getLocation(){
		return new Point3f(i,j,k);
	}
	public void setRefPosition(int i, int j, int k) {
		this.i=i;
		this.j=j;
		this.k=k;
	}
	public void setLocation(Point3f p){
		i=(int)Math.floor(p.x);
		j=(int)Math.floor(p.y);
		k=(int)Math.floor(p.z);
	}

	public Double getValue() {
		return Math.abs(getLength());
	}
	public void setValue(Comparable len) {
		setLength((Double)len);
	}
}
