package edu.jhu.ece.iacl.algorithms.thickness.grid;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

/**
 * Grid node that lies inside shell on rectilinear grid
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class SimpleInsideNode extends GridNode{
	private double innerLength=0;
	private double outerLength=0;

	public byte marchingLabel;
	protected Point3f innerPoint;
	protected Point3f outerPoint;	
	
	public SimpleInsideNode(int i,int j,int k,byte label){
		super();
		this.i=i;this.j=j;this.k=k;
		innerLength=0;
		outerLength=0;
		outerPoint=new Point3f();
		innerPoint=new Point3f();
		this.regionLabel=label;
	}
	protected double normalizedLength=-1;
	public void setNormalizedLength(double len){
		this.normalizedLength=len;
	}
	protected Vector3f tanget;
	public Vector3f getTanget(){
		return tanget;
	}
	public void setTanget(Vector3f v){
		this.tanget=v;
	}

	public SimpleInsideNode clone(){
		SimpleInsideNode dat=new SimpleInsideNode(i,j,k,regionLabel);
		dat.chain=chain;
		dat.index=index;
		dat.marchingLabel=marchingLabel;
		dat.regionLabel=regionLabel;
		dat.innerLength=innerLength;
		dat.outerLength=outerLength;
		dat.innerPoint=new Point3f(innerPoint);
		dat.outerPoint=new Point3f(outerPoint);
		dat.connect(nbhd[0], 0);
		dat.connect(nbhd[1], 1);
		dat.connect(nbhd[2], 2);
		dat.connect(nbhd[3], 3);
		dat.connect(nbhd[4], 4);
		dat.connect(nbhd[5], 5);
		dat.tanget=(Vector3f)tanget.clone();
		return dat;
	}
	public double getThickness(){
		return innerLength+outerLength;
	}
	public double getInnerLength(){
		return innerLength;
	}
	public double getOuterLength(){
		return outerLength;
	}

	public double getNormalizedLength(){
		if(normalizedLength<0){
			return innerLength/(innerLength+outerLength);
		} else {
			return normalizedLength;
		}
	}
	public Point3f getInnerPoint(){return innerPoint;}
	public Point3f getOuterPoint(){return outerPoint;}
	public void setCorrespodence(Point3f p){
		if(compareToInner){
			innerPoint=p;
		} else {
			outerPoint=p;
		}
	}
	public Point3f getCorrespodence(){
		if(compareToInner){
			return innerPoint;
		} else {
			return outerPoint;
		}
	}
	public void setLength(double inner,double outer){
			innerLength=inner;
			outerLength=outer;
	}
	public void setLength(double len){
		if(compareToInner){
			innerLength=len;
		} else {
			outerLength=len;
		}
	}
	public double getLength(){
		if(compareToInner){
			return innerLength;
		} else {
			return outerLength;
		}
	}
	public byte getMarchingLabel(){
		return marchingLabel;
	}
	public void setMarchingLabel(byte label){
		this.marchingLabel=label;
	};
	protected Vector3f grad=null;
	public Vector3f getGradient() {
		return grad;
	}
	public void setGradient(Vector3f g) {
		this.grad=g;
	}
}
