package edu.jhu.ece.iacl.plugins.comp_geom;

import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
import edu.jhu.ece.iacl.algorithms.graphics.smooth.SmoothAndRegularize;
import edu.jhu.ece.iacl.algorithms.graphics.smooth.SmoothAndRegularize.Method;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamSurface;

public class MedicAlgorithmSmoothSurface extends ProcessingAlgorithm{
	protected ParamDouble lambdaParam;
	protected ParamDouble chiParam;
	protected ParamInteger maxItersParam;
	protected ParamSurface surfParam;
	protected ParamOption methodParam;
	protected ParamSurface smoothSurfParam;
	protected ParamDouble curvThreshold;
	protected ParamDouble radialForceWeight;
	protected ParamDouble fuzziness;
	protected ParamInteger resolutions;
	protected ParamInteger updateStep;
	protected ParamDouble decimation;
	protected ParamDouble maxDecimation;
	protected ParamBoolean useLorentzian;
	protected ParamBoolean preventSelfIntersection;
	protected ParamBoolean useShapeMetrics;
	protected ParamInteger shapeResolutions;

	private static final String cvsversion = "$Revision: 1.7 $".replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String revnum = SmoothAndRegularize.getVersion();
	private static final String shortDescription = "A general purpose surface smoothing algorithm. Multiple resolutions can be used to avoid cusp formation.\n"
	+ "Algorithm Version: " + revnum + "\n"
	+ "GUI Version:" + cvsversion + "\n";
	private static final String longDescription = "The goal of this module was to find something either better or more reliable than traditional surface inflation. Nothing has been found to be definitively better that surface inflation. The radial force is useful to inflate the surface to a sphere, but is likely to cause self-intersections.";


	protected void createInputParameters(ParamCollection inputParams) {
		Method[] values = SmoothAndRegularize.Method.values();
		String[] labels = new String[values.length];

		for (int i = 0; i < values.length; i++) labels[i] = values[i].toString().replace("_"," ");

		inputParams.add(surfParam = new ParamSurface("Surface"));
		inputParams.add(methodParam = new ParamOption("Method",labels));
		methodParam.setValue(2);
		inputParams.add(maxItersParam = new ParamInteger("Maximum Iterations",0,100000,500));
		inputParams.add(updateStep = new ParamInteger("Update Step Size",0,100000,10));
		inputParams.add(resolutions = new ParamInteger("Multi-Resolutions",0,1000,4));
		inputParams.add(maxDecimation = new ParamDouble("Maximum Decimation (%)",0,1,0.5));
		inputParams.add(preventSelfIntersection = new ParamBoolean("Prevent Self-Intersection"));
		inputParams.add(useShapeMetrics = new ParamBoolean("Compute Shape Metrics",false));
		inputParams.add(shapeResolutions = new ParamInteger("Shape Metrics Resolutions",5));
		inputParams.add(lambdaParam = new ParamDouble("Smoothing Factor",0,4,0.75));
		inputParams.add(chiParam = new ParamDouble("Regularization Factor",0,4,0.5));
		inputParams.add(curvThreshold = new ParamDouble("Mean Curvature Threshold",0,1E6,40));
		inputParams.add(useLorentzian = new ParamBoolean("Lorentzian Norm",true));
		inputParams.add(radialForceWeight = new ParamDouble("Radial Force",0,1,0));
		inputParams.add(fuzziness = new ParamDouble("Radial Force Fuzziness",0,1000,0.2));


		inputParams.setPackage("IACL");
		inputParams.setCategory("Processing.Surface");
		inputParams.setLabel("Smooth and Regularize Surface");
		inputParams.setName("Smooth_and_Regularize_Surface");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.add(ReferencedPapers.meshRegularizationAndAdaptiveSmoothing);
		info.add(ReferencedPapers.surfaceInflation);
		info.add(ReferencedPapers.surfaceTopologyCorrection);
		info.add(PrinceGroupAuthors.blakeLucas);
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.Release);
		info.setAdditionalDocURL("html/edu/jhu/ece/iacl/plugins/comp_geom/MedicAlgorithmSmoothSurface/index.html");
	}


	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(smoothSurfParam=new ParamSurface("Smoothed Surface"));
	}


	protected void execute(CalculationMonitor monitor) {
		SmoothAndRegularize sandr = new SmoothAndRegularize();
		monitor.observe(sandr);
		sandr.setMaxIterations(maxItersParam.getInt());
		sandr.setLambda(lambdaParam.getFloat());
		sandr.setChi(chiParam.getFloat());
		sandr.setFuzziness(fuzziness.getFloat());
		sandr.setRadialForce(radialForceWeight.getFloat());
		sandr.setUpdateStep(updateStep.getInt());
		sandr.setPreventSelfIntersection(preventSelfIntersection.getValue());
		sandr.setResolutions(resolutions.getInt());
		sandr.setMaxDecimation(maxDecimation.getDouble());
		sandr.setCurvatureThreshold(curvThreshold.getDouble());
		sandr.setUseLorentzian(useLorentzian.getValue());
		sandr.setShapeMetrics(useShapeMetrics.getValue());
		sandr.setShapeMetricsResolutions(shapeResolutions.getInt());
		smoothSurfParam.setValue(sandr.smooth(surfParam.getSurface(), SmoothAndRegularize.Method.values()[methodParam.getIndex()]));
	}
}
