package edu.jhu.ece.iacl.plugins.comp_geom;


/* added by clara, 2012.08.27
 * Probably wrong, since SurfaceToMask doesn't work properly 
 */


import javax.vecmath.Point3f;
import javax.vecmath.Point3i;

import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.graphics.intersector.SurfaceIntersector;
import edu.jhu.ece.iacl.algorithms.graphics.isosurf.IsoSurfaceOnGrid;
import edu.jhu.ece.iacl.algorithms.graphics.utilities.ResampleLevelSet;
import edu.jhu.ece.iacl.algorithms.graphics.utilities.SurfaceToMask;
import edu.jhu.ece.iacl.algorithms.topology.ConnectivityRule;
import edu.jhu.ece.iacl.algorithms.topology.TopologyCorrection;
import edu.jhu.ece.iacl.algorithms.volume.DistanceField;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;

public class MedicAlgorithmSurfaceToLevelSet  extends ProcessingAlgorithm{
	ParamVolume origVol;
	ParamSurface origSurf;
	ParamSurface resultSurf;
	ParamVolume result;
	ParamOption connectivity;
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(origSurf=new ParamSurface("Surface"));
		inputParams.add(origVol=new ParamVolume("Reference Volume"));
		origVol.setDescription("Reference volume to use for level set representation dimensions.");
		inputParams.add(connectivity=new ParamOption("Connectivity (Foreground,Background)",new String[]{"(18,6)","(6,18)","(26,6)","(6,26)"}));		
		inputParams.setName("surf2levelset");
		
		inputParams.setLabel("Surface to Level Set");

		inputParams.setPackage("IACL");
		inputParams.setCategory("Processing.Surface");
		
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("");
		info.setVersion(SurfaceToMask.getVersion());
		info.setDescription("Finds a volumetric level-set representation of an input surface. The topology rule relates to iso-surface generation.");
		info.setLongDescription("The toplogy of the object is not preserved with this method.");
		
		info.setAffiliation("Johns Hopkins University, Department of Electrical Engineering");
		info.add(PrinceGroupAuthors.blakeLucas);
		info.setStatus(DevelopmentStatus.ALPHA);
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(result=new ParamVolume("Level Set"));
		outputParams.add(resultSurf=new ParamSurface("Edited Surface"));
	}
	/*
	protected class SurfaceToLevelSet extends AbstractCalculation{
		public SurfaceToLevelSet(){
			
		}
		public void solve(){
			int conn=0;
			switch(connectivity.getIndex()){
				case 0:conn=ConnectivityRule.CONNECT_18_6;break;
				case 1:conn=ConnectivityRule.CONNECT_6_18;break;
				case 2:conn=ConnectivityRule.CONNECT_26_6;break;
				case 3:conn=ConnectivityRule.CONNECT_6_26;break;
				default:break;
			}
			

			ImageDataFloat vol=(new ImageDataFloat(origVol.getImageData()));
			int rows=vol.getRows();
			int cols=vol.getCols();
			int slices=vol.getSlices();
			float[][][] volMat=vol.toArray3d();
			IsoSurfaceOnGrid isosurf=new IsoSurfaceOnGrid();
			EmbeddedSurface surf=origSurf.getSurface();
			SurfaceIntersector locator=new SurfaceIntersector(this,16,surf);
			ImageDataFloat result=new ImageDataFloat(rows,cols,slices);
			float[][][] resultMat=result.toArray3d();
			setTotalUnits(rows);
			for(int i=0;i<rows;i++){
				for(int j=0;j<cols;j++){
					for(int k=0;k<slices;k++){
						float level=volMat[i][j][k];
						resultMat[i][j][k]=(Math.abs(level)<3)?(float)locator.signedDistance(new Point3f(i,j,k)):level;
					}
				}
				incrementCompletedUnits();
			}
			TopologyCorrection tc=new TopologyCorrection(result);
			result=tc.correctLevelSet(conn);
			result.setName(surf.getName());
			EmbeddedSurface rsurf=isosurf.solveOriginal(result, conn, 0, false);
			markCompleted();
			if(rsurf!=null){
				rsurf.setName(surf.getName()+"_tc");
				System.out.println("Topology "+rsurf.getNumberOfHoles());
				resultSurf.setValue(rsurf);
			}
		
		}
	}
	*/
	protected void execute(CalculationMonitor monitor) {
		SurfaceToMask surf2vol=new SurfaceToMask();
		EmbeddedSurface surf=origSurf.getSurface();
		monitor.observe(surf2vol);
		ImageDataFloat maskVol=surf2vol.solve(new ImageDataFloat(origVol.getImageData()), surf);
		int conn=0;
		switch(connectivity.getIndex()){
			case 0:conn=ConnectivityRule.CONNECT_18_6;break;
			case 1:conn=ConnectivityRule.CONNECT_6_18;break;
			case 2:conn=ConnectivityRule.CONNECT_26_6;break;
			case 3:conn=ConnectivityRule.CONNECT_6_26;break;
			default:break;
		}
		/*
		DistanceField df=new DistanceField();
		float[][][] maskVolMat=maskVol.toArray3d();
		for(int i=0;i<maskVol.getRows();i++){
			for(int j=0;j<maskVol.getCols();j++){
				for(int k=0;k<maskVol.getSlices();k++){
					maskVolMat[i][j][k]=0.5f-maskVolMat[i][j][k];
				}
			}
		}
		maskVol=df.solve(maskVol, 30);
		/*
		TopologyCorrection tc=new TopologyCorrection(maskVol);
		tc.set
		maskVol=tc.correctLevelSet(conn);
		maskVol.setName(surf.getName());
		*/
		IsoSurfaceOnGrid isosurf=new IsoSurfaceOnGrid();
		
		EmbeddedSurface rsurf=isosurf.solveOriginal(maskVol, ConnectivityRule.CONNECT_18_6, 0, false);
		result.setValue(maskVol);
		if(rsurf!=null){
			rsurf.setName(surf.getName()+"_tc");
			System.out.println("Topology "+rsurf.getNumberOfHoles());
			resultSurf.setValue(rsurf);
		}
	}

}
