package edu.jhu.ece.iacl.plugins.dti.spine;

import java.util.ArrayList;
import java.util.List;

import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.registration.RegistrationUtilities;
//import edu.jhu.ece.iacl.algorithms.volume.DistanceField;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipavWrapper;
import gov.nih.mipav.model.algorithms.utilities.AlgorithmMatchImages;
import gov.nih.mipav.model.structures.ModelImage;

public class MedicAlgorithmCropToSpineMT  extends ProcessingAlgorithm{
	ParamVolumeCollection inParamVolsToCrop;
	ParamVolume inParamDW;
	ParamVolume inParamMT;
	ParamVolume inParamB0Seg;
	ParamVolume inParamMTSeg;
	ParamBoolean inParamResMatched;
		
	ParamVolumeCollection outParamCroppedVols;

	
	ImageData[] volDW;//, volDWMatched, volDWCropped;
	ImageData volB0MatchedSeg;
	ImageData volMaskCropped;
	ImageData[] volMT, volMTMatched, volMTSeg, volMTCropped;
	ImageData[] volInputMatched, volInputCropped;
	int numOfDW, numOfMT, numOfInput, b0Index;

	
	//private static final String revnum = DistanceField.getVersion();
	private static final String cvsversion = "$Revision: 1.2 $".replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Fixes geometry distortion in spine DW images using MT as reference";
	private static final String longDescription = "";

	public String[] getDefaultJVMArgs() {
		return new String[] { "-XX:MinHeapFreeRatio=70",
				"-XX:MaxHeapFreeRatio=95",
				"-XX:YoungGenerationSizeIncrement=150",
				"-XX:TenuredGenerationSizeIncrement=150" };
	}

	protected void createInputParameters(ParamCollection inputParams) {
		
		ParamCollection mainParams = new ParamCollection("Main");
		mainParams.add(inParamVolsToCrop=new ParamVolumeCollection("Volumes To Crop"));
		mainParams.add(inParamDW=new ParamVolume("Diffusion Weighted"));
		mainParams.add(inParamMT=new ParamVolume("MT"));
		mainParams.add(inParamB0Seg=new ParamVolume("Diffusion Weighted Segmentations"));
		mainParams.add(inParamMTSeg=new ParamVolume("MT Segmentations"));
		mainParams.add(inParamResMatched=new ParamBoolean("Input Already Resolution Matched",false));
				
		inputParams.add(mainParams);
		
		inputParams.setPackage("IACL");
		inputParams.setCategory("DTI");
		inputParams.setLabel("Crop to Spine MT");
		inputParams.setName("CropToSpineMT");	


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.add(PrinceGroupAuthors.minChen);
		info.setDescription(shortDescription + longDescription);
		info.setVersion(cvsversion);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.BETA);
	}


	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outParamCroppedVols=new ParamVolumeCollection("Cropped Volumes"));
		//outputParams.add(outParamRegisteredB0=new ParamVolume("B0 Registered to MT"));
				
	}


	protected void execute(CalculationMonitor monitor) {




		//0.)Extract B0 and first channel of MT
		extractB0andMT();

		//1.)Resolution and Dimension Match, and crop out black space
		if(!inParamResMatched.getValue())matchResAndDim();
		else {
			volInputMatched = new ImageData[numOfInput];
			for (int c = 0; c < numOfInput; c++)
				volInputMatched[c] = inParamVolsToCrop.getImageDataList().get(c);
		}
	             		

		//2.)Segment images, and crop to FoV
		segAndCrop();
		
		//3.)Save
		
		List<ImageData> outVolList = new ArrayList<ImageData>();
		for (int c = 0; c < numOfInput; c++){
			volInputCropped[c].setName(inParamVolsToCrop.getImageDataList().get(c).getName() +"_cropped");
			outVolList.add(volInputCropped[c]);
		}
		System.out.format(outVolList.size()+"\n");
		outParamCroppedVols.setValue(outVolList);
		
	}
	
	
	private void extractB0andMT(){
		ImageData volDWAll = inParamDW.getImageData();
		ImageData volMTAll = inParamMT.getImageData();
		
		b0Index = 16;
		numOfDW = volDWAll.getComponents();
		numOfMT = volMTAll.getComponents();
		numOfInput = inParamVolsToCrop.size();
		
		if(numOfDW == 17)
			b0Index = 16;
		else if(numOfDW == 34)
			b0Index = 0;
		else
			System.out.format("WRONG NUMBER OF DW IMAGES!!!!!! \n");
		if(numOfMT != 2)System.out.format("WRONG NUMBER OF MT IMAGES!!!!!! \n");
		
		//Split Into Array
		volDW = RegistrationUtilities.split4DImageDataIntoArray(volDWAll);
		volMT = RegistrationUtilities.split4DImageDataIntoArray(volMTAll);
		volMTSeg = RegistrationUtilities.split4DImageDataIntoArray(inParamMTSeg.getImageData());
	}
	
	
	
	private void matchResAndDim(){
		volMTMatched = new ImageData[numOfMT];
		volInputMatched = new ImageData[numOfInput];
		ModelImage inVol, MT, DW;
		AlgorithmMatchImages matchImage;
		
		//Match resolution/dimensions for all MT to DW
		DW = volDW[b0Index].getModelImageCopy();
		for (int c = 0; c < numOfMT; c++){
			MT = volMT[c].getModelImageCopy();
			matchImage = new AlgorithmMatchImages(DW, MT, true, true,true);
			matchImage.runAlgorithm();
			MT.disposeLocal();
			
			volMTMatched[c] = new ImageDataMipavWrapper(matchImage.getImageB());
		}

		//Match Resolution to DW
		DW = volDW[b0Index].getModelImageCopy();
		for (int c = 0; c < numOfInput; c++){
			inVol = RegistrationUtilities.split4DImageDataIntoArray(inParamVolsToCrop.getImageDataList().get(c))[1].getModelImageCopy();
			matchImage = new AlgorithmMatchImages(DW, inVol, true, true,true);
			matchImage.runAlgorithm();
			inVol.disposeLocal();
			
			volInputMatched[c] = new ImageDataMipavWrapper(matchImage.getImageB());
			System.out.format(volInputMatched[c].getRows() +","+volInputMatched[c].getCols() +","+volInputMatched[c].getSlices() +"\n");
		}
		DW.disposeLocal();
		

	//	volInputMatched[0]=inParamVolsToCrop.getImageDataList().get(0);
		
		//Crop BlackSpace
		int[] MTBoundingBox = calculateBoundingBox(volMTMatched);		
		for (int c = 0; c < numOfMT; c++){
			volMTMatched[c] = cropToBoundingBox(volMTMatched[c] , MTBoundingBox);
		}
		
		//Crop to MT BlackSpace
		for (int c = 0; c < numOfInput; c++){
			volInputMatched[c] = cropToBoundingBox(volInputMatched[c] , MTBoundingBox);
		}
		
	}
	
	private void segAndCrop(){

		volMTCropped = new ImageData[numOfMT];
		volInputCropped  = new ImageData[numOfInput];
		
		volB0MatchedSeg = inParamB0Seg.getImageData();

		int[] volB0SegBox = calculateBoundingBox(volB0MatchedSeg, .8, 35);
		int[] volMTSegBox = calculateBoundingBox(volMTSeg, .8, 35);
		matchBoundingBox(volB0SegBox, volMTSegBox);
				
		/*for (int c = 0; c < numOfMT; c++){
			volMTCropped[c] =  cropToBoundingBox(volMTMatched[c], volMTSegBox);
		}*/
		
		for (int c = 0; c < numOfInput; c++){
			volInputCropped[c] =  cropToBoundingBox(volInputMatched[c], volMTSegBox);
		}
				
	}
	

	private void matchBoundingBox(int[] boxA, int[] boxB){
		int widthA, widthB;
		float diff;
		for(int i = 0; i < 3; i++){
			widthA = boxA[2*i+1] - boxA[2*i];
			widthB = boxB[2*i+1] - boxB[2*i];
			if(widthA > widthB){
				diff = ((float)(widthA - widthB))/2;
				boxB[2*i] = boxB[2*i] - (int)Math.floor(diff);
				boxB[2*i + 1] = boxB[2*i + 1] + (int)Math.ceil(diff);
			}
			else if(widthA < widthB){
				diff = ((float)(widthB - widthA))/2;
				boxA[2*i] = boxA[2*i] - (int)Math.floor(diff);
				boxA[2*i + 1] = boxA[2*i + 1] + (int)Math.ceil(diff);
			}
		}
	}
	
	ImageData cropToBoundingBox(ImageData inVol, int[] boundingBox){
		
		int XN = boundingBox[1] - boundingBox[0] + 1;
		int YN = boundingBox[3] - boundingBox[2] + 1;
		int ZN = boundingBox[5] - boundingBox[4] + 1;
		ImageData croppedVol = new ImageDataMipav(inVol.getName(),inVol.getType(),XN, YN, ZN);
		int ii, jj, kk;
		for (int i = 0; i < XN; i++) for (int j = 0; j < YN; j++)for (int k = 0; k < ZN; k++){
			ii = i + boundingBox[0];
			jj = j + boundingBox[2];
			kk = k + boundingBox[4];
			croppedVol.set(i, j, k, inVol.get(ii, jj, kk));
		}
		croppedVol.setHeader(inVol.getHeader());
		return croppedVol;
		
	}
	
	int[] calculateBoundingBox(ImageData vol) {
		
		return calculateBoundingBox(vol, 0, 0);
	}
	
	int[] calculateBoundingBox(ImageData[] vol) {
		
		return calculateBoundingBox(vol, 0, 0);
	}
	
	int[] calculateBoundingBox(ImageData vol, double threshold, int pad) {
		
		ImageData[] temp = new ImageData[1];
		temp[0] = vol;
		
		return calculateBoundingBox(temp, threshold, pad);
	}
	
	int[] calculateBoundingBox(ImageData[] vol, double threshold, int pad) {
		int k, j, i,c;
		int ext;
		int boundingBox[] = new int[6];
		ext = pad;

		int XN = vol[0].getRows();;
		int YN = vol[0].getCols();
		int ZN = vol[0].getSlices();
		int CH = vol.length;
		
		boundingBox[1] = 0;
		boundingBox[0] = XN;
		boundingBox[3] = 0;
		boundingBox[2] = YN;
		boundingBox[5] = 0;
		boundingBox[4] = ZN;

		
		
		int count = 0;
		for (c = 0; c < CH; c ++){
			for (i = 0; i < XN; i++)	for (j = 0; j < YN; j++) for (k = 0; k < ZN; k++) {
					// if (subject.data[k][j][i][ch] > 0 ||
					// target.data[k][j][i][ch] > 0)
					if (vol[c].getDouble(i, j, k) > threshold)
					{
						count++;
						if (i < boundingBox[0])
							boundingBox[0] = i;
						if (i > boundingBox[1])
							boundingBox[1] = i;
						if (j < boundingBox[2])
							boundingBox[2] = j;
						if (j > boundingBox[3])
							boundingBox[3] = j;
						if (k < boundingBox[4])
							boundingBox[4] = k;
						if (k > boundingBox[5])
							boundingBox[5] = k;
					}
			}
		}

    	boundingBox[0] = Math.max(0, boundingBox[0] - ext);
		boundingBox[1] = Math.min(XN - 1, boundingBox[1] + ext);
		boundingBox[2] = Math.max(0, boundingBox[2] - ext);
		boundingBox[3] = Math.min(YN - 1, boundingBox[3] + ext);
		boundingBox[4] = Math.max(0, boundingBox[4] - ext);
		boundingBox[5] = Math.min(ZN - 1, boundingBox[5] + ext);
		



		for (i = 0; i < 6; i++) {
			  System.out.format("bb[%d]:%d ",i,boundingBox[i]); }
		System.out.format("\n");

		return boundingBox;
	}

}
