package edu.jhu.ece.iacl.plugins.dti.spine;


import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;


import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
import edu.jhu.ece.iacl.algorithms.graphics.intersector.SurfaceIntersector;
import edu.jhu.ece.iacl.algorithms.graphics.isosurf.IsoSurfaceOnGrid;
import edu.jhu.ece.iacl.algorithms.graphics.utilities.ResampleLevelSet;
import edu.jhu.ece.iacl.algorithms.registration.RegistrationUtilities;
import edu.jhu.ece.iacl.algorithms.topology.ConnectivityRule;
import edu.jhu.ece.iacl.algorithms.topology.TopologyCorrection;
import edu.jhu.ece.iacl.algorithms.vabra.VabraAlgorithm;
import edu.jhu.ece.iacl.algorithms.volume.DistanceField;
import edu.jhu.ece.iacl.jist.io.FileExtensionFilter;
import edu.jhu.ece.iacl.jist.io.ImageDataReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataInt;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipavWrapper;
import edu.jhu.ece.iacl.plugins.labeling.MedicAlgorithmMultiAtlasLabeling;
import edu.jhu.ece.iacl.plugins.registration.MedicAlgorithmTransformVolume;
import gov.nih.mipav.model.algorithms.utilities.AlgorithmMatchImages;
import gov.nih.mipav.model.structures.ModelImage;
import edu.jhu.ece.iacl.jist.structures.image.VoxelType;
import edu.jhu.ece.iacl.jist.utility.JistLogger;



public class MedicAlgorithmSpineGeoCorrection  extends ProcessingAlgorithm{
	ParamVolume inParamDW;
	ParamVolume inParamMT;
	
	ParamFile inParamMTAndDWAtlasTxt;
	
//	ParamVolumeCollection inParamMTAtlases;
//	ParamVolumeCollection inParamMTAtlasMasks;
	
//	ParamVolumeCollection inParamB0Atlases;
//	ParamVolumeCollection inParamB0AtlasMasks;
	ParamFile inParamVABRAConfigFile;
	ParamInteger inParamB0index;
	
	
	ParamVolume outParamCroppedB0;
	ParamVolume outParamCroppedMTCh1;
	ParamVolume outParamCroppedMTCh2;
	ParamVolume outParamCroppedDW;
	ParamVolume outParamCroppedMask;
	ParamVolume outParamSegB0;
	ParamVolume outParamSegMT;
	ParamVolume outParamMatchedDW;
	ParamVolume outParamMatchedMT;
	//ParamVolume outParamRegisteredB0;

	
	ArrayList<ImageData> B0AtlasesList; 
	ArrayList<ImageData> B0AtlasMasksList;
	ArrayList<ImageData> MTAtlasesList;
	ArrayList<ImageData> MTAtlasMasksList;
	ImageData[] volDW, volDWMatched, volDWCropped;
	ImageData volB0MatchedSeg;
	ImageData volMaskCropped;
	ImageData[] volMT, volMTMatched, volMTSeg, volMTCropped;
	int numOfDW, numOfMT, b0Index;

	
	private static final String revnum = DistanceField.getVersion();
	private static final String cvsversion = "$Revision: 1.2 $".replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Fixes geometry distortion in spine DW images using MT as reference";
	private static final String longDescription = "";

	public String[] getDefaultJVMArgs() {
		return new String[] { "-XX:MinHeapFreeRatio=70",
				"-XX:MaxHeapFreeRatio=95",
				"-XX:YoungGenerationSizeIncrement=150",
				"-XX:TenuredGenerationSizeIncrement=150" };
	}

	protected void createInputParameters(ParamCollection inputParams) {
		
		ParamCollection mainParams = new ParamCollection("Main");
		mainParams.add(inParamDW=new ParamVolume("Diffusion Weighted Image (DW)"));
		mainParams.add(inParamMT=new ParamVolume("Magnetization Transfer Image (MT)"));
		mainParams.add(inParamB0index=new ParamInteger("Index for B0 Direction in DW",0));
		
		//ParamCollection segParams = new ParamCollection("Segmentation");
		
		inParamVABRAConfigFile = new ParamFile("VABRA Configuration", ParamFile.DialogType.FILE);
		inParamVABRAConfigFile.setExtensionFilter(new FileExtensionFilter(new String[] { "xml" }));
		URL url = VabraAlgorithm.class.getResource("config.xml");
		try {
			if(url!=null) {
				inParamVABRAConfigFile.setValue(new File(url.toURI()));	
			} else {			
				inParamVABRAConfigFile.setValue(new File("")); // prevent crash when module is not found
			}
		} catch (URISyntaxException e) {
			inParamVABRAConfigFile.setValue(new File("")); // prevent crash when module is not found
			e.printStackTrace();
			JistLogger.logError(JistLogger.INFO, "Continuing with library build.");
		}
		mainParams.add(inParamVABRAConfigFile);
		mainParams.add(inParamMTAndDWAtlasTxt = new ParamFile("MT and B0 Atlas File"));

//		segParams.add(inParamMTAtlases = new ParamVolumeCollection("MT Atlases"));
//		segParams.add(inParamMTAtlasMasks = new ParamVolumeCollection("MT Atlas Masks"));
//		segParams.add(inParamB0Atlases = new ParamVolumeCollection("B0 Atlases"));
//		segParams.add(inParamB0AtlasMasks = new ParamVolumeCollection("B0 Atlas Masks"));		
	
		inputParams.add(mainParams);
		//inputParams.add(segParams);

		inputParams.setPackage("IACL");
		inputParams.setCategory("DTI");
		inputParams.setLabel("Spine Geometry Correction");
		inputParams.setName("SpineGeoCorrect");	


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.add(PrinceGroupAuthors.minChen);
		info.setDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.BETA);
	}


	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outParamCroppedB0=new ParamVolume("B0 Cropped"));
		outputParams.add(outParamCroppedMTCh1=new ParamVolume("MT Channel 1(off) Cropped"));
		outputParams.add(outParamCroppedMTCh2=new ParamVolume("MT Channel 2(on) Cropped"));
		outputParams.add(outParamCroppedDW=new ParamVolume("DW (All) Cropped",null,-1,-1,-1,-1));
		outputParams.add(outParamCroppedMask=new ParamVolume("Cropped Binary Mask"));
		outputParams.add(outParamSegB0=new ParamVolume("B0 Segmentation"));
		outputParams.add(outParamSegMT=new ParamVolume("MT (Both) Segmentation",null,-1,-1,-1,-1));
		outputParams.add(outParamMatchedDW=new ParamVolume("DW (All) Resolution Matched",null,-1,-1,-1,-1));
		outputParams.add(outParamMatchedMT=new ParamVolume("MT(Both) Resoltuion matched",null,-1,-1,-1,-1));
		//outputParams.add(outParamRegisteredB0=new ParamVolume("B0 Registered to MT"));
				
	}


	protected void execute(CalculationMonitor monitor) {




		//0.)Extract B0 and first channel of MT
		extractB0andMT();

		//1.)Resolution and Dimension Match, and crop out black space
		matchResAndDim();

		//2.)Segment images, and crop to max dimensions
		loadAtlasFiles(inParamMTAndDWAtlasTxt.getValue().getAbsolutePath());
		segAndCrop();
		
		//3.)VABRA without affine to match B0 to MT

		//5.)Recombine and Save Output
		recombAndSave();
		
	}
	
	
	private void extractB0andMT(){
		ImageData volDWAll = inParamDW.getImageData();
		ImageData volMTAll = inParamMT.getImageData();
		
		b0Index = inParamB0index.getInt();
		numOfDW = volDWAll.getComponents();
		numOfMT = volMTAll.getComponents();
		
		if(b0Index >= numOfDW)
			System.out.format("B0 INDEX EXCEEDS NUMBER OF DW IMAGES!!!!!! \n");
		if(numOfMT != 2)
			System.out.format("WRONG NUMBER OF MT IMAGES, SHOULD BE 2!!!!!! \n");
		
		//Split Into Array
		volDW = RegistrationUtilities.split4DImageDataIntoArray(volDWAll);
		volMT = RegistrationUtilities.split4DImageDataIntoArray(volMTAll);
		
	}
	
	
	
	private void matchResAndDim(){
		volDWMatched = new ImageData[numOfDW];		
		volMTMatched = new ImageData[numOfMT];
		ModelImage MT, DW;
		AlgorithmMatchImages matchImage;
		
		//Match resolution/dimensions for all MT to DW
		DW = volDW[b0Index].getModelImageCopy();
		for (int c = 0; c < numOfMT; c++){
			MT = volMT[c].getModelImageCopy();
			matchImage = new AlgorithmMatchImages(DW, MT, true, true,true);
			matchImage.runAlgorithm();
			MT.disposeLocal();
			
			volMTMatched[c] = new ImageDataMipavWrapper(matchImage.getImageB());
		}
		DW.disposeLocal();

			

		//Match resolution/dimensions for all DW to MT
		MT = volMTMatched[0].getModelImageCopy();
		for (int c = 0; c < numOfDW; c++){
			System.out.format("C: " + c+"\n");
			DW = volDW[c].getModelImageCopy();
			matchImage = new AlgorithmMatchImages(MT, DW, true, true,true);
			matchImage.runAlgorithm();
			DW.disposeLocal();
		
			volDWMatched[c] =new ImageDataMipavWrapper(matchImage.getImageB());
			volDWMatched[c].setHeader(inParamDW.getImageData().getHeader());
		}
		MT.disposeLocal();

		//Crop BlackSpace
		int[] MTBoundingBox = calculateBoundingBox(volMTMatched);		
		int[] B0BoundingBox = calculateBoundingBox(volDWMatched[b0Index]);
		for (int c = 0; c < numOfMT; c++){
			volMTMatched[c] = cropToBoundingBox(volMTMatched[c] , MTBoundingBox);

		}
		for (int c = 0; c < numOfDW; c++){
			volDWMatched[c] = cropToBoundingBox(volDWMatched[c], B0BoundingBox);
		}
		
	}
	
	private void segAndCrop(){

		volMTSeg = new ImageData[numOfMT];
		volMTCropped = new ImageData[numOfMT];
		volDWCropped = new ImageData[numOfDW]; 

		MedicAlgorithmMultiAtlasLabeling spineSeg = new MedicAlgorithmMultiAtlasLabeling(); 
		spineSeg.multivabra.vabra.inParamConfigFile.setValue(inParamVABRAConfigFile.getValue());
		spineSeg.multivabra.vabra.inParamUseFlirt.setValue(false);
		spineSeg.inParamSaveDefAtlases.setValue(true);
		spineSeg.setOutputDirectory(this.getOutputDirectory());

		//Find segmentation for b0
		spineSeg.inParamTarget.setValue(volDWMatched[b0Index]);
		spineSeg.inParamAtlases.setValue(B0AtlasesList);
		spineSeg.inParamAtlasLabels.setValue(B0AtlasMasksList);
		spineSeg.runAlgorithm();
		volB0MatchedSeg = spineSeg.outParamLabeledTarget.getImageData();
		
		
		spineSeg = new MedicAlgorithmMultiAtlasLabeling(); 
		spineSeg.multivabra.vabra.inParamConfigFile.setValue(inParamVABRAConfigFile.getValue());
		spineSeg.multivabra.vabra.inParamUseFlirt.setValue(false);
		spineSeg.inParamSaveDefAtlases.setValue(true);
		spineSeg.setOutputDirectory(this.getOutputDirectory());
		
		spineSeg.inParamTarget.setObject(volMTMatched[1]);
		spineSeg.inParamAtlases.setValue(MTAtlasesList);
		spineSeg.inParamAtlasLabels.setValue(MTAtlasMasksList);
		spineSeg.runAlgorithm();
		volMTSeg[1] =new ImageDataInt(spineSeg.outParamLabeledTarget.getImageData());
		volMTSeg[1].setHeader(inParamMT.getImageData().getHeader());
		volMTSeg[0] = volMTSeg[1].clone(); 
	
		int[] volB0SegBox = calculateBoundingBox(volB0MatchedSeg, .8, 35);
		int[] volMTSegBox = calculateBoundingBox(volMTSeg, .8, 35);
		matchBoundingBox(volB0SegBox, volMTSegBox);
		
		for (int c = 0; c < numOfDW; c++){
			volDWCropped[c] = cropToBoundingBox(volDWMatched[c], volB0SegBox);
		}
		
		for (int c = 0; c < numOfMT; c++){
			volMTCropped[c] =  cropToBoundingBox(volMTMatched[c], volMTSegBox);
		}
		
		volMaskCropped = createCroppedMask(volB0SegBox, volMTSegBox);
		
	}
	
	final public void loadAtlasFiles(String filename) {
		try {
			File f = new File(filename);
			FileReader fr = new FileReader(f);
			BufferedReader br = new BufferedReader(fr);
			String line = br.readLine();
			// Exact corresponding template
			if (!line.equals("Spinal Cord Geometry Correction Atlas List")) {
				System.out.println("Not a proper atlas file\n");
				br.close();
				fr.close();
				return;
			}
			
			B0AtlasesList = new ArrayList<ImageData>(); 
			B0AtlasMasksList = new ArrayList<ImageData>();
			MTAtlasesList = new ArrayList<ImageData>();
			MTAtlasMasksList = new ArrayList<ImageData>();

			ImageData atlasVol;
			while (true) {
				line = br.readLine();

				if (line==null||line.isEmpty())break;

				String[] lin = line.split(" ");
				String type = lin[0].toLowerCase();
				if (type.compareTo("mt_atlas")==0) {
					String atlasFilename = f.getParent()+File.separator + lin[1];
					atlasVol = ImageDataReaderWriter.getInstance().read(new File(atlasFilename));
					MTAtlasesList.add(atlasVol);
				} else if(type.compareTo("mt_atlas_mask")==0){
					String atlasFilename = f.getParent()+File.separator + lin[1];
					atlasVol = ImageDataReaderWriter.getInstance().read(new File(atlasFilename));
					MTAtlasMasksList.add(atlasVol);
				} else if(type.compareTo("b0_atlas")==0){
					String atlasFilename = f.getParent()+File.separator + lin[1];
					atlasVol = ImageDataReaderWriter.getInstance().read(new File(atlasFilename));
					B0AtlasesList.add(atlasVol);
				} else if(type.compareTo("b0_atlas_mask")==0){
					String atlasFilename = f.getParent()+File.separator + lin[1];
					atlasVol = ImageDataReaderWriter.getInstance().read(new File(atlasFilename));
					B0AtlasMasksList.add(atlasVol);
				}
			}
			br.close();
			fr.close();
		} catch (FileNotFoundException e) {
			System.out.println(e.getMessage());
		} catch (IOException e) {
			System.out.println(e.getMessage());
		} catch (OutOfMemoryError e) {
			System.out.println(e.getMessage());
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}

		//Final check to make sure atlases are loaded 
		boolean atlasValidCheck = false;
		try{
			for (int i = 0; i < MTAtlasesList.size(); i++){
				System.out.format("Loading MT Atlas: " + i + " ");
				System.out.format(MTAtlasesList.get(i).getName() +" ");
				System.out.format("Success!\n");
			}
			for (int i = 0; i < MTAtlasMasksList.size(); i++){
				System.out.format("Loading MT Atlas Mask: " + i + " ");
				System.out.format(MTAtlasMasksList.get(i).getName() +" ");
				System.out.format("Success!\n");
			}
			for (int i = 0; i < B0AtlasesList.size(); i++){
				System.out.format("Loading B0 Atlas: " + i + " ");
				System.out.format(B0AtlasesList.get(i).getName() +" ");
				System.out.format("Success!\n");
			}
			for (int i = 0; i < B0AtlasMasksList.size(); i++){
				System.out.format("Loading B0 Atlas Mask: " + i + " ");
				System.out.format(B0AtlasMasksList.get(i).getName() +" ");
				System.out.format("Success!\n");
			}
			atlasValidCheck = true;
		}
		catch (Exception e) {
			System.out.println(e.getMessage());
		}

		if(!atlasValidCheck){
			for(int i =0; i <10; i++)System.out.format("Problems Encountered While Loading Atlases. Check Atlas Files Exists!\n");
			System.out.flush();
			System.exit(0);
		}

		return;
	}
	
	private ImageData createCroppedMask(int[] volB0SegBox,int[] volMTSegBox){
		int XN = volB0SegBox[1] - volB0SegBox[0] + 1;
		int YN = volB0SegBox[3] - volB0SegBox[2] + 1;
		int ZN = volB0SegBox[5] - volB0SegBox[4] + 1;
		ImageData croppedMask = new ImageDataFloat(XN, YN, ZN);
		ImageData croppedMaskDilated = new ImageDataFloat(XN, YN, ZN);
		int ii, jj, kk, ii2, jj2, kk2;
		for (int i = 0; i < XN; i++) for (int j = 0; j < YN; j++)for (int k = 0; k < ZN; k++){
			ii = i + volB0SegBox[0];
			jj = j + volB0SegBox[2];
			kk = k + volB0SegBox[4];
			
			ii2 = i + volMTSegBox[0];
			jj2 = j + volMTSegBox[2];
			kk2 = k + volMTSegBox[4];
			
			if(volB0MatchedSeg.getDouble(ii, jj, kk) > 0.8 || volMTSeg[0].getDouble(ii2, jj2, kk2) > 0.8 || volMTSeg[1].getDouble(ii2, jj2, kk2) > 0.8){
				croppedMask.set(i, j, k, 1);
			}
		}
		
		for (int i = 0; i < XN; i++) for (int j = 0; j < YN; j++)for (int k = 0; k < ZN; k++){
				
				for(ii = -10; ii < 10; ii++)
					for(jj = -10; jj < 10; jj++)
						for(kk = -10; kk < 10; kk++){
								if(i+ii >= 0 && i+ii < XN)
									if(j+jj >= 0 && j+jj < YN)
										if(k+kk >= 0 && k+kk < ZN)
								if(croppedMask.getInt(i+ii, j+jj, k+kk) == 1) croppedMaskDilated.set(i, j, k, 1);
							
						}
				
		}
		
		
		croppedMaskDilated.setHeader(volB0MatchedSeg.getHeader());
		return croppedMaskDilated; 
		
		
	}

	private void recombAndSave(){
		//recombine arrays back into a single image
		ImageData volDWCroppedComb = new ImageDataFloat(RegistrationUtilities.combineImageDataArrayTo4D(volDWCropped));
		ImageData volMTSegComb =  new ImageDataInt(RegistrationUtilities.combineImageDataArrayTo4D(volMTSeg));
		ImageData volDWMatchedComb =  new ImageDataFloat(RegistrationUtilities.combineImageDataArrayTo4D(volDWMatched));
		ImageData volMTMatchedComb =  new ImageDataFloat(RegistrationUtilities.combineImageDataArrayTo4D(volMTMatched));

		//rename with tags
		volDWCropped[b0Index].setName(inParamDW.getImageData().getName()+"_b0_crop");
		volMTCropped[0].setName(inParamMT.getImageData().getName()+"_MT1_crop");
		volMTCropped[1].setName(inParamMT.getImageData().getName()+"_MT2_crop");
		volB0MatchedSeg.setName(inParamDW.getImageData().getName()+"_b0_seg");
		volMaskCropped.setName(inParamMT.getImageData().getName()+"_mask_crop");
		
		volDWCroppedComb.setName(inParamDW.getImageData().getName()+"_DW_crop");
		volMTSegComb.setName(inParamMT.getImageData().getName()+"_MT_seg");
		volDWMatchedComb.setName(inParamDW.getImageData().getName()+"_DW_ResMatch");
		volMTMatchedComb.setName(inParamMT.getImageData().getName()+"_MT_ResMatch");
		
		//set as outputs
		outParamCroppedMask.setValue(volMaskCropped);
		outParamCroppedB0.setValue(volDWCropped[b0Index]);
		outParamCroppedMTCh1.setValue(volMTCropped[0]);
		outParamCroppedMTCh2.setValue(volMTCropped[1]);
		outParamCroppedDW.setValue(volDWCroppedComb);
		outParamSegB0.setValue(volB0MatchedSeg);
		outParamSegMT.setValue(volMTSegComb);
		
		outParamMatchedDW.setValue(volDWMatchedComb);
		outParamMatchedMT.setValue(volMTMatchedComb);
		
		/*
		volMTCh1.setName("MT_matched");
		outParamRegisteredB0.setValue(volMTCh1);
		*/
		
	}


	private void matchBoundingBox(int[] boxA, int[] boxB){
		int widthA, widthB;
		float diff;
		for(int i = 0; i < 3; i++){
			widthA = boxA[2*i+1] - boxA[2*i];
			widthB = boxB[2*i+1] - boxB[2*i];
			if(widthA > widthB){
				diff = ((float)(widthA - widthB))/2;
				boxB[2*i] = boxB[2*i] - (int)Math.floor(diff);
				boxB[2*i + 1] = boxB[2*i + 1] + (int)Math.ceil(diff);
			}
			else if(widthA < widthB){
				diff = ((float)(widthB - widthA))/2;
				boxA[2*i] = boxA[2*i] - (int)Math.floor(diff);
				boxA[2*i + 1] = boxA[2*i + 1] + (int)Math.ceil(diff);
			}
		}
	}
	
	ImageData cropToBoundingBox(ImageData inVol, int[] boundingBox){
		
		int XN = boundingBox[1] - boundingBox[0] + 1;
		int YN = boundingBox[3] - boundingBox[2] + 1;
		int ZN = boundingBox[5] - boundingBox[4] + 1;
		ImageData croppedVol = new ImageDataFloat(XN, YN, ZN);
		int ii, jj, kk;
		for (int i = 0; i < XN; i++) for (int j = 0; j < YN; j++)for (int k = 0; k < ZN; k++){
			ii = i + boundingBox[0];
			jj = j + boundingBox[2];
			kk = k + boundingBox[4];
			croppedVol.set(i, j, k, inVol.getDouble(ii, jj, kk));
		}
		croppedVol.setHeader(inVol.getHeader());
		return croppedVol;
		
	}
	
	int[] calculateBoundingBox(ImageData vol) {
		
		return calculateBoundingBox(vol, 0, 0);
	}
	
	int[] calculateBoundingBox(ImageData[] vol) {
		
		return calculateBoundingBox(vol, 0, 0);
	}
	
	int[] calculateBoundingBox(ImageData vol, double threshold, int pad) {
		
		ImageData[] temp = new ImageData[1];
		temp[0] = vol;
		
		return calculateBoundingBox(temp, threshold, pad);
	}
	
	int[] calculateBoundingBox(ImageData[] vol, double threshold, int pad) {
		int k, j, i,c;
		int ext;
		int boundingBox[] = new int[6];
		ext = pad;

		int XN = vol[0].getRows();;
		int YN = vol[0].getCols();
		int ZN = vol[0].getSlices();
		int CH = vol.length;
		
		boundingBox[1] = 0;
		boundingBox[0] = XN;
		boundingBox[3] = 0;
		boundingBox[2] = YN;
		boundingBox[5] = 0;
		boundingBox[4] = ZN;

		
		
		int count = 0;
		for (c = 0; c < CH; c ++){
			for (i = 0; i < XN; i++)	for (j = 0; j < YN; j++) for (k = 0; k < ZN; k++) {
					// if (subject.data[k][j][i][ch] > 0 ||
					// target.data[k][j][i][ch] > 0)
					if (vol[c].getDouble(i, j, k) > threshold)
					{
						count++;
						if (i < boundingBox[0])
							boundingBox[0] = i;
						if (i > boundingBox[1])
							boundingBox[1] = i;
						if (j < boundingBox[2])
							boundingBox[2] = j;
						if (j > boundingBox[3])
							boundingBox[3] = j;
						if (k < boundingBox[4])
							boundingBox[4] = k;
						if (k > boundingBox[5])
							boundingBox[5] = k;
					}
			}
		}

    	boundingBox[0] = Math.max(0, boundingBox[0] - ext);
		boundingBox[1] = Math.min(XN - 1, boundingBox[1] + ext);
		boundingBox[2] = Math.max(0, boundingBox[2] - ext);
		boundingBox[3] = Math.min(YN - 1, boundingBox[3] + ext);
		boundingBox[4] = Math.max(0, boundingBox[4] - ext);
		boundingBox[5] = Math.min(ZN - 1, boundingBox[5] + ext);
		



		for (i = 0; i < 6; i++) {
			  System.out.format("bb[%d]:%d ",i,boundingBox[i]); }
		System.out.format("\n");

		return boundingBox;
	}

}
