package edu.jhu.ece.iacl.plugins.registration;

import java.util.ArrayList;
import java.util.List;
import java.util.Collections;

import edu.jhmi.rad.medic.libraries.ImageFunctions;
import edu.jhmi.rad.medic.libraries.Morphology;
import edu.jhmi.rad.medic.methods.DigitalHomeomorphism;
import edu.jhu.ece.iacl.algorithms.registration.RegistrationUtilities;
import edu.jhu.ece.iacl.jist.io.StringReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataByte;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataInt;
import edu.jhu.ece.iacl.jist.structures.image.VoxelType;
import gov.nih.mipav.view.ViewJProgressBar;

public class MedicAlgorithmApproxHomeomorphicDef extends ProcessingAlgorithm {
	// Approximate a homeomorphic deformation for a given deformation field and label pair
	public ParamVolume inParamOrigDef, inParamLabels, outParamDeformedLabel,outParamHomeoDef;
	

	private static final String rcsid = "$Id: MedicAlgorithmApproxHomeomorphicDef.java,v 1.1 2014/04/15 19:27:31 aaron_carass Exp $";
	private static final String revnum = "$Revision: 1.1 $".replace(
			"Revision: ", "").replace("$", "").replace(" ", "");

	private static final String shortDescription = "Approximate a homeomorphic deformation for a given deformation field and label pair.\n";
	private static final String longDescription = "";

	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(inParamOrigDef = new ParamVolume("Deformation to Approximate", VoxelType.FLOAT, -1, -1, -1, -1));
		inputParams.add(inParamLabels = new ParamVolume("Labels to Maintain Topology On"));
		inputParams.setLabel("Approximate Homeomorphic Deformation");
		inputParams.setName("ApproxHomeoDef");
		inputParams.setPackage("IACL");
		inputParams.setCategory("Registration.Volume");
		// inputParams.add(numRaters=new ParamInteger("Number of Raters"));
		// numRaters.setValue(new Integer(2));

		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.add(new AlgorithmAuthor("Min Chen", "",
		"http://www.iacl.ece.jhu.edu/"));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}

	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outParamHomeoDef = new ParamVolume("Homeomorphically Approximated Field", null, -1, -1, -1, -1));
		outputParams.add(outParamDeformedLabel = new ParamVolume("Homeomorphically Deformed Labels"));
	}

	protected void execute(CalculationMonitor monitor) {

		
		ImageDataFloat[] origDefSplit = splitIntoFloatArray(inParamOrigDef.getImageData());
		ImageDataByte labels = new ImageDataByte(inParamLabels.getImageData());
		
			
			
		DigitalHomeomorphism algo = new DigitalHomeomorphism(labels.toArray3d(), 
				origDefSplit[0].toArray3d(),
				origDefSplit[1].toArray3d(),
				origDefSplit[2].toArray3d(),
				labels.getRows(), labels.getCols(), labels.getSlices(),
				labels.getHeader().getDimResolutions()[0], 
				labels.getHeader().getDimResolutions()[1],
				labels.getHeader().getDimResolutions()[2],
				"6/26",
				null);

		algo.computeHomeomorphicTransformAndImage();
		
		
		ImageDataFloat[] approxDefSplit = new ImageDataFloat[3];
		
		approxDefSplit[0] = new ImageDataFloat(algo.getTransformedFieldX());
		approxDefSplit[1] = new ImageDataFloat(algo.getTransformedFieldY());
		approxDefSplit[2] = new ImageDataFloat(algo.getTransformedFieldZ());
		
		
		
		ImageData outVol = inParamOrigDef.getImageData().mimic();
		
		for(int i =0; i < outVol.getRows(); i++)
			for(int j =0; j < outVol.getCols(); j++)
				for(int k =0; k < outVol.getSlices(); k++)
					for(int c =0; c < outVol.getComponents(); c++){
						outVol.set(i,j,k,c, approxDefSplit[c].getFloat(i, j, k));
					}
		
		outVol.setName(labels.getName() + "_homeoDefField");
		outParamHomeoDef.setValue(outVol);
		
		ImageDataByte deformedLabel = new ImageDataByte(algo.getTransformed());
		deformedLabel.setHeader(labels.getHeader());
		deformedLabel.setName(labels.getName()+"_homeoDef");
		outParamDeformedLabel.setValue(new ImageDataInt(deformedLabel));
		
		
		System.out.format("\n");
		System.out.println("FINISHED");
	}
	
	private ImageDataFloat[] splitIntoFloatArray(ImageData volIn){
		
		int XN = volIn.getRows();
		int YN = volIn.getCols();
		int ZN = volIn.getSlices();
		int CH = volIn.getComponents();
		
		ImageDataFloat[] volInArray = new ImageDataFloat[CH];
		
		for (int c = 0; c < CH; c++){
			volInArray[c] = new ImageDataFloat( XN, YN, ZN);
			for (int i = 0; i < XN; i++) for (int j = 0; j < YN; j++)for (int k = 0; k < ZN; k++){
				volInArray[c].set(i, j, k, volIn.getDouble(i, j, k, c));
			}
			volInArray[c].setHeader(volIn.getHeader());
			volInArray[c].setName(volIn.getName() +"_" +c);
		}
		
		return volInArray;
	}

}
