
package edu.jhu.ece.iacl.plugins.segmentation.cruise;


import java.awt.Dimension;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;

import edu.jhmi.rad.medic.utilities.CropParameters;
import edu.jhmi.rad.medic.utilities.CubicVolumeCropper;
import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.plugins.measure.thickness.MedicAlgorithmThickness;
import edu.jhu.ece.iacl.plugins.segmentation.gdm.MedicAlgorithmNestedTGDM;
import edu.jhu.ece.iacl.plugins.topology.MedicAlgorithmTopologyCorrection;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataMath;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.VoxelType;
import edu.jhu.ece.iacl.jist.utility.FileUtil;

public class MedicAlgorithmShortCRUISE extends ProcessingAlgorithm{
	MedicAlgorithmAnatomicallyConsistentEnhance ace;
	MedicAlgorithmNestedTGDM tgdm;
	MedicAlgorithmGradVecFlow gvfCentral;

	MedicAlgorithmTopologyCorrection topoCorrect;
	ParamVolume wmfillVol;
	ParamVolume gmVol,isoVol;
	ParamVolume brainMask;
	ParamVolume maskVol;
	ParamCollection cropParams;
	ParamPointInteger offset;
	ParamPointInteger dim;
	//ParamBoolean scaleData;
	//ParamOption connectivity;

	ParamSurface uncroppedInnerSurf,uncroppedCentralSurf,uncroppedOuterSurf;
	ParamVolume croppedGM,croppedWM,croppedInitWM,uncroppedInner,uncroppedCentral,uncroppedOuter;
	ParamVolume ucSignedVol,uncroppedGvf,uncroppedEnhancedGM,uncroppedthinCSF,uncroppedTopo,uncroppedCSF,uncroppedSkel;

	private static final String cvsversion = "$Revision: 1.6 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");

	protected void createInputParameters(ParamCollection inputParams) {
		ParamCollection clspanel=new ParamCollection("Classification");
		clspanel.add(wmfillVol=new ParamVolume("WM fill",VoxelType.FLOAT));
		wmfillVol.setDescription("Ventricle filled WM membership(float), usually obtained from TOADS.");
		clspanel.add(gmVol=new ParamVolume("GM",VoxelType.FLOAT));
		gmVol.setDescription("GM membership in float");
		clspanel.add(maskVol=new ParamVolume("WM Mask",VoxelType.FLOAT));
		maskVol.setDescription("White Matter mask, should be float, usually obtained from TOADS.");
		
		brainMask=new ParamVolume("Brain Mask Level Set",VoxelType.FLOAT);
		brainMask.setMandatory(false);
		

		/*clspanel.add(connectivity = new ParamOption("Connectivity (Foreground,Background)", new String[] {
				"(18,6)", "(6,18)", "(26,6)", "(6,26)" }));
		connectivity.setDescription("To generate Cruise surface, use 18/6 connectivity");
		clspanel.add(scaleData=new ParamBoolean("Scale Data by 255",true));
		scaleData.setDescription("If the input memberships are [0,1], then scale them to [0,255]");*/
		inputParams.add(clspanel);

		topoCorrect=new MedicAlgorithmTopologyCorrection();
		/*topoCorrect.getInput().getFirstChildByName("Volume").setHidden(true);
		topoCorrect.getInput().getFirstChildByName("Paint mask").setHidden(true);
		topoCorrect.getInput().getFirstChildByName("Connectivity (Foreground,Background)").setHidden(true);
		((ParamOption)topoCorrect.getInput().getFirstChildByName("Propagation Direction")).setValue(1);
		inputParams.add(topoCorrect.getInput());*/

		gvfCentral=new MedicAlgorithmGradVecFlow();
		gvfCentral.getInput().getFirstChildByName("Volume").setHidden(true);
		inputParams.add(gvfCentral.getInput());

		ace=new MedicAlgorithmAnatomicallyConsistentEnhance();
		/*ace.getInput().getFirstChildByName("Gray Matter").setHidden(true);
		ace.getInput().getFirstChildByName("White Matter").setHidden(true);
		inputParams.add(ace.getInput());*/

		tgdm=new MedicAlgorithmNestedTGDM();
		tgdm.getInput().getFirstChildByName("Data").setHidden(true);
		tgdm.getInput().getFirstChildByName("Initial Level Set").setHidden(true);
		tgdm.getInput().getFirstChildByName("Initial Iso Level").setHidden(true);
		tgdm.getInput().getFirstChildByName("Initial Smoothing Curvature Force").setHidden(true);
		tgdm.getInput().getFirstChildByName("Iterations for Initial Smoothing").setHidden(true);
	
		
		
		inputParams.add(tgdm.getInput());


		this.setPreferredSize(new Dimension(350,450));

		inputParams.setPackage("IACL");
		inputParams.setCategory("Segmentation.CRUISE");


		inputParams.setName("CRUISE");
		inputParams.setLabel("CRUISE");

		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
		info.add(ReferencedPapers.cruise);
		info.add(PrinceGroupAuthors.xiaoHan);
		info.add(PrinceGroupAuthors.dzungPham);
		info.add(PrinceGroupAuthors.chenyangXu);
		info.add(PrinceGroupAuthors.duyguTosun);
		info.add(PrinceGroupAuthors.pierreLouisBazin);
    	info.add(PrinceGroupAuthors.blakeLucas);
    	info.setDescription("Cruise pipeline, the inputs being GM and ventricle filled WM memberships, generating cortical surfaces and thickness statistics.");
    	info.setLongDescription("Cruise takes GM and ventricle filled WM memberships, (usually obtained from TOADS). It generates smooth cortical surfaces and thickness statistics.");
    	info.setAdditionalDocURL("html/edu/jhu/ece/iacl/plugins/segmentation/cruise/MedicAlgorithmShortCRUISE/index.html");
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		uncroppedTopo=new ParamVolume("Topologically Correct WM volume");
		uncroppedGvf=new ParamVolume("Gradient Vector Field",VoxelType.FLOAT,-1,-1,-1,3);
		uncroppedEnhancedGM=new ParamVolume("ACE Enhanced GM");
		uncroppedthinCSF=new ParamVolume("ACE Thinned CSF Skeleton");
		uncroppedSkel = new ParamVolume("ACE CSF Skeleton");
		ucSignedVol=new ParamVolume("TGDM Signed Volume");
		uncroppedInner=new ParamVolume("TGDM Inner Level Set");
		uncroppedCentral=new ParamVolume("TGDM Central Level Set");
		uncroppedOuter=new ParamVolume("TGDM Outer Level Set");
		uncroppedInnerSurf=new ParamSurface("TGDM Inner Surface");
		uncroppedCentralSurf=new ParamSurface("TGDM Central Surface");
		uncroppedOuterSurf=new ParamSurface("TGDM Outer Surface");
		outputParams.add(uncroppedTopo);
		outputParams.add(uncroppedGvf);
		outputParams.add(uncroppedEnhancedGM);
		outputParams.add(uncroppedSkel);
		outputParams.add(uncroppedthinCSF);
		outputParams.add(ucSignedVol);
		outputParams.add(uncroppedInner);
		outputParams.add(uncroppedCentral);
		outputParams.add(uncroppedOuter);
		outputParams.add(uncroppedInnerSurf);
		outputParams.add(uncroppedCentralSurf);
		outputParams.add(uncroppedOuterSurf);
	}

	@Override
	protected void execute(CalculationMonitor monitor) {
		ImageDataMipav GM=new ImageDataMipav(gmVol.getImageData());
		String gmname = GM.getName();
		ImageData gm=gmVol.getImageData();
		ImageData wmfill=wmfillVol.getImageData();
		ImageData wmfillMasked;
		ImageData bmask=brainMask.getImageData();
		String wmname = wmfill.getName();
		ImageData wmmask=maskVol.getImageData();
		int rows=gm.getRows();
		int cols=gm.getCols();
		int slices=gm.getSlices();
		CubicVolumeCropper cropper = new CubicVolumeCropper();	
		gm=cropper.crop(gm, 0, 5);
		CropParameters crops=cropper.getLastCropParams();
		wmfill=cropper.crop(wmfill, crops);
		wmmask=cropper.crop(wmmask, crops);	
		if(bmask!=null){
			bmask=cropper.crop(bmask, crops);
		}
		/*if(scaleData.getValue()){
			ImageDataMath.scaleFloatValue(gm, 255.0f);
			ImageDataMath.scaleFloatValue(wmfill, 255.0f);
			ImageDataMath.scaleFloatValue(wmmask, 255.0f);
		}*/
		((ParamVolume)ace.getInput().getFirstChildByName("Gray Matter")).setValue(gm);
		((ParamVolume)ace.getInput().getFirstChildByName("White Matter")).setValue(wmfill);
		ace.runAlgorithm(monitor);
		ImageDataMipav skel = new ImageDataMipav(((ParamVolume)ace.getOutput().getFirstChildByName("Skeleton")).getImageData());
		ImageData thinnedcsf=((ParamVolume)ace.getOutput().getFirstChildByName("Thinned Skeleton")).getImageData();
		ImageData enhancedgm=((ParamVolume)ace.getOutput().getFirstChildByName("Enhanced GM")).getImageData();
		//enforce connectivity to 18/6
		int bcon=0;
		int conn=0;
		switch(conn){
			case 0:bcon=1;break;
			case 1:bcon=0;break;
			case 2:bcon=3;break;
			case 3:bcon=2;break;
		}
		wmfillMasked=wmfill.clone();
		int r=wmfillMasked.getRows();
		int c=wmfillMasked.getCols();
		int s=wmfillMasked.getSlices();
		if(bmask!=null){
			for(int i=0;i<r;i++){
				for(int j=0;j<c;j++){
					for(int k=0;k<s;k++){
						if(bmask.getDouble(i, j, k)>0){
							wmfillMasked.set(i,j,k,0);
						}
					}
				}
			}
		} else {
			//Mask out ACE skeleton to preserve inter-hemispherical fissure
			int count=0;
			for(int i=0;i<r;i++){
				for(int j=0;j<c;j++){
					for(int k=0;k<s;k++){
						if(thinnedcsf.getInt(i, j, k)>0){
							wmfillMasked.set(i,j,k,0);
							count++;
						}
					}
				}
			}
			System.out.println("MASKED "+count/(float)(r*c*s)+" "+r+" "+c+" "+s);
		}
		((ParamOption)topoCorrect.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).setValue(bcon);
		((ParamVolume)topoCorrect.getInput().getFirstChildByName("Volume")).setValue(wmfillMasked);
		((ParamVolume)topoCorrect.getInput().getFirstChildByName("Paint mask")).setValue(wmmask);
		topoCorrect.runAlgorithm(monitor);
		ImageData mask=((ParamVolume)topoCorrect.getOutput().getFirstChildByName("Topologically Correct Volume")).getImageData();

		((ParamVolume)gvfCentral.getInput().getFirstChildByName("Volume")).setValue(enhancedgm);
		gvfCentral.runAlgorithm(monitor);		
		ImageDataMipav gmvecfield=new ImageDataMipav(((ParamVolume)gvfCentral.getOutput().getFirstChildByName("Vector Field")).getImageData());

		((ParamOption)tgdm.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).setValue(conn);
		((ParamVolume)tgdm.getInput().getFirstChildByName("Initial Level Set")).setValue(mask);
		((ParamVolume)tgdm.getInput().getFirstChildByName("White Matter Membership")).setValue(wmfill);
		((ParamVolume)tgdm.getInput().getFirstChildByName("ACE Gray Matter Membership")).setValue(enhancedgm);	
		((ParamVolume)tgdm.getInput().getFirstChildByName("Gray Matter Membership")).setValue(gm);
		((ParamVolume)tgdm.getInput().getFirstChildByName(("Thinned ACE Skeleton"))).setValue(thinnedcsf);
		((ParamVolume)tgdm.getInput().getFirstChildByName(("Gradient Vector Field"))).setValue(gmvecfield);

		if(bmask!=null){
			((ParamVolume)tgdm.getInput().getFirstChildByName("Brain Mask Level Set")).setValue(bmask);
		}
		tgdm.runAlgorithm(monitor);

		EmbeddedSurface surf=((ParamSurface)tgdm.getOutput().getFirstChildByName("Inner Surface")).getSurface();
		Point3f offset = new Point3f(crops.xmin, crops.ymin, crops.zmin);
		surf.translate(offset);
		uncroppedInnerSurf.setValue(surf);
		uncroppedInnerSurf.getSurface().setName(gmname+"_innerSurface");
		surf=((ParamSurface)tgdm.getOutput().getFirstChildByName("Central Surface")).getSurface();
		surf.translate(offset);
		uncroppedCentralSurf.setValue(surf);
		uncroppedCentralSurf.getSurface().setName(gmname+"_centralSurface");
		surf=((ParamSurface)tgdm.getOutput().getFirstChildByName("Outer Surface")).getSurface();
		surf.translate(offset);
		uncroppedOuterSurf.setValue(surf);
		uncroppedOuterSurf.getSurface().setName(gmname+"_outerSurface");

		ImageDataMipav topo=new ImageDataMipav(mask);
//		ImageDataMipav csf=((ParamVolume)ace.getOutput().getFirstChildByName("Skeleton")).getImageData();
		ImageDataMipav inner=new ImageDataMipav(((ParamVolume)tgdm.getOutput().getFirstChildByName("Inner Level Set")).getImageData());
		ImageDataMipav central=new ImageDataMipav(((ParamVolume)tgdm.getOutput().getFirstChildByName("Central Level Set")).getImageData());
		ImageDataMipav outer=new ImageDataMipav(((ParamVolume)tgdm.getOutput().getFirstChildByName("Outer Level Set")).getImageData());
		ImageDataMipav signedvol=new ImageDataMipav(((ParamVolume)tgdm.getOutput().getFirstChildByName("Signed Volume")).getImageData());
		ImageDataMipav thinCSF=new ImageDataMipav(((ParamVolume)ace.getOutput().getFirstChildByName("Thinned Skeleton")).getImageData());
		ImageDataMipav gvf=new ImageDataMipav(((ParamVolume)gvfCentral.getOutput().getFirstChildByName("Vector Field")).getImageData());
		Point3i d=new Point3i(crops.getCroppedRows(),crops.getCroppedCols(),crops.getCroppedSlices());
		Point3i off=new Point3i(crops.xmin,crops.ymin,crops.zmin);
		CropParameters uncrop=new CropParameters(rows,cols,slices,1,off.x,d.x+off.x-1,off.y,d.y+off.y-1,off.z,d.z+off.z-1,20);
		CropParameters uncrop2=new CropParameters(rows,cols,slices,1,off.x,d.x+off.x-1,off.y,d.y+off.y-1,off.z,d.z+off.z-1,0);
		CropParameters uncrop3=new CropParameters(rows,cols,slices,3,off.x,d.x+off.x-1,off.y,d.y+off.y-1,off.z,d.z+off.z-1,0);

		ImageData B=cropper.uncrop(gvf, uncrop3);
		B.setName(gmname+"_gradvecfield");
		ImageDataMipav C= new ImageDataMipav(B);
//		C.getModelImageCopy().copyFileTypeInfo(GM.getModelImageCopy());
		//FileUtil.updateFileInfo(GM.getModelImageCopy(), C.getModelImageCopy());
		C.setHeader(GM.getHeader());
		
		uncroppedGvf.setValue(C);

		ImageData A=cropper.uncrop(signedvol,uncrop);
		A.setName(gmname + "_signedVol");
		ucSignedVol.setValue(A);
		//ucSignedVol.getImageData().getModelImageCopy().copyFileTypeInfo(GM.getModelImageCopy());
		ucSignedVol.getImageData().setHeader(GM.getHeader());
		
		A=cropper.uncrop(inner,uncrop);
		A.setName(gmname + "_innerlevelset");
		uncroppedInner.setValue(A);
		//uncroppedInner.getImageData().getModelImageCopy().copyFileTypeInfo(GM.getModelImageCopy());
		uncroppedInner.getImageData().setHeader(GM.getHeader());
		
		A=cropper.uncrop(central,uncrop);
		A.setName(gmname + "_centrallevelset");
		uncroppedCentral.setValue(A);
		//uncroppedCentral.getImageData().getModelImageCopy().copyFileTypeInfo(GM.getModelImageCopy());
		uncroppedCentral.getImageData().setHeader(GM.getHeader());
		
		A=cropper.uncrop(outer,uncrop);
		A.setName(gmname + "_outerlevelset");
		uncroppedOuter.setValue(A);
		//uncroppedOuter.getImageData().getModelImageCopy().copyFileTypeInfo(GM.getModelImageCopy());
		uncroppedOuter.getImageData().setHeader(GM.getHeader());

		A=cropper.uncrop(topo,uncrop2);
		A.setName(wmname + "_topocorrected");
		uncroppedTopo.setValue(A);
		//uncroppedTopo.getImageData().getModelImageCopy().copyFileTypeInfo(GM.getModelImageCopy());
		uncroppedTopo.getImageData().setHeader(GM.getHeader());

		A=cropper.uncrop(enhancedgm,uncrop2);
		A.setName(gmname + "_ACEenhanced");
		uncroppedEnhancedGM.setValue(A);
		//uncroppedEnhancedGM.getImageData().getModelImageCopy().copyFileTypeInfo(GM.getModelImageCopy());
		uncroppedEnhancedGM.getImageData().setHeader(GM.getHeader());

		A=cropper.uncrop(skel,uncrop2);
		A.setName(gmname + "_ACESkeleton");
		uncroppedSkel.setValue(A);
		//uncroppedSkel.getImageData().getModelImageCopy().copyFileTypeInfo(GM.getModelImageCopy());
		uncroppedSkel.getImageData().setHeader(GM.getHeader());

		A=cropper.uncrop(thinCSF,uncrop2);
		A.setName(gmname + "_thinnedCSFskel");
		uncroppedthinCSF.setValue(A);
		//uncroppedthinCSF.getImageData().getModelImageCopy().copyFileTypeInfo(GM.getModelImageCopy());
		uncroppedthinCSF.getImageData().setHeader(GM.getHeader());
	}
}
