/*
 * 
 */
package edu.jhu.ece.iacl.plugins.segmentation.skull_strip;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;

import Jama.Matrix;
import edu.jhmi.rad.medic.algorithms.AlgorithmFantasm;
import edu.jhu.ece.iacl.algorithms.skull_strip.SPECTRE2009;
import edu.jhu.ece.iacl.algorithms.skull_strip.SPECTRE2009.ImageModality;
import edu.jhu.ece.iacl.algorithms.skull_strip.SPECTRE2009.OutputType;
import edu.jhu.ece.iacl.algorithms.volume.IsotropicResample;
import edu.jhu.ece.iacl.algorithms.volume.MSP;
import edu.jhu.ece.iacl.algorithms.volume.ReorientVolume;
import edu.jhu.ece.iacl.algorithms.volume.TransformVolume;
import edu.jhu.ece.iacl.algorithms.volume.IsotropicResample.InterpolationMethod;
import edu.jhu.ece.iacl.algorithms.volume.ReorientVolume.Interpolation;
import edu.jhu.ece.iacl.algorithms.volume.ReorientVolume.Orientation;
import edu.jhu.ece.iacl.algorithms.volume.ReorientVolume.Resolution;
import edu.jhu.ece.iacl.jist.io.ImageDataReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.plugins.classification.MedicAlgorithmFantasm;
import edu.jhu.ece.iacl.plugins.registration.MedicAlgorithmFLIRT;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataIntent;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipavWrapper;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataUByte;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.image.ImageHeader;
import gov.nih.mipav.model.algorithms.utilities.AlgorithmMatchImages;
import gov.nih.mipav.model.structures.ModelImage;
import gov.nih.mipav.model.structures.ModelStorageBase;


import edu.jhu.ece.iacl.jist.structures.image.ImageHeader.AxisOrientation;
/*
 * @author Aaron Carass <aaron_carass@jhu.edu>
 * @author Hanlin Wan <hanlinwan@gmail.com>
 * @author Min Chen <mchen55@jhu.edu>
 */
public class MedicAlgorithmSPECTRE2010 extends ProcessingAlgorithm {
	private static final String[] modalities = { "T1_SPGR", "T1_ALT", "T1_MPRAGE", "T2", "FLAIR" };
	private OutputType outputType = OutputType.ALL;

	private HashMap<String,ArrayList> atlasFile;

	//private int registrationScale;

	private double initPrior;

	private double minPrior;

	private int initialErosionSize;
	private int mmcDilationSize;
	private int mmcErosionSize;
	private int max_iterations = 1;

	private	double smoothing;
	private double bgThreshold;


	private ParamBoolean runSmoothBrainMask;
	private ParamBoolean outputInOriginalSpace;
	private ParamFile atlasText;

	private ParamDouble priorInitText;
	private ParamDouble priorMinText;

	private ParamInteger initialErosionText;
	private ParamInteger mmcDilationText;
	private ParamInteger mmcErosionText;

	private ParamOption comboModality;

	// Boolean to decide if we make volumes isotropic.
	private ParamBoolean IsotropicResampleBool;

	private ParamVolume priorVol, segVol;
	private ParamVolume marchVol;
	private ParamVolume d0Vol, d1Vol, d2Vol, d3Vol;

	private ParamVolume maskVol;
	private ParamVolume reorientedVol;
	// private ParamVolume trimmedVol;

	private String maskType;

	private String modality;

	private String transformType;

	private ParamVolume origVol, resultVol;

	private int Natlas;

	// private AlgorithmRegOAR3D register = null;

	// private AlgorithmTransform transform = null;

	private AlgorithmFantasm segment = null;
	private ParamBoolean InhomogeneityCorrectionBool;
	private ParamDouble smoothingText;
	private ParamDouble bgThresholdText;

	private ParamBoolean runMSP;
	private ParamBoolean oPlane;
	private ParamBoolean oOutSplit;
	private ParamBoolean oPlaneSeg;
	private ParamVolume plane;
	private ParamVolume outSplit;
	private ParamVolume planeSeg;

	// private ModelImage image; // source image

	private ImageDataMipav[] atlasImages; // images to register in the atlas

	private ImageDataMipav[] atlasMasks; // associated masks
	//private ModelImage resultImage = null; // result image

	private ModelImage segImage; // the segmentation image

	private MedicAlgorithmFLIRT flirt;

	// private MedicAlgorithmFantasm fantasm;

	private static final String rcsid = "$Id: MedicAlgorithmSPECTRE2010.java,v 1.10 2014/04/15 19:27:32 aaron_carass Exp $";
	private static final String cvsversion = "$Revision: 1.10 $".replace(
			"Revision: ", "").replace("$", "").replace(" ", "");
	private static final String revnum = SPECTRE2009.get_version();
	private static final String shortDescription = "Simple Paradigm for Extra-Cranial Tissue REmoval\n"
		+ "################################################\n"
		+ "Algorithm Version: "
		+ revnum
		+ "\n"
		+ "GUI Version: "
		+ cvsversion + "\n";
	private static final String longDescription = "";


	protected void createInputParameters(ParamCollection inputParams) {
		maskType = "binary";
		modality = "T1-ALT";
		transformType = "affine";
		//registrationScale = 2;
		initPrior = 0.350;
		minPrior = 0.100;
		initialErosionSize = 5;
		mmcDilationSize = 2;
		mmcErosionSize = 2;
		smoothing = 0.02;
		bgThreshold = 0.001;
		flirt = new MedicAlgorithmFLIRT();
		// fantasm = new MedicAlgorithmFantasm();

		ParamCollection mainParams = new ParamCollection("Main");
		origVol = new ParamVolume("Input Volume");
		origVol.setDescription("Input volume to be skullstripped.");

		atlasText = new ParamFile("Atlas List");
		atlasText.setDescription("SPECTRE atlas description file. A text file enumerating atlas files and landmarks.");


		/*
		 * This comes from Bhaskar.
		 */
		String atlasFileName = "Atlas/spectre/oasis-3.txt";
		try {
			ClassLoader cl = Thread.currentThread().getContextClassLoader();
			atlasText.setValue(cl.getResource(atlasFileName).getFile());
		} catch (Exception e) {
			//System.err.print("Error: Unable to set default atlas\n");
		}


		initialErosionText = new ParamInteger("Initial Erosion distance", 0, 20, initialErosionSize);
		initialErosionText.setDescription("Erosion of the inital mask, which is based on the probability mask and the classification.\nThe initial mask is ouput as the d0 volume at the conclusion of SPECTRE.");

		comboModality = new ParamOption("Image modality", modalities);
		comboModality.setDescription("Set the image modality. MP-RAGE is recommended for most T1 sequence images.");
		comboModality.setValue(2);

		outputInOriginalSpace = new ParamBoolean("Output in Original Image Space", false);
		outputInOriginalSpace.setDescription("Determines if the output results are transformed back into the space of the original input image.");

		runMSP = new ParamBoolean("Find Midsaggital Plane", true);

		mainParams.add(origVol);
		mainParams.add(atlasText);
		mainParams.add(initialErosionText);
		mainParams.add(comboModality);
		mainParams.add(outputInOriginalSpace);
		mainParams.add(runMSP);


		ParamCollection advParams = new ParamCollection("Advanced");

		IsotropicResampleBool = new ParamBoolean("Resample data to Isotropic voxels", false);
		IsotropicResampleBool.setDescription("Determines if the data is resampled to be isotropic during the processing.");

		priorInitText = new ParamDouble("Initial probability threshold", initPrior);
		priorInitText.setDescription("Initial probability threshold");

		priorMinText = new ParamDouble("Minimum probability threshold", minPrior);
		priorMinText.setDescription("Minimum probability threshold");

		mmcDilationText = new ParamInteger("MMC Dilation distance", 0, 20, mmcDilationSize);
		mmcDilationText.setDescription("The size of the dilation step within the Modified Morphological Closing.");

		mmcErosionText = new ParamInteger("MMC Erosion distance", 0, 20, mmcErosionSize);
		mmcErosionText.setDescription("The size of the erosion step within the Modified Morphological Closing.");


		advParams.add(runSmoothBrainMask = new ParamBoolean("Run Smooth Brain Mask",true));
		advParams.add(IsotropicResampleBool);
		advParams.add(priorInitText);
		advParams.add(priorMinText);
		advParams.add(mmcDilationText);
		advParams.add(mmcErosionText);


		flirt.source.setHidden(true);
		flirt.target.setHidden(true);
		flirt.refWeight.setHidden(true);
		flirt.inputWeight.setHidden(true);


		ParamCollection fantasmParams = new ParamCollection("FANTASM");
		InhomogeneityCorrectionBool = new ParamBoolean("Inhomogeneity Correction", false);
		InhomogeneityCorrectionBool.setDescription("Set to false by default, this parameter will make FANTASM try to do inhomogeneity correction during it's iterative cycle.");
		smoothingText = new ParamDouble("Smoothing parameter", smoothing);
		smoothingText.setDescription("");
		bgThresholdText = new ParamDouble("Background threshold (%)", bgThreshold);
		bgThresholdText.setDescription("");

		fantasmParams.add(InhomogeneityCorrectionBool);
		fantasmParams.add(smoothingText);
		fantasmParams.add(bgThresholdText);

		ParamCollection msp = new ParamCollection("MSP");
		msp.add(oPlane = new ParamBoolean("Output Plane?",true));
		msp.add(oOutSplit = new ParamBoolean("Output Split-Halves?",true));
		msp.add(oPlaneSeg = new ParamBoolean("Output Segmentation on Plane?",true));

		// ((ParamVolumeCollection)fantasm.getInput().getFirstChildByName("Image
		// to segment")).setHidden(true);
		// ((ParamInteger)fantasm.getInput().getFirstChildByName("Number of
		// classes")).setHidden(true);
		// ((ParamInteger)fantasm.getInput().getFirstChildByName("Maximum
		// iterations")).setHidden(true);

		inputParams.add(mainParams);
		inputParams.add(advParams);
		inputParams.add(fantasmParams);
		inputParams.add(msp);
		inputParams.add(flirt.getInput());
		// inputParams.add(fantasm.getInput());
		// setPreferredSize(new Dimension(300, 600));


		inputParams.setPackage("IACL");
		inputParams.setCategory("Segmentation.Skull_Stripping");
		inputParams.setLabel("SPECTRE 2010");
		inputParams.setName("SPECTRE_2010");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.add(new AlgorithmAuthor("Aaron Carass", "aaron_carass@jhu.edu", "http://www.iacl.ece.jhu.edu/"));
		info.add(new AlgorithmAuthor("Hanlin Wan", "hanlinwan@gmail.com", ""));
		info.add(new AlgorithmAuthor("Min Chen", "mchen55@jhu.edu", ""));
		info.setAffiliation("Johns Hopkins University, Departments of Electrical and Computer Engineering");
		info.add(new Citation("A. Carass, M.B. Wheeler, J. Cuzzocreo, P.-L. Bazin, S.S. Bassett, and J.L. Prince, 'A Joint Registration and Segmentation Approach to Skull Stripping', Fourth IEEE International Symposium on Biomedical Imaging (ISBI 2007), Arlington, VA, April 12-15, 2007."));
		info.add(new Citation("A. Carass, J. Cuzzocreo, M.B. Wheeler, P.-L. Bazin, S.M. Resnick, and J.L. Prince, 'Simple paradigm for extra-cerebral tissue removal: Algorithm and analysis', NeuroImage 56(4):1982-1992, 2011."));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.Release);
		info.setAdditionalDocURL("html/edu/jhu/ece/iacl/plugins/segmentation/skull_strip/MedicAlgorithmSPECTRE/index.html");
	}


	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(reorientedVol = new ParamVolume("Original or Reoriented Volume"));
		reorientedVol.setDescription("If Output in Original Space Flag is true then outputs the original input volume. Otherwise outputs the axialy reoriented input volume.");
		// outputParams.add(trimmedVol = new ParamVolume("Trimmed Volume"));
		outputParams.add(resultVol = new ParamVolume("Stripped Volume"));
		resultVol.setDescription("Skullstripped result of the input volume with just the brain.");

		outputParams.add(maskVol = new ParamVolume("Mask Volume"));
		maskVol.setDescription("Binary Mask of the skullstripped result with just the brain");

		maskVol.setDataIntent(ImageDataIntent.NIFTI_INTENT_LABEL);
		outputParams.add(priorVol = new ParamVolume("Prior Volume"));
		priorVol.setDescription("Probability prior from the atlas registrations");
		outputParams.add(segVol = new ParamVolume("FANTASM Segmentation"));
		segVol.setDescription("Tissue classification of of the whole input volume.");
		segVol.setDataIntent(ImageDataIntent.NIFTI_INTENT_LABEL);
		// outputParams.add(marchVol = new ParamVolume("Fast Marching Output"));
		outputParams.add(d0Vol = new ParamVolume("d0"));
		d0Vol.setDescription("Initial Brainmask");
		// outputParams.add(d1Vol = new ParamVolume("d1"));
		// outputParams.add(d2Vol = new ParamVolume("d2"));
		// outputParams.add(d3Vol = new ParamVolume("d3"));

		// outputParams.add(fantasm.getOutput());
		// outputParams.getFirstChildByName("Execution Time").setHidden(true);

		outputParams.add(plane = new ParamVolume("Midsagittal Plane",null,-1,-1,-1,-1));
		plane.setDescription("Plane dividing the brain hemispheres");
		plane.setMandatory(false);
		plane.setDataIntent(ImageDataIntent.NIFTI_INTENT_LABEL);

		outputParams.add(outSplit = new ParamVolume("Split-Halves Volume",null,-1,-1,-1,-1));
		outSplit.setDescription("Skullstripped mask of the brain with the hemispheres divided.");
		outSplit.setMandatory(false);
		outSplit.setDataIntent(ImageDataIntent.NIFTI_INTENT_LABEL);

		outputParams.add(planeSeg = new ParamVolume("Segmentation on Midsagittal Plane",null,-1,-1,-1,-1));
		planeSeg.setDescription("2D image showing the tissue classification on the midsagittal plane");
		planeSeg.setMandatory(false);
		planeSeg.setDataIntent(ImageDataIntent.NIFTI_INTENT_LABEL);
	}


	protected void execute(CalculationMonitor monitor)
	throws AlgorithmRuntimeException {
		SPECTREwrapper algo_run = new SPECTREwrapper();
		monitor.observe(algo_run);
		algo_run.execute();
	}


	protected class SPECTREwrapper extends AbstractCalculation {
		public SPECTREwrapper() {
			setLabel("SPECTRE 2010 " + revnum);
		}


		public void execute() {
			// System.out.println("start");
			ImageDataMipav image = new ImageDataMipav(origVol.getImageData());
			ImageHeader header = image.getHeader();

			// System.out.println("img");
			loadAtlasFiles(atlasText.getValue().getAbsolutePath());
			// System.out.println("atlas");

			//System.out.format(image.getName());
			//System.out.format(":"+atlasImages.length+"\n");

			//If not outputting in original space then make axial and isotropic(if checked)
			if(!outputInOriginalSpace.getValue()){
				image = ReorientVolume.solve(image, atlasImages[0],
						Orientation.AXIAL, Resolution.UNCHANGED,
						Interpolation.WINDOWED_SINC);

				if (IsotropicResampleBool.getValue()) {
					System.out.println("\n\nISOTROPIC RESAMPLE");
					System.out.print("Old resolution:");
					float[] res = image.getHeader().getDimResolutions();
					System.out.println(res[0] + " x " + res[1] + " x " + res[2] );
					image = IsotropicResample.resample(image, InterpolationMethod.WSINC);
					System.out.print("New resolution:");
					res = image.getHeader().getDimResolutions();
					System.out.println(res[0] + " x " + res[1] + " x " + res[2]);
				} else {
					System.out.println("\n\nSKIPPING ISOTROPIC RESAMPLE\n");
				}
				
				header = image.getHeader();
				header.setAxisOrientation(new AxisOrientation[]{AxisOrientation.R2L_TYPE,AxisOrientation.A2P_TYPE,AxisOrientation.I2S_TYPE});
				header.setImageOrientation(ImageHeader.ImageOrientation.AXIAL);
			}				

			int XN = image.getRows();
			int YN = image.getCols();
			int ZN = image.getSlices();

			ParamVolume srcVol = flirt.source;
			ParamVolume targetVol = flirt.target;


			targetVol.setValue(image);
			Point3i dimensions = new Point3i(XN, YN, ZN);
			float[] inputImgRes = image.getHeader().getDimResolutions();
			float[][] atlasRes = new float[Natlas][3];
			Point3f resolutions = new Point3f(inputImgRes[0], inputImgRes[1], inputImgRes[2]);

			Matrix[] transMatrix = new Matrix[Natlas];
			System.out.println("\n\nALIGNING ATLASES\n");
			for (int i = 0; i < Natlas; i++) {
				srcVol.setValue(atlasImages[i]);
				atlasRes[i] = atlasImages[i].getHeader().getDimResolutions();//save atlas resolutions for later
				
				//if outputing in original space, then affine range needs to be made larger to allow full rotations
				if (outputInOriginalSpace.getValue()){
					flirt.maxAngle.setValue(190);
					flirt.minAngle.setValue(-190);
					flirt.coarseAngleIncrement.setValue(90);
					flirt.fineAngleIncrement.setValue(30);
				}
				flirt.run();
				transMatrix[i] = flirt.trans.getValue();
				atlasImages[i] = null;
				atlasMasks[i] = TransformVolume.transform(atlasMasks[i],
						TransformVolume.Interpolation.Nearest_Neighbor,
						transMatrix[i], resolutions, dimensions);
			}
			atlasImages = null;


			float[][][][] masks = new float[Natlas][XN][YN][ZN];
			for (int i = 0; i < Natlas; i++) {
				masks[i] = (new ImageDataFloat(atlasMasks[i])).toArray3d();
				atlasMasks[i] = null;
			}
			atlasMasks = null;


			byte[][][] prob = new byte[XN][YN][ZN];
			int x_min = 10000, x_max = -10000;
			int y_min = 10000, y_max = -10000;
			int z_min = 10000, z_max = -10000;
//			resultImage.disposeLocal();
			for (int x = 0; x < XN; x++)
				for (int y = 0; y < YN; y++)
					for (int z = 0; z < ZN; z++) {
						prob[x][y][z] = 0;
						for (int n = 0; n < Natlas; n++) {
							if (masks[n][x][y][z] > 0)
								prob[x][y][z] += 1;
						}
					}
			ImageDataUByte probVol = new ImageDataUByte(prob);
			probVol.setHeader(header);


			for (int x = 0; x < XN; x++)
				for (int y = 0; y < YN; y++)
					for (int z = 0; z < ZN; z++) {
						if (prob[x][y][z] > 0)
						{
							if (x_min > x) x_min = x;
							if (x_max < x) x_max = x;
							if (y_min > y) y_min = y;
							if (y_max < y) y_max = y;
							if (z_min > z) z_min = z;
							if (z_max < z) z_max = z;
						}
					}
			float[][][] image_float = (new ImageDataFloat(image)).toArray3d();


			if (x_min > 0) x_min--;
			if (x_max < XN) x_max++;
			if (y_min > 0) y_min--;
			if (y_max < YN) y_max++;
			if (z_min > 0) z_min--;
			if (z_max < ZN) z_max++;


			System.out.println("\n\nX range [" + x_min + ", " + x_max + "]");
			System.out.println("Y range [" + y_min + ", " + y_max + "]");
			System.out.println("Z range [" + z_min + ", " + z_max + "]\n");


			for (int x = 0; x < XN; x++)
				for (int y = 0; y < YN; y++)
					for (int z = 0; z < ZN; z++) {
						if (x < x_min || x > x_max || y < y_min || y > y_max || z < z_min || z > z_max)
						{
							image_float[x][y][z] = 0.0f;
						}
					}
			// ImageDataFloat imageTrimmed = new ImageDataFloat(image_float);
			// imageTrimmed.setHeader(header);
			// imageTrimmed.setName(origVol.getName());


			// ParamVolumeCollection fantasmInput =
			// (ParamVolumeCollection)(fantasm.getInput().getFirstChildByName("Image
			// to segment"));
			// System.out.println("\nMaximum iterations\n");
			// ((ParamInteger)fantasm.getInput().getFirstChildByName("Maximum
			// iterations")).setValue("5");


			System.out.println("\nFANTASM BEGIN\n");
			ModelImage[] segImages = new ModelImage[1];
			ModelImage images = image.getModelImageCopy();
			// ModelImage images = imageTrimmed.getModelImage();
			int classes = -1;
			int[] destExtents = images.getExtents();
			segImages[0] = new ModelImage(ModelStorageBase.UBYTE, destExtents, "Fantasm_seg");
			String correct;


			if (InhomogeneityCorrectionBool.getValue()) {
				correct = "image";
			} else {
				correct = "none";
			}


			if (ImageModality.values()[comboModality.getIndex()] == ImageModality.T1_MPRAGE) {
				// ((ParamInteger)fantasm.getInput().getFirstChildByName("Number
				// of classes")).setValue("5");
				classes = 5;
			} else if (ImageModality.values()[comboModality.getIndex()] == ImageModality.T1_ALT) {
				classes = 6;
			} else {
				// ((ParamInteger)fantasm.getInput().getFirstChildByName("Number
				// of classes")).setValue("4");
				classes = 4;
			}

			// fantasmInput.add(image);
			// fantasm.run();
			segment = new AlgorithmFantasm(segImages, images, 1, "range", "hard_segmentation", classes, 20, 0.05f, smoothingText.getFloat(), 2.0f, false, 0.1f, correct, 3, false, 0.0f, 0.0f, 0.0f, true, bgThresholdText.getFloat(), true, false);


			segment.run();
			segImage = segImages[0];
			segment.finalize();

			// ImageDataMipav segImage =
			// ((ParamVolume)fantasm.getOutput().getFirstChildByName("Hard
			// segmentation")).getImageData();
			/*
			 * byte[][][] segmentation = (new
			 * ImageDataUByte(segImage)).toArray3d(); for (int x = 149; x < 150;
			 * x++) for (int y = 100; y < 150; y++){ for (int z = 100; z < 150;
			 * z++){ System.out.print(segmentation[x][y][z] + " "); }
			 * System.out.println(); }
			 */


			SPECTRE2009 spectre = new SPECTRE2009();
			ImageData result = spectre.solve(image,
					new ImageDataMipav(segImage), probVol, ImageModality
					.values()[comboModality.getIndex()], outputType,
					priorInitText.getFloat(), priorMinText.getFloat(),
					initialErosionText.getInt(), mmcDilationText.getInt(),
					mmcErosionText.getInt(), max_iterations, Natlas);

			ImageData resultMask = spectre.getMask();

			if(runSmoothBrainMask.getValue()){

				MedicAlgorithmSmoothBrainMask smoothMask = new MedicAlgorithmSmoothBrainMask();

				smoothMask.brainmask.setValue(resultMask);
				smoothMask.origVol.setValue(image);				
				smoothMask.run();

				result = smoothMask.maskedBrain.getImageData();
				resultMask = smoothMask.newBrainMask.getImageData();
			}

			if(runMSP.getValue()){
				// Run MSP
				Set entries = atlasFile.entrySet();
				Iterator it = entries.iterator();
				int numLandmarks = atlasFile.size();
				ArrayList<double[][]> landmarks = new ArrayList<double[][]>();

				System.out.format("num of landmarks:"+numLandmarks+"\n");

				while (it.hasNext()) {
					Map.Entry entry = (Map.Entry) it.next();
					ArrayList<ArrayList<double[]>> list = (ArrayList<ArrayList<double[]>>) entry.getValue();
					int count = 0;
					for (ArrayList<double[]> arrayList : list)
						for (double[] ds : arrayList)
							count++;
					double[][] newLmark = new double[count][3];
					count = 0;
					for (int i = 0; i<Natlas; i++) {
						ArrayList<double[]> lmark = list.get(i);
						for (double[] ds : lmark) {

							for (int j =0; j < 3; j++) ds[j]=ds[j]*atlasRes[i][j]/inputImgRes[j];//Multiply by resolution ratio to fix landmark resolutions

							Matrix v = new Matrix(ds,4);
							Matrix vp = transMatrix[i].inverse().solve(v);
							newLmark[count++]=new double[]{vp.get(0,0), vp.get(1,0), vp.get(2,0)};
							/*Debug
                        System.out.format("\n\n\n\nLandmarks-old\n");
                        for (int ii = 0; ii < ds.length;ii++)System.out.format(ds[ii]+" ");
                        System.out.format("\nTransformed:\n");
                        for (int ii = 0; ii < newLmark[count-1].length;ii++)System.out.format(newLmark[count-1][ii]+" ");
							 */
						}
					}
					landmarks.add(newLmark);


				}

				//flip landmarks ordering to match format in MSP

				ArrayList<double[][]> flippedLandmks = new ArrayList<double[][]>();

				for (double[][] l: landmarks) {	
					double[][] ll = new double[l[0].length][l.length];
					for (int i = 0; i < ll.length; i++) {
						for (int j = 0; j < ll[0].length; j++) {
							ll[i][j]=l[j][i];
							//System.out.format(ll[i][j]+" i:"+i+" j:"+j +"\n");
						}
					}
					flippedLandmks.add(ll);
				}


				//Run FANTASM on SPECTRE result and find MSP
				MedicAlgorithmFantasm fantasm = new MedicAlgorithmFantasm();

				fantasm.inputImage.add(result);
				fantasm.correctInhomogeneity.setValue(false);
				fantasm.run();
				ImageData segImg = fantasm.classification.getImageData();

				MSP msp = new MSP(flippedLandmks, segImg, resultMask);
				msp.estimatePlane();

				if (oPlane.getValue()) {
					ImageData outPlane = msp.getPlane();
					outPlane.setHeader(header);
					outPlane.setName(segImg.getName()+"_plane");
					plane.setValue(outPlane);
				}

				if (oOutSplit.getValue()) {
					ImageData outSeg = msp.getSegmentation();
					outSeg.setHeader(header);
					outSeg.setName(segImg.getName()+"_twoHalves");
					outSplit.setValue(outSeg);
				}

				if (oPlaneSeg.getValue()) {
					ImageData outPlaneSeg = msp.getPlaneSegmentation();
					outPlaneSeg.setHeader(header);
					outPlaneSeg.setName(segImg.getName()+"_segmentedPlane");
					planeSeg.setValue(outPlaneSeg);
				}
			}
			image.setHeader(header);
			// imageTrimmed.setName(image.getName() + "_trimmed");
			result.setHeader(header);
			spectre.getPrior().setHeader(header);
			resultMask.setHeader(header);
			spectre.getSegmentation().setHeader(header);
			// spectre.getMarchVol().setHeader(header);
			spectre.getd0Vol().setHeader(header);
			// spectre.getd1Vol().setHeader(header);
			// spectre.getd2Vol().setHeader(header);
			// spectre.getd3Vol().setHeader(header);
			reorientedVol.setValue(image);
			// trimmedVol.setValue(imageTrimmed);
			resultVol.setValue(result);
			priorVol.setValue(spectre.getPrior());
			maskVol.setValue(resultMask);
			segVol.setValue(spectre.getSegmentation());
			// marchVol.setValue(spectre.getMarchVol());
			d0Vol.setValue(spectre.getd0Vol());
			// d1Vol.setValue(spectre.getd1Vol());
			// d2Vol.setValue(spectre.getd2Vol());
			// d3Vol.setValue(spectre.getd3Vol());
			//if(outputInOriginalSpace.getValue())outputInOriginalSpace();
			//Dispose ModelImages
			segImages[0].disposeLocal();
			images.disposeLocal();
		}
	}

	public void outputInOriginalSpace(){

		ImageData origImage = origVol.getImageData();
		ImageHeader origHeader = origVol.getImageData().getHeader();


		flirt.source.setValue(reorientedVol.getImageData());
		flirt.target.setValue(origImage);
		flirt.dof.setValue(0);
		flirt.maxAngle.setValue(190);
		flirt.minAngle.setValue(-190);
		flirt.run();

		Matrix returnMatrix = flirt.trans.getValue();
		//set reoriented Vol as original
		reorientedVol.setValue(flirt.registered.getImageData());//origVol.getImageData());
		//Match outputs to original 
		transformParamVolToOrigSpace(maskVol,origImage, returnMatrix, TransformVolume.Interpolation.Nearest_Neighbor);

		transformParamVolToOrigSpace(priorVol,origImage, returnMatrix, TransformVolume.Interpolation.Windowed_sinc);
		transformParamVolToOrigSpace(segVol,origImage, returnMatrix, TransformVolume.Interpolation.Nearest_Neighbor);
		transformParamVolToOrigSpace(d0Vol,origImage, returnMatrix, TransformVolume.Interpolation.Windowed_sinc);
		if (oPlane.getValue()) transformParamVolToOrigSpace(plane,origImage, returnMatrix, TransformVolume.Interpolation.Nearest_Neighbor);
		if (oOutSplit.getValue()) transformParamVolToOrigSpace(outSplit,origImage, returnMatrix, TransformVolume.Interpolation.Nearest_Neighbor);
		//Set Result as the original volume Masked
		ImageData resultImage = origVol.getImageData().clone();
		ImageData maskImage = maskVol.getImageData();
		for(int i = 0; i<resultImage.getRows();i++)
			for(int j = 0; j<resultImage.getCols();j++)
				for(int k = 0; k<resultImage.getSlices();k++){
					if(maskImage.getInt(i, j, k)==0)resultImage.set(i,j,k,0);
				}

		resultImage.setHeader(origHeader);
		resultImage.setName(resultVol.getImageData().getName());
		resultVol.setValue(resultImage);
	}

	public void transformParamVolToOrigSpace(ParamVolume inParam, ImageData origImage, Matrix returnMatrix, TransformVolume.Interpolation interpType){


		ModelImage sub = inParam.getImageData().getModelImageCopy();

		//Matrix xfmIdentity = new Matrix(4,4);
		//for(int ii=0;ii<4;ii++)	xfmIdentity.set(ii,ii,1);
		Point3i dimensions;
		Point3f resolutions;
		float[] res;
		res = origImage.getHeader().getDimResolutions();
		resolutions = new Point3f(res[0], res[1], res[2]);
		dimensions = new Point3i(origImage.getRows(), origImage.getCols(), origImage.getSlices());

		ImageData out = TransformVolume.transform(sub, interpType, returnMatrix, resolutions, dimensions);

		//AlgorithmMatchImages matchImage new AlgorithmMatchImages(origImage.getModelImageCopy(), sub, false, true,true);
		//matchImage.runAlgorithm();
		//System.out.format("hi1002\n");
		//ImageData out = new ImageDataMipavWrapper(matchImage.getImageB());
		//if(inParam.getDataIntent() == ImageDataIntent.NIFTI_INTENT_LABEL)out = cleanMasks(out,inParam.getImageData());
		out.setHeader(origImage.getHeader());
		out.setName(inParam.getImageData().getName());
		inParam.setValue(out);
		sub.disposeLocal();

	}

	//clean interpolation errors
	public ImageData cleanMasks(ImageData inVol,ImageData origVol){
		ArrayList<Integer> origVolLabels = new ArrayList<Integer>();
		int val;
		for(int i = 0; i<origVol.getRows();i++)
			for(int j = 0; j<origVol.getCols();j++)
				for(int k = 0; k<origVol.getSlices();k++){
					val =  origVol.getInt(i, j,k);
					if(!origVolLabels.contains(val)) origVolLabels.add(val);
				}

		Collections.sort(origVolLabels);

		double valD;

		for(int i = 0; i<inVol.getRows();i++)
			for(int j = 0; j<inVol.getCols();j++)
				for(int k = 0; k<inVol.getSlices();k++){
					for(int c = 0; c<origVolLabels.size()-1;c++){
						valD = inVol.getDouble(i, j, k);
						if(valD == origVolLabels.get(c)) break;
						else if(valD > origVolLabels.get(c) && valD < origVolLabels.get(c+1)){
							inVol.set(i, j, k, origVolLabels.get(c+1));
							break;
						}
					}

				}

		return inVol;
	}


	final public void loadAtlasFiles(String filename) {
		try {
			File f = new File(filename);
			FileReader fr = new FileReader(f);
			BufferedReader br = new BufferedReader(fr);
			String line = br.readLine();
			// Exact corresponding template
			if (!line.equals("Skull stripping atlas list")) {
				System.out.println("not a proper atlas file");
				br.close();
				fr.close();
				return;
			}

			atlasFile = new HashMap<String, ArrayList>();
			while (true) {
				line = br.readLine();

				if (line==null||line.isEmpty())break;

				String[] lin = line.split(" ");
				String type = lin[0].toLowerCase();
				ArrayList data = atlasFile.get(type);
				if (type.compareTo("image")==0||type.compareTo("mask")==0) {
					if (data==null){
						atlasFile.put(type, data= new ArrayList<String>());
					}
					data.add(lin[1]);

				} else if (type.compareTo("l1")==0||type.compareTo("l2")==0||type.compareTo("l3")==0) {
					int imgNum = atlasFile.get("image").size()-1;
					if (data==null)
						atlasFile.put(type, data = new ArrayList<ArrayList<double[]>>());

					while (data.size()<=imgNum)
						data.add(new ArrayList<double[]>());
					ArrayList<double[]> loc = (ArrayList<double[]>) data.get(imgNum);
					loc.add(new double[] {Double.parseDouble(lin[1]), Double.parseDouble(lin[2]),
							Double.parseDouble(lin[3]), 1});
				}
			}

			Natlas = atlasFile.get("image").size();
			atlasImages = new ImageDataMipav[Natlas];
			atlasMasks = new ImageDataMipav[Natlas];
			for (int n = 0; n<Natlas; n++) {
				String atlasFilename = f.getParent()+File.separator+atlasFile.get("image").get(n);
				String maskFilename = f.getParent()+File.separator+atlasFile.get("mask").get(n);
				atlasImages[n] = ((ImageDataMipav) ImageDataReaderWriter.getInstance().read(new File(atlasFilename)));
				atlasMasks[n] = ((ImageDataMipav) ImageDataReaderWriter.getInstance().read(new File(maskFilename)));
				System.out.println("file" + atlasFilename);
			}
			br.close();
			fr.close();
			atlasFile.remove("image");
			atlasFile.remove("mask");
		} catch (FileNotFoundException e) {
			System.out.println(e.getMessage());
		} catch (IOException e) {
			System.out.println(e.getMessage());
		} catch (OutOfMemoryError e) {
			System.out.println(e.getMessage());
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}

		//check if atlas load failed, try loading older version of atlas.
		if(Natlas == 0){
			loadOldAtlasFiles(filename);
			if(Natlas > 0){
				//Set MSP related parameters as false if using old atlas
				runMSP.setValue(false);
				oPlane.setValue(false);
				oOutSplit.setValue(false);
				oPlaneSeg.setValue(false);
			}
		}

		//Final check to make sure atlases are loaded 
		boolean atlasValidCheck = false;
		try{
			for (int i = 0; i < Natlas; i++){
				System.out.format("Loading Atlas 1:");
				System.out.format(atlasImages[i].getName() +"\n");
				System.out.format("Success!\n");
				atlasValidCheck = true;
			}

		}
		catch (Exception e) {
			System.out.println(e.getMessage());
		}

		if(!atlasValidCheck){
			for(int i =0; i <10; i++)System.out.format("Problems Encountered While Loading Atlases. Check Atlas Files Exists!\n");
			System.out.flush();
			System.exit(0);
		}

		return;
	}

	final public void loadOldAtlasFiles(String filename) {
		String[] atlasFilenames = null;
		try {
			File f = new File(filename);
			FileReader fr = new FileReader(f);
			BufferedReader br = new BufferedReader(fr);
			String line = br.readLine();
			StringTokenizer st;
			String imageFile;
			// Exact corresponding template
			if (!line.equals("Skull stripping atlas list")) {
				System.out.println("not a proper atlas file");
				br.close();
				fr.close();
				return;
			}
			line = br.readLine();
			if (line.startsWith("pairs of original / stripped images: "))
				Natlas = Integer.valueOf(line.substring(line.indexOf(":") + 2))
				.intValue();
			atlasFilenames = new String[2 * Natlas];
			for (int n = 0; n < 2 * Natlas; n++) {
				atlasFilenames[n] = f.getParent() + File.separator
				+ br.readLine();
				System.out.println("file: " + atlasFilenames[n]);
			}
			br.close();
			fr.close();
		} catch (FileNotFoundException e) {
			System.out.println(e.getMessage());
		} catch (IOException e) {
			System.out.println(e.getMessage());
		} catch (OutOfMemoryError e) {
			System.out.println(e.getMessage());
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}
		atlasImages = new ImageDataMipav[Natlas];
		atlasMasks = new ImageDataMipav[Natlas];
		for (int n = 0; n < Natlas; n++) {
			atlasImages[n] = ((ImageDataMipav) ImageDataReaderWriter
					.getInstance().read(new File(atlasFilenames[2 * n])));
			atlasMasks[n] = ((ImageDataMipav) ImageDataReaderWriter
					.getInstance().read(new File(atlasFilenames[2 * n + 1])));
		}
		return;
	}

}
