package edu.jhu.ece.iacl.utility;

import java.util.ArrayList;
import java.util.Arrays;

import javax.vecmath.*;

/**
 * 
 * @author John Bogovic
 * January 2012
 */
public class VectorParser {
	
	boolean hasAsterisk;
	boolean allowRepeats = false;
	int[] 	intSet;
	
	ArrayList<Point2i> point2iList;
	ArrayList<Point2i> lastPoints;
	public VectorParser(){
		hasAsterisk=false;
	}
	public VectorParser(boolean allowRepeats){
		this();
		setAllowReapeats(allowRepeats);
	}
	public VectorParser(boolean allowRepeats, int[] intSet){
		this(allowRepeats);
		setIntSet(intSet);
	}
	public VectorParser(int[] intSet){
		this();
		setIntSet(intSet);
	}
	
	public void setAllowReapeats(boolean allowRepeats){
		this.allowRepeats=allowRepeats;
	}
	
	public void setIntSet(int[]  intSet){
		this.intSet=intSet;
	}
	
	public ArrayList<Point2i> parsePoints(String s){
		
		lastPoints = new ArrayList<Point2i>(); 
		
		if(s==null || s.length()==0){
			return null;
		}
		String substr = s;
		if(s.length() > 2 && s.startsWith("\"")){
			substr = s.substring(2,(s.length())-2);
		}
		
		if (substr.length() > 2 && substr.startsWith("(") && substr.endsWith(")") ){
			substr = s.substring(1,(s.length())-1);
		}else{
			return null;
		}
		
		String[] nums = substr.split(",");
		
		if(nums.length<2){
			return null;
		}
		
		int[] a1 = parseSingleSideBndString(nums[0]);
		int[] a2 = parseSingleSideBndString(nums[1]);
		
		int nadded = 0;
		for(int i=0; i<a1.length; i++)for(int j=0; j<a2.length; j++){
			int n1 = a1[i];
			int n2 = a2[j];
			Point2i thisbnd;
			if(n1<n2){
				thisbnd = new Point2i(n1,n2);
			}else if(n1>n2){
				thisbnd = new Point2i(n2,n1);
			}else if(n1==Integer.MAX_VALUE && n2 == -1){
				thisbnd = new Point2i(n1,n2);
			}else{
				if(allowRepeats){
					thisbnd = new Point2i(n1,n2);
				}else{
					// equality does not describe a boundary, so we ignore
					//return null;  
					continue;
				}
			}
			
			if(!lastPoints.contains(thisbnd)){
				lastPoints.add(thisbnd);
				nadded++;
			}
		}
		
		return lastPoints;
	}
	
	public int addPoints(ArrayList<Point2i> newPoints){
		int nptsadded = 0;
		for(Point2i np : newPoints){
			if(!point2iList.contains(np)){
				point2iList.add(np);
				nptsadded++;
			}
		}
		return nptsadded;
	}
	
	public int addPoints(String s){
		ArrayList<Point2i> newpts = parsePoints(s);
		return addPoints(newpts);
	}
	
	public int[] parseSingleSideBndString(String s){
		int[] bndlabs = null;
		if(s.charAt(0)=='['){
			
			String objstrbnds = s.substring(1, s.indexOf(']'));
			bndlabs = VectorParser.parseInt(objstrbnds);
			
		}else if(s.charAt(0)=='*'){
			bndlabs = intSet;
			hasAsterisk = true;
		}else{
			System.out.println("s: " + s);
			
			bndlabs = new int[]{Integer.parseInt(s)};
		}
		
		return bndlabs;
	}
	
	
	public static int[] parseInt(String exp){
		try{
			String[] tokens = exp.split(";");
			ArrayList<int[]> numlist = new ArrayList<int[]>();
			int totallen = 0;
			for(int i=0; i<tokens.length; i++){
				if(tokens[i].contains(":")){
					int[] addme = parseColonInt(tokens[i].trim());
					totallen += addme.length;
					numlist.add(addme);
				}else{
					numlist.add(new int[]{Integer.parseInt(tokens[i].trim())});
					totallen++;
				}
			}
			
			int[] out = new int[totallen];
			int k = 0;
			for(int i=0; i<numlist.size(); i++){
				int[] thesenums = numlist.get(i);
				for(int j=0; j<thesenums.length; j++){
					out[k] = thesenums[j];
					k++;
				}
			}
			return out;
			
		}catch(Exception e){
			e.printStackTrace();
			return null;
		}
	}
	
	public static double[] parseDouble(String exp){
		try{
			String[] tokens = exp.split(";");
			ArrayList<double[]> numlist = new ArrayList<double[]>();
			int totallen = 0;
			for(int i=0; i<tokens.length; i++){
				if(tokens[i].contains(":")){
					double[] addme = parseColonDouble(tokens[i].trim());
					totallen += addme.length;
					numlist.add(addme);
				}else{
					numlist.add(new double[]{Double.parseDouble(tokens[i].trim())});
					totallen++;
				}
			}
			
			double[] out = new double[totallen];
			int k = 0;
			for(int i=0; i<numlist.size(); i++){
				double[] thesenums = numlist.get(i);
				for(int j=0; j<thesenums.length; j++){
					out[k] = thesenums[j];
					k++;
				}
			}
			return out;
			
		}catch(Exception e){
			e.printStackTrace();
			return null;
		}
	}
	
	public static int[] parseColonInt(String exp){
		try{
			String[] tokens = exp.split(":");
			if(tokens.length==2){
				
				// assume step of 1
				int start = Integer.parseInt(tokens[0]);
				int end = Integer.parseInt(tokens[1]);
				int len = (end-start)+1;
				
				int[] out = new int[len];
				for(int i=0; i<len; i++){
					out[i] = start + i;
				}
				return out;
			}else if(tokens.length==3){
				// step is given
				int start = Integer.parseInt(tokens[0]);
				int step = Integer.parseInt(tokens[1]);
				int end = Integer.parseInt(tokens[2]);
				int len = ((end-start)/step)+1;
				
				int[] out = new int[len];
				for(int i=0; i<len; i++){
					out[i] = start + step*i;
				}
				return out;
			}else{
				System.err.println("Expression must have exactly 2 or 3 colons");
				return null;
			}
		}catch(Exception e){
			e.printStackTrace();
			return null;
		}
	}
	
	public static double[] parseColonDouble(String exp){
		try{
			String[] tokens = exp.split(":");
			if(tokens.length==2){
				
				// assume step of 1
				double start = Double.parseDouble(tokens[0]);
				double end = Double.parseDouble(tokens[1]);
				int len = (int)Math.floor(end-start)+1;
				
				double[] out = new double[len];
				for(int i=0; i<len; i++){
					out[i] = start + i;
				}
				return out;
			}else if(tokens.length==3){
				// step is given
				double start = Double.parseDouble(tokens[0]);
				double step = Double.parseDouble(tokens[1]);
				double end = Double.parseDouble(tokens[2]);
				int len = (int)Math.floor((end-start)/step)+1;
				
				double[] out = new double[len];
				for(int i=0; i<len; i++){
					out[i] = start + step*i;
				}
				return out;
			}else{
				System.err.println("Expression must have exactly 2 or 3 colons");
				return null;
			}
		}catch(Exception e){
			e.printStackTrace();
			return null;
		}
	}
	
	public static void main(String[] args){
		System.out.println("start");
		
		String s = "1.1:11.1";
		String s2 = "1;4;3";
		String s3 = "1:5; 6; 9";
		String s4 = "0:3:15";
		
		System.out.println(Arrays.toString(VectorParser.parseDouble(s)));
		System.out.println(Arrays.toString(VectorParser.parseDouble(s2)));
		System.out.println(Arrays.toString(VectorParser.parseDouble(s3)));
		System.out.println(Arrays.toString(VectorParser.parseDouble(s4)));
		
		System.out.println(Arrays.toString(VectorParser.parseInt(s3)));
		
	}

}
