package edu.vanderbilt.masi.algorithms.CRUISE.utilities;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

import edu.jhu.ece.iacl.algorithms.graphics.intersector.IntersectorTriangle;
import edu.jhu.ece.iacl.algorithms.graphics.intersector.SurfaceIntersector;
import edu.jhu.ece.iacl.algorithms.graphics.locator.kdtree.KdTriangle;
import edu.jhu.ece.iacl.algorithms.thickness.ThicknessSolver;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataInt;



/**
 * @author Yuankai Huo
 * @email yuankai.huo@vanderbilt.edu
 * @version 1.0
 *
 *Based on Compute thickness by measuring the shortest distance 
 *between corresponding points. by Blake Lucas in CRUISE
 *
 *The difference is that it calculate the average thickness from inner
 *to the closest point in outer and from that point back to inner surf
 *
 *In addition, this file generate the scalar vtk file which project
 *the thickness to central file
 */

public class CorrectVolFromThreeSurfaces extends ThicknessSolver {
	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");

	private ImageDataInt inVol;

	public static String getVersion(){
		return revnum;
	}


	public CorrectVolFromThreeSurfaces(double lambda, double isoVal,
			double lagrangeDeltaT) {
		this.isoVal = isoVal;
		this.lambda = lambda;
		this.lagrangeDeltaT = lagrangeDeltaT;
		setLabel("Correct Volume from Three Surfaces");
	}


	public CorrectVolFromThreeSurfaces(ImageDataInt Inputimg) {
		this.inVol = Inputimg.clone();
		setLabel("Correct Volume from Three Surfaces");
	}

	public CorrectVolFromThreeSurfaces() {
		setLabel("Correct Volume from Three Surfaces");
	}


	//project to central Mesh
	public void solve(EmbeddedSurface innerMesh, EmbeddedSurface centralMesh, EmbeddedSurface outerMesh) {
		this.innerMesh = innerMesh;
		this.centralMesh = centralMesh;
		this.outerMesh = outerMesh;

		//		computeThickness();
		correctSegVolume();
		markCompleted();
	}

	public ImageDataInt getCorrectedVol(){
		return this.inVol;
	}



	public SurfaceIntersector solve(EmbeddedSurface MeshSurf){

		SurfaceIntersector intersectMeshSurf = new SurfaceIntersector(this, 13, MeshSurf);

		return intersectMeshSurf;
	}


	protected void computeThickness() {
	}

	protected void correctSegVolume(){

		Vector3f nv;
		Point3f pt = null;

		double dsInner;
		double dsCentral;
		double dsOuter;

		// distance central to other
		SurfaceIntersector intersectInner = new SurfaceIntersector(this, 13, innerMesh);
		SurfaceIntersector intersectCentral = new SurfaceIntersector(this, 13, centralMesh);
		SurfaceIntersector intersectOuter = new SurfaceIntersector(this, 13, outerMesh);

		int rows = inVol.getRows();
		int cols = inVol.getCols();
		int slices = inVol.getSlices();

		int[][][] InputVol = inVol.toArray3d();
		for (int i = 0; i < rows; i++) {
			for (int j = 0; j < cols; j++) {
				for (int k = 0; k < slices; k++) {
					int labelVoxel = InputVol[i][j][k];
					if (labelVoxel>100){
						pt = new Point3f(i, j, k); 
						dsInner  = intersectInner.distance(pt);
						dsCentral  = intersectCentral.distance(pt);
						dsOuter  = intersectOuter.distance(pt);
						if(dsInner!=dsCentral&&dsInner!=dsOuter&&dsCentral!=dsOuter){
							// find minimum distance
							if (dsInner<dsCentral&&dsInner<dsOuter){
								KdTriangle lastTriangleInner= intersectInner.getLastIntersectionTriangle();
								int label = getLabel(innerMesh,lastTriangleInner,pt);
								inVol.set(i,j,k,label);									
							}

							if (dsCentral<dsInner&&dsCentral<dsOuter){
								KdTriangle lastTriangleCentral= intersectCentral.getLastIntersectionTriangle();
								int label = getLabel(centralMesh,lastTriangleCentral,pt);	
								inVol.set(i,j,k,label);	
							}

							if (dsOuter<dsInner&&dsOuter<dsCentral){
								KdTriangle lastTriangleOuter = intersectOuter.getLastIntersectionTriangle();
								int label = getLabel(outerMesh,lastTriangleOuter,pt);		
								inVol.set(i,j,k,label);	
							}
						}

					}
				}
			}
		}

		inVol.setName(inVol.getName() + "_surfCorrected");
		incrementCompletedUnits();

	}

	private int getLabel(EmbeddedSurface centralMesh,KdTriangle lastTriangleInner, Point3f pt){
		Point3f[] pts;
		int id1;
		int id2;
		int id3;
		int fid;
		int smallestdistind;
		float smallestdistance;

		IntersectorTriangle TriangleInner = (IntersectorTriangle)lastTriangleInner;

		pts = TriangleInner.getPoints();
		id1 = TriangleInner.id1; 
		id2 = TriangleInner.id2; 
		id3 = TriangleInner.id3; 
		fid = TriangleInner.fid;

		//find the cloest points among the three vertices in
		//the triangular
		smallestdistind = id1;
		smallestdistance = pt.distance(pts[0]);			
		if (pt.distance(pts[1]) < smallestdistance){
			smallestdistind = id2;
			smallestdistance = 	pt.distance(pts[1]);
		}
		if (pt.distance(pts[2]) < smallestdistance){
			smallestdistind = id3;
			smallestdistance = 	pt.distance(pts[2]);
		}
		int outLabel = (int) centralMesh.getVertexDataAtOffset(smallestdistind,0);
		return outLabel;
	}



}
