package edu.vanderbilt.masi.plugins.CRUISE.MaCRUISE;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import edu.jhu.ece.iacl.algorithms.ace.ThinACE;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataInt;
import edu.vanderbilt.masi.plugins.CRUISE.utilities.MASImorph;

/**
 * @author Yuankai Huo
 * @email yuankai.huo@vanderbilt.edu
 * @version 1.0
 *
 *enhance the GM additonally
 *
 */

public class EnhanceGMadditional extends ProcessingAlgorithm{

	private ParamVolume GM_ACE,MA_boundary,Skeleton;
	private ParamVolume GM_ACE_enhanced,Skeleton_enhanced,Thin_enhanced;
		

	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "enhance GM additonal" + revnum + "\n";

	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.setPackage("Vanderbilt");
		inputParams.setCategory("format");
		inputParams.setLabel("Enhance GM Additonal");
		inputParams.setName("Enhance_GM_Additonal");

		// inputs
		GM_ACE=new ParamVolume("ACE_GM file");
		MA_boundary = new ParamVolume("MA_boundary file");
		Skeleton=new ParamVolume("ACE_Skeleton from ACE");
//		Skeleton.setMandatory(false);
		
							
		inputParams.add(GM_ACE);
		inputParams.add(MA_boundary);
		inputParams.add(Skeleton);
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		// TODO Auto-generated method stub
		GM_ACE_enhanced=new ParamVolume("Enhanced_GM volume");
		outputParams.add(GM_ACE_enhanced);
		Skeleton_enhanced=new ParamVolume("Enhanced_Skeleton volume");
		outputParams.add(Skeleton_enhanced);
		Thin_enhanced=new ParamVolume("Enhanced_Thin volume");
		outputParams.add(Thin_enhanced);
	}

	@Override
	protected void execute(CalculationMonitor monitor) {
		// TODO Auto-generated method stub

		ImageData GM_ACE_vol = GM_ACE.getImageData();
		ImageData Skeleton_vol = Skeleton.getImageData();
		ImageData MA_boundary_vol = MA_boundary.getImageData();
		
		
		int rows = GM_ACE_vol.getRows();
		int cols = GM_ACE_vol.getCols();
		int slices = GM_ACE_vol.getSlices();
		
		int i,j,k;	

		// init output volumes
		ImageDataFloat GM_ACE_enhanced_vol = new ImageDataFloat(rows,cols,slices);
		ImageDataInt Skeleton_enhanced_vol = new ImageDataInt(rows,cols,slices);
		ImageData Thin_enhanced_vol;

		for (i = 0; i < rows; i++) {
			for (j = 0; j < cols; j++) {
				for (k = 0; k < slices; k++) {
					if(MA_boundary_vol.getInt(i,j,k)>0){
						GM_ACE_enhanced_vol.set(i,j,k,0f);
						Skeleton_enhanced_vol.set(i,j,k,254);
					}else{
						GM_ACE_enhanced_vol.set(i,j,k,GM_ACE_vol.getFloat(i,j,k));
						Skeleton_enhanced_vol.set(i,j,k,Skeleton_vol.getInt(i,j,k));
					}

				}
			}
		}
		
		//get thin skeleton
		ThinACE thin = new ThinACE();
		Thin_enhanced_vol = thin.solve(Skeleton_enhanced_vol);
		
		// set output file
		GM_ACE_enhanced_vol.setName(GM_ACE_vol.getName()+"_enhanced");
		GM_ACE_enhanced_vol.setHeader(GM_ACE_vol.getHeader());
		GM_ACE_enhanced.setValue(GM_ACE_enhanced_vol);
		
		Skeleton_enhanced_vol.setName(Skeleton_vol.getName()+"_enhanced");
		Skeleton_enhanced_vol.setHeader(Skeleton_vol.getHeader());
		Skeleton_enhanced.setValue(Skeleton_enhanced_vol);
		
		Thin_enhanced_vol.setName(Skeleton_vol.getName()+"thin_enhanced");
		Thin_enhanced_vol.setHeader(Skeleton_vol.getHeader());
		Thin_enhanced.setValue(Thin_enhanced_vol);
}

	public int[][][] RemoveLabels(int[][][]InputVol,ParamString OverlookLabels){
		
		// get removable labels
		String RemoveString = OverlookLabels.getValue();
		String[] RemoveStrings = RemoveString.split(",");
//		int[] RemoveLabels = new int[RemoveStrings.length];
		List<Integer> RemoveLabelsList = new ArrayList<Integer>();
		for (int ii = 0; ii < RemoveStrings.length; ii++) {
		    try {
//		    	RemoveLabels[i] = Integer.parseInt(RemoveStrings[i]);
		    	RemoveLabelsList.add(Integer.parseInt(RemoveStrings[ii]));
		    } catch (NumberFormatException nfe) {};
		}
		
		
		int rows = InputVol.length;
		int cols = InputVol[0].length;
		int slices = InputVol[0][0].length;
		for (int i = 0; i < rows; i++) {
			for (int j = 0; j < cols; j++) {
				for (int k = 0; k < slices; k++) {
					if(RemoveLabelsList.contains(InputVol[i][j][k])){
						InputVol[i][j][k] = 0;
					}
				}
			}
		}
		return InputVol;
	}
	
	
	

}