package edu.vanderbilt.masi.plugins.CRUISE.MaCRUISE;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;

import edu.jhmi.rad.medic.utilities.CropParameters;
import edu.jhmi.rad.medic.utilities.CubicVolumeCropper;
import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
import edu.jhu.ece.iacl.jist.io.ImageDataReaderWriter;
import edu.jhu.ece.iacl.jist.io.FileExtensionFilter;
import edu.jhu.ece.iacl.jist.io.SurfaceFreeSurferReaderWriter;
import edu.jhu.ece.iacl.jist.io.SurfaceVtkReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.plugins.measure.thickness.MedicAlgorithmThickness;
import edu.jhu.ece.iacl.plugins.segmentation.cruise.MedicAlgorithmGradVecFlow;
import edu.jhu.ece.iacl.plugins.topology.MedicAlgorithmTopologyCorrection;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.ImageHeader;
import edu.jhu.ece.iacl.jist.structures.image.VoxelType;
import edu.vanderbilt.masi.plugins.CRUISE.ace.MaACE;
import edu.vanderbilt.masi.plugins.CRUISE.tgdm.MaTGDMorigin;

public class MaLongCRUISENewACE extends ProcessingAlgorithm{
	MaACE ace;
	MaTGDMorigin tgdm;
	MedicAlgorithmGradVecFlow gvfCentral;
	MedicAlgorithmTopologyCorrection topoCorrect;
//	MedicAlgorithmRemoveDura09 rmDura;
//	MedicAlgorithmSmoothSurface smooth;
	MedicAlgorithmThickness  thickness;
//	MedicAlgorithmOrientSurface orient;
	ParamPointInteger offset;
	ParamPointInteger dim;
	ParamCollection cropParams;
	
	ParamVolume wmfillraw;
	ParamVolume gmVolraw;
	ParamVolume maskVolraw;
	
	
	ParamWeightedVolumeCollection<String> inputImages;
	int rows = 0, cols = 0, slices = 0;
	ParamVolume ucthickvol, ucthicklevset,
		uncroppedthinCSF, uncroppedTopo, uncroppedGvf, croppedGM,
		croppedWM, croppedInitWM, uncroppedInner, uncroppedCentral,
		uncroppedOuter, uncroppedEnhancedGM, ucSignedVol, ucSkel;
	
	ParamSurface uncroppedInnerSurf, uncroppedCentralSurf, uncroppedOuterSurf;
//	ParamFile uncroppedInnerSurf, uncroppedCentralSurf, uncroppedOuterSurf;
	
	ParamVolume BeforeCropVol,LevelVol,WMVol,GMVol,ACEskelectonVol,ACEGMVol,GVFVol;
	ImageData BeforeCropimg,Levelimg,WMimg,GMimg,ACEskelectonimg,ACEGMimg,GVFimg;
	
	private static final String cvsversion = "$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	
	private static final ImageDataReaderWriter vrw = ImageDataReaderWriter.getInstance();
	private static final SurfaceVtkReaderWriter srw = SurfaceVtkReaderWriter.getInstance();
	private static final SurfaceFreeSurferReaderWriter frw = SurfaceFreeSurferReaderWriter.getInstance();

	
	private static final FileExtensionFilter volumeFileExts = vrw.getExtensionFilter();
	private static final FileExtensionFilter surfaceFileExts = srw.getExtensionFilter();

	
	protected void createInputParameters(ParamCollection inputParams) {
		setPreferredSize(new Dimension(800, 500));
		
		ParamCollection clspanel=new ParamCollection("Classification");
		clspanel.add(wmfillraw=new ParamVolume("WMfillraw",VoxelType.FLOAT));
		wmfillraw.setDescription("Ventricle filled WM membership(float), usually obtained from TOADS.");
		clspanel.add(gmVolraw=new ParamVolume("GMraw",VoxelType.FLOAT));
		gmVolraw.setDescription("GM membership in float");
		clspanel.add(maskVolraw=new ParamVolume("WMMaskraw",VoxelType.FLOAT));
		maskVolraw.setDescription("White Matter mask, should be float, usually obtained from TOADS.");
		inputParams.add(clspanel);
		
		gvfCentral = new MedicAlgorithmGradVecFlow();
		gvfCentral.getInput().getFirstChildByName("Volume").setHidden(true);
				
		thickness = new MedicAlgorithmThickness();
		thickness.getInput().getFirstChildByName("Inner Level Set").setHidden(true);
		thickness.getInput().getFirstChildByName("Outer Level Set").setHidden(true);
		((ParamOption)thickness.getInput().getFirstChildByName("Approximation Method")).setValue("Level Set Subtraction");
		thickness.getInput().getFirstChildByName("Approximation Method").setHidden(true);
		thickness.getInput().getFirstChildByName("Lagrange Step Size").setHidden(true);
		
		topoCorrect = new MedicAlgorithmTopologyCorrection();
		topoCorrect.getInput().getFirstChildByName("Volume").setHidden(true);
		topoCorrect.getInput().getFirstChildByName("Paint mask").setHidden(true);
		topoCorrect.getInput().getFirstChildByName("Connectivity (Foreground,Background)").setHidden(true);
		ace=new MaACE();
		ace.getInput().getFirstChildByName("Gray Matter").setHidden(true);
		ace.getInput().getFirstChildByName("White Matter").setHidden(true);
		
		
		
		tgdm=new MaTGDMorigin();
		tgdm.getInput().getFirstChildByName("Connectivity (Foreground,Background)").setHidden(true);
		tgdm.getInput().getFirstChildByName("Data").setHidden(true);
		tgdm.getInput().getFirstChildByName("Initial Level Set").setHidden(true);
		tgdm.getInput().getFirstChildByName("Initial Iso Level").setHidden(true);
		tgdm.getInput().getFirstChildByName("Initial Smoothing Curvature Force").setHidden(true);
		tgdm.getInput().getFirstChildByName("Iterations for Initial Smoothing").setHidden(true);

		//to compatible with MultiAtlas condition 
		//((ParamDouble)tgdm.getInput().getFirstChildByName("White Matter Iso Level")).setValue(0.5);

		inputParams.add(topoCorrect.getInput());
		inputParams.add(ace.getInput());
		inputParams.add(gvfCentral.getInput());

		inputParams.add(tgdm.getInput());
		inputParams.add(thickness.getInput());

		inputParams.setLabel("TOADS-CRUISE"); // Name Displayed in Module List
		inputParams.setName("ToadsCRUISE");   // Name displayed in Process Manager
		
		inputParams.setPackage("IACL");
		inputParams.setCategory("Segmentation.CRUISE");

		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.Release);

		info.add(ReferencedPapers.cruise);
		info.add(ReferencedPapers.ace);
		info.add(ReferencedPapers.tgdm);
		info.add(ReferencedPapers.gvf);
		info.add(PrinceGroupAuthors.xiaoHan);
		info.add(PrinceGroupAuthors.dzungPham);
		info.add(PrinceGroupAuthors.chenyangXu);
		info.add(PrinceGroupAuthors.duyguTosun);
		info.add(PrinceGroupAuthors.pierreLouisBazin);
    	info.add(PrinceGroupAuthors.blakeLucas);
    	info.setDescription("TOADS-CRUISE pipeline generating cortical surfaces and thickness statistics.");
    	info.setLongDescription("Full TOADS-CRUISE pipeline. It takes a 3D volume, does skull stripping by SPECTRE and cortical segmentation using TOADS. Then an Anatomically Consistent Enhancement (ACE) is done to remove partial voluming in the deep sulci. The surfaces are generated by a Topology Preserving Geoemtric Deformable Model (TGDM).");
    	info.setAdditionalDocURL("html/edu/jhu/ece/iacl/plugins/segmentation/cruise/MedicAlgorithmLongCRUISE/index.html");
	}

	protected void createOutputParameters(ParamCollection outputParams) {
		uncroppedTopo = new ParamVolume("Topologically Correct WM volume");		
		uncroppedEnhancedGM = new ParamVolume("ACE Enhanced GM");
		uncroppedthinCSF = new ParamVolume("ACE Thinned CSF Skeleton");
		uncroppedInner = new ParamVolume("TGDM Inner Level Set");
		uncroppedCentral = new ParamVolume("TGDM Central Level Set");
		uncroppedOuter = new ParamVolume("TGDM Outer Level Set");
		uncroppedInnerSurf = new ParamSurface("TGDM Inner Surface");
		uncroppedCentralSurf = new ParamSurface("TGDM Central Surface");
		uncroppedOuterSurf = new ParamSurface("TGDM Outer Surface");
//		uncroppedInnerSurf = new ParamFile("TGDM Inner Surface",surfaceFileExts);
//		uncroppedCentralSurf = new ParamFile("TGDM Central Surface",surfaceFileExts);
//		uncroppedOuterSurf = new ParamFile("TGDM Outer Surface",surfaceFileExts);
		ucthickvol = new ParamVolume("Thickness Volume");
		ucthicklevset = new ParamVolume("Thickness Level Set");
		uncroppedGvf = new ParamVolume("Gradient Vector Field",VoxelType.FLOAT,-1,-1,-1,3);

		outputParams.add(uncroppedTopo);	
		outputParams.add(uncroppedEnhancedGM);
		outputParams.add(uncroppedthinCSF);
		outputParams.add(uncroppedInner);
		outputParams.add(uncroppedCentral);
		outputParams.add(uncroppedOuter);
		outputParams.add(uncroppedInnerSurf);
		outputParams.add(uncroppedCentralSurf);
		outputParams.add(uncroppedOuterSurf);
		outputParams.add(ucthickvol);
		outputParams.add(ucthicklevset);
		outputParams.add(uncroppedGvf);
		
		outputParams.setLabel("TOADS-CRUISE"); // Name Displayed in Module List
		outputParams.setName("TOADS-CRUISE");   // Name displayed in Process Manager
	}


	@Override
	protected void execute(CalculationMonitor monitor) {
		
		System.out.println("MedicAlgorithmLongCruiseyk_v4");// yk add debug
		//set the output directory and create it if it doesn't exist
		File dir = new File(this.getOutputDirectory()+File.separator+edu.jhu.ece.iacl.jist.utility.FileUtil.forceSafeFilename(this.getAlgorithmName()));
		try{
			if(!dir.isDirectory()){
				(new File(dir.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }
//		String dir1 = dir + "/Toads1stPass/";
//		File dirToads1 = new File(dir1);
//		try{
//			if(!dirToads1.isDirectory()){
//				(new File(dirToads1.getCanonicalPath())).mkdir();
//			}
//		}catch(IOException e){ e.printStackTrace(); }
//		dir1 = dir + "/Toads2ndPass/";
//		File dirToads2 = new File(dir1);
//		try{
//			if(!dirToads2.isDirectory()){
//				(new File(dirToads2.getCanonicalPath())).mkdir();
//			}
//		}catch(IOException e){ e.printStackTrace(); }
		//yk add to save the results
		String dir_raw_input = dir + "/raw/";
		File dir_raw= new File(dir_raw_input);
		try{
			if(!dir_raw.isDirectory()){
				(new File(dir_raw.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }
		//yk add to save topo results
		String dir_topo_working = dir + "/topoCorrect/";
		File dir_topo= new File(dir_topo_working);
		try{
			if(!dir_topo.isDirectory()){
				(new File(dir_topo.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }
		//yk add to save crop results
		String dir_crop_working = dir + "/crop/";
		File dir_crop= new File(dir_crop_working);
		try{
			if(!dir_crop.isDirectory()){
				(new File(dir_crop.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }
		//yk add to save ace results
		String dir_ace_working = dir + "/ace/";
		File dir_ace= new File(dir_ace_working);
		try{
			if(!dir_ace.isDirectory()){
				(new File(dir_ace.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }
		String dir_gvf_working = dir + "/gvf/";
		File dir_gvf= new File(dir_gvf_working);
		try{
			if(!dir_gvf.isDirectory()){
				(new File(dir_gvf.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }
		String dir_tgdm_working = dir + "/tgdm_input/";
		File dir_tgdm= new File(dir_tgdm_working);
		try{
			if(!dir_tgdm.isDirectory()){
				(new File(dir_tgdm.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }
		String dir_output_working = dir + "/final_output/";
		File dir_output= new File(dir_output_working);
		try{
			if(!dir_output.isDirectory()){
				(new File(dir_output.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }
		
		ImageData gm=gmVolraw.getImageData();
		ImageData wmfill=wmfillraw.getImageData();
		ImageData wmmask=maskVolraw.getImageData();
		
//		//yk add debug
		String name = "target_image";
		ParamFile ykdebug = new ParamVolume("yk debug");
		wmmask.setName(name+"_mask");
 		ykdebug.setValue(vrw.write(wmmask, dir_raw));
 		gm.setName(name+"_gm");
 		ykdebug.setValue(vrw.write(gm, dir_raw));
 		wmfill.setName(name+"_wm");
 		ykdebug.setValue(vrw.write(wmfill, dir_raw));
 		
 		int rows=gm.getRows();
		int cols=gm.getCols();
		int slices=gm.getSlices();//
		ImageHeader gmhdr = gm.getHeader();
		float[] gmorigin = gmhdr.getOrigin();
		
		
		CubicVolumeCropper cropper = new CubicVolumeCropper();	
		gm = cropper.crop(gm, 0, 5); //enlarge (crop) the image by 5 voxels
		CropParameters crops = cropper.getLastCropParams();
		wmfill = cropper.crop(wmfill, crops);
		wmmask = cropper.crop(wmmask, crops);
		
		
		ImageData A;		

		//Connectivity rule is reversed for topology correction!
		int conn = 0;
		int bcon=0;
		switch(conn){
			case 0:bcon=1;break;
			case 1:bcon=0;break;
			case 2:bcon=3;break;
			case 3:bcon=2;break;
		}

		((ParamOption)topoCorrect.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).setValue(bcon);
		((ParamVolume)topoCorrect.getInput().getFirstChildByName("Volume")).setValue(wmfill);
		((ParamVolume)topoCorrect.getInput().getFirstChildByName("Paint mask")).setValue(wmmask);
		topoCorrect.runAlgorithm(monitor);
		ImageData mask = ((ParamVolume)topoCorrect.getOutput().getFirstChildByName("Topologically Correct Volume")).getImageData();
		mask.setName(name+"_topocorrected");
 		ykdebug.setValue(vrw.write(mask, dir_topo));
 		
		((ParamVolume)ace.getInput().getFirstChildByName("Gray Matter")).setValue(gm);
		((ParamVolume)ace.getInput().getFirstChildByName("White Matter")).setValue(wmfill);

 		wmmask.dispose();
	
		
//		//yk add debug
//		mask.setName(name+"_topocorrected");
//		ykdebug.setValue(vrw.write(mask, dir_topo));
//		
//	
//		
		//yk add debug
		gm.setName(name+"_gm_crop");
		ykdebug.setValue(vrw.write(gm, dir_crop));
		wmfill.setName(name+"_wmfill_crop");
		ykdebug.setValue(vrw.write(wmfill, dir_crop));
		mask.setName(name+"_mask_crop");
		ykdebug.setValue(vrw.write(mask, dir_crop));
//
//
		((ParamVolume)ace.getInput().getFirstChildByName("Gray Matter")).setValue(gm);
		((ParamVolume)ace.getInput().getFirstChildByName("White Matter")).setValue(wmfill);
		ace.runAlgorithm(monitor);
//
//
		A = ((ParamVolume)ace.getOutput().getFirstChildByName("Skeleton")).getImageData();
 		A.setName(name+"_gm_crop_skel");
 		ykdebug.setValue(vrw.write(A, dir_ace));
		A.dispose();
		ImageData thinnedcsf = ((ParamVolume)ace.getOutput().getFirstChildByName("Thinned Skeleton")).getImageData();
		ImageData enhancedgm = ((ParamVolume)ace.getOutput().getFirstChildByName("Enhanced GM")).getImageData();
		
		thinnedcsf.setName(name+"_gm_crop_thin");
 		ykdebug.setValue(vrw.write(thinnedcsf, dir_ace));
 		enhancedgm.setName(name+"_gm_crop_ace");
 		ykdebug.setValue(vrw.write(enhancedgm, dir_ace));
 		
		((ParamVolume)gvfCentral.getInput().getFirstChildByName("Volume")).setValue(enhancedgm);
		gvfCentral.runAlgorithm(monitor);

		ImageDataMipav gmvecfield = new ImageDataMipav(((ParamVolume)gvfCentral.getOutput().getFirstChildByName("Vector Field")).getImageData());
		gmvecfield.setName(name+"_gm_crop_ace_gvf");
 		ykdebug.setValue(vrw.write(gmvecfield, dir_gvf));
	
 		
 		Levelimg = mask;
 		WMimg = wmfill;
 		GMimg = gm;
 		ACEGMimg = enhancedgm;
 		ACEskelectonimg = thinnedcsf;
 		GVFimg = gmvecfield;
 		
 		Levelimg.setName(name+"_Levelimg");
 		ykdebug.setValue(vrw.write(Levelimg, dir_tgdm));
 		WMimg.setName(name+"_WMimg");
 		ykdebug.setValue(vrw.write(WMimg, dir_tgdm));
 		GMimg.setName(name+"_GMimg");
 		ykdebug.setValue(vrw.write(GMimg, dir_tgdm));
 		ACEGMimg.setName(name+"_ACEGMimg");
 		ykdebug.setValue(vrw.write(ACEGMimg, dir_tgdm));
 		ACEskelectonimg.setName(name+"_ACEskelectonimg");
 		ykdebug.setValue(vrw.write(ACEskelectonimg, dir_tgdm)); 
 		GVFimg.setName(name+"_GVFimg");
 		ykdebug.setValue(vrw.write(GVFimg, dir_tgdm));
 		
 		System.out.println("ykinput for tgdm Levelimg is "+Levelimg.getName());// yk add debug
 		System.out.println("ykinput for tgdm WMimg is "+WMimg.getName());// yk add debug
 		System.out.println("ykinput for tgdm GMimg is "+GMimg.getName());// yk add debug
 		System.out.println("ykinput for tgdm ACEGMimg is "+ACEGMimg.getName());// yk add debug
 		System.out.println("ykinput for tgdm ACEskelectonimg is "+ACEskelectonimg.getName());// yk add debug
 		System.out.println("ykinput for tgdm GVFimg is "+GVFimg.getName());// yk add debug
 		
 		
		((ParamOption)tgdm.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).setValue(conn);
		((ParamVolume)tgdm.getInput().getFirstChildByName("Initial Level Set")).setValue(Levelimg);
		((ParamVolume)tgdm.getInput().getFirstChildByName("White Matter Membership")).setValue(WMimg);
		((ParamVolume)tgdm.getInput().getFirstChildByName("ACE Gray Matter Membership")).setValue(ACEGMimg);	
		((ParamVolume)tgdm.getInput().getFirstChildByName("Gray Matter Membership")).setValue(GMimg);
		((ParamVolume)tgdm.getInput().getFirstChildByName(("Thinned ACE Skeleton"))).setValue(ACEskelectonimg);
		((ParamVolume)tgdm.getInput().getFirstChildByName(("Gradient Vector Field"))).setValue(GVFimg);
//		tgdm.runAlgorithm(monitor);
		
		
		System.out.println("tgdm Initial Level Set: "+((ParamVolume)tgdm.getInput().getFirstChildByName("Initial Level Set")).getName());
		System.out.println("tgdm Initial Volume is Membership: "+((ParamBoolean)tgdm.getInput().getFirstChildByName("Initial Volume is Membership [0,255]")).getValue());
		
		
		System.out.println("tgdm White Matter Membership: "+((ParamVolume)tgdm.getInput().getFirstChildByName("White Matter Membership")).getName());
		System.out.println("tgdm Gray Matter Membership: "+((ParamVolume)tgdm.getInput().getFirstChildByName("Gray Matter Membership")).getName());
		System.out.println("tgdm ACE Gray Matter Membership: "+((ParamVolume)tgdm.getInput().getFirstChildByName("ACE Gray Matter Membership")).getName());
		System.out.println("tgdm Thinned ACE Skeleton: "+((ParamVolume)tgdm.getInput().getFirstChildByName("Thinned ACE Skeleton")).getName());
		System.out.println("tgdm Gradient Vector Field: "+((ParamVolume)tgdm.getInput().getFirstChildByName("Gradient Vector Field")).getName());
		System.out.println("tgdm Brain Mask Level Set: "+((ParamVolume)tgdm.getInput().getFirstChildByName("Brain Mask Level Set")).getName());
		System.out.println("tgdm Tracking: "+((ParamOption)tgdm.getInput().getFirstChildByName("Tracking")).getValue());
		System.out.println("tgdm Generate Inner Surface: "+((ParamBoolean)tgdm.getInput().getFirstChildByName("Generate Inner Surface")).getValue());
		System.out.println("tgdm Generate Central Surface: "+((ParamBoolean)tgdm.getInput().getFirstChildByName("Generate Central Surface")).getValue());
		System.out.println("tgdm Generate Outer Surface: "+((ParamBoolean)tgdm.getInput().getFirstChildByName("Generate Outer Surface")).getValue());
		System.out.println("tgdm Initial Iso Level: "+((ParamDouble)tgdm.getInput().getFirstChildByName("Initial Iso Level")).getValue());
		System.out.println("tgdm White Matter Iso Level: "+((ParamDouble)tgdm.getInput().getFirstChildByName("White Matter Iso Level")).getValue());
		System.out.println("tgdm Gray Matter Iso Level: "+((ParamDouble)tgdm.getInput().getFirstChildByName("Gray Matter Iso Level")).getValue());
		System.out.println("tgdm Initial Smoothing Curvature Force: "+((ParamDouble)tgdm.getInput().getFirstChildByName("Initial Smoothing Curvature Force")).getValue());
		System.out.println("tgdm Iterations for Initial Smoothing: "+((ParamInteger)tgdm.getInput().getFirstChildByName("Iterations for Initial Smoothing")).getValue());
		System.out.println("tgdm Inner Surface Curvature Force: "+((ParamDouble)tgdm.getInput().getFirstChildByName("Inner Surface Curvature Force")).getValue());
		System.out.println("tgdm Inner Surface Pressure Force: "+((ParamDouble)tgdm.getInput().getFirstChildByName("Inner Surface Pressure Force")).getValue());
		System.out.println("tgdm Inner Surface External Force: "+((ParamDouble)tgdm.getInput().getFirstChildByName("Inner Surface External Force")).getValue());
		System.out.println("tgdm Iterations for Inner Surface: "+((ParamInteger)tgdm.getInput().getFirstChildByName("Iterations for Inner Surface")).getValue());
		System.out.println("tgdm Central Surface Curvature Force: "+((ParamDouble)tgdm.getInput().getFirstChildByName("Central Surface Curvature Force")).getValue());
		System.out.println("tgdm Central Surface Pressure Force: "+((ParamDouble)tgdm.getInput().getFirstChildByName("Central Surface Pressure Force")).getValue());
		System.out.println("tgdm Central Surface External Force: "+((ParamDouble)tgdm.getInput().getFirstChildByName("Central Surface External Force")).getValue());
		System.out.println("tgdm Iterations for Central Surface: "+((ParamInteger)tgdm.getInput().getFirstChildByName("Iterations for Central Surface")).getValue());
		System.out.println("tgdm Outer Surface Curvature Force: "+((ParamDouble)tgdm.getInput().getFirstChildByName("Outer Surface Curvature Force")).getValue());
		System.out.println("tgdm Outer Surface Pressure Force: "+((ParamDouble)tgdm.getInput().getFirstChildByName("Outer Surface Pressure Force")).getValue());
		System.out.println("tgdm Outer Surface External Force: "+((ParamDouble)tgdm.getInput().getFirstChildByName("Outer Surface External Force")).getValue());
		System.out.println("tgdm Iterations for Outer Surface: "+((ParamInteger)tgdm.getInput().getFirstChildByName("Iterations for Outer Surface")).getValue());
		System.out.println("tgdm Connectivity (Foreground,Background): "+((ParamOption)tgdm.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).getValue());
		System.out.println("tgdm Generate Iso-Surfaces: "+((ParamBoolean)tgdm.getInput().getFirstChildByName("Generate Iso-Surfaces")).getValue());
		
		
		tgdm.runAlgorithm();


		// clear unnecessary TGDM results
		A = ((ParamVolume)tgdm.getOutput().getFirstChildByName("Signed Volume")).getImageData();
		A.dispose();
		
			
		EmbeddedSurface surf = ((ParamSurface)tgdm.getOutput().getFirstChildByName("Inner Surface")).getSurface();
		Point3f offset = new Point3f(crops.xmin, crops.ymin, crops.zmin);
		Point3f freesurferoffset = new Point3f((-gmorigin[0]), (-gmorigin[1]), (gmorigin[2]));

		surf.translate(offset);
		surf.setName(name+"_TGDMinnerSurface");
//		uncroppedInnerSurf.setValue(srw.write(surf, dir));
//		surf.disposeAllTables();	
		uncroppedInnerSurf.setValue(surf);
//		uncroppedInnerSurf.getSurface().setName(name+"_TGDMinnerSurface");
		
		surf = ((ParamSurface)tgdm.getOutput().getFirstChildByName("Central Surface")).getSurface();
		surf.translate(offset);	
		surf.setName(name+"_TGDMcentralSurface");
//		uncroppedCentralSurf.setValue(srw.write(surf, dir));
//		surf.disposeAllTablegms();
		uncroppedCentralSurf.setValue(surf);
//		uncroppedCentralSurf.getSurface().setName(name+"_TGDMcentralSurface");
		
		surf = ((ParamSurface)tgdm.getOutput().getFirstChildByName("Outer Surface")).getSurface();
		surf.translate(offset);
		surf.setName(name+"_TGDMouterSurface");
//		uncroppedOuterSurf.setValue(srw.write(surf, dir));
//		surf.disposeAllTables();
		uncroppedOuterSurf.setValue(surf);
//		uncroppedOuterSurf.getSurface().setName(name+"_TGDMouterSurface");
		
		
		ImageDataMipav topo = new ImageDataMipav(Levelimg);

		ImageDataMipav inner = new ImageDataMipav(((ParamVolume)tgdm.getOutput().getFirstChildByName("Inner Level Set")).getImageData());
		ImageDataMipav central = new ImageDataMipav(((ParamVolume)tgdm.getOutput().getFirstChildByName("Central Level Set")).getImageData());
		ImageDataMipav outer = new ImageDataMipav(((ParamVolume)tgdm.getOutput().getFirstChildByName("Outer Level Set")).getImageData());
//		ImageDataMipav signedvol=((ParamVolume)tgdm.getOutput().getFirstChildByName("Signed Volume")).getImageData();
		ImageDataMipav thinCSF = new ImageDataMipav(ACEskelectonimg);
		ImageDataMipav gvf = new ImageDataMipav(GVFimg);
		Point3i d = new Point3i(crops.getCroppedRows(),crops.getCroppedCols(),crops.getCroppedSlices());
		Point3i off = new Point3i(crops.xmin,crops.ymin,crops.zmin);
	
		CropParameters uncrop = new CropParameters(rows,cols,slices,1,off.x,d.x+off.x-1,off.y,d.y+off.y-1,off.z,d.z+off.z-1,20);
		CropParameters uncrop2=new CropParameters(rows,cols,slices,1,off.x,d.x+off.x-1,off.y,d.y+off.y-1,off.z,d.z+off.z-1,0);
		CropParameters uncrop3=new CropParameters(rows,cols,slices,3,off.x,d.x+off.x-1,off.y,d.y+off.y-1,off.z,d.z+off.z-1,0);

		A = cropper.uncrop(inner,uncrop);
		A.setName(name + "_TGDMinnerlevelset");
		uncroppedInner.setValue(A);
		//uncroppedInner.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		uncroppedInner.getImageData().setHeader(GMimg.getHeader());
		
		A = cropper.uncrop(central,uncrop);
		A.setName(name + "_TGDMcentrallevelset");
		uncroppedCentral.setValue(A);
		//uncroppedCentral.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		uncroppedCentral.getImageData().setHeader(GMimg.getHeader());
		
		A = cropper.uncrop(outer,uncrop);
		A.setName(name + "_TGDMouterlevelset");
		uncroppedOuter.setValue(A);
		//uncroppedOuter.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		uncroppedOuter.getImageData().setHeader(GMimg.getHeader());
		
		
		A = cropper.uncrop(topo,uncrop2);
		A.setName(name + "_topologycorrected");
		uncroppedTopo.setValue(A);
		//uncroppedTopo.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		uncroppedTopo.getImageData().setHeader(GMimg.getHeader());
		
		
		A = cropper.uncrop(ACEGMimg,uncrop2);
		A.setName(name + "_ACEenhancedGM");
		uncroppedEnhancedGM.setValue(A);
		//uncroppedEnhancedGM.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		uncroppedEnhancedGM.getImageData().setHeader(GMimg.getHeader());
/*
		A = cropper.uncrop(skel,uncrop2);
		A.setName(gmname + "_CSFskeleton");
		ucSkel.setValue(A);
		ucSkel.getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
*/
		A = cropper.uncrop(thinCSF,uncrop2);
		A.setName(name + "_thinnedCSFskeleton");
		uncroppedthinCSF.setValue(A);
		uncroppedthinCSF.getImageData().setHeader(GMimg.getHeader());
		
		
		ImageData B = cropper.uncrop(gvf, uncrop3);
		//FileUtil.updateFileInfo(gm.getModelImageCopy(), B.getModelImageCopy());
		B.setHeader(GMimg.getHeader());
		B.setName(name+"_gradientvectorfield");
		uncroppedGvf.setValue(B);
		
		
		((ParamVolume)thickness.getInput().getFirstChildByName("Inner Level Set")).setValue(inner);
		((ParamVolume)thickness.getInput().getFirstChildByName("Outer Level Set")).setValue(outer);
		thickness.runAlgorithm(monitor);


		ImageDataMipav thickvol =new ImageDataMipav(((ParamVolume)thickness.getOutput().getFirstChildByName("Thickness Volume")).getImageData());
		A = cropper.uncrop(thickvol,uncrop2);
		A.setName(name + "_thicknessVol");
		ucthickvol.setValue(A);
		//ucthickvol.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		ucthickvol.getImageData().setHeader(GMimg.getHeader());
		
		ImageDataMipav thicklevset=new ImageDataMipav(((ParamVolume)thickness.getOutput().getFirstChildByName("Level Set")).getImageData());
		A = cropper.uncrop(thicklevset,uncrop2);
		A.setName(name + "_thicknesslevset");
		ucthicklevset.setValue(A);
		//ucthicklevset.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		ucthicklevset.getImageData().setHeader(GMimg.getHeader());
		
		
		
		System.out.println("Start to save output files");// yk add debug
		A = uncroppedInner.getImageData();
		A.setName(name+"_innerVol");
		ykdebug.setValue(vrw.write(A, dir_output));

		A = uncroppedCentral.getImageData();
		A.setName(name+"_centralVol");
		ykdebug.setValue(vrw.write(A, dir_output));

		A = uncroppedOuter.getImageData();// yk add debugmageData();
		A.setName(name+"_outerVol");
		ykdebug.setValue(vrw.write(A, dir_output));
		
		A = uncroppedTopo.getImageData();// yk add debugmageData();
		A.setName(name+"_TopoCorrect");
		ykdebug.setValue(vrw.write(A, dir_output));
		
		A = uncroppedEnhancedGM.getImageData();// yk add debugmageData();
		A.setName(name+"_ACEGM");
		ykdebug.setValue(vrw.write(A, dir_output));
		
		A = uncroppedthinCSF.getImageData();// yk add debugmageData();
		A.setName(name+"_ACEskelectonimg");
		ykdebug.setValue(vrw.write(A, dir_output));
		
		A = uncroppedGvf.getImageData();// yk add debugmageData();
		A.setName(name+"_GVFimg");
		ykdebug.setValue(vrw.write(A, dir_output));
		
		A = ucthickvol.getImageData();// yk add debugmageData();
		A.setName(name+"_thicknessVol");
		ykdebug.setValue(vrw.write(A, dir_output));

		
		A = ucthicklevset.getImageData();// yk add debugmageData();
		A.setName(name+"_thicknesslevset");
		ykdebug.setValue(vrw.write(A, dir_output));

// surface
		surf = uncroppedInnerSurf.getSurface();
		surf.setName(name+"_innerSurf");
		ykdebug.setValue(srw.write(surf, dir_output));
		//set freesurfer surface
//		surf.translate(freesurferoffset);
//		surf.setName(name+"_innerSurf_freesurfer");
//		ykdebug.setValue(frw.write(surf, dir_output));

		surf = uncroppedCentralSurf.getSurface();
		surf.setName(name+"_centralSurf");
		ykdebug.setValue(srw.write(surf, dir_output));
//		surf.translate(freesurferoffset);
//		surf.setName(name+"_centralSurf_freesurfer");
//		ykdebug.setValue(frw.write(surf, dir_output));

		surf = uncroppedOuterSurf.getSurface();
		surf.setName(name+"_outerSurf");
		ykdebug.setValue(srw.write(surf, dir_output));
//		surf.translate(freesurferoffset);
//		surf.setName(name+"_outerSurf_freesurfer");
//		ykdebug.setValue(frw.write(surf, dir_output));
		
		
		System.out.println("MedicAlgorithmMultiAtlasCRUISE is done!!!");// yk add debug
		
	}
}
