package edu.vanderbilt.masi.plugins.CRUISE.testing;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;

import edu.jhmi.rad.medic.utilities.CropParameters;
import edu.jhmi.rad.medic.utilities.CubicVolumeCropper;
import edu.jhmi.rad.medic.utilities.MedicUtilPublic;
import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
import edu.jhu.ece.iacl.jist.io.ImageDataReaderWriter;
import edu.jhu.ece.iacl.jist.io.FileExtensionFilter;
import edu.jhu.ece.iacl.jist.io.SurfaceVtkReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.plugins.classification.MedicAlgorithmAtlasEMSegmentation;
import edu.jhu.ece.iacl.plugins.classification.MedicAlgorithmLesionToads;
import edu.jhu.ece.iacl.plugins.classification.MedicAlgorithmN3;
import edu.jhu.ece.iacl.plugins.measure.statistics.MedicAlgorithmIsoLevelSurfaceLandmarks;
import edu.jhu.ece.iacl.plugins.measure.statistics.MedicAlgorithmSurfaceStatistics;
import edu.jhu.ece.iacl.plugins.measure.thickness.MedicAlgorithmThickness;
import edu.jhu.ece.iacl.plugins.registration.MedicAlgorithmFLIRT;
import edu.jhu.ece.iacl.plugins.registration.MedicAlgorithmTransformVolume;
import edu.jhu.ece.iacl.plugins.segmentation.cruise.MedicAlgorithmAnatomicallyConsistentEnhance;
import edu.jhu.ece.iacl.plugins.segmentation.cruise.MedicAlgorithmGradVecFlow;
import edu.jhu.ece.iacl.plugins.segmentation.gdm.MedicAlgorithmNestedTGDM;
import edu.jhu.ece.iacl.plugins.topology.MedicAlgorithmTopologyCorrection;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.VoxelType;
import edu.jhu.ece.iacl.plugins.segmentation.skull_strip.MedicAlgorithmSPECTRE2010;
import edu.jhu.ece.iacl.plugins.segmentation.skull_strip.MedicAlgorithmRemoveDura09;
import edu.jhu.ece.iacl.plugins.utilities.volume.MedicAlgorithmReorientVolume;
import edu.jhu.ece.iacl.plugins.utilities.math.MedicAlgorithmImageCalculator;
import edu.jhu.ece.iacl.plugins.utilities.math.MedicAlgorithmImageMath;

public class CRUISEplus_ori extends ProcessingAlgorithm{
	MedicAlgorithmN3 n3;
	MedicAlgorithmLesionToads lToads;
	MedicAlgorithmAtlasEMSegmentation atlasEM;
	MedicAlgorithmSPECTRE2010 spectre;
	MedicAlgorithmAnatomicallyConsistentEnhance ace;
	MedicAlgorithmNestedTGDM tgdm;
	MedicAlgorithmGradVecFlow gvfCentral;
	MedicAlgorithmTopologyCorrection topoCorrect;
	MedicAlgorithmRemoveDura09 rmDura;
//	MedicAlgorithmSmoothSurface smooth;
	MedicAlgorithmThickness  thickness;
//	MedicAlgorithmOrientSurface orient;
	ParamPointInteger offset;
	ParamPointInteger dim;
	ParamCollection cropParams;
	ParamBoolean doRegister;
	ParamWeightedVolumeCollection<String> inputImages;
	int rows = 0, cols = 0, slices = 0;
	ParamVolume mprage, spgr, t2flair;
	ParamVolume ucthickvol, ucthicklevset,
		uncroppedthinCSF, uncroppedTopo, uncroppedGvf, croppedGM,
		croppedWM, croppedInitWM, uncroppedInner, uncroppedCentral,
		uncroppedOuter, uncroppedEnhancedGM, ucSignedVol, ucSkel,
		rmDuravol, rmDuramask;
	ParamSurface uncroppedInnerSurf, uncroppedCentralSurf, uncroppedOuterSurf, thicknessSurface;
//	ParamFile uncroppedInnerSurf, uncroppedCentralSurf, uncroppedOuterSurf;
	//ParamFile n3img_t1, n3field_t1,n3img_flair, n3field_flair,
	ParamFile spectrestripped_t1, spectremask,spectrestripped_flair,
	atlasEMseg, atlasEMwmfill, atlasEMmask, atlasEMgm,
	durastripped_t1, duramask,durastripped_flair,
	ltoadsseg, ltoadslesion, ltoadsmaxmem, ltoadsmemb, ltoadswmfill, ltoadsmask, ltoadsgm, ltoadscsf;
	
	ParamDouble meanThickness, stdThickness, medianThickness;

	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	
	private static final ImageDataReaderWriter vrw = ImageDataReaderWriter.getInstance();
	private static final SurfaceVtkReaderWriter srw = SurfaceVtkReaderWriter.getInstance();
	
	private static final FileExtensionFilter volumeFileExts = vrw.getExtensionFilter();
	private static final FileExtensionFilter surfaceFileExts = srw.getExtensionFilter();
	
	protected void createInputParameters(ParamCollection inputParams) {
		setPreferredSize(new Dimension(800, 500));
		
		ParamCollection inputs = new ParamCollection("Input Images");
		inputs.add(mprage=new ParamVolume("T1-MPRAGE Image"));
		mprage.setMandatory(false);
		inputs.add(spgr=new ParamVolume("T1-SPGR Image"));
		spgr.setMandatory(false);
		inputs.add(t2flair=new ParamVolume("FLAIR Image"));
		t2flair.setMandatory(false);
		doRegister = new ParamBoolean ("Register input images", false);
		
		n3 = new MedicAlgorithmN3();
		n3.getInput().getFirstChildByName("Input Volume").setHidden(true);
		
		gvfCentral = new MedicAlgorithmGradVecFlow();
		gvfCentral.getInput().getFirstChildByName("Volume").setHidden(true);
		
		spectre = new MedicAlgorithmSPECTRE2010();
		spectre.getInput().getFirstChildByName("Input Volume").setHidden(true);
		spectre.getInput().getFirstChildByName("Image modality").setHidden(true);
		spectre.getInput().getFirstChildByName("Output in Original Image Space").setHidden(true);
		((ParamBoolean)spectre.getInput().getFirstChildByName("Output in Original Image Space")).setValue(false);
		spectre.getInput().getFirstChildByName("FANTASM").setHidden(true);
		spectre.getInput().getFirstChildByName("MSP").setHidden(true);
		spectre.getInput().getFirstChildByName("Find Midsaggital Plane").setHidden(true);
		spectre.getInput().getFirstChildByName("Resample data to Isotropic voxels").setHidden(true);
		((ParamBoolean)spectre.getInput().getFirstChildByName("Resample data to Isotropic voxels")).setValue(false);
		spectre.getInput().getFirstChildByName("Run Smooth Brain Mask").setHidden(true);
		((ParamOption)spectre.getInput().getFirstChildByName("Image modality")).setValue(2); //always choose T1_MPRAGE for Spectre
		((ParamBoolean)spectre.getInput().getFirstChildByName("Inhomogeneity Correction")).setValue(false); // N3 does correction so set FANTASM option to false.
		((ParamBoolean)spectre.getInput().getFirstChildByName("Resample data to Isotropic voxels")).setValue(false);
		((ParamBoolean)spectre.getInput().getFirstChildByName("Find Midsaggital Plane")).setValue(false);
				
		rmDura = new MedicAlgorithmRemoveDura09();
		rmDura.getInput().getFirstChildByName("Original Volume").setHidden(true);
		rmDura.getInput().getFirstChildByName("WM Volume").setHidden(true);
		rmDura.getInput().getFirstChildByName("GM Volume").setHidden(true);
		rmDura.getInput().getFirstChildByName("WM Mask").setHidden(true);
		rmDura.getInput().getFirstChildByName("Data").setHidden(true);
		
		atlasEM = new MedicAlgorithmAtlasEMSegmentation();
		atlasEM.getInput().setName("EM Segmentation");
		atlasEM.getInput().setLabel("EM Segmentation");
		atlasEM.getInput().getFirstChildByName("T1_MPRAGE Image").setHidden(true);
		atlasEM.getInput().getFirstChildByName("T1_SPGR Image").setHidden(true);
		atlasEM.getInput().getFirstChildByName("Correct inhomogeneity").setHidden(true);
		atlasEM.getInput().getFirstChildByName("Output Atlases").setHidden(true);
		atlasEM.getInput().getFirstChildByName("Output inhomogeniety filed").setHidden(true);
		/*atlasEM.getInput().getFirstChildByName("Smooting parameter").setHidden(true);
		atlasEM.getInput().getFirstChildByName("Maximum iterations").setHidden(true);
		atlasEM.getInput().getFirstChildByName("Maximum difference").setHidden(true);*/
		//atlasEM.getInput().getFirstChildByName("Gaussian kernel Size").setHidden(true);
		atlasEM.getInput().getFirstChildByName("registeration Type").setHidden(true);
		atlasEM.getInput().getFirstChildByName("Demons Scale").setHidden(true);
		atlasEM.getInput().getFirstChildByName("Demons Smoothing").setHidden(true);
		//atlasEM.getInput().getFirstChildByName("Prior Type").setHidden(true);
		((ParamOption)atlasEM.getInput().getFirstChildByName("Prior Type")).setValue(2);
		//atlasEM.getInput().getFirstChildByName("Atlas Adaptation Weight").setHidden(true);
		atlasEM.getInput().getFirstChildByName("Output images").setHidden(true);
		((ParamOption)atlasEM.getInput().getFirstChildByName("Output images")).setValue(2);
		String filename = "Atlas/ibsr8obj/cruise-atlas-8obj-noBG-EM.txt";
		try {
	        ClassLoader cl = Thread.currentThread().getContextClassLoader();
	        ((ParamFile)atlasEM.getInput().getFirstChildByName("Atlas file")).setValue(cl.getResource(filename).getFile());
		} catch (Exception e) {
	                System.out.print("Error: Unable to set default atlas\n");
	                //System.out.print("Error: "+e.getMessage()+ "\n");
		}
		((ParamDouble)atlasEM.getInput().getFirstChildByName("Smooting parameter")).setValue(10.0);
	        
		/*
		 * N3 does the Inhomogeneity Correction.
		 */
		//((ParamBoolean)toads.getInput().getFirstChildByName("Correct inhomogeneity")).setHidden(true);
		//((ParamBoolean)toads.getInput().getFirstChildByName("Correct inhomogeneity")).setValue(false);
		/*((ParamOption)toads.getInput().getFirstChildByName("Correction Method")).setHidden(true);
		((ParamInteger)toads.getInput().getFirstChildByName("Inhomogeneity field degree")).setHidden(true);*/

		
		lToads = new MedicAlgorithmLesionToads();
		lToads.getInput().setName("Lesion-TOADS");
		lToads.getInput().setLabel("Lesion-TOADS");
		lToads.getInput().getFirstChildByName("T1_MPRAGE Image").setHidden(true);
		lToads.getInput().getFirstChildByName("T1_SPGR Image").setHidden(true);
		lToads.getInput().getFirstChildByName("FLAIR Image").setHidden(true);
		lToads.getInput().getFirstChildByName("Correct inhomogeneity").setHidden(true);
		((ParamBoolean)lToads.getInput().getFirstChildByName("Correct inhomogeneity")).setValue(true);
		lToads.getInput().getFirstChildByName("Output inhomogeniety filed").setHidden(true);
		((ParamOption)lToads.getInput().getFirstChildByName("Output images")).setValue(2); //output should be cruise_input
		String filename2 = "Atlas/lesionToads-atlas-2012/cruise-atlas-12obj-lesiontoads2012.txt";
		try {

	        ClassLoader cl = Thread.currentThread().getContextClassLoader();
	        ((ParamFile)lToads.getInput().getFirstChildByName("Atlas file")).setValue(cl.getResource(filename2).getFile());
		} catch (Exception e) {
	                System.out.print("Error: Unable to set default atlas\n");
	                //System.out.print("Error: "+e.getMessage()+ "\n");
		}

		/*
		 * N3 does the Inhomogeneity Correction.
		 */
		//((ParamBoolean)toads2.getInput().getFirstChildByName("Correct inhomogeneity")).setHidden(true);
		//((ParamBoolean)toads2.getInput().getFirstChildByName("Correct inhomogeneity")).setValue(false);
		/*((ParamOption)toads2.getInput().getFirstChildByName("Correction Method")).setHidden(true);
		((ParamInteger)toads2.getInput().getFirstChildByName("Inhomogeneity field degree")).setHidden(true);*/
		
		
		thickness = new MedicAlgorithmThickness();
		thickness.getInput().getFirstChildByName("Inner Level Set").setHidden(true);
		thickness.getInput().getFirstChildByName("Outer Level Set").setHidden(true);
		((ParamOption)thickness.getInput().getFirstChildByName("Approximation Method")).setValue("Level Set Subtraction");
		thickness.getInput().getFirstChildByName("Approximation Method").setHidden(true);
		thickness.getInput().getFirstChildByName("Lagrange Step Size").setHidden(true);
		thickness.getOutput().setHidden(true);
		
		topoCorrect = new MedicAlgorithmTopologyCorrection();
		topoCorrect.getInput().getFirstChildByName("Volume").setHidden(true);
		topoCorrect.getInput().getFirstChildByName("Paint mask").setHidden(true);
		topoCorrect.getInput().getFirstChildByName("Connectivity (Foreground,Background)").setHidden(true);
		ace=new MedicAlgorithmAnatomicallyConsistentEnhance();
		ace.getInput().getFirstChildByName("Gray Matter").setHidden(true);
		ace.getInput().getFirstChildByName("White Matter").setHidden(true);
		tgdm=new MedicAlgorithmNestedTGDM();
		tgdm.getInput().getFirstChildByName("Connectivity (Foreground,Background)").setHidden(true);
		tgdm.getInput().getFirstChildByName("Data").setHidden(true);
		tgdm.getInput().getFirstChildByName("Initial Level Set").setHidden(true);
		tgdm.getInput().getFirstChildByName("Initial Iso Level").setHidden(true);
		tgdm.getInput().getFirstChildByName("Initial Smoothing Curvature Force").setHidden(true);
		tgdm.getInput().getFirstChildByName("Iterations for Initial Smoothing").setHidden(true);
			
		
		inputParams.add(inputs);
		inputParams.add(n3.getInput());
		inputParams.add(spectre.getInput());
		inputParams.add(atlasEM.getInput());
		inputParams.add(rmDura.getInput());
		inputParams.add(lToads.getInput());
		//inputParams.add(topoCorrect.getInput());
		inputParams.add(gvfCentral.getInput());

		inputParams.add(tgdm.getInput());
		inputParams.add(thickness.getInput());

		inputParams.setLabel("CRUISE+"); // Name Displayed in Module List
		inputParams.setName("CRUISE+");   // Name displayed in Process Manager
		
		inputParams.setPackage("IACL");
		inputParams.setCategory("Segmentation.CRUISE");

		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.Release);

		info.add(ReferencedPapers.cruisePlus);
		info.add(ReferencedPapers.cruise);
		info.add(ReferencedPapers.ace);
		info.add(ReferencedPapers.tgdm);
		info.add(ReferencedPapers.gvf);
		info.add(PrinceGroupAuthors.navidShiee);
		info.add(PrinceGroupAuthors.pierreLouisBazin);
		info.add(PrinceGroupAuthors.dzungPham);
		info.add(new AlgorithmAuthor("Aaron Carass", "aaron_carass@jhu.edu", "http://www.iacl.ece.jhu.edu/"));
		info.setDescription("CRUISE+ pipeline generating cortical surfaces and thickness statistics of brains with WM lesions.");
    	info.setLongDescription("CRUISE+ pipeline. It takes a single or multi-channel 3D volume, does skull stripping by SPECTRE and cortical segmentation using Lesion-TOADS. Then an Anatomically Consistent Enhancement (ACE) is done to remove partial voluming in the deep sulci. The surfaces are generated by a Topology Preserving Geoemtric Deformable Model (TGDM).");
    	info.setAdditionalDocURL("html/edu/jhu/ece/iacl/plugins/segmentation/cruise/MedicAlgorithmLongCRUISE/index.html");
	}

	protected void createOutputParameters(ParamCollection outputParams) {
		uncroppedTopo = new ParamVolume("Topologically Correct WM volume");		
		uncroppedEnhancedGM = new ParamVolume("ACE Enhanced GM");
		uncroppedthinCSF = new ParamVolume("ACE Thinned CSF Skeleton");
		uncroppedInner = new ParamVolume("TGDM Inner Level Set");
		uncroppedCentral = new ParamVolume("TGDM Central Level Set");
		uncroppedOuter = new ParamVolume("TGDM Outer Level Set");
		uncroppedInnerSurf = new ParamSurface("TGDM Inner Surface");
		uncroppedCentralSurf = new ParamSurface("TGDM Central Surface");
		uncroppedOuterSurf = new ParamSurface("TGDM Outer Surface");
		thicknessSurface = new ParamSurface("Thickness Map on Central Surface");
//		uncroppedInnerSurf = new ParamFile("TGDM Inner Surface",surfaceFileExts);
//		uncroppedCentralSurf = new ParamFile("TGDM Central Surface",surfaceFileExts);
//		uncroppedOuterSurf = new ParamFile("TGDM Outer Surface",surfaceFileExts);
		ucthickvol = new ParamVolume("Thickness Volume");
		ucthicklevset = new ParamVolume("Thickness Level Set");
		uncroppedGvf = new ParamVolume("Gradient Vector Field",VoxelType.FLOAT,-1,-1,-1,3);
		meanThickness = new ParamDouble("Mean Thickness on Central Surface");
		stdThickness = new ParamDouble("Standard Deviation Thickness on Central Surface");
		medianThickness = new ParamDouble("Median Thickness on Central Surface");

		//n3img_t1 = new ParamFile("N3 Inhomogeneity Corrected T1 Image", volumeFileExts);
		//n3field = new ParamFile("N3 Inhomogeneity Field T1", volumeFileExts);/*
		//n3img_flair = new ParamFile("N3 Inhomogeneity Corrected FLAIR Image", volumeFileExts);
		//n3field_flair = new ParamFile("N3 Inhomogeneity Field FLAIR", volumeFileExts);*/
		atlasEMseg = new ParamFile("EM Hard Segmentation", volumeFileExts);
		atlasEMwmfill = new ParamFile("EM Filled WM membership", volumeFileExts);
		atlasEMgm = new ParamFile("EM GM Membership", volumeFileExts);
		atlasEMmask = new ParamFile("EM WM Mask", volumeFileExts);
		
		ltoadsseg = new ParamFile("Lesion-Toads Hard Segmentation", volumeFileExts);
		ltoadsmaxmem = new ParamFile("Lesion-Toads Hard Segmentation from Memberships", volumeFileExts);
		ltoadsmaxmem.setMandatory(false);
		ltoadslesion = new ParamFile("Lesion-Toads Lesion Segmentation", volumeFileExts);
		ltoadsmemb = new ParamFile("Lesion-Toads Membership", volumeFileExts);
		ltoadscsf = new ParamFile("Lesion-Toads CSF Membership", volumeFileExts);
		ltoadswmfill = new ParamFile("Lesion-Toads Filled WM membership", volumeFileExts);
		ltoadsgm = new ParamFile("Lesion-Toads GM Membership", volumeFileExts);
		ltoadsmask = new ParamFile("Lesion-Toads WM Mask", volumeFileExts);
		
		spectrestripped_t1 = new ParamFile("SPECTRE stripped and N3 corrected original reoriented T1 volume");
		spectremask = new ParamFile("Brainmask from SPECTRE");
		spectrestripped_flair = new ParamFile("SPECTRE stripped and N3 corrected regostered FLAIR volume");
		spectrestripped_flair.setMandatory(false);
		durastripped_t1 = new ParamFile("Dura stripped and N3 corrected original reoriented T1 volume");
		duramask = new ParamFile("Brainmask from Dura Removal");
		durastripped_flair = new ParamFile("Dura stripped and N3 corrected regostered FLAIR volume");
		durastripped_flair.setMandatory(false);
//		rmDuravol = new ParamVolume("Dura Removed Volume");
//		rmDuramask = new ParamVolume("Dura Removed Mask");
				
		ParamCollection EMSegmentation = new ParamCollection("EMsegmentation");
		ParamCollection LesionToads = new ParamCollection("LesionTOADS");
//		ParamCollection Spectre = new ParamCollection("SPECTRE");
//		ParamCollection N3 = new ParamCollection("N3");
//		N3.add(n3img);
//		N3.add(n3field);
//		ParamCollection RMDura = new ParamCollection("DuraRemoval");
		EMSegmentation.add(atlasEMseg);	
		EMSegmentation.add(atlasEMgm);
		EMSegmentation.add(atlasEMwmfill);
		EMSegmentation.add(atlasEMmask);
		LesionToads.add(ltoadsseg);
		LesionToads.add(ltoadscsf);
		LesionToads.add(ltoadsgm);
		LesionToads.add(ltoadswmfill);
		LesionToads.add(ltoadsmask);
		
//		EMSegmentation.add(toads.getOutput());
//		ToadsSecondPass.add(toads2.getOutput());
//		Spectre.add(spectrestripped);
//		Spectre.add(spectremask);
//		RMDura.add(rmDuravol);
//		RMDura.add(rmDuramask);

//		outputParams.add(N3);
		outputParams.add(EMSegmentation);
		outputParams.add(LesionToads);
//		outputParams.add(Spectre);
//		outputParams.add(RMDura);
		outputParams.add(uncroppedTopo);	
		outputParams.add(uncroppedEnhancedGM);
		outputParams.add(uncroppedthinCSF);
		outputParams.add(uncroppedInner);
		outputParams.add(uncroppedCentral);
		outputParams.add(uncroppedOuter);
		outputParams.add(uncroppedInnerSurf);
		outputParams.add(uncroppedCentralSurf);
		outputParams.add(uncroppedOuterSurf);
		outputParams.add(thicknessSurface);
		outputParams.add(ucthickvol);
		outputParams.add(ucthicklevset);
		outputParams.add(uncroppedGvf);
		outputParams.add(meanThickness);
		outputParams.add(stdThickness);
		outputParams.add(medianThickness);
		
		outputParams.setLabel("CRUISE+"); // Name Displayed in Module List
		outputParams.setName("CRUISE+");   // Name displayed in Process Manager
	}


	@Override
	protected void execute(CalculationMonitor monitor) {
		
		//set the output directory and create it if it doesn't exist
		File dir = new File(this.getOutputDirectory()+File.separator+edu.jhu.ece.iacl.jist.utility.FileUtil.forceSafeFilename(this.getAlgorithmName()));
		try{
			if(!dir.isDirectory()){
				(new File(dir.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }
		String dir1 = dir + "/EMsegmentation/";
		File dirToads1 = new File(dir1);
		try{
			if(!dirToads1.isDirectory()){
				(new File(dirToads1.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }
		dir1 = dir + "/LesionTOADS/";
		File dirToads2 = new File(dir1);
		try{
			if(!dirToads2.isDirectory()){
				(new File(dirToads2.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }
		
		
		ImageData t1, flair;
		
		if (mprage.getImageData()!=null){
			t1 = new ImageDataFloat(mprage.getImageData());
		}else if (spgr.getImageData() != null){
			t1 = new ImageDataFloat(spgr.getImageData());
		}else{
			t1 = null;
			MedicUtilPublic.displayError("No T1-weighted image found");
		}
		if (t2flair.getImageData()!=null){
			flair = new ImageDataFloat(t2flair.getImageData());
		}else
			flair =null;
		
		
		String name = t1.getName();	
		
		ImageData A, orig;

		((ParamVolume)n3.getInput().getFirstChildByName("Input Volume")).setValue(t1);
		n3.runAlgorithm(monitor);
		orig = ((ParamVolume)n3.getOutput().getFirstChildByName("Inhomogeneity Corrected Volume")).getImageData();
		/*n3img_t1.setValue(vrw.write(orig, dir));
		n3field_t1.setValue(vrw.write(((ParamVolume)n3.getOutput().getFirstChildByName("Inhomogeneity Field")).getImageData(), dir));*/
		A = ((ParamVolume)n3.getOutput().getFirstChildByName("Inhomogeneity Field")).getImageData();
		A.dispose();
				
		
		((ParamVolume)spectre.getInput().getFirstChildByName("Input Volume")).setValue(orig);
		spectre.runAlgorithm(monitor);
		//clear memory pointed to by orig (N3 corrected volume)
		orig.dispose();
		orig = ((ParamVolume)spectre.getOutput().getFirstChildByName("Stripped Volume")).getImageData();
		A = ((ParamVolume)spectre.getOutput().getFirstChildByName("Prior Volume")).getImageData();
		A.dispose();
		A = ((ParamVolume)spectre.getOutput().getFirstChildByName("FANTASM Segmentation")).getImageData();
		A.dispose();
		A = ((ParamVolume)spectre.getOutput().getFirstChildByName("d0")).getImageData();
		A.dispose();
		A = ((ParamVolume)spectre.getOutput().getFirstChildByName("Original or Reoriented Volume")).getImageData();
		A.dispose();
			
		
		//Strip the original uncorrected T1 image
		MedicAlgorithmImageCalculator calculator = new MedicAlgorithmImageCalculator();
		((ParamOption)calculator.getInput().getFirstChildByName("Operation")).setValue(2);
		((ParamVolume)calculator.getInput().getFirstChildByName("Volume 1")).setValue(t1);
		((ParamVolume)calculator.getInput().getFirstChildByName("Volume 2")).setValue(
				((ParamVolume)spectre.getOutput().getFirstChildByName("Mask Volume")).getImageData());
		calculator.runAlgorithm();
		orig=((ParamVolume)calculator.getOutput().getFirstChildByName("Result Volume")).getImageData();
		//N3 Correction on Stripped T1 image
		((ParamVolume)n3.getInput().getFirstChildByName("Input Volume")).setValue(orig);
		n3.runAlgorithm(monitor);
		orig.dispose();
		orig = ((ParamVolume)n3.getOutput().getFirstChildByName("Inhomogeneity Corrected Volume")).getImageData();
		A = ((ParamVolume)n3.getOutput().getFirstChildByName("Inhomogeneity Field")).getImageData();
		A.dispose();
		
		MedicAlgorithmTransformVolume trans = new MedicAlgorithmTransformVolume();
		File intermOutputDir = new File(this.getOutputDirectory() + File.separator
				+ "Intermediat Results");
		intermOutputDir.mkdir();
		trans.setOutputDirectory(intermOutputDir);
		MedicAlgorithmReorientVolume reorient = new MedicAlgorithmReorientVolume();
		
		
		/**
		 * Check if there is a FLAIR image
		 */
		
		ImageData flairA = null;;
		if (flair!=null){
			if (doRegister.getValue()){
				int flairOrient= flair.getModelImageCopy().getImageOrientation();
				//reorient both T1 and FLAIR to standard (dicom) FLAIR orientation
				((ParamVolume)reorient.getInput().getFirstChildByName("Source")).setValue(flair);
				((ParamOption)reorient.getInput().getFirstChildByName("Interpolation")).setValue(1);
				((ParamOption)reorient.getInput().getFirstChildByName("Orientation")).setValue(flairOrient);
				((ParamOption)reorient.getInput().getFirstChildByName("Resolution")).setValue(0);
				reorient.runAlgorithm();
				flairA = ((ParamVolume)reorient.getOutput().getFirstChildByName("Reoriented Volume")).getImageData().clone();
				((ParamVolume)reorient.getInput().getFirstChildByName("Source")).setValue(t1);
				reorient.runAlgorithm();
				A = ((ParamVolume)reorient.getOutput().getFirstChildByName("Reoriented Volume")).getImageData();

				//register T1 to FLAIR so we have the stripping mask in the FLAIR space
				MedicAlgorithmFLIRT flirt = new MedicAlgorithmFLIRT();	
				((ParamOption)flirt.getInput().getFirstChildByName("Degrees of freedom")).setValue(0);
				((ParamOption)flirt.getInput().getFirstChildByName("Cost function")).setValue(3);
				((ParamVolume)flirt.getInput().getFirstChildByName("Source volume")).setValue(A);
				((ParamVolume)flirt.getInput().getFirstChildByName("Target volume")).setValue(flairA);
				flirt.runAlgorithm();
				A.dispose();
				A=((ParamVolume)flirt.getOutput().getFirstChildByName("Registered Volume")).getImageData();
				A.dispose();

				//Transform the stripping mask to the FLAIR space
				((ParamVolumeCollection)trans.getInput().getFirstChildByName("Volumes")).add(
						((ParamVolume)spectre.getOutput().getFirstChildByName("Mask Volume")).getImageData().clone());
				//((ParamVolume)calculator.getInput().getFirstChildByName("Volume 2")).setValue(new ImageDataFloat(spgr.getImageData()));
				((ParamOption)trans.getInput().getFirstChildByName("Registration interpolation")).setValue(7);
				((ParamVolume)trans.getInput().getFirstChildByName("Volume to Match - Dimensions & Resolution")).setValue(flairA.clone());
				((ParamMatrix)trans.getInput().getFirstChildByName("Transformation Matrix")).setValue(
						((ParamMatrix)flirt.getOutput().getFirstChildByName("Transformation Matrix")).getValue());
				trans.run();
				A=trans.result.getParamVolume(0).getImageData();
				//strip the FLAIR image
				((ParamVolume)calculator.getInput().getFirstChildByName("Volume 1")).setValue(flairA);
				((ParamVolume)calculator.getInput().getFirstChildByName("Volume 2")).setValue(A);
				calculator.runAlgorithm();
				A.dispose();
				flairA.dispose();
				flairA=((ParamVolume)calculator.getOutput().getFirstChildByName("Result Volume")).getImageData();
				//N3 Correction on Stripped T1 image
				((ParamVolume)n3.getInput().getFirstChildByName("Input Volume")).setValue(flairA);
				n3.runAlgorithm(monitor);
				flairA.dispose();
				flairA = ((ParamVolume)n3.getOutput().getFirstChildByName("Inhomogeneity Corrected Volume")).getImageData();
				A = ((ParamVolume)n3.getOutput().getFirstChildByName("Inhomogeneity Field")).getImageData();
				A.dispose();
			}else{
				/*((ParamVolume)n3.getInput().getFirstChildByName("Input Volume")).setValue(flair);
				n3.runAlgorithm(monitor);
				flairA = ((ParamVolume)n3.getOutput().getFirstChildByName("Inhomogeneity Corrected Volume")).getImageData();
				A = ((ParamVolume)n3.getOutput().getFirstChildByName("Inhomogeneity Field")).getImageData();
				A.dispose();*/
				((ParamVolume)calculator.getInput().getFirstChildByName("Volume 1")).setValue(flair);
				((ParamVolume)calculator.getInput().getFirstChildByName("Volume 2")).setValue(((ParamVolume)spectre.getOutput().getFirstChildByName("Mask Volume")).getImageData().clone());
				calculator.runAlgorithm();
				flairA=((ParamVolume)calculator.getOutput().getFirstChildByName("Result Volume")).getImageData();
				//N3 Correction on Stripped FLAIR image
				((ParamVolume)n3.getInput().getFirstChildByName("Input Volume")).setValue(flairA);
				n3.runAlgorithm(monitor);
				flairA.dispose();
				flairA = ((ParamVolume)n3.getOutput().getFirstChildByName("Inhomogeneity Corrected Volume")).getImageData();
				A = ((ParamVolume)n3.getOutput().getFirstChildByName("Inhomogeneity Field")).getImageData();
				A.dispose();
			}
		}else{
			flairA=null;
		}
		
		
		
		//Reorient the T1 to AXIAL and resample isotropically
		
		//First reoreint the stripping mask
		
		A = ((ParamVolume)spectre.getOutput().getFirstChildByName("Mask Volume")).getImageData();
		/*((ParamVolume)reorient.getInput().getFirstChildByName("Source")).setValue(orig);
		((ParamOption)reorient.getInput().getFirstChildByName("Interpolation")).setValue(2);
		((ParamOption)reorient.getInput().getFirstChildByName("Orientation")).setValue(0);
		((ParamOption)reorient.getInput().getFirstChildByName("Resolution")).setValue(0);
		reorient.runAlgorithm();
		orig.dispose();
		orig = ((ParamVolume)reorient.getOutput().getFirstChildByName("Reoriented Volume")).getImageData();
		orig= IsotropicResample.resample(orig, InterpolationMethod.WSINC);
		((ParamVolume)reorient.getInput().getFirstChildByName("Source")).setValue(A);
		((ParamOption)reorient.getInput().getFirstChildByName("Interpolation")).setValue(0);
		((ParamOption)reorient.getInput().getFirstChildByName("Resolution")).setValue(0);
		//((ParamVolume)reorient.getInput().getFirstChildByName("Target")).setValue(orig);
		reorient.runAlgorithm();
		A.dispose();
		A = ((ParamVolume)reorient.getOutput().getFirstChildByName("Reoriented Volume")).getImageData();
		A= IsotropicResample.resample(A, InterpolationMethod.NEAREST_NEIGHBOR);
	
		//make sure of the correspondence between the mask and the stripped image
		
		((ParamVolume)calculator.getInput().getFirstChildByName("Volume 1")).setValue(orig);
		((ParamVolume)calculator.getInput().getFirstChildByName("Volume 2")).setValue(A);
		calculator.runAlgorithm();
		orig.dispose();
		orig=((ParamVolume)calculator.getOutput().getFirstChildByName("Result Volume")).getImageData();
				
 		if (flair != null){
 			if (!doRegister.getValue()){
 				MedicAlgorithmFLIRT flirt = new MedicAlgorithmFLIRT();	
 				((ParamOption)flirt.getInput().getFirstChildByName("Degrees of freedom")).setValue(0);
 				((ParamOption)flirt.getInput().getFirstChildByName("Cost function")).setValue(3);
 				((ParamOption)flirt.getInput().getFirstChildByName("Output interpolation")).setValue(6);
 				((ParamVolume)flirt.getInput().getFirstChildByName("Source volume")).setValue(flairA);
 				((ParamVolume)flirt.getInput().getFirstChildByName("Target volume")).setValue(orig);
 				flirt.runAlgorithm();
 				flairA.dispose();
 				flairA=((ParamVolume)flirt.getOutput().getFirstChildByName("Registered Volume")).getImageData();
 			}else{
 				((ParamVolume)reorient.getInput().getFirstChildByName("Source")).setValue(flairA);
 				((ParamOption)reorient.getInput().getFirstChildByName("Interpolation")).setValue(2);
 				((ParamOption)reorient.getInput().getFirstChildByName("Orientation")).setValue(0);
 				((ParamOption)reorient.getInput().getFirstChildByName("Resolution")).setValue(0);
 				reorient.runAlgorithm();
 				flairA.dispose();
 				flairA = ((ParamVolume)reorient.getOutput().getFirstChildByName("Reoriented Volume")).getImageData();
 				flairA= IsotropicResample.resample(orig, InterpolationMethod.WSINC);
 			}
			for (int x=0; x<orig.getRows(); x++) for (int y=0; y<orig.getCols(); y++) for (int z=0; z<orig.getSlices(); z++){
				 if (orig.getFloat(x, y,z)<0)
					 orig.set(x,y,z,0);
				 if (flairA.getFloat(x, y,z)<0)
					 flairA.set(x,y,z,0);
			}
			flairA.setName(flair.getName()+"_spectre_stripped");
			spectrestripped_flair.setValue(vrw.write(flairA, dir));
		
 		}else{
 			//remove negative values due to the interpolation
 			for (int x=0; x<orig.getRows(); x++) for (int y=0; y<orig.getCols(); y++) for (int z=0; z<orig.getSlices(); z++) if (orig.getFloat(x, y,z)<0)
 				orig.set(x,y,z,0);
 		}*/
		if (flair!=null){
			for (int x=0; x<orig.getRows(); x++) for (int y=0; y<orig.getCols(); y++) for (int z=0; z<orig.getSlices(); z++){
				if (orig.getFloat(x, y,z)<0)
					orig.set(x,y,z,0);
				if (flairA.getFloat(x, y,z)<0)
					flairA.set(x,y,z,0);
			}
			flairA.setName(flair.getName()+"_spectre_stripped");
			spectrestripped_flair.setValue(vrw.write(flairA, dir));

		}else{
			//remove negative values due to the interpolation
			for (int x=0; x<orig.getRows(); x++) for (int y=0; y<orig.getCols(); y++) for (int z=0; z<orig.getSlices(); z++) if (orig.getFloat(x, y,z)<0)
				orig.set(x,y,z,0);
		}
		//save data
		orig.setName(name+"_spectre_stripped");
 		spectrestripped_t1.setValue(vrw.write(orig, dir));
 		A.setName(name+"_spectre_mask");
		spectremask.setValue(vrw.write(A, dir));
 		A.dispose();
 		
 		//Deleting the intermediate results
        deleteDir(intermOutputDir);
		
		if (mprage.getImageData() != null)
			((ParamVolume)atlasEM.getInput().getFirstChildByName("T1_MPRAGE Image")).setValue(orig);
		else
			((ParamVolume)atlasEM.getInput().getFirstChildByName("T1_SPGR Image")).setValue(orig);
		atlasEM.runAlgorithm(monitor);
		
		ImageData wmmask = ((ParamVolume)atlasEM.getOutput().getFirstChildByName("WM Mask")).getImageData();		
		ImageData gm = ((ParamVolume)atlasEM.getOutput().getFirstChildByName("Cortical GM Membership")).getImageData();
		ImageData wmfill = ((ParamVolume)atlasEM.getOutput().getFirstChildByName("Filled WM Membership")).getImageData();
				
		// clear unnecessary atlasEM results
		A = ((ParamVolume)atlasEM.getOutput().getFirstChildByName("Hard segmentation")).getImageData();
		A.setName(name+"_EM_seg");
		atlasEMseg.setValue(vrw.write(A , dirToads1));
		A.dispose();
/*		A = ((ParamVolume)atlasEM.getOutput().getFirstChildByName("Sulcal CSF Membership")).getImageData();
		A.setName(name+"_EMcsf");
		atlasEMcsf.setValue(vrw.write(A , dirToads1));
		A.dispose();*/
		
		wmfill.setName(name+"_EM_wmfill");
		atlasEMwmfill.setValue(vrw.write(wmfill , dirToads1));
		gm.setName(name+"_EM_gm");
		atlasEMgm.setValue(vrw.write(gm , dirToads1));
		wmmask.setName(name+"_EM_wmmask");
		atlasEMmask.setValue(vrw.write(wmmask , dirToads1));
		
		
		((ParamVolume)rmDura.getInput().getFirstChildByName("Original Volume")).setValue(orig);
		((ParamVolume)rmDura.getInput().getFirstChildByName("WM Volume")).setValue(wmfill);
		((ParamVolume)rmDura.getInput().getFirstChildByName("GM Volume")).setValue(gm);
		((ParamVolume)rmDura.getInput().getFirstChildByName("WM Mask")).setValue(wmmask);
		rmDura.runAlgorithm(monitor);
		
		//clear unnecessary rmDura results
		A = ((ParamVolume)rmDura.getOutput().getFirstChildByName("Brain Mask Level Set")).getImageData();
		A.dispose();
		/*A = ((ParamVolume)rmDura.getOutput().getFirstChildByName("Corrected WM Membership")).getImageData();
		A.dispose();
		A = ((ParamVolume)rmDura.getOutput().getFirstChildByName("Corrected GM Membership")).getImageData();
		A.dispose();*/
		
		//clear unnecessary Toads1 results
		/*A = ((ParamVolume)atlasEM.getOutput().getFirstChildByName("Cortical GM Membership")).getImageData();
		A.dispose();
		A = ((ParamVolume)atlasEM.getOutput().getFirstChildByName("Filled WM Membership")).getImageData();
		A.dispose();
		A = ((ParamVolume)atlasEM.getOutput().getFirstChildByName("WM mask")).getImageData();
		A.dispose();*/
		wmfill.dispose();
		gm.dispose();
		wmmask.dispose();
		
		A = ((ParamVolume)rmDura.getOutput().getFirstChildByName("Corrected Brain Mask")).getImageData();
		A.setName(name+"_duramask");
		duramask.setValue(vrw.write(A, dir));
		
		

		if (flairA !=null){
			((ParamVolume)calculator.getInput().getFirstChildByName("Volume 1")).setValue(flairA);
			((ParamVolume)calculator.getInput().getFirstChildByName("Volume 2")).setValue(A);
			calculator.runAlgorithm();
			flairA.dispose();
			flairA = ((ParamVolume)calculator.getOutput().getFirstChildByName("Result Volume")).getImageData();
			flairA.setName(flair.getName()+"_durastripped");
			durastripped_flair.setValue(vrw.write(flairA, dir));
		}
		A.dispose();	
		A = ((ParamVolume)rmDura.getOutput().getFirstChildByName("Stripped Volume")).getImageData();
		A.setName(name+"_durastripped");
		durastripped_t1.setValue(vrw.write(A, dir));
		
		if (mprage.getImageData()!=null)
			((ParamVolume)lToads.getInput().getFirstChildByName("T1_MPRAGE Image")).setValue(A);
		else
			((ParamVolume)lToads.getInput().getFirstChildByName("T1_SPGR Image")).setValue(A);
		if (flairA != null){
			
			((ParamVolume)lToads.getInput().getFirstChildByName("FLAIR Image")).setValue(flairA);
		}
	
		lToads.runAlgorithm(monitor);
		
		
		

		wmmask = ((ParamVolume)lToads.getOutput().getFirstChildByName("WM Mask")).getImageData();		
		gm = ((ParamVolume)lToads.getOutput().getFirstChildByName("Cortical GM Membership")).getImageData();
		wmfill = ((ParamVolume)lToads.getOutput().getFirstChildByName("Filled WM Membership")).getImageData();
		
		// clear unnecessary lToads results
		orig.dispose();
		A.dispose();
		A = ((ParamVolume)lToads.getOutput().getFirstChildByName("Hard segmentation")).getImageData();
		A.setName(name+"ltoads_seg");
		ltoadsseg.setValue(vrw.write(A , dirToads2));
		A.dispose();
		if (((ParamBoolean)lToads.getInput().getFirstChildByName("Output max membership classification")).getValue()){
			A = ((ParamVolume)lToads.getOutput().getFirstChildByName("Hard segmentationfrom memberships")).getImageData();
			A.setName(name+"_ltoads_maxmem");
			ltoadsmaxmem.setValue(vrw.write(A , dirToads2));
			A.dispose();
		}
		A = ((ParamVolume)lToads.getOutput().getFirstChildByName("Lesion Segmentation")).getImageData();
		A.setName(name+"_ltoads_lesion");
		ltoadslesion.setValue(vrw.write(A , dirToads2));
		A.dispose();	
		A = ((ParamVolume)lToads.getOutput().getFirstChildByName("Sulcal CSF Membership")).getImageData();
		A.setName(name+"_ltoads_csf");
		ltoadscsf.setValue(vrw.write(A , dirToads2));
		A.dispose();
		wmfill.setName(name+"_ltoads_wmfill");
		ltoadswmfill.setValue(vrw.write(wmfill , dirToads2));
		gm.setName(name+"_ltoads_gm");
		ltoadsgm.setValue(vrw.write(gm , dirToads2));
		wmmask.setName(name+"_ltoads_wmmask");
		ltoadsmask.setValue(vrw.write(wmmask , dirToads2));

		// writing rmDura volumes
//		ImageData B = ((ParamVolume)rmDura.getOutput().getFirstChildByName("Stripped Volume")).getImageData();
//		B.setName(name+"_durastripped");
//		FileUtil.updateFileInfo(gm.getModelImage(), B.getModelImage());
//		rmDuravol.setValue(B);
//		B.dispose();
//		B = ((ParamVolume)rmDura.getOutput().getFirstChildByName("Corrected Brain Mask")).getImageData();
//		B.setName(name+"_durastrippedmask");
//		FileUtil.updateFileInfo(gm.getModelImage(), B.getModelImage());
//		rmDuramask.setValue(B);
//		B.dispose();
		
		
		int rows=gm.getRows();
		int cols=gm.getCols();
		int slices=gm.getSlices();
		//Connectivity rule is reversed for topology correction!
		int bcon=0;
		int conn = ((ParamOption)lToads.getInput().getFirstChildByName("Connectivity (foreground,background)")).getIndex();
		switch(conn){
			case 0:bcon=1;break;
			case 1:bcon=0;break;
			case 2:bcon=3;break;
			case 3:bcon=2;break;
		}


		((ParamOption)topoCorrect.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).setValue(bcon);
		((ParamVolume)topoCorrect.getInput().getFirstChildByName("Volume")).setValue(wmfill);
		((ParamVolume)topoCorrect.getInput().getFirstChildByName("Paint mask")).setValue(wmmask);
		topoCorrect.runAlgorithm(monitor);


		ImageData mask = ((ParamVolume)topoCorrect.getOutput().getFirstChildByName("Topologically Correct Volume")).getImageData();
		wmmask.dispose();

		CubicVolumeCropper cropper = new CubicVolumeCropper();	
		gm = cropper.crop(gm, 0, 5);


		CropParameters crops = cropper.getLastCropParams();
		wmfill = cropper.crop(wmfill, crops);
		mask = cropper.crop(mask, crops);


		((ParamVolume)ace.getInput().getFirstChildByName("Gray Matter")).setValue(gm);
		((ParamVolume)ace.getInput().getFirstChildByName("White Matter")).setValue(wmfill);
		ace.runAlgorithm(monitor);


		A = ((ParamVolume)ace.getOutput().getFirstChildByName("Skeleton")).getImageData();
		A.dispose();
		ImageData thinnedcsf = ((ParamVolume)ace.getOutput().getFirstChildByName("Thinned Skeleton")).getImageData();
		ImageData enhancedgm = ((ParamVolume)ace.getOutput().getFirstChildByName("Enhanced GM")).getImageData();
		((ParamVolume)gvfCentral.getInput().getFirstChildByName("Volume")).setValue(enhancedgm);
		gvfCentral.runAlgorithm(monitor);


		ImageDataMipav gmvecfield = new ImageDataMipav(((ParamVolume)gvfCentral.getOutput().getFirstChildByName("Vector Field")).getImageData());
		
		

		((ParamOption)tgdm.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).setValue(conn);
		((ParamVolume)tgdm.getInput().getFirstChildByName("Initial Level Set")).setValue(mask);
		((ParamVolume)tgdm.getInput().getFirstChildByName("White Matter Membership")).setValue(wmfill);
		((ParamVolume)tgdm.getInput().getFirstChildByName("ACE Gray Matter Membership")).setValue(enhancedgm);	
		((ParamVolume)tgdm.getInput().getFirstChildByName("Gray Matter Membership")).setValue(gm);
		((ParamVolume)tgdm.getInput().getFirstChildByName(("Thinned ACE Skeleton"))).setValue(thinnedcsf);
		((ParamVolume)tgdm.getInput().getFirstChildByName(("Gradient Vector Field"))).setValue(gmvecfield);
		tgdm.runAlgorithm(monitor);

		//clear unnecessary LesionToads results
		A = ((ParamVolume)lToads.getOutput().getFirstChildByName("Cortical GM Membership")).getImageData();
		A.dispose();
		A = ((ParamVolume)lToads.getOutput().getFirstChildByName("Filled WM Membership")).getImageData();
		A.dispose();
		A = ((ParamVolume)lToads.getOutput().getFirstChildByName("WM Mask")).getImageData();
		A.dispose();
		
		// clear unnecessary TGDM results
		A = ((ParamVolume)tgdm.getOutput().getFirstChildByName("Signed Volume")).getImageData();
		A.dispose();
				
		EmbeddedSurface surf = ((ParamSurface)tgdm.getOutput().getFirstChildByName("Inner Surface")).getSurface();
		Point3f offset = new Point3f(crops.xmin, crops.ymin, crops.zmin);
		surf.translate(offset);
		surf.setName(name+"_TGDM_innerSurface");
//		uncroppedInnerSurf.setValue(srw.write(surf, dir));
//		surf.disposeAllTables();	
		uncroppedInnerSurf.setValue(surf);
//		uncroppedInnerSurf.getSurface().setName(name+"_TGDMinnerSurface");
		
		surf = ((ParamSurface)tgdm.getOutput().getFirstChildByName("Central Surface")).getSurface();
		surf.translate(offset);
		surf.setName(name+"_TGDM_centralSurface");
//		uncroppedCentralSurf.setValue(srw.write(surf, dir));
//		surf.disposeAllTables();
		uncroppedCentralSurf.setValue(surf);
//		uncroppedCentralSurf.getSurface().setName(name+"_TGDMcentralSurface");
		
		surf = ((ParamSurface)tgdm.getOutput().getFirstChildByName("Outer Surface")).getSurface();
		surf.translate(offset);
		surf.setName(name+"_TGDM_outerSurface");
//		uncroppedOuterSurf.setValue(srw.write(surf, dir));
//		surf.disposeAllTables();
		uncroppedOuterSurf.setValue(surf);
//		uncroppedOuterSurf.getSurface().setName(name+"_TGDMouterSurface");
		
		
		ImageDataMipav topo = new ImageDataMipav(mask);

		ImageDataMipav inner = new ImageDataMipav(((ParamVolume)tgdm.getOutput().getFirstChildByName("Inner Level Set")).getImageData());
		ImageDataMipav central = new ImageDataMipav(((ParamVolume)tgdm.getOutput().getFirstChildByName("Central Level Set")).getImageData());
		ImageDataMipav outer = new ImageDataMipav(((ParamVolume)tgdm.getOutput().getFirstChildByName("Outer Level Set")).getImageData());
//		ImageDataMipav signedvol=((ParamVolume)tgdm.getOutput().getFirstChildByName("Signed Volume")).getImageData();
		ImageDataMipav thinCSF = new ImageDataMipav(((ParamVolume)ace.getOutput().getFirstChildByName("Thinned Skeleton")).getImageData());
		ImageDataMipav gvf = new ImageDataMipav(((ParamVolume)gvfCentral.getOutput().getFirstChildByName("Vector Field")).getImageData());
		Point3i d = new Point3i(crops.getCroppedRows(),crops.getCroppedCols(),crops.getCroppedSlices());
		Point3i off = new Point3i(crops.xmin,crops.ymin,crops.zmin);
		CropParameters uncrop = new CropParameters(rows,cols,slices,1,off.x,d.x+off.x-1,off.y,d.y+off.y-1,off.z,d.z+off.z-1,20);
		CropParameters uncrop2=new CropParameters(rows,cols,slices,1,off.x,d.x+off.x-1,off.y,d.y+off.y-1,off.z,d.z+off.z-1,0);
		CropParameters uncrop3=new CropParameters(rows,cols,slices,3,off.x,d.x+off.x-1,off.y,d.y+off.y-1,off.z,d.z+off.z-1,0);

		A = cropper.uncrop(inner,uncrop);
		A.setName(name + "_TGDM_innerlevelset");
		uncroppedInner.setValue(A);
		//uncroppedInner.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		uncroppedInner.getImageData().setHeader(gm.getHeader());
		
		A = cropper.uncrop(central,uncrop);
		A.setName(name + "_TGDM_centrallevelset");
		uncroppedCentral.setValue(A);
		//uncroppedCentral.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		uncroppedCentral.getImageData().setHeader(gm.getHeader());
		
		A = cropper.uncrop(outer,uncrop);
		A.setName(name + "_TGDM_outerlevelset");
		uncroppedOuter.setValue(A);
		//uncroppedOuter.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		uncroppedOuter.getImageData().setHeader(gm.getHeader());
		
		
		A = cropper.uncrop(topo,uncrop2);
		A.setName(name + "_topologycorrected");
		uncroppedTopo.setValue(A);
		//uncroppedTopo.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		uncroppedTopo.getImageData().setHeader(gm.getHeader());
		
		
		A = cropper.uncrop(enhancedgm,uncrop2);
		A.setName(name + "_ACE_enhancedGM");
		uncroppedEnhancedGM.setValue(A);
		//uncroppedEnhancedGM.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		uncroppedEnhancedGM.getImageData().setHeader(gm.getHeader());
/*
		A = cropper.uncrop(skel,uncrop2);
		A.setName(gmname + "_CSFskeleton");
		ucSkel.setValue(A);
		ucSkel.getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
*/
		A = cropper.uncrop(thinCSF,uncrop2);
		A.setName(name + "_thinnedCSFskeleton");
		uncroppedthinCSF.setValue(A);
		uncroppedthinCSF.getImageData().setHeader(gm.getHeader());
		
		
		ImageData B = cropper.uncrop(gvf, uncrop3);
		//FileUtil.updateFileInfo(gm.getModelImageCopy(), B.getModelImageCopy());
		B.setHeader(gm.getHeader());
		B.setName(name+"_gradientvectorfield");
		uncroppedGvf.setValue(B);
		
		
		((ParamVolume)thickness.getInput().getFirstChildByName("Inner Level Set")).setValue(inner);
		((ParamVolume)thickness.getInput().getFirstChildByName("Outer Level Set")).setValue(outer);
		thickness.runAlgorithm(monitor);


		MedicAlgorithmImageMath image_math = new MedicAlgorithmImageMath();
		((ParamVolume)image_math.getInput().getFirstChildByName("Volume")).setValue(new ImageDataMipav(((ParamVolume)thickness.getOutput().getFirstChildByName("Thickness Volume")).getImageData()));
		((ParamOption)image_math.getInput().getFirstChildByName("Operation")).setValue(3);
		((ParamDouble)image_math.getInput().getFirstChildByName("Value")).setValue(t1.getHeader().getDimResolutions()[0]);
		image_math.runAlgorithm(monitor);
		ImageDataMipav thickvol = new ImageDataMipav(((ParamVolume)image_math.getOutput().getFirstChildByName("Result Volume")).getImageData());
		A = cropper.uncrop(thickvol,uncrop2);
		A.setName(name + "_thickness_Vol");
		ucthickvol.setValue(A);
		//ucthickvol.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		ucthickvol.getImageData().setHeader(t1.getHeader());
		
		ImageDataMipav thicklevset=new ImageDataMipav(((ParamVolume)thickness.getOutput().getFirstChildByName("Level Set")).getImageData());
		A = cropper.uncrop(thicklevset,uncrop2);
		A.setName(name + "_thickness_levset");
		ucthicklevset.setValue(A);
		//ucthicklevset.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		ucthicklevset.getImageData().setHeader(t1.getHeader());
		
		//mapping thickness on central surface
		MedicAlgorithmIsoLevelSurfaceLandmarks thickness_mapper = new MedicAlgorithmIsoLevelSurfaceLandmarks();
		((ParamSurface) thickness_mapper.getInput().getFirstChildByName("Surface")).setValue(uncroppedCentralSurf.getSurface());
		((ParamVolume) thickness_mapper.getInput().getFirstChildByName("Iso-Level Volume")).setValue(ucthickvol.getImageData());
		thickness_mapper.runAlgorithm();
		thicknessSurface.setValue(((ParamSurface) thickness_mapper.getOutput().getFirstChildByName("Iso-Level Surface")).getSurface());
		thicknessSurface.getSurface().setName(name+"_thicknessMap");
		
		//computing thickness statistics
		MedicAlgorithmSurfaceStatistics thickness_stat = new MedicAlgorithmSurfaceStatistics();
		((ParamSurface)thickness_stat.getInput().getFirstChildByName("Embedded Surface")).setValue(thicknessSurface.getSurface());
		((ParamString)thickness_stat.getInput().getFirstChildByName("Statisitics File Name")).setValue(this.getOutputDirectory().toString()+File.separator+edu.jhu.ece.iacl.jist.utility.FileUtil.forceSafeFilename(this.getAlgorithmName())+File.separator+name+"_thickness_stat.csv");
		thickness_stat.runAlgorithm();
		meanThickness.setValue(((ParamDouble)thickness_stat.getOutput().getFirstChildByName("Mean")).getValue());
		stdThickness.setValue(((ParamDouble)thickness_stat.getOutput().getFirstChildByName("Std. Dev.")).getValue());
		medianThickness.setValue(((ParamDouble)thickness_stat.getOutput().getFirstChildByName("Median")).getValue());
	}
	
	private static boolean deleteDir(File dir) {
	    if (dir.isDirectory()) {
	        String[] children = dir.list();
	        for (int i=0; i<children.length; i++) {
	            boolean success = deleteDir(new File(dir, children[i]));
	            if (!success) {
	                return false;
	            }
	        }
	    }

	    
	    return dir.delete();
	}
}
