package edu.vanderbilt.masi.plugins.CRUISE.testing;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;

import edu.jhmi.rad.medic.utilities.CropParameters;
import edu.jhmi.rad.medic.utilities.CubicVolumeCropper;
import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.ReferencedPapers;
import edu.jhu.ece.iacl.jist.io.ImageDataReaderWriter;
import edu.jhu.ece.iacl.jist.io.FileExtensionFilter;
import edu.jhu.ece.iacl.jist.io.SurfaceVtkReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.plugins.classification.MedicAlgorithmToads08;
import edu.jhu.ece.iacl.plugins.classification.MedicAlgorithmN3;
import edu.jhu.ece.iacl.plugins.measure.thickness.MedicAlgorithmThickness;
import edu.jhu.ece.iacl.plugins.segmentation.cruise.MedicAlgorithmAnatomicallyConsistentEnhance;
import edu.jhu.ece.iacl.plugins.segmentation.cruise.MedicAlgorithmGradVecFlow;
import edu.jhu.ece.iacl.plugins.segmentation.gdm.MedicAlgorithmNestedTGDM;
import edu.jhu.ece.iacl.plugins.topology.MedicAlgorithmTopologyCorrection;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.VoxelType;
import edu.jhu.ece.iacl.plugins.segmentation.skull_strip.MedicAlgorithmSPECTRE2010;
import edu.jhu.ece.iacl.plugins.segmentation.skull_strip.MedicAlgorithmRemoveDura09;

public class LongCRUISE_testing extends ProcessingAlgorithm{
	MedicAlgorithmN3 n3;
	MedicAlgorithmToads08 toads,toads2;
	MedicAlgorithmSPECTRE2010 spectre;
	MedicAlgorithmAnatomicallyConsistentEnhance ace;
	MedicAlgorithmNestedTGDM tgdm;
	MedicAlgorithmGradVecFlow gvfCentral;
	MedicAlgorithmTopologyCorrection topoCorrect;
	MedicAlgorithmRemoveDura09 rmDura;
//	MedicAlgorithmSmoothSurface smooth;
	MedicAlgorithmThickness  thickness;
//	MedicAlgorithmOrientSurface orient;
	ParamPointInteger offset;
	ParamPointInteger dim;
	ParamCollection cropParams;
	ParamWeightedVolumeCollection<String> inputImages;
	int rows = 0, cols = 0, slices = 0;
	ParamVolume ucthickvol, ucthicklevset,
		uncroppedthinCSF, uncroppedTopo, uncroppedGvf, croppedGM,
		croppedWM, croppedInitWM, uncroppedInner, uncroppedCentral,
		uncroppedOuter, uncroppedEnhancedGM, ucSignedVol, ucSkel,
		rmDuravol, rmDuramask;
	ParamSurface uncroppedInnerSurf, uncroppedCentralSurf, uncroppedOuterSurf;
//	ParamFile uncroppedInnerSurf, uncroppedCentralSurf, uncroppedOuterSurf;
	ParamFile n3img, n3field,spectrestripped, spectremask,
	toads1seg, toads1memb,toads1wmfill, toads1mask, toads1gm,toads1csf,
	toads2seg, toads2memb, toads2wmfill, toads2mask, toads2gm, toads2csf;

	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	
	private static final ImageDataReaderWriter vrw = ImageDataReaderWriter.getInstance();
	private static final SurfaceVtkReaderWriter srw = SurfaceVtkReaderWriter.getInstance();
	
	private static final FileExtensionFilter volumeFileExts = vrw.getExtensionFilter();
	private static final FileExtensionFilter surfaceFileExts = srw.getExtensionFilter();
	
	protected void createInputParameters(ParamCollection inputParams) {
		setPreferredSize(new Dimension(800, 500));
		n3 = new MedicAlgorithmN3();
		gvfCentral = new MedicAlgorithmGradVecFlow();
		gvfCentral.getInput().getFirstChildByName("Volume").setHidden(true);
		
		spectre = new MedicAlgorithmSPECTRE2010();
		spectre.getInput().getFirstChildByName("Input Volume").setHidden(true);
		spectre.getInput().getFirstChildByName("Image modality").setHidden(true);
		spectre.getInput().getFirstChildByName("Output in Original Image Space").setHidden(true);
		spectre.getInput().getFirstChildByName("FANTASM").setHidden(true);
		spectre.getInput().getFirstChildByName("MSP").setHidden(true);
		spectre.getInput().getFirstChildByName("Find Midsaggital Plane").setHidden(true);
		spectre.getInput().getFirstChildByName("Resample data to Isotropic voxels").setHidden(true);
		spectre.getInput().getFirstChildByName("Run Smooth Brain Mask").setHidden(true);
		((ParamOption)spectre.getInput().getFirstChildByName("Image modality")).setValue(2); //always choose T1_MPRAGE for Spectre
		((ParamBoolean)spectre.getInput().getFirstChildByName("Inhomogeneity Correction")).setValue(false); // N3 does correction so set FANTASM option to false.
		((ParamBoolean)spectre.getInput().getFirstChildByName("Resample data to Isotropic voxels")).setValue(true);
		((ParamBoolean)spectre.getInput().getFirstChildByName("Find Midsaggital Plane")).setValue(false);
				
		rmDura = new MedicAlgorithmRemoveDura09();
		rmDura.getInput().getFirstChildByName("Original Volume").setHidden(true);
		rmDura.getInput().getFirstChildByName("WM Volume").setHidden(true);
		rmDura.getInput().getFirstChildByName("GM Volume").setHidden(true);
		rmDura.getInput().getFirstChildByName("WM Mask").setHidden(true);
		rmDura.getInput().getFirstChildByName("Data").setHidden(true);
		
		
		toads = new MedicAlgorithmToads08();
		toads.getInput().setName("toads1");
		toads.getInput().setLabel("TOADS");
		toads.getInput().getFirstChildByName("Image to segment").setHidden(true);
		toads.getInput().getFirstChildByName("Output images").setHidden(true);
		toads.getInput().getFirstChildByName("Output inhomogeniety filed").setHidden(true);
		toads.getInput().getFirstChildByName("Correct inhomogeneity").setHidden(true);
		toads.getInput().getFirstChildByName("Output max membership classification").setHidden(true);
		((ParamOption)toads.getInput().getFirstChildByName("Output images")).setValue(3); //output should be dura removal inputs

		/*
		 * N3 does the Inhomogeneity Correction.
		 */
		//((ParamBoolean)toads.getInput().getFirstChildByName("Correct inhomogeneity")).setHidden(true);
		//((ParamBoolean)toads.getInput().getFirstChildByName("Correct inhomogeneity")).setValue(false);
		/*((ParamOption)toads.getInput().getFirstChildByName("Correction Method")).setHidden(true);
		((ParamInteger)toads.getInput().getFirstChildByName("Inhomogeneity field degree")).setHidden(true);*/

		
		toads2 = new MedicAlgorithmToads08();
		toads2.getInput().setName("toads2");
		toads2.getInput().setLabel("TOADS Second Pass");
		toads2.getInput().getFirstChildByName("Image to segment").setHidden(true);
		toads2.getInput().getFirstChildByName("Output images").setHidden(true);
		toads2.getInput().getFirstChildByName("Output inhomogeniety filed").setHidden(true);
		toads2.getInput().getFirstChildByName("Correct inhomogeneity").setHidden(true);
		toads2.getInput().getFirstChildByName("Image modality").setHidden(true);
		toads2.getInput().getFirstChildByName("Output max membership classification").setHidden(true);
		((ParamOption)toads2.getInput().getFirstChildByName("Output images")).setValue(2); //output should be cruise_input

		/*
		 * N3 does the Inhomogeneity Correction.
		 */
		//((ParamBoolean)toads2.getInput().getFirstChildByName("Correct inhomogeneity")).setHidden(true);
		//((ParamBoolean)toads2.getInput().getFirstChildByName("Correct inhomogeneity")).setValue(false);
		/*((ParamOption)toads2.getInput().getFirstChildByName("Correction Method")).setHidden(true);
		((ParamInteger)toads2.getInput().getFirstChildByName("Inhomogeneity field degree")).setHidden(true);*/
		
		
		thickness = new MedicAlgorithmThickness();
		thickness.getInput().getFirstChildByName("Inner Level Set").setHidden(true);
		thickness.getInput().getFirstChildByName("Outer Level Set").setHidden(true);
		((ParamOption)thickness.getInput().getFirstChildByName("Approximation Method")).setValue("Level Set Subtraction");
		thickness.getInput().getFirstChildByName("Approximation Method").setHidden(true);
		thickness.getInput().getFirstChildByName("Lagrange Step Size").setHidden(true);
		
		topoCorrect = new MedicAlgorithmTopologyCorrection();
		topoCorrect.getInput().getFirstChildByName("Volume").setHidden(true);
		topoCorrect.getInput().getFirstChildByName("Paint mask").setHidden(true);
		topoCorrect.getInput().getFirstChildByName("Connectivity (Foreground,Background)").setHidden(true);
		ace=new MedicAlgorithmAnatomicallyConsistentEnhance();
		ace.getInput().getFirstChildByName("Gray Matter").setHidden(true);
		ace.getInput().getFirstChildByName("White Matter").setHidden(true);
		tgdm=new MedicAlgorithmNestedTGDM();
		tgdm.getInput().getFirstChildByName("Connectivity (Foreground,Background)").setHidden(true);
		tgdm.getInput().getFirstChildByName("Data").setHidden(true);
		tgdm.getInput().getFirstChildByName("Initial Level Set").setHidden(true);
		tgdm.getInput().getFirstChildByName("Initial Iso Level").setHidden(true);
		tgdm.getInput().getFirstChildByName("Initial Smoothing Curvature Force").setHidden(true);
		tgdm.getInput().getFirstChildByName("Iterations for Initial Smoothing").setHidden(true);
		

		inputParams.add(n3.getInput());
		inputParams.add(spectre.getInput());
		inputParams.add(toads.getInput());
		inputParams.add(rmDura.getInput());
		//inputParams.add(toads2.getInput());
		//inputParams.add(topoCorrect.getInput());
		inputParams.add(gvfCentral.getInput());

		inputParams.add(tgdm.getInput());
		inputParams.add(thickness.getInput());

		inputParams.setLabel("TOADS-CRUISE"); // Name Displayed in Module List
		inputParams.setName("ToadsCRUISE");   // Name displayed in Process Manager
		
		inputParams.setPackage("IACL");
		inputParams.setCategory("Segmentation.CRUISE");

		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.Release);

		info.add(ReferencedPapers.cruise);
		info.add(ReferencedPapers.ace);
		info.add(ReferencedPapers.tgdm);
		info.add(ReferencedPapers.gvf);
		info.add(PrinceGroupAuthors.xiaoHan);
		info.add(PrinceGroupAuthors.dzungPham);
		info.add(PrinceGroupAuthors.chenyangXu);
		info.add(PrinceGroupAuthors.duyguTosun);
		info.add(PrinceGroupAuthors.pierreLouisBazin);
    	info.add(PrinceGroupAuthors.blakeLucas);
    	info.setDescription("TOADS-CRUISE pipeline generating cortical surfaces and thickness statistics.");
    	info.setLongDescription("Full TOADS-CRUISE pipeline. It takes a 3D volume, does skull stripping by SPECTRE and cortical segmentation using TOADS. Then an Anatomically Consistent Enhancement (ACE) is done to remove partial voluming in the deep sulci. The surfaces are generated by a Topology Preserving Geoemtric Deformable Model (TGDM).");
    	info.setAdditionalDocURL("html/edu/jhu/ece/iacl/plugins/segmentation/cruise/MedicAlgorithmLongCRUISE/index.html");
	}

	protected void createOutputParameters(ParamCollection outputParams) {
		uncroppedTopo = new ParamVolume("Topologically Correct WM volume");		
		uncroppedEnhancedGM = new ParamVolume("ACE Enhanced GM");
		uncroppedthinCSF = new ParamVolume("ACE Thinned CSF Skeleton");
		uncroppedInner = new ParamVolume("TGDM Inner Level Set");
		uncroppedCentral = new ParamVolume("TGDM Central Level Set");
		uncroppedOuter = new ParamVolume("TGDM Outer Level Set");
		uncroppedInnerSurf = new ParamSurface("TGDM Inner Surface");
		uncroppedCentralSurf = new ParamSurface("TGDM Central Surface");
		uncroppedOuterSurf = new ParamSurface("TGDM Outer Surface");
//		uncroppedInnerSurf = new ParamFile("TGDM Inner Surface",surfaceFileExts);
//		uncroppedCentralSurf = new ParamFile("TGDM Central Surface",surfaceFileExts);
//		uncroppedOuterSurf = new ParamFile("TGDM Outer Surface",surfaceFileExts);
		ucthickvol = new ParamVolume("Thickness Volume");
		ucthicklevset = new ParamVolume("Thickness Level Set");
		uncroppedGvf = new ParamVolume("Gradient Vector Field",VoxelType.FLOAT,-1,-1,-1,3);

		n3img = new ParamFile("N3 Inhomogeneity Corrected Image", volumeFileExts);
		n3field = new ParamFile("N3 Inhomogeneity Field", volumeFileExts);
		toads1seg = new ParamFile("1st Toads Hard Segmentation", volumeFileExts);
		toads1memb = new ParamFile("1st Toads Membership", volumeFileExts);
		toads1csf = new ParamFile("1st Toads CSF Membership", volumeFileExts);
		toads1wmfill = new ParamFile("1st Toads Filled WM membership", volumeFileExts);
		toads1gm = new ParamFile("1st Toads GM Membership", volumeFileExts);
		toads1mask = new ParamFile("1st Toads WM Mask", volumeFileExts);
		
		toads2seg = new ParamFile("2nd Toads Hard Segmentation", volumeFileExts);
		toads2memb = new ParamFile("2nd Toads Membership", volumeFileExts);
		toads2csf = new ParamFile("2nd Toads CSF Membership", volumeFileExts);
		toads2wmfill = new ParamFile("2nd Toads Filled WM membership", volumeFileExts);
		toads2gm = new ParamFile("2nd Toads GM Membership", volumeFileExts);
		toads2mask = new ParamFile("2nd Toads WM Mask", volumeFileExts);
		
		spectrestripped = new ParamFile("SPECTRE stripped original reoriented volume");
		spectremask = new ParamFile("Brainmask from SPECTRE");
		rmDuravol = new ParamVolume("Dura Removed Volume");
		rmDuramask = new ParamVolume("Dura Removed Mask");
		
		
		toads.getOutput().getFirstChildByName("Thalamus Membership").setHidden(true);
		toads2.getOutput().getFirstChildByName("Thalamus Membership").setHidden(true);
		
				
		ParamCollection ToadsFirstPass = new ParamCollection("Toads1stPass");
		ParamCollection ToadsSecondPass = new ParamCollection("Toads2ndPass");
//		ParamCollection Spectre = new ParamCollection("SPECTRE");
//		ParamCollection N3 = new ParamCollection("N3");
//		N3.add(n3img);
//		N3.add(n3field);
//		ParamCollection RMDura = new ParamCollection("DuraRemoval");
		ToadsFirstPass.add(toads1seg);	
		ToadsFirstPass.add(toads1csf);
		ToadsFirstPass.add(toads1gm);
		ToadsFirstPass.add(toads1wmfill);
		ToadsFirstPass.add(toads1mask);
		ToadsSecondPass.add(toads2seg);
		ToadsFirstPass.add(toads2csf);
		ToadsSecondPass.add(toads2gm);
		ToadsSecondPass.add(toads2wmfill);
		ToadsSecondPass.add(toads2mask);
		
//		ToadsFirstPass.add(toads.getOutput());
//		ToadsSecondPass.add(toads2.getOutput());
//		Spectre.add(spectrestripped);
//		Spectre.add(spectremask);
//		RMDura.add(rmDuravol);
//		RMDura.add(rmDuramask);

//		outputParams.add(N3);
		outputParams.add(ToadsFirstPass);
		outputParams.add(ToadsSecondPass);
//		outputParams.add(Spectre);
//		outputParams.add(RMDura);
		outputParams.add(uncroppedTopo);	
		outputParams.add(uncroppedEnhancedGM);
		outputParams.add(uncroppedthinCSF);
		outputParams.add(uncroppedInner);
		outputParams.add(uncroppedCentral);
		outputParams.add(uncroppedOuter);
		outputParams.add(uncroppedInnerSurf);
		outputParams.add(uncroppedCentralSurf);
		outputParams.add(uncroppedOuterSurf);
		outputParams.add(ucthickvol);
		outputParams.add(ucthicklevset);
		outputParams.add(uncroppedGvf);
		
		outputParams.setLabel("TOADS-CRUISE"); // Name Displayed in Module List
		outputParams.setName("TOADS-CRUISE");   // Name displayed in Process Manager
	}


	@Override
	protected void execute(CalculationMonitor monitor) {
		
		//set the output directory and create it if it doesn't exist
		File dir = new File(this.getOutputDirectory()+File.separator+edu.jhu.ece.iacl.jist.utility.FileUtil.forceSafeFilename(this.getAlgorithmName()));
		try{
			if(!dir.isDirectory()){
				(new File(dir.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }
		String dir1 = dir + "/Toads1stPass/";
		File dirToads1 = new File(dir1);
		try{
			if(!dirToads1.isDirectory()){
				(new File(dirToads1.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }
		dir1 = dir + "/Toads2ndPass/";
		File dirToads2 = new File(dir1);
		try{
			if(!dirToads2.isDirectory()){
				(new File(dirToads2.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }
		//yk add to save the results
		String dir_tgdm_input = dir + "/Inputfiles_tgdm/";
		File dir_tgdm= new File(dir_tgdm_input);
		try{
			if(!dir_tgdm.isDirectory()){
				(new File(dir_tgdm.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }
		
		ImageData A, orig;
		
		// yk test
//		ImageData A_test;
//		A_test = ((ParamVolume)n3.getInput().getFirstChildByName("Input Volume")).getImageData();
//		CubicVolumeCropper_yk cropper_yk = new CubicVolumeCropper_yk();	
//		A_test = cropper_yk.crop(A_test, 0, 5);
//		A_test.dispose();
//		 

		n3.runAlgorithm(monitor);
		orig = ((ParamVolume)n3.getOutput().getFirstChildByName("Inhomogeneity Corrected Volume")).getImageData();
		String name = orig.getName();
		
		n3img.setValue(vrw.write(orig, dir));
		n3field.setValue(vrw.write(((ParamVolume)n3.getOutput().getFirstChildByName("Inhomogeneity Field")).getImageData(), dir));
		
		((ParamVolume)spectre.getInput().getFirstChildByName("Input Volume")).setValue(orig);
		A = ((ParamVolume)n3.getOutput().getFirstChildByName("Inhomogeneity Field")).getImageData();

		
		spectre.runAlgorithm(monitor);
		//clear memory pointed to by orig (N3 corrected volume)
		orig.dispose();
		A = ((ParamVolume)spectre.getOutput().getFirstChildByName("Prior Volume")).getImageData();
		A.dispose();
		A = ((ParamVolume)spectre.getOutput().getFirstChildByName("FANTASM Segmentation")).getImageData();
		A.dispose();
		A = ((ParamVolume)spectre.getOutput().getFirstChildByName("d0")).getImageData();
		A.dispose();
		orig = ((ParamVolume)spectre.getOutput().getFirstChildByName("Original or Reoriented Volume")).getImageData();

		A = ((ParamVolume)spectre.getOutput().getFirstChildByName("Mask Volume")).getImageData();
 		A.setName(name+"_spectremask");
		spectremask.setValue(vrw.write(A, dir));
		A.dispose();
		A = ((ParamVolume)spectre.getOutput().getFirstChildByName("Stripped Volume")).getImageData();
		A.setName(name+"_spectrestripped");
 		spectrestripped.setValue(vrw.write(A, dir));
		
		
		((ParamVolume)toads.getInput().getFirstChildByName("Image to segment")).setValue(A);
		int conn = ((ParamOption)toads.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).getIndex();
		toads.runAlgorithm(monitor);
		

		ImageData wmmask = ((ParamVolume)toads.getOutput().getFirstChildByName("WM mask")).getImageData();		
		ImageData gm = ((ParamVolume)toads.getOutput().getFirstChildByName("Cortical GM Membership")).getImageData();
		ImageData wmfill = ((ParamVolume)toads.getOutput().getFirstChildByName("Filled WM Membership")).getImageData();
		
		A.dispose();
		// clear unnecessary toads1 results
		A = ((ParamVolume)toads.getOutput().getFirstChildByName("Hard segmentation")).getImageData();
		A.setName(name+"_toads1seg");
		toads1seg.setValue(vrw.write(A , dirToads1));
		A.dispose();
		A = ((ParamVolume)toads.getOutput().getFirstChildByName("Sulcal CSF Membership")).getImageData();
		A.setName(name+"_toads1csf");
		toads1csf.setValue(vrw.write(A , dirToads1));
		A.dispose();
		
		wmfill.setName(name+"_toads1wmfill");
		toads1wmfill.setValue(vrw.write(wmfill , dirToads1));
		gm.setName(name+"_toads1gm");
		toads1gm.setValue(vrw.write(gm , dirToads1));
		wmmask.setName(name+"_toads1wmmask");
		toads1mask.setValue(vrw.write(wmmask , dirToads1));
		
		
		((ParamVolume)rmDura.getInput().getFirstChildByName("Original Volume")).setValue(orig);
		((ParamVolume)rmDura.getInput().getFirstChildByName("WM Volume")).setValue(wmfill);
		((ParamVolume)rmDura.getInput().getFirstChildByName("GM Volume")).setValue(gm);
		((ParamVolume)rmDura.getInput().getFirstChildByName("WM Mask")).setValue(wmmask);
		rmDura.runAlgorithm(monitor);
		
		//clear unnecessary rmDura results
		A = ((ParamVolume)rmDura.getOutput().getFirstChildByName("Brain Mask Level Set")).getImageData();
		A.dispose();
		/*A = ((ParamVolume)rmDura.getOutput().getFirstChildByName("Corrected WM Membership")).getImageData();
		A.dispose();
		A = ((ParamVolume)rmDura.getOutput().getFirstChildByName("Corrected GM Membership")).getImageData();
		A.dispose();*/
		
		//clear unnecessary Toads1 results
		A = ((ParamVolume)toads.getOutput().getFirstChildByName("Cortical GM Membership")).getImageData();
		A.dispose();
		A = ((ParamVolume)toads.getOutput().getFirstChildByName("Filled WM Membership")).getImageData();
		A.dispose();
		A = ((ParamVolume)toads.getOutput().getFirstChildByName("WM mask")).getImageData();
		A.dispose();
		
		A = ((ParamVolume)rmDura.getOutput().getFirstChildByName("Corrected Brain Mask")).getImageData();
		A.setName(name+"_duramask");
		rmDuramask.setValue(vrw.write(A, dir));
		A.dispose();
		A = ((ParamVolume)rmDura.getOutput().getFirstChildByName("Stripped Volume")).getImageData();
		A.setName(name+"_durastripped");
 		rmDuravol.setValue(vrw.write(A, dir));
		int imagemodal = ((ParamOption)toads.getInput().getFirstChildByName("Image modality")).getIndex();
		((ParamOption)toads2.getInput().getFirstChildByName("Image modality")).setValue(imagemodal);
		((ParamVolume)toads2.getInput().getFirstChildByName("Image to segment")).setValue(A);
		
		((ParamDouble)toads2.getInput().getFirstChildByName("Smooting parameter")).setValue(
				((ParamDouble)toads.getInput().getFirstChildByName("Smooting parameter")).getValue());
		((ParamInteger)toads2.getInput().getFirstChildByName("Maximum iterations")).setValue(
				((ParamInteger)toads.getInput().getFirstChildByName("Maximum iterations")).getValue());
		((ParamDouble)toads2.getInput().getFirstChildByName("Maximum difference")).setValue(
				((ParamDouble)toads.getInput().getFirstChildByName("Maximum difference")).getValue());
		((ParamDouble)toads2.getInput().getFirstChildByName("Atlas prior")).setValue(
				((ParamDouble)toads.getInput().getFirstChildByName("Atlas prior")).getValue());
		((ParamFile)toads2.getInput().getFirstChildByName("Atlas file")).setValue(
				((ParamFile)toads.getInput().getFirstChildByName("Atlas file")).getValue());
		String connectivity = ((ParamOption)toads.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).getValue();
		((ParamOption)toads.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).setValue(connectivity);
		
		toads2.runAlgorithm(monitor);
		
		wmmask = ((ParamVolume)toads2.getOutput().getFirstChildByName("WM mask")).getImageData();		
		gm = ((ParamVolume)toads2.getOutput().getFirstChildByName("Cortical GM Membership")).getImageData();
		wmfill = ((ParamVolume)toads2.getOutput().getFirstChildByName("Filled WM Membership")).getImageData();
		
		// clear unnecessary toads2 results
		
		A = ((ParamVolume)toads2.getOutput().getFirstChildByName("Hard segmentation")).getImageData();
		A.setName(name+"toads2seg");
		toads2seg.setValue(vrw.write(A , dirToads2));
		A.dispose();
		A = ((ParamVolume)toads2.getOutput().getFirstChildByName("Sulcal CSF Membership")).getImageData();
		A.setName(name+"_toads2csf");
		toads2csf.setValue(vrw.write(A , dirToads2));
		A.dispose();
		wmfill.setName(name+"_toads2wmfill");
		toads2wmfill.setValue(vrw.write(wmfill , dirToads2));
		gm.setName(name+"_toads2gm");
		toads2gm.setValue(vrw.write(gm , dirToads2));
		wmmask.setName(name+"_toads2wmmask");
		toads2mask.setValue(vrw.write(wmmask , dirToads2));

		// writing rmDura volumes
//		ImageData B = ((ParamVolume)rmDura.getOutput().getFirstChildByName("Stripped Volume")).getImageData();
//		B.setName(name+"_durastripped");
//		FileUtil.updateFileInfo(gm.getModelImage(), B.getModelImage());
//		rmDuravol.setValue(B);
//		B.dispose();
//		B = ((ParamVolume)rmDura.getOutput().getFirstChildByName("Corrected Brain Mask")).getImageData();
//		B.setName(name+"_durastrippedmask");
//		FileUtil.updateFileInfo(gm.getModelImage(), B.getModelImage());
//		rmDuramask.setValue(B);
//		B.dispose();
		
		
		int rows=gm.getRows();
		int cols=gm.getCols();
		int slices=gm.getSlices();
		//Connectivity rule is reversed for topology correction!
		int bcon=0;
		switch(conn){
			case 0:bcon=1;break;
			case 1:bcon=0;break;
			case 2:bcon=3;break;
			case 3:bcon=2;break;
		}


		((ParamOption)topoCorrect.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).setValue(bcon);
		((ParamVolume)topoCorrect.getInput().getFirstChildByName("Volume")).setValue(wmfill);
		((ParamVolume)topoCorrect.getInput().getFirstChildByName("Paint mask")).setValue(wmmask);
		topoCorrect.runAlgorithm(monitor);


		ImageData mask = ((ParamVolume)topoCorrect.getOutput().getFirstChildByName("Topologically Correct Volume")).getImageData();
		wmmask.dispose();

		CubicVolumeCropper cropper = new CubicVolumeCropper();	
		gm = cropper.crop(gm, 0, 5); //enlarge (crop) the image by 5 voxels


		CropParameters crops = cropper.getLastCropParams();
		wmfill = cropper.crop(wmfill, crops);
		mask = cropper.crop(mask, crops);


		((ParamVolume)ace.getInput().getFirstChildByName("Gray Matter")).setValue(gm);
		((ParamVolume)ace.getInput().getFirstChildByName("White Matter")).setValue(wmfill);
		ace.runAlgorithm(monitor);


		A = ((ParamVolume)ace.getOutput().getFirstChildByName("Skeleton")).getImageData();
		A.dispose();
		ImageData thinnedcsf = ((ParamVolume)ace.getOutput().getFirstChildByName("Thinned Skeleton")).getImageData();
		ImageData enhancedgm = ((ParamVolume)ace.getOutput().getFirstChildByName("Enhanced GM")).getImageData();
		((ParamVolume)gvfCentral.getInput().getFirstChildByName("Volume")).setValue(enhancedgm);
		gvfCentral.runAlgorithm(monitor);


		ImageDataMipav gmvecfield = new ImageDataMipav(((ParamVolume)gvfCentral.getOutput().getFirstChildByName("Vector Field")).getImageData());
		
		// yk add to debug the tgdm part
		ParamFile tgdminput = new ParamVolume("tgdm input");
		
		mask.setName(name+"_tgdmmask");
		tgdminput.setValue(vrw.write(mask, dir_tgdm));
		
		wmfill.setName(name+"_tgdmwmfill");
		tgdminput.setValue(vrw.write(wmfill, dir_tgdm));
		
		enhancedgm.setName(name+"_tgdmenhancedgm");
		tgdminput.setValue(vrw.write(enhancedgm, dir_tgdm));
		
		gm.setName(name+"_tgdmgm");
		tgdminput.setValue(vrw.write(gm, dir_tgdm));
		
		thinnedcsf.setName(name+"_tgdmthinnedcsf");
		tgdminput.setValue(vrw.write(thinnedcsf, dir_tgdm));
		
		gmvecfield.setName(name+"_tgdmgmvecfield");
		tgdminput.setValue(vrw.write(gmvecfield, dir_tgdm));

		((ParamOption)tgdm.getInput().getFirstChildByName("Connectivity (Foreground,Background)")).setValue(conn);
		((ParamVolume)tgdm.getInput().getFirstChildByName("Initial Level Set")).setValue(mask);
		((ParamVolume)tgdm.getInput().getFirstChildByName("White Matter Membership")).setValue(wmfill);
		((ParamVolume)tgdm.getInput().getFirstChildByName("ACE Gray Matter Membership")).setValue(enhancedgm);	
		((ParamVolume)tgdm.getInput().getFirstChildByName("Gray Matter Membership")).setValue(gm);
		((ParamVolume)tgdm.getInput().getFirstChildByName(("Thinned ACE Skeleton"))).setValue(thinnedcsf);
		((ParamVolume)tgdm.getInput().getFirstChildByName(("Gradient Vector Field"))).setValue(gmvecfield);
		tgdm.runAlgorithm(monitor);

		//clear unnecessary Toads2 results
		A = ((ParamVolume)toads2.getOutput().getFirstChildByName("Cortical GM Membership")).getImageData();
		A.dispose();
		A = ((ParamVolume)toads2.getOutput().getFirstChildByName("Filled WM Membership")).getImageData();
		A.dispose();
		A = ((ParamVolume)toads2.getOutput().getFirstChildByName("WM mask")).getImageData();
		A.dispose();
		
		// clear unnecessary TGDM results
		A = ((ParamVolume)tgdm.getOutput().getFirstChildByName("Signed Volume")).getImageData();
		A.dispose();
				
		EmbeddedSurface surf = ((ParamSurface)tgdm.getOutput().getFirstChildByName("Inner Surface")).getSurface();
		Point3f offset = new Point3f(crops.xmin, crops.ymin, crops.zmin);
		surf.translate(offset);
		surf.setName(name+"_TGDMinnerSurface");
//		uncroppedInnerSurf.setValue(srw.write(surf, dir));
//		surf.disposeAllTables();	
		uncroppedInnerSurf.setValue(surf);
//		uncroppedInnerSurf.getSurface().setName(name+"_TGDMinnerSurface");
		
		surf = ((ParamSurface)tgdm.getOutput().getFirstChildByName("Central Surface")).getSurface();
		surf.translate(offset);
		surf.setName(name+"_TGDMcentralSurface");
//		uncroppedCentralSurf.setValue(srw.write(surf, dir));
//		surf.disposeAllTablegms();
		uncroppedCentralSurf.setValue(surf);
//		uncroppedCentralSurf.getSurface().setName(name+"_TGDMcentralSurface");
		
		surf = ((ParamSurface)tgdm.getOutput().getFirstChildByName("Outer Surface")).getSurface();
		surf.translate(offset);
		surf.setName(name+"_TGDMouterSurface");
//		uncroppedOuterSurf.setValue(srw.write(surf, dir));
//		surf.disposeAllTables();
		uncroppedOuterSurf.setValue(surf);
//		uncroppedOuterSurf.getSurface().setName(name+"_TGDMouterSurface");
		
		
		ImageDataMipav topo = new ImageDataMipav(mask);

		ImageDataMipav inner = new ImageDataMipav(((ParamVolume)tgdm.getOutput().getFirstChildByName("Inner Level Set")).getImageData());
		ImageDataMipav central = new ImageDataMipav(((ParamVolume)tgdm.getOutput().getFirstChildByName("Central Level Set")).getImageData());
		ImageDataMipav outer = new ImageDataMipav(((ParamVolume)tgdm.getOutput().getFirstChildByName("Outer Level Set")).getImageData());
//		ImageDataMipav signedvol=((ParamVolume)tgdm.getOutput().getFirstChildByName("Signed Volume")).getImageData();
		ImageDataMipav thinCSF = new ImageDataMipav(((ParamVolume)ace.getOutput().getFirstChildByName("Thinned Skeleton")).getImageData());
		ImageDataMipav gvf = new ImageDataMipav(((ParamVolume)gvfCentral.getOutput().getFirstChildByName("Vector Field")).getImageData());
		Point3i d = new Point3i(crops.getCroppedRows(),crops.getCroppedCols(),crops.getCroppedSlices());
		Point3i off = new Point3i(crops.xmin,crops.ymin,crops.zmin);
		CropParameters uncrop = new CropParameters(rows,cols,slices,1,off.x,d.x+off.x-1,off.y,d.y+off.y-1,off.z,d.z+off.z-1,20);
		CropParameters uncrop2=new CropParameters(rows,cols,slices,1,off.x,d.x+off.x-1,off.y,d.y+off.y-1,off.z,d.z+off.z-1,0);
		CropParameters uncrop3=new CropParameters(rows,cols,slices,3,off.x,d.x+off.x-1,off.y,d.y+off.y-1,off.z,d.z+off.z-1,0);

		A = cropper.uncrop(inner,uncrop);
		A.setName(name + "_TGDMinnerlevelset");
		uncroppedInner.setValue(A);
		//uncroppedInner.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		uncroppedInner.getImageData().setHeader(gm.getHeader());
		
		A = cropper.uncrop(central,uncrop);
		A.setName(name + "_TGDMcentrallevelset");
		uncroppedCentral.setValue(A);
		//uncroppedCentral.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		uncroppedCentral.getImageData().setHeader(gm.getHeader());
		
		A = cropper.uncrop(outer,uncrop);
		A.setName(name + "_TGDMouterlevelset");
		uncroppedOuter.setValue(A);
		//uncroppedOuter.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		uncroppedOuter.getImageData().setHeader(gm.getHeader());
		
		
		A = cropper.uncrop(topo,uncrop2);
		A.setName(name + "_topologycorrected");
		uncroppedTopo.setValue(A);
		//uncroppedTopo.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		uncroppedTopo.getImageData().setHeader(gm.getHeader());
		
		
		A = cropper.uncrop(enhancedgm,uncrop2);
		A.setName(name + "_ACEenhancedGM");
		uncroppedEnhancedGM.setValue(A);
		//uncroppedEnhancedGM.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		uncroppedEnhancedGM.getImageData().setHeader(gm.getHeader());
/*
		A = cropper.uncrop(skel,uncrop2);
		A.setName(gmname + "_CSFskeleton");
		ucSkel.setValue(A);
		ucSkel.getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
*/
		A = cropper.uncrop(thinCSF,uncrop2);
		A.setName(name + "_thinnedCSFskeleton");
		uncroppedthinCSF.setValue(A);
		uncroppedthinCSF.getImageData().setHeader(gm.getHeader());
		
		
		ImageData B = cropper.uncrop(gvf, uncrop3);
		//FileUtil.updateFileInfo(gm.getModelImageCopy(), B.getModelImageCopy());
		B.setHeader(gm.getHeader());
		B.setName(name+"_gradientvectorfield");
		uncroppedGvf.setValue(B);
		
		
		((ParamVolume)thickness.getInput().getFirstChildByName("Inner Level Set")).setValue(inner);
		((ParamVolume)thickness.getInput().getFirstChildByName("Outer Level Set")).setValue(outer);
		thickness.runAlgorithm(monitor);


		ImageDataMipav thickvol =new ImageDataMipav(((ParamVolume)thickness.getOutput().getFirstChildByName("Thickness Volume")).getImageData());
		A = cropper.uncrop(thickvol,uncrop2);
		A.setName(name + "_thicknessVol");
		ucthickvol.setValue(A);
		//ucthickvol.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		ucthickvol.getImageData().setHeader(gm.getHeader());
		
		ImageDataMipav thicklevset=new ImageDataMipav(((ParamVolume)thickness.getOutput().getFirstChildByName("Level Set")).getImageData());
		A = cropper.uncrop(thicklevset,uncrop2);
		A.setName(name + "_thicknesslevset");
		ucthicklevset.setValue(A);
		//ucthicklevset.getImageData().getModelImageCopy().copyFileTypeInfo(gm.getModelImageCopy());
		ucthicklevset.getImageData().setHeader(gm.getHeader());
	
		
	}
}
