package edu.vanderbilt.masi.plugins.CRUISE.utilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamNumberCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataInt;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;

/**
 * @author Yuankai Huo
 * @email yuankai.huo@vanderbilt.edu
 * @version 1.0
 *
 *transfer the toads cruise space image to original space
 *
 */

public class CleanBoundaryFromToads extends ProcessingAlgorithm{

	private ParamVolume BoundaryVol;
	private ParamVolume ToadsWMVol;
	private ParamDouble WM_confident_level;
	
	private ParamVolume OutputVol;
	
	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "remove the problematic boundary voxels form Toads WM" + revnum + "\n";

	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.setPackage("Vanderbilt");
		inputParams.setCategory("format");
		inputParams.setLabel("Clean Boundary From Toads");
		inputParams.setName("Clean_Boundary_From_Toads");

		// input multi-atlas segmentation
		BoundaryVol=new ParamVolume("Boundary volume");
		ToadsWMVol=new ParamVolume("ToadsWM volume");
		
		// define the difference between 
		WM_confident_level = new ParamDouble("WMconfident level");
		WM_confident_level.setValue(0.01);
		WM_confident_level.setMandatory(false);
		

						
		inputParams.add(BoundaryVol);
		inputParams.add(ToadsWMVol);
		inputParams.add(WM_confident_level);
		
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		// TODO Auto-generated method stub
		OutputVol = new ParamVolume("Output volume");
		outputParams.add(OutputVol);
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		// TODO Auto-generated method stub
		ImageDataInt Inputimg = new ImageDataInt(BoundaryVol.getImageData());
		int rows = Inputimg.getRows();
		int cols = Inputimg.getCols();
		int slices = Inputimg.getSlices();
		
		ImageData ToadsWMimg = ToadsWMVol.getImageData();
		
		int i,j,k;
		
		for (i = 0; i < rows; i++) {
			for (j = 0; j < cols; j++) {
				for (k = 0; k < slices; k++) {
					// if is labeled as WM in Toads WM
					if (ToadsWMimg.getFloat(i,j,k)>WM_confident_level.getFloat()){
						Inputimg.set(i,j,k,0);
					}	
				}
			}
		}
		
		
		ImageDataInt Outputimg = Inputimg;
		String outputname =  Inputimg.getName()+"_refspace";
		Outputimg.setName(outputname);
		OutputVol.setValue(Outputimg);
		OutputVol.getImageData().setHeader(Inputimg.getHeader());


	}

}
