package edu.vanderbilt.masi.plugins.CRUISE.utilities;

import java.io.File;
import java.io.IOException;

import edu.jhu.ece.iacl.algorithms.graphics.isosurf.IsoSurfaceOnGrid;
import edu.jhu.ece.iacl.jist.io.SurfaceVtkReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamSurface;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.image.VoxelType;

public class GetMeshSurfaceFromLevelSet extends ProcessingAlgorithm{

	//	private ParamCollection data;
	private ParamVolume LevelSet;
	private ParamSurface OutputVtk;
	protected ImageDataFloat implicitLevelSet;
	private EmbeddedSurface finalSurf;
	protected int connectivityRule = 18;

	private static final String cvsversion = "$Revision: 1.4 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Get Mesh Surface FromLevelSet: " + revnum + "\n";

	private static final SurfaceVtkReaderWriter srw = SurfaceVtkReaderWriter.getInstance();


	@Override
	protected void createInputParameters(ParamCollection inputParams) {

		inputParams.setPackage("Vanderbilt");
		inputParams.setCategory("format");
		inputParams.setLabel("Levelset to surface");
		inputParams.setName("Levelset to surface");

		LevelSet=new ParamVolume("levelset file",VoxelType.FLOAT);
		inputParams.add(LevelSet);



	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		// TODO Auto-generated method stub
		OutputVtk = new ParamSurface("OutputVtk file");
		outputParams.add(OutputVtk);
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		// TODO Auto-generated method stub

		File dir = new File(this.getOutputDirectory()+File.separator);
		try{
			if(!dir.isDirectory()){
				(new File(dir.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }

		IsoSurfaceOnGrid isogrid = new IsoSurfaceOnGrid();
		ImageData LevelSetVol = LevelSet.getImageData();
		implicitLevelSet = new ImageDataFloat(LevelSetVol);
		// Create final surface

		finalSurf = isogrid.solveOriginal(new ImageDataFloat(implicitLevelSet),
				connectivityRule, 0, false);

		finalSurf.setName(LevelSet.getImageData().getName());
		OutputVtk.setValue(finalSurf);

	}

}
