package edu.vanderbilt.masi.plugins.CRUISE.utilities;

import java.io.File;
import java.io.IOException;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.jist.structures.geom.CurveCollection;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.thickness.ClosestPointThickness;
import edu.jhu.ece.iacl.algorithms.thickness.EulerLagrangeThickness;
import edu.jhu.ece.iacl.algorithms.thickness.EulerThickness;
import edu.jhu.ece.iacl.algorithms.thickness.HybridLagrangianEmbedding;
import edu.jhu.ece.iacl.algorithms.thickness.LagrangeThickness;
import edu.jhu.ece.iacl.algorithms.thickness.LevelSetThickness;
import edu.jhu.ece.iacl.algorithms.thickness.OrthoProjectionThickness;
import edu.jhu.ece.iacl.algorithms.thickness.RobustInterSurfaceConformalMapEuler;
import edu.jhu.ece.iacl.algorithms.thickness.RobustLagrangeThickness;
import edu.jhu.ece.iacl.algorithms.thickness.SimpleLagrangianEmbedding;
import edu.jhu.ece.iacl.algorithms.thickness.grid.EmbeddedGrid;
import edu.jhu.ece.iacl.jist.io.*;
import edu.vanderbilt.masi.algorithms.CRUISE.utilities.ClosestPointThicknessForInner;
import edu.vanderbilt.masi.algorithms.CRUISE.utilities.ParcellateInnerAndOuterFromCentral;

/**
 * @author Yuankai Huo
 * @email yuankai.huo@vanderbilt.edu
 * @version 1.0
 *
 *Probagate the contral surface labels to outer and inner surface
 *

 */



public class GetParcellatedInnerAndOuterSurfaceFromCentral extends ProcessingAlgorithm{
	ParamVolume innerVol;
	ParamVolume centralVol;
	ParamVolume outerVol;
	ParamOption algorithm,direction;
	ParamVolume fieldVol;
	ParamVolume thickVol;
	ParamVolume levelVol;
	ParamSurface ParcellatedInnerMesh,ParcellatedOuterMesh;
	ParamSurface centralMesh,innerMesh,outerMesh;
	ParamDouble stepSize;
	ParamDouble isoVal;
	ParamDouble lambda;

	ParamDouble mean;
	ParamDouble stdev;

	ParamDouble meanInner;
	ParamDouble stdevInner;
	ParamDouble meanOuter;
	ParamDouble stdevOuter;
	ParamDouble min;
	ParamDouble max;
	ParamObject<CurveCollection> streamlines;
	ParamObject<EmbeddedGrid> grid;
	private static final int MAX_SURFS=10;

	private static final String cvsversion = "$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");

	private static final SurfaceVtkReaderWriter srw = SurfaceVtkReaderWriter.getInstance();




	protected void createInputParameters(ParamCollection inputParams) {
		innerMesh=new ParamSurface("Inner or Outer mesh");
		centralMesh=new ParamSurface("Central mesh");
		algorithm=new ParamOption("Distance method", new String[]{"euclidean","normPlane","normRay"});
		algorithm.setMandatory(false);
		direction=new ParamOption("Direction", new String[]{"Center->Inner","Center->Outer"});
		direction.setMandatory(false);


		isoVal=new ParamDouble("Iso Value",-255.0,255.0);
		//				lambda=new ParamDouble("Lambda",0,5,1);
		//				stepSize=new ParamDouble("Lagrange Step Size",0,100,0.25);

		inputParams.setLabel("InnerOuterParcel");
		inputParams.setName("InnerOuterParcel");
		inputParams.setPackage("IACL");
		inputParams.setCategory("Measurement.Surface");

		inputParams.add(innerMesh);
		inputParams.add(centralMesh);
		inputParams.add(algorithm);
		inputParams.add(direction);
		//				inputParams.add(isoVal);
		//				inputParams.add(lambda);
		//				inputParams.add(stepSize);


		AlgorithmInformation info = getAlgorithmInformation();
		info.add(PrinceGroupAuthors.blakeLucas);
		info.setDescription("Using three level set functions (usually inner surface, central surface and outer surface levelset), the module generates a thickness volume and statistics on the thickness. The inner and outer level sets can be obtained from NestedTGDM module.");
		info.setLongDescription("The surfaces generated by this method are not the same as the ones generated by CRUISE, they are slightly smoother. CRUISE will perturb vertices closer than 0.1 of a voxel close to a grid point to 0.1 away from that grid point, which greatly affects the precision of thickness measurements. Instead, this method perturbs the surface by only 0.01 voxel. Thickness measurements should be made relative to the perturbed level set, instead of the original level set. To toggle between the original CRUISE and the improved method, change the ADJUST_BOUNDARY flag. However, one shouldn't agonize over these differences because the fast-marching method doesn't have great precision. What's important is that thickness measurements are computed in a consistent manner with consistent metrics.");
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.Release);
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		ParcellatedInnerMesh=new ParamSurface("Inner Mesh");
		//		ParcellatedOuterMesh=new ParamSurface("Outer Mesh");
		outputParams.add(ParcellatedInnerMesh);
		//		outputParams.add(ParcellatedOuterMesh);
		outputParams.setName("parcellation");
	}

	@Override
	protected void execute(CalculationMonitor monitor) {
		ParcellateInnerAndOuterFromCentral solver=null;
		/*
		 * This is really stupid.
		 */

		EmbeddedSurface innerMeshSurf;
		EmbeddedSurface outerMeshSurf;



		solver = new ParcellateInnerAndOuterFromCentral(algorithm.getIndex(),direction.getIndex());	


		if(solver!=null){
			monitor.observe(solver);
			solver.solve(innerMesh.getSurface(), centralMesh.getSurface());
			innerMeshSurf = solver.getInnerSurface();				
			innerMeshSurf.setName(innerMeshSurf.getName());
			ParcellatedInnerMesh.setValue(innerMeshSurf);

			//			outerMeshSurf = solver.getOuterSurface();
			//			outerMeshSurf.setName("outerSurf_withData");
			//			ParcellatedOuterMesh.setValue(outerMeshSurf);

		}	
	}
}



