package edu.vanderbilt.masi.plugins.CRUISE.utilities;

import java.io.File;
import java.io.IOException;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.jist.structures.geom.CurveCollection;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.thickness.grid.EmbeddedGrid;
import edu.jhu.ece.iacl.jist.io.*;
import edu.vanderbilt.masi.algorithms.CRUISE.utilities.ClosestPointThicknessForInner;

/**
 * @author Yuankai Huo
 * @email yuankai.huo@vanderbilt.edu
 * @version 1.0
 *
 *Based on Compute thickness by measuring the shortest distance 
 *between corresponding points. by Blake Lucas in CRUISE
 *
 *The difference is that it calculate the average thickness from inner
 *to the closest point in outer and from that point back to inner surf
 *
 *In addition, this file generate the scalar vtk file which project
 *the thickness to central file
 */



public class GetThicknessByClosestPoints extends ProcessingAlgorithm{
	ParamVolume innerVol;
	ParamVolume centralVol;
	ParamVolume outerVol;
	ParamOption algorithm;
	ParamVolume fieldVol;
	ParamVolume thickVol;
	ParamVolume levelVol;
	ParamSurface innerMesh,innerMeshScale;
	ParamSurface centralMesh,centralMeshScale;
	ParamSurface outerMesh;
	ParamDouble stepSize;
	ParamDouble isoVal;
	ParamDouble lambda;

	ParamDouble mean;
	ParamDouble stdev;

	ParamDouble meanInner;
	ParamDouble stdevInner;
	ParamDouble meanOuter;
	ParamDouble stdevOuter;
	ParamDouble min;
	ParamDouble max;
	ParamObject<CurveCollection> streamlines;
	ParamObject<EmbeddedGrid> grid;
	private static final int MAX_SURFS=10;

	private static final String cvsversion = "$Revision: 1.3 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");

	private static final SurfaceVtkReaderWriter srw = SurfaceVtkReaderWriter.getInstance();




	protected void createInputParameters(ParamCollection inputParams) {
		innerMesh=new ParamSurface("Inner mesh");
		centralMesh=new ParamSurface("Central mesh");
		centralMesh.setMandatory(false);
		outerMesh=new ParamSurface("Outer mesh");

		isoVal=new ParamDouble("Iso Value",-255.0,255.0);
		lambda=new ParamDouble("Lambda",0,5,1);
		stepSize=new ParamDouble("Lagrange Step Size",0,100,0.25);

		inputParams.setLabel("Thickness");
		inputParams.setName("Thickness");
		inputParams.setPackage("IACL");
		inputParams.setCategory("Measurement.Surface");

		inputParams.add(innerMesh);
		inputParams.add(centralMesh);
		inputParams.add(outerMesh);
		inputParams.add(isoVal);
		inputParams.add(lambda);
		inputParams.add(stepSize);


		AlgorithmInformation info = getAlgorithmInformation();
		info.add(PrinceGroupAuthors.blakeLucas);
		info.setDescription("Using three level set functions (usually inner surface, central surface and outer surface levelset), the module generates a thickness volume and statistics on the thickness. The inner and outer level sets can be obtained from NestedTGDM module.");
		info.setLongDescription("The surfaces generated by this method are not the same as the ones generated by CRUISE, they are slightly smoother. CRUISE will perturb vertices closer than 0.1 of a voxel close to a grid point to 0.1 away from that grid point, which greatly affects the precision of thickness measurements. Instead, this method perturbs the surface by only 0.01 voxel. Thickness measurements should be made relative to the perturbed level set, instead of the original level set. To toggle between the original CRUISE and the improved method, change the ADJUST_BOUNDARY flag. However, one shouldn't agonize over these differences because the fast-marching method doesn't have great precision. What's important is that thickness measurements are computed in a consistent manner with consistent metrics.");
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.Release);
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		innerMeshScale=new ParamSurface("Inner Mesh");
		centralMeshScale=new ParamSurface("Central Mesh");
		centralMeshScale.setMandatory(false);
		outputParams.add(innerMeshScale);
		outputParams.add(centralMeshScale);
		outputParams.setName("thickness");
	}

	@Override
	protected void execute(CalculationMonitor monitor) {
		ClosestPointThicknessForInner solver=null;
		/*
		 * This is really stupid.
		 */

		EmbeddedSurface innerMeshSurf;
		EmbeddedSurface centralMeshSurf;

		solver = new ClosestPointThicknessForInner(lambda.getDouble(),isoVal.getDouble(),stepSize.getDouble());	

		if(solver!=null){
			monitor.observe(solver);
			if(centralMesh.getSurface()!=null){
				solver.solve(innerMesh.getSurface(), centralMesh.getSurface(), outerMesh.getSurface());
				innerMeshSurf = solver.getInnerSurface();				
				innerMeshSurf.setName("innerSurf_withData");
				innerMeshScale.setValue(innerMeshSurf);

				centralMeshSurf = solver.getCentralSurface();
				centralMeshSurf.setName("centralSurf_withData");
				centralMeshScale.setValue(centralMeshSurf);
			}
			else{
				solver.solve(innerMesh.getSurface(), outerMesh.getSurface());
				innerMeshSurf = solver.getInnerSurface();				
				innerMeshSurf.setName("innerSurf_withData");
				innerMeshScale.setValue(innerMeshSurf);
			}
		}

		//			
		//
		//			File dir = new File(this.getOutputDirectory()+File.separator);
		//			try{
		//				if(!dir.isDirectory()){
		//					(new File(dir.getCanonicalPath())).mkdir();
		//				}
		//			}catch(IOException e){ e.printStackTrace(); }


		//			ParamFile ykdebug = new ParamVolume("yk debug");
		//			innerMeshSurf.setName("innerSurf_withData");
		//			ykdebug.setValue(srw.write(innerMeshSurf, dir));
		//			centralMeshSurf.setName("centralSurf_withData");
		//			ykdebug.setValue(srw.write(centralMeshSurf, dir));

		//			outerMeshSurf.setName("outtrSurf_withData");
		//			ykdebug.setValue(srw.write(outerMeshSurf, dir));

		//			innerMesh.setValue(solver.getInnerSurface());
		//			outerMesh.setValue(solver.getOuterSurface());

		//		fieldVol.setValue(solver.getTangetField());
		//			thickVol.setValue(solver.getThickness());
		//			thickVol.getImageData().setHeader(innerVol.getImageData().getHeader());
		//			levelVol.setValue(solver.getLevelSet());
		//			levelVol.getImageData().setHeader(innerVol.getImageData().getHeader());
		//			mean.setValue(solver.getMeanThickness());
		//			stdev.setValue(solver.getStdevThickness());
		//			meanInner.setValue(solver.getMeanInnerThickness());
		//			meanOuter.setValue(solver.getMeanOuterThickness());
		//			stdevInner.setValue(solver.getStdevInnerThickness());
		//			stdevOuter.setValue(solver.getStdevOuterThickness());
		//			min.setValue(solver.getMinThickness());
		//			max.setValue(solver.getMaxThickness());
		/*			
			if(solver instanceof LagrangeThickness){
				CurveCollection collection=((LagrangeThickness)solver).getStreamlines();

				streamlines.setObject(collection);
			}
			if(solver instanceof RobustLagrangeThickness){
				CurveCollection collection=((RobustLagrangeThickness)solver).getStreamlines();

				streamlines.setObject(collection);
			}

			if(solver instanceof ExtendedLagrangianEmbedding){
				EmbeddedGrid egrid=((ExtendedLagrangianEmbedding)solver).getGrid();
				grid.setObject(egrid);
				grid.setFileName(innerVol.getValue().getName()+".grid");
			}
		 */			
	}
}



