package edu.vanderbilt.masi.plugins.CRUISE.utilities;

import edu.jhmi.rad.medic.utilities.CropParameters;
import edu.jhmi.rad.medic.utilities.CubicVolumeCropper;
import edu.jhu.ece.iacl.algorithms.ace.ThinACE;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;

/**
 * @author Yuankai Huo
 * @email yuankai.huo@vanderbilt.edu
 * @version 1.0
 *
 *make thin skeleton from the original skeleton
 *
 */

public class MakeThinSkeleton extends ProcessingAlgorithm{
	
	private ParamVolume Skeleton,GMace;
	private ParamVolume ThinSkeleton,GMclean,Skeletonclean;
//	private ParamSurface VTKsurfParam;
//	private ParamSurface ASCsurfParam;
	
	private static final String cvsversion = "$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Generate thin skeleton" + revnum + "\n";

	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		
		inputParams.setPackage("Vanderbilt");
		inputParams.setCategory("format");
		inputParams.setLabel("Get Thin Skeleton");
		inputParams.setName("Get_Thin_Skeleton");
		
		Skeleton=new ParamVolume("Original Skeleton");
		GMace=new ParamVolume("GM ACE");
		GMace.setMandatory(false);
		
		inputParams.add(Skeleton);
		inputParams.add(GMace);

	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		// TODO Auto-generated method stub
		ThinSkeleton = new ParamVolume("Thin Skeleton");
		GMclean = new ParamVolume("GM clean");
		Skeletonclean = new ParamVolume("Skeleton Skeleton");
		outputParams.add(ThinSkeleton);
		outputParams.add(GMclean);
		outputParams.add(Skeletonclean);
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		// TODO Auto-generated method stub
		
		ImageData csf = Skeleton.getImageData();
		ImageData enhancedGM = GMace.getImageData();
		ImageData thinGM;
		
//		String GMname = enhancedGM.getName();
		
		ThinACE thin = new ThinACE();
		
		int rows = csf.getRows();
		int cols = csf.getCols();
		int slices = csf.getSlices();
		int i, j, k;
		
		
		thinGM = thin.solve(csf);
		for (i = 0; i < rows; i++) {
			for (j = 0; j < cols; j++) {
				for (k = 0; k < slices; k++) {
					if (i == 0 || j == 0 || k == 0 || i == rows - 1
							|| j == cols - 1 || k == slices - 1) {
						csf.set(i, j, k, (int) 0);
						if (enhancedGM != null)  {
							enhancedGM.set(i, j, k, (float) 0.0f);
						}
						
					}
				}
			}
		}
		
//		if (enhancedGM != null)  {
//			enhancedGM.setHeader(csf.getHeader());
//			enhancedGM.setName("enhanceGM");
//		}

		
		thinGM.setHeader(csf.getHeader());
		thinGM.setName("thinskeleton");
		
//		csf.setHeader(csf.getHeader());
//		csf.setName("skeleton");
		
		ThinSkeleton.setValue(thinGM);
//		GMclean.setValue(enhancedGM);
//		Skeletonclean.setValue(csf);
		
		
	}

}
