package edu.vanderbilt.masi.plugins.CRUISE.utilities;

import java.io.File;
import java.io.IOException;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.jhu.ece.iacl.jist.structures.geom.CurveCollection;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.thickness.grid.EmbeddedGrid;
import edu.jhu.ece.iacl.jist.io.*;
import edu.vanderbilt.masi.algorithms.CRUISE.utilities.ClosestPointThicknessForInner;
import edu.vanderbilt.masi.algorithms.CRUISE.utilities.ParcellateInnerAndOuterFromCentral;
import edu.vanderbilt.masi.algorithms.CRUISE.utilities.ParcellateInnerAndOuterFromVolume;

/**
 * @author Yuankai Huo
 * @email yuankai.huo@vanderbilt.edu
 * @version 1.0
 *
 *Probagate the contral surface labels to outer and inner surface
 *

 */



public class ParcelOuterSurfaceFromVolume extends ProcessingAlgorithm{
	ParamVolume innerVol;
	ParamOption algorithm;
	ParamVolume fieldVol;
	ParamVolume thickVol;
	ParamVolume levelVol;
	ParamSurface ParcellatedInnerMesh;
	ParamSurface innerMesh;
	ParamDouble stepSize;
	ParamDouble isoVal;
	ParamDouble lambda;

	ParamDouble mean;
	ParamDouble stdev;

	ParamDouble meanInner;
	ParamDouble stdevInner;
	ParamDouble meanOuter;
	ParamDouble stdevOuter;
	ParamDouble min;
	ParamDouble max;
	ParamObject<CurveCollection> streamlines;
	ParamObject<EmbeddedGrid> grid;
	private static final int MAX_SURFS=10;

	private static final String cvsversion = "$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");

	private static final SurfaceVtkReaderWriter srw = SurfaceVtkReaderWriter.getInstance();
	private static AlgorithmAuthor Huo=new AlgorithmAuthor("Yuankai Huo","yuankai.huo@vanderbilt.com","");



	protected void createInputParameters(ParamCollection inputParams) {
		innerMesh=new ParamSurface("Inner mesh");
		innerVol=new ParamVolume("Segmentation");

		inputParams.setLabel("InnerSurfParcel");
		inputParams.setName("InnerSurfParcel");
		inputParams.setPackage("IACL");
		inputParams.setCategory("Measurement.Surface");

		inputParams.add(innerMesh);
		inputParams.add(innerVol);


		AlgorithmInformation info = getAlgorithmInformation();
		info.add(Huo);
		info.setDescription("Using multi-atlas segmentation to parcellate outer surface");
		info.setLongDescription("Find the cloest label for outer surface");
		info.setWebsite("http://");
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.Release);
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		ParcellatedInnerMesh=new ParamSurface("Inner Mesh");
//		ParcellatedOuterMesh=new ParamSurface("Outer Mesh");
		outputParams.add(ParcellatedInnerMesh);
//		outputParams.add(ParcellatedOuterMesh);
		outputParams.setName("parcellation");
	}

	@Override
	protected void execute(CalculationMonitor monitor) {
		ParcellateInnerAndOuterFromVolume solver=null;
		/*
		 * This is really stupid.
		 */

		EmbeddedSurface innerMeshSurf;
		EmbeddedSurface outerMeshSurf;

		solver = new ParcellateInnerAndOuterFromVolume();	

		if(solver!=null){
			monitor.observe(solver);
			solver.solve(innerMesh.getSurface(), innerVol.getImageData());
			innerMeshSurf = solver.getInnerSurface();	
			innerMeshSurf.setName(innerMesh.getSurface().getName()+"_x_"+innerVol.getImageData().getName());
			
			innerMeshSurf.setName(innerMeshSurf.getName());
			ParcellatedInnerMesh.setValue(innerMeshSurf);

//			outerMeshSurf = solver.getOuterSurface();
//			outerMeshSurf.setName("outerSurf_withData");
//			ParcellatedOuterMesh.setValue(outerMeshSurf);

		}	
	}
}



