import gov.nih.mipav.plugins.PlugInGeneric;
import edu.jhmi.rad.medic.floatvoi.*;
import edu.jhmi.rad.medic.visualization.models.*;
import javax.swing.*;
import java.io.*;
import gov.nih.mipav.view.ViewJProgressBar;

public class PlugInStandAloneSurfaceViewer implements PlugInGeneric {
	public static final String[] CATEGORY = {"TOADS-CRUISE", "Visualization"};
	private JFileChooser fc;
	public void run() {
		System.out.println("Launching Medic Simple Surface Viewer");
		fc = new JFileChooser();
		fc.setFileSelectionMode(JFileChooser.FILES_ONLY );
		int returnVal = fc.showOpenDialog(null);
		if(returnVal == JFileChooser.APPROVE_OPTION) {
			new Thread( new Runnable() {
  				public void run() {
  					File f = fc.getSelectedFile();
  					ViewJProgressBar pb = new ViewJProgressBar("Loading ...", "Reading Surface : " + f.getName(), 0, 100, false);
  					try {
						String extension = f.getName().substring(f.getName().lastIndexOf('.') + 1).toLowerCase();
						String errorMessage = "Unable to load Surface File.";
						TriangleMesh m = null;
						if(extension.equals("vtk"))
           					m = (TriangleMesh) ModelLoader.LoadVTKLegacyMesh(f.getPath(), pb);
						else
							errorMessage = "Unrecognized file format.";
        				if(m == null)
							JOptionPane.showMessageDialog(null, errorMessage);
						else {
							JSurfaceFrame jsf = new JSurfaceFrame(null, m, null, null );
						}
  					}
					catch(IOException e) {
						JOptionPane.showMessageDialog(null, "Error loading surface file. Reason : " + e.getMessage());
					}
					pb.dispose();
      			}
			}).start();
		}
		System.gc();
	}
}
