package edu.jhmi.rad.medic.methods;

import java.io.*;
import java.util.*;


import edu.jhmi.rad.medic.structures.BinaryTree;

import edu.jhu.ece.iacl.jist.structures.data.*;
import edu.jhu.ece.iacl.jist.structures.image.*;


/**
 *
 *  This class implements the fast marching algorithm, an updated version of 
 *  ObjectProcessing.signedDistanceFunction by Pilou.
 *	
 *  @version    July 2006
 *	@author     Jing Wan
 *		
 *
 */

 public class FastMarching{	
	 
	 private final static byte ALIVE = 1, NBAND = 2, FAWAY = 3; 
	 private final static byte IFij = 1;  /* 1/F[k][i][j] */
	 private final static byte ISFij = 1;  /* 1/(F[k][i][j]*F[k][i][j]) */
	 public final static float SQR2 = (float)Math.sqrt(2.0f);
	 public final static float SQR3 = (float)Math.sqrt(3.0f);
	 static int[] xoff = {1, 0, -1, 0, 0, 0}; 
	 static int[] yoff = {0, 1, 0, -1, 0, 0};
	 static int[] zoff = {0, 0, 0, 0, 1, -1};
	 public static final float[][][] signedDistanceFunction(float[][][] obj, int nx, int ny, int nz, float Thred) {

		// Thred: distance threshold to stop marching
		// obj: original level set function, float type
		float			val=0.0f;
		float			ngb=0.0f;
		int				x,y,z;
		
		float[][][]		dist = new float[nx][ny][nz];
		int LX,HX,LY,HY,LZ,HZ; /* Logical variables aid in dealing with boundary */
		byte[][][] label = new byte[nx][ny][nz];
		boolean NSFlag, WEFlag, FBFlag; /* Logical variables aid in locating sign change */
		float Nv=0,Sv=0,Wv=0,Ev=0, Fv=0, Bv=0;    /* Value at six neighours of a pixel */
		byte Nl, Sl, Wl, El, Fl, Bl; /* Label at six neighours of a pixel */
		float s=0,t=0,w=0;		 /* Used in initialization */
		float result;          /* 1/s*s + 1/t*t + 1/w*w */
		float Cv;
		int koff;				/* Neighbourhood index */
		int newx,newy, newz;
		
		float newvalue;
		VoxelIndexed<VoxelFloat> he;
		/* Initialization for marching inwards and outwards */
		/* It is assumed the original contour lies exactly at grid points. 
		 * If not, more complicated initialization method need to be performed
		 */
		// boundaries: no processing
		for (x=0;x<nx;x++) for (y=0;y<ny;y++) for (z=0;z<nz;z++) {
			label[x][y][z] = FAWAY; /*All points are labelled as FAR AWAY */
		}
		/* First, find grid points that lie no more than 1 pixel away from the 
		   * contour, label them as ALIVE
		   */
		 
		int countAlive = 0;
		for (x=0;x<nx;x++) for (y=0;y<ny;y++) for (z=0;z<nz;z++) {
			if(obj[x][y][z] == 0f){ /* This grid point lies exactly on the contour */
			  dist[x][y][z]  = 0f; /* Its distance value is exactly zero */
			  label[x][y][z] = ALIVE;
			  countAlive++;
			}
			else{ /* Judge whether it's within one pixel away from the contour */
				LX = (x==0) ? 1 : 0; HX = (x==(nx-1)) ? 1 : 0;
				LY = (y==0) ? 1 : 0; HY = (y==(ny-1)) ? 1 : 0;
				LZ = (z==0) ? 1 : 0; HZ = (z==(nz-1)) ? 1 : 0;
				NSFlag = false; WEFlag = false; FBFlag = false;
				Nv = obj[x][y-1+LY][z];
				Sv = obj[x][y+1-HY][z];
				Wv = obj[x-1+LX][y][z];
				Ev = obj[x+1-HX][y][z];
				Fv = obj[x][y][z+1-HZ];
				Bv = obj[x][y][z-1+LZ];
				Cv = obj[x][y][z];
				
				if(Nv*Cv < 0){
					NSFlag = true;
					s = Nv;
				}
				if(Sv*Cv < 0){
					if(NSFlag == false){
						NSFlag = true;
						s = Sv;
					}else{
						s = (Math.abs(Nv) > Math.abs(Sv))? Nv : Sv;
					}  
				}	
			  
				if(Wv*Cv < 0){
					WEFlag = true;
					t = Wv;
				}
				if(Ev*Cv < 0){
					if(WEFlag == false){
						WEFlag = true;
						t = Ev;
					}else{
						t = (Math.abs(Ev) > Math.abs(Wv))? Ev : Wv;
					}  
				}
			  
				if(Fv*Cv < 0){
					FBFlag = true;
					w = Fv;
				}
				if(Bv*Cv < 0){
					if(FBFlag == false){
						FBFlag = true;
						w = Bv;
					}else{
						w = (Math.abs(Fv) > Math.abs(Bv))? Fv : Bv;
					}  
				}
				
				result = 0;
				  if(NSFlag){
				    s = Cv/(Cv-s);
				    result += 1.0/(s*s);
				  }
				  if(WEFlag){
				    t = Cv/(Cv-t);
				    result += 1.0/(t*t);
				  }
				  if(FBFlag){
				    w = Cv/(Cv-w);
				    result += 1.0/(w*w);
				  }
				  
				  if(result == 0) continue; /* Not within 1 pixel away */
				  
				  label[x][y][z] = ALIVE; /*Within 1 pixel away, put into ALIVE */
				  countAlive++;
				  result = (float)Math.sqrt((double)result);
				  
				  dist[x][y][z] = IFij/result;
				
			}
		}
		/*
		for (x=0;x<32;x++) for (y=0;y<32;y++)
			System.out.print("dist-"+x+"-"+y+": "+dist[x][y][0]+"\t");
		*/
		
		BinaryMinHeap heap = new BinaryMinHeap((int)Math.ceil(countAlive*1.25),nx,ny,nz);
		/* Initialize NarrowBand Heap */
		for (x=0;x<nx;x++) for (y=0;y<ny;y++) for (z=0;z<nz;z++) {
			if(label[x][y][z]!=ALIVE) continue;
			
				// check for inside boundary, find six neighbouring points
				for(koff=0; koff <= 5; koff++){/*Find six neighbouring points */ 
				  newx = x + xoff[koff];
				  newy = y + yoff[koff];
				  newz = z + zoff[koff];
				
				  if(newy <0 || newy >= ny || newx < 0 || 
				     newx >= nx || newz < 0 || newz >= nz) 
				    continue; /* Out of computational Boundary*/
				    
				    if(label[newx][newy][newz] != FAWAY)					    
					    continue;
				    
				  label[newx][newy][newz] = NBAND;
				  
				  
				   /* Note: Only ALIVE points contribute to the distance computation */
				 /* Neighbour to the north*/ 
				 
				 /* Neighbour to the north*/
				  if(newy > 0) { 
				    Nv = dist[newx][newy-1][newz];
				    Nl = label[newx][newy-1][newz];
				  }else Nl = 0;
				  
				  /* Neighbour to the south*/
				  if(newy < ny-1) {
				    Sv = dist[newx][newy+1][newz];
				    Sl = label[newx][newy+1][newz];
				  } else Sl = 0;
				  
				  /* Neighbour to the east*/
				  if(newx < nx-1) {
				    Ev = dist[newx+1][newy][newz];
				    El = label[newx+1][newy][newz];
				  }else El = 0;
				  
				  /*Neighbour to the west*/
				  if(newx > 0){
				    Wv = dist[newx-1][newy][newz];
				    Wl = label[newx-1][newy][newz];
				  }else Wl = 0;
				  
				  /* Neighbour to the front */
				  if(newz < nz-1) {
				    Fv = dist[newx][newy][newz+1];
				    Fl = label[newx][newy][newz+1];
				  }else Fl = 0;
				  
				  /*Neighbour to the back */
				  if(newz > 0){
				    Bv = dist[newx][newy][newz-1];
				    Bl = label[newx][newy][newz-1];
				  }else Bl = 0;
				  
				/*Update the value of this to-be-updated NarrowBand point*/	
				  newvalue = ReCompute(Nv,Sv,Ev,Wv,Fv,Bv,Nl,Sl,El,Wl,Fl,Bl);
				  dist[newx][newy][newz] = newvalue;
				  VoxelIndexed<VoxelFloat> vox=new VoxelIndexed<VoxelFloat> (new VoxelFloat(newvalue));
				  vox.setRefPosition(newx,newy,newz);
				  heap.add(vox);
				  
			}
		}
		/* End of Initialization */
		
		/* Begin Fast Marching to get the unsigned distance function inwords 
		 * and outwards simultaneously
		 * since points inside and outside the contour won't interfere with 
		 * each other
		 */
		int whileiter = 0;
		while (!heap.isEmpty()) {
			whileiter++;
			he =  (VoxelIndexed<VoxelFloat> )heap.remove(); 
			/* Label the point with smallest value among all 
			 NarrowBand points as ALIVE */
			// get the next value
			x = he.getRow();
			y = he.getColumn();
			z = he.getSlice();
			
			if(he.getFloat()>Thred)	break;
			
			dist[x][y][z] = he.getFloat();
			
			if(label[x][y][z] == ALIVE)
				continue;
			label[x][y][z]=ALIVE;
					
			/* Put the first tree element to ALIVE */
			/* Update its neighbor */
		    /* Put FARAWAY neighbour into NarrowBand, Recompute values at 
		     * NarrowBand neighbours,
		     * Keep ALIVE (Accepted) neighbour unchanged
		     */
		    for(koff=0; koff <= 5; koff++){
			      newy = y + yoff[koff];
			      newx = x + xoff[koff];
			      newz = z + zoff[koff];
			      if(newy <0 || newy >= ny || newx < 0 || 
				     newx >= nx || newz < 0 || newz >= nz) 
				    continue; /* Out of computational Boundary*/
				
				
			    if(label[newx][newy][newz] == ALIVE) 
				  continue;/* Don't change ALIVE neighbour */
				  
			  /* ReCompute the value at (newj, newi, newd) */
		      /* Get the values and labels of six neighbours of the to-be-updated 
		       * point. The labels are needed since only values at ALIVE 
		       * neighbours will be used to update
		       * the value of the to-be-updated point
		       */
		      
		      /* Note: Only ALIVE points contribute to the distance computation */
		      /* Neighbour to the north */
		      
				  if(newy > 0) { 
				    Nv = dist[newx][newy-1][newz];
				    Nl = label[newx][newy-1][newz];
				  }else Nl = 0;
				  
				  /* Neighbour to the south*/
				  if(newy < ny-1) {
				    Sv = dist[newx][newy+1][newz];
				    Sl = label[newx][newy+1][newz];
				  } else Sl = 0;
				  
				  /* Neighbour to the east*/
				  if(newx < nx-1) {
				    Ev = dist[newx+1][newy][newz];
				    El = label[newx+1][newy][newz];
				  }else El = 0;
				  
				  /*Neighbour to the west*/
				  if(newx > 0){
				    Wv = dist[newx-1][newy][newz];
				    Wl = label[newx-1][newy][newz];
				  }else Wl = 0;
				  
				  /* Neighbour to the front */
				  if(newz < nz-1) {
				    Fv = dist[newx][newy][newz+1];
				    Fl = label[newx][newy][newz+1];
				  }else Fl = 0;
				  
				  /*Neighbour to the back */
				  if(newz > 0){
				    Bv = dist[newx][newy][newz-1];
				    Bl = label[newx][newy][newz-1];
				  }else Bl = 0;
				  
				  newvalue = ReCompute(Nv,Sv,Ev,Wv,Fv,Bv,Nl,Sl,El,Wl,Fl,Bl);
				  /* If it was a FARAWAY point, add it to the NarrowBand Heap; 
				 * otherwise, just update its value
				 * using the backpointer
				 */
				  VoxelIndexed<VoxelFloat> vox=new VoxelIndexed<VoxelFloat> (new VoxelFloat((float)newvalue));
				  vox.setRefPosition(newx,newy,newz);
				  if(label[newx][newy][newz] == NBAND) 
					  heap.change(newx,newy,newz,vox);
				  else{
					  heap.add(vox);
					  label[newx][newy][newz] = NBAND;
				  }
							
		    }/* End of updating 6 neighbours */ 
		    
		}/* End of marching loop */
  
		/* Add signs to the unsigned distance function */
		for (x=0;x<nx;x++) for (y=0;y<ny;y++) for (z=0;z<nz;z++){
			if(label[x][y][z] != ALIVE) dist[x][y][z] = Thred;
			if(obj[x][y][z]<0)	dist[x][y][z]=-dist[x][y][z];
		}
			
		// clean up
		
		return dist;
	}//signedDistanceFunction
	
	public static final float ReCompute(float Nv,float Sv,float Ev,float Wv,float Fv, float Bv, 
						  byte Nl, byte Sl, byte El, byte Wl, byte Fl, byte Bl){
	
		float s, s2; /* s = a + b +c; s2 = a*a + b*b +c*c */
		float tmp;
		int count;
		s = 0; s2 =0; count = 0;
	/*	if(Nl == 3 && Sl==1 && El== 1 && Wl== 3 && Fl==0 && Bl==0)
			  System.out.print("Inside Values: "+Nv+" "+Sv+" "+Ev+" "+Wv+" "+Fv+" "+Bv+"\n");
	*/
	/*	if(flag == 1 && Nl == 3 && Sl==1 && El== 1 && Wl== 3 && Fl==0 && Bl==0)
			  System.out.print("Inside Values: "+Nv+" "+Sv+" "+Ev+" "+Wv+" "+Fv+" "+Bv+" "+Nl+" "+Sl+" "+El+" "+Wl+" "+Fl+" "+Bl+"\n");
	*/		  
		if (Nl == ALIVE && Sl == ALIVE){ 
		    tmp = Math.min(Nv, Sv); /* Take the smaller one if both ALIVE */
		    s += tmp;
		    s2 += tmp*tmp;
		    count++;
		    		  
		  }
		  else if (Nl == ALIVE){
		    s += Nv;	 /* Else, take the ALIVE one */
		    s2 += Nv*Nv;
		    count++;
		    
		  } 
		  else if (Sl == ALIVE){
		    s += Sv;
		    s2 += Sv*Sv;
		    count++;
		    
		  }
	/*	  if(flag == 1 && Nl == 3 && Sl==1 && El== 1 && Wl== 3 && Fl==0 && Bl==0)
			  System.out.print("NS s,s2 = "+s+" "+s2+" \t");
	*/	  
		  /* Similarly in the east-west direction to get correct 
		     approximation to the derivative in the x-direction */
		  if (El == ALIVE && Wl == ALIVE){ 
		    tmp = Math.min(Ev, Wv); /* Take the smaller one if both ALIVE */
		    s += tmp;
		    s2 += tmp*tmp;
		    count++;
		    
		  }
		  else if (El == ALIVE){
		    s += Ev;	 /* Else, take the ALIVE one */
		    s2 += Ev*Ev;
		    count++;
		    
		  } 
		  else if (Wl == ALIVE){
		    s += Wv;
		    s2 += Wv*Wv;
		    count++;
		    
		  }
		
		  /* Similarly in the front-back direction to get correct 
		     approximation to the derivative in the z-direction */
		  if (Fl == ALIVE && Bl == ALIVE){ 
		    tmp = Math.min(Fv, Bv); /* Take the smaller one if both ALIVE */
		    s += tmp;
		    s2 += tmp*tmp;
		    count++;
		    
		  }
		  else if (Fl == ALIVE){
		    s += Fv;	 /* Else, take the ALIVE one */
		    s2 += Fv*Fv;
		    count++;
		  } 
		  else if (Bl == ALIVE){
		    s += Bv;
		    s2 += Bv*Bv;
		    count++;
		  }
		  
	
		  /* count must be greater than zero since there must be one ALIVE pt 
		     in the neighbors */
		  
		  tmp = (s + (float)Math.sqrt((double)(s*s - count*(s2 - ISFij))))/count; 
		  
		  /* The larger root */
		  return tmp;
	}
	
	
 }
