package edu.jhmi.rad.medic.visualization.models;

import edu.jhmi.rad.medic.visualization.models.*;
import edu.jhmi.rad.medic.visualization.primitives.*;

import java.io.*;
import java.util.Vector;

import gov.nih.mipav.view.ViewJProgressBar;

public class ModelLoader {
	
	public static Drawable LoadModel(String filename, ViewJProgressBar progress) throws IOException {
		return LoadVTKLegacyMesh(filename, progress);
	}
	
	/*
	 * Loads a legacy VTK mesh into the surface object.
	 * NOTE: Data type argument is not being used.
	 *
	 *	@param	filename	Full path filename of the vtk surface
	 *	@param	progress	ProgressBar
	 *	@throw	IOException
	 *	@return	Surface
	 *	@todo	Binary Support
	 */
	static public TriangleMesh LoadVTKLegacyMesh(String filename, ViewJProgressBar progress) throws IOException {				
		File file = new File(filename);
		
		// Check if file is readable
		if(!file.exists() || !file.canRead()) 
			return null;
		
		BufferedReader b = new BufferedReader(new FileReader(file));
		String line = "";
		String [] splits;
		String name = "";
		String data_Type;
		int FileType = 1;
		int vertex_num, poly_num;
			
		if(b == null)	return null;
		
		System.out.println("Loading Surface ... ");
			
		//Read in the headers
		line = b.readLine().trim().toLowerCase();
		
		//Check for VTK
		if(line.indexOf("vtk datafile") == -1) 	return null;		
			
		progress.setVisible(true);
		
		// Read in Surface name
		line = b.readLine();
		name = line.trim();		
		
		// Read in format type
		line = b.readLine().trim().toLowerCase();
		if(line.compareTo("binary") == 0)
			FileType = TriangleMesh.FILE_BINARY;		
		else 
			FileType = TriangleMesh.FILE_ASCII;
		
		// Check if the file contains polygon data
		line = b.readLine().trim().toLowerCase();		
		if(line.indexOf("dataset") == -1 || line.indexOf("polydata") == -1)	return null;
			
		// Read in the number of points
		line = b.readLine().trim().toLowerCase();
		splits = line.split(" ");		
			
		if(splits.length != 3)					return null;		
		if(splits[0].indexOf("points") == -1)	return null;
		
		vertex_num	= Integer.parseInt(splits[1]);
		data_Type	= splits[2];
		
		TriangleMesh s = new TriangleMesh();
		s.setName(name);
		s.setFileType(FileType);
		s.allocateVertices(vertex_num);
		
		Vertex v;
		
		System.out.println("Found " + vertex_num + " points");
		
		progress.setMessage("Reading Points ... ");
		if(FileType == TriangleMesh.FILE_ASCII)			
			for(int i = 0; i < vertex_num; ++i) {
				v = new Vertex();
				line = b.readLine().trim();
				splits = line.split(" ");
				if(splits.length != 3) {
					System.out.println("Incorrect number of coordinates for Point : " + i);
					return null;
				}
				v.point.x = Float.parseFloat(splits[0]);
				v.point.y = Float.parseFloat(splits[1]);
				v.point.z = Float.parseFloat(splits[2]);
				s.addVertex(v);				
			}		
		progress.updateValueImmed(25);
		
		line = b.readLine().trim().toLowerCase();
		splits = line.split(" ");
		
		if(splits.length != 3)					return null;
		if(splits[0].indexOf("polygons") == -1)	return null;
		
		poly_num	= Integer.parseInt(splits[1]);
		
		s.allocatePolygons(poly_num);
		
		Vector<Integer> poly;
		
		progress.setMessage("Reading Polygons ... ");
		
		System.out.println("Found " + poly_num + " polygons");
		if(FileType	== TriangleMesh.FILE_ASCII) 
			for(int i = 0 ; i < poly_num; ++i) {
				poly = new Vector<Integer>();				
				line = b.readLine().trim();				
				splits = line.split(" ");
				if(splits.length < 4)	return null;
				int vertices = Integer.parseInt(splits[0]);
				for(int j = 0; j < vertices; ++j) {
					int index = Integer.parseInt(splits[1 + j]);
					poly.addElement(index);
				}
				s.addPolygon(poly);					
			}
		
		progress.updateValueImmed(50);		
		progress.setMessage("Computing Normals ... ");
		s.computeNormals();
		
		progress.updateValueImmed(75);		
		progress.setMessage("Computing Bounding Box ...");
		s.computeBoundingBox();
		
		progress.setMessage("Surface Loaded");
		progress.updateValueImmed(100);
		
		
		b.close();
		System.out.println("Surface loaded");
		System.gc();
		return s;
	}
}