package edu.jhmi.rad.medic.visualization.primitives;

import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GL;
import javax.vecmath.Point3f;

public class BoundingBox {
	private Point3f minCoords;		//Minimum coordinate of bounding box
	private Point3f maxCoords;		//Maximum coordinate of bounding box
	
	public BoundingBox() {
		minCoords = new Point3f(0.0f,0.0f,0.0f);
		maxCoords = new Point3f(0.0f,0.0f,0.0f);
	}
	
	protected void finalize() {	
		minCoords = maxCoords = null;
	}
	
	public BoundingBox(Point3f min, Point3f max) {
		minCoords = new Point3f(min.x, min.y, min.z);
		maxCoords = new Point3f(max.x, max.y, max.z);		
	}
	
	public void setMinCoords(Point3f min) {
		minCoords.set(min.x, min.y, min.z);	
	}
	
	public Point3f getMinCoords() {
		return minCoords;
	}
	
	public void setMaxCoords(Point3f max) {
		maxCoords.set(max.x, max.y, max.z);
	}
	
	public Point3f getMaxCoords() {
		return maxCoords;
	}
	
	public void set(Point3f min, Point3f max) {
		minCoords.set(min.x, min.y, min.z);	
		maxCoords.set(max.x, max.y, max.z);
	}
	
	/*
	 * Draws the wire-frame bounding box for this surface.
	 *	@param	drawable	Object containing the active openGL reference
	 */
	public void drawGL(GLAutoDrawable drawable) {
		GL gl = drawable.getGL();
		gl.glBegin(GL.GL_LINE_LOOP);
    		gl.glVertex3f(minCoords.x, minCoords.y, minCoords.z);
    		gl.glVertex3f(maxCoords.x, minCoords.y, minCoords.z);
    		gl.glVertex3f(maxCoords.x, maxCoords.y, minCoords.z);        		
    		gl.glVertex3f(minCoords.x, maxCoords.y, minCoords.z);        		
    	gl.glEnd();
    	
    	gl.glBegin(GL.GL_LINE_LOOP);
    		gl.glVertex3f(minCoords.x, minCoords.y, minCoords.z);
    		gl.glVertex3f(minCoords.x, minCoords.y, maxCoords.z);
    		gl.glVertex3f(maxCoords.x, minCoords.y, maxCoords.z);        		
    		gl.glVertex3f(maxCoords.x, minCoords.y, minCoords.z);        		
    	gl.glEnd();
    	
    	gl.glBegin(GL.GL_LINE_LOOP);
    		gl.glVertex3f(minCoords.x, minCoords.y, minCoords.z);
    		gl.glVertex3f(maxCoords.x, minCoords.y, minCoords.z);
    		gl.glVertex3f(maxCoords.x, maxCoords.y, minCoords.z);        		
    		gl.glVertex3f(minCoords.x, maxCoords.y, minCoords.z);        		
    	gl.glEnd();
    	
    	gl.glBegin(GL.GL_LINE_LOOP);
    		gl.glVertex3f(maxCoords.x, maxCoords.y, maxCoords.z);
    		gl.glVertex3f(minCoords.x, maxCoords.y, maxCoords.z);
    		gl.glVertex3f(minCoords.x, maxCoords.y, minCoords.z);        		
    		gl.glVertex3f(maxCoords.x, maxCoords.y, minCoords.z);        		
    	gl.glEnd();
    	
		gl.glBegin(GL.GL_LINE_LOOP);
    		gl.glVertex3f(maxCoords.x, maxCoords.y, maxCoords.z);
    		gl.glVertex3f(maxCoords.x, minCoords.y, maxCoords.z);
    		gl.glVertex3f(maxCoords.x, minCoords.y, minCoords.z);        		
    		gl.glVertex3f(maxCoords.x, maxCoords.y, minCoords.z);        		
    	gl.glEnd();        	
    	
    	gl.glBegin(GL.GL_LINE_LOOP);
    		gl.glVertex3f(maxCoords.x, maxCoords.y, maxCoords.z);
    		gl.glVertex3f(minCoords.x, maxCoords.y, maxCoords.z);
    		gl.glVertex3f(minCoords.x, minCoords.y, maxCoords.z);        		
    		gl.glVertex3f(maxCoords.x, minCoords.y, maxCoords.z);        		
    	gl.glEnd(); 
	}
}