package edu.jhu.ece.iacl.algorithms.graphics.locator.balltree;

import javax.vecmath.Vector3d;

import edu.jhu.ece.iacl.algorithms.graphics.GeometricUtilities;

/**
 * A Bounding ball edge is used to split a ball in half along an axis defined by
 * the edge vector.
 * 
 * @author Blake Lucas
 * 
 */
public class BBallEdge implements Comparable<BBallEdge> {
	private double val;
	private Ball ball;
	/**
	 * Get ball
	 * @return ball edge
	 */
	public Ball getBall() {
		return ball;
	}
	/**
	 * Get ball tree edge
	 * @param b ball
	 * @param v edge direction
	 */
	public BBallEdge(Ball b, Vector3d v) {
		ball = b;
		val = GeometricUtilities.dot(b, v);
	}
	/**
	 * Set ball and edge direction
	 * @param b ball
	 * @param v edge direciton
	 */
	public void set(Ball b, Vector3d v) {
		this.ball = b;
		val = GeometricUtilities.dot(b, v);
	}

	public BBallEdge() {
		ball = null;
		val = 0;
	}

	public BBallEdge clone() {
		BBallEdge e = new BBallEdge();
		e.val = val;
		e.ball = ball;
		return e;
	}

	public int compareTo(BBallEdge e1) {
		return (int) Math.signum(this.val - e1.val);
	}

}
