package edu.jhu.ece.iacl.algorithms.graphics.locator.balltree;

import java.util.List;

import javax.vecmath.Point3d;
import javax.vecmath.Point3f;

/**
 * A ball used to store a single 3D point and a reference into a data array.
 * This object is used for leaf nodes.
 * 
 * @author Blake
 * 
 */
public class PointBall extends Ball {
	protected int index;

	public PointBall(Point3d p, int index) {
		super(p);
		this.index = index;
	}

	public PointBall(Point3f p, int index) {
		super(p);
		this.index = index;
	}

	public int getIndex() {
		return index;
	}

	public void setIndex(int index) {
		this.index = index;
	}

	public PointBall(double x, double y, double z) {
		super(x, y, z);
	}

	public PointBall(Point3d p) {
		super(p);
	}

	public PointBall(Point3f p) {
		super(p);
	}

	public List<Ball> getChildren() {
		return null;
	}

	public int getDepth() {
		return (parent != null) ? parent.getDepth() + 1 : 0;
	}

	public double getRadius() {
		return 0;
	}

	public void setDepth(int d) {
	}

	public void updateDescendants() {
	}

	public boolean isLeaf() {
		return true;
	}

	public void updateAncestors() {
		if (parent != null)
			parent.updateAncestors();
	}

}
