package edu.jhu.ece.iacl.algorithms.graphics.utilities.quickhull;

/**
 * Maintains a single-linked list of faces for use by QuickHull3D
 */
class QFaceList
{
	private QFace head;
	private QFace tail;

	/**
	 * Clears this list.
	 */
	public void clear()
	 {
	   head = tail = null; 
	 }

	/**
	 * Adds a vertex to the end of this list.
	 */
	public void add (QFace vtx)
	 { 
	   if (head == null)
	    { head = vtx;
	    }
	   else
	    { tail.next = vtx; 
	    }
	   vtx.next = null;
	   tail = vtx;
	 }

	public QFace first()
	 {
	   return head;
	 }

	/**
	 * Returns true if this list is empty.
	 */
	public boolean isEmpty()
	 {
	   return head == null;
	 }
}
