package edu.jhu.ece.iacl.algorithms.graphics.utilities.rbf;

import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

/**
 * Abstract class for floating point radial basis function operations.
 * 
 * @author Blake Lucas
 * 
 */
public abstract class RadialBasisFunctionDouble {
	protected RadialFunctionType radialFunc;
	protected double alpha = 1;
	protected double C = 1;
	protected Point3d[] points;
	protected double[] lambda;
	protected double[] chi;

	protected abstract void computeCoefficients();

	public abstract double evalFunc(Point3d p1, Point3d p2);

	public abstract Vector3d evalFuncGradient(Point3d p1, Point3d p2);
}
