package edu.jhu.ece.iacl.algorithms.gvf;

import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;

/**
 * Down sample volume to specified dimensions X by Y by Z using trilinear
 * interpolation on neighboring voxels
 * 
 * @author Blake Lucas
 * 
 */
public class DownSample3dTrilinear extends DownSample3d {
	private static final DownSample3dTrilinear downSample = new DownSample3dTrilinear();

	public static ImageDataFloat doSolve(ImageDataFloat in, int x, int y, int z) {
		return downSample.solve(in, x, y, z);
	}

	/**
	 * Down sample matrix to specified dimensions
	 * 
	 * @param xo
	 *            x dimension must be smaller than input dimension
	 * @param yo
	 *            y dimension must be smaller than input dimension
	 * @param zo
	 *            z dimension must be smaller than input dimension
	 * @param in
	 *            3D matrix representation of volume
	 */
	public ImageDataFloat solve(ImageDataFloat in, int xo, int yo, int zo) {
		int xi = in.getRows();
		int yi = in.getCols();
		int zi = in.getSlices();
		ImageDataFloat out = new ImageDataFloat(xo, yo, zo);
		int inew, jnew, knew, ic, jc, kc;
		float scalex, scaley, scalez, wx, wy, wz, tmpv;
		float zn, z0, z1, z2, yn, y0, y1, y2, xn, x0, x1, x2;
		int prevz, prevy, prevx, nextx1, nextx2, nexty1, nexty2, nextz1, nextz2;
		float[][][] outmat=out.toArray3d();
		float[][][] inmat=in.toArray3d();
		scalex = (zi - 1.0f) / (zo - 1.0f);
		scaley = (yi - 1.0f) / (yo - 1.0f);
		scalez = (xi - 1.0f) / (xo - 1.0f);

		for (knew = 0; knew < xo; knew++) {
			tmpv = (float) knew * scalez;
			kc = (int) Math.floor(tmpv);
			wz = tmpv - (float) kc;
			if (knew == 0) {
				zn = 0.25f;
				z0 = 0.5f;
				z1 = 0.25f;
				z2 = 0;
				prevz = 0;
				kc = 0;
				nextz1 = 1;
				nextz2 = 1;
			} else if (knew == (xo - 1)) {
				zn = 0.25f;
				z0 = 0.5f;
				z1 = 0.25f;
				z2 = 0;
				prevz = xi - 2;
				kc = xi - 1;
				nextz1 = xi - 1;
				nextz2 = xi - 1;
			} else {
				zn = (1.0f - wz) * 0.25f;
				z0 = (2.0f - wz) * 0.25f;
				z1 = (1.0f + wz) * 0.25f;
				z2 = wz * 0.25f;
				prevz = kc - 1;
				nextz1 = kc + 1;
				nextz2 = kc + 2;
			}
			for (inew = 0; inew < yo; inew++) {
				tmpv = (float) inew * scaley;
				ic = (int) Math.floor(tmpv);
				wy = tmpv - (float) ic;
				if (inew == 0) {
					yn = 0.25f;
					y0 = 0.5f;
					y1 = 0.25f;
					y2 = 0;
					prevy = 0;
					ic = 0;
					nexty1 = 1;
					nexty2 = 1;
				} else if (inew == (yo - 1)) {
					yn = 0.25f;
					y0 = 0.5f;
					y1 = 0.25f;
					y2 = 0;
					prevy = yi - 2;
					ic = yi - 1;
					nexty1 = yi - 1;
					nexty2 = yi - 1;
				} else {
					yn = (1.0f - wy) * 0.25f;
					y0 = (2.0f - wy) * 0.25f;
					y1 = (1.0f + wy) * 0.25f;
					y2 = wy * 0.25f;
					prevy = ic - 1;
					nexty1 = ic + 1;
					nexty2 = ic + 2;
				}
				for (jnew = 0; jnew < zo; jnew++) {
					tmpv = (float) jnew * scalex;
					jc = (int) Math.floor(tmpv);
					wx = tmpv - (float) jc;
					if (jnew == 0) {
						xn = 0.25f;
						x0 = 0.5f;
						x1 = 0.25f;
						x2 = 0;
						prevx = 0;
						jc = 0;
						nextx1 = 1;
						nextx2 = 1;
					} else if (jnew == (zo - 1)) {
						xn = 0.25f;
						x0 = 0.5f;
						x1 = 0.25f;
						x2 = 0;
						prevx = zi - 2;
						jc = zi - 1;
						nextx1 = zi - 1;
						nextx2 = zi - 1;
					} else {
						xn = (1.0f - wx) * 0.25f;
						x0 = (2.0f - wx) * 0.25f;
						x1 = (1.0f + wx) * 0.25f;
						x2 = wx * 0.25f;
						prevx = jc - 1;
						nextx1 = jc + 1;
						nextx2 = jc + 2;
					}

					tmpv = zn
							* (yn
									* (xn * inmat[prevz][prevy][prevx] + x0
											* inmat[prevz][prevy][jc] + x1
											* inmat[prevz][prevy][nextx1] + x2
											* inmat[prevz][prevy][nextx2])
									+ y0
									* (xn * inmat[prevz][ic][prevx] + x0
											* inmat[prevz][ic][jc] + x1
											* inmat[prevz][ic][nextx1] + x2
											* inmat[prevz][ic][nextx2])
									+ y1
									* (xn * inmat[prevz][nexty1][prevx] + x0
											* inmat[prevz][nexty1][jc] + x1
											* inmat[prevz][nexty1][nextx1] + x2
											* inmat[prevz][nexty1][nextx2]) + y2
									* (xn * inmat[prevz][nexty2][prevx] + x0
											* inmat[prevz][nexty2][jc] + x1
											* inmat[prevz][nexty2][nextx1] + x2
											* inmat[prevz][nexty2][nextx2]));

					tmpv += z0
							* (yn
									* (xn * inmat[kc][prevy][prevx] + x0
											* inmat[kc][prevy][jc] + x1
											* inmat[kc][prevy][nextx1] + x2
											* inmat[kc][prevy][nextx2])
									+ y0
									* (xn * inmat[kc][ic][prevx] + x0
											* inmat[kc][ic][jc] + x1
											* inmat[kc][ic][nextx1] + x2
											* inmat[kc][ic][nextx2])
									+ y1
									* (xn * inmat[kc][nexty1][prevx] + x0
											* inmat[kc][nexty1][jc] + x1
											* inmat[kc][nexty1][nextx1] + x2
											* inmat[kc][nexty1][nextx2]) + y2
									* (xn * inmat[kc][nexty2][prevx] + x0
											* inmat[kc][nexty2][jc] + x1
											* inmat[kc][nexty2][nextx1] + x2
											* inmat[kc][nexty2][nextx2]));

					tmpv += z1
							* (yn
									* (xn * inmat[nextz1][prevy][prevx] + x0
											* inmat[nextz1][prevy][jc] + x1
											* inmat[nextz1][prevy][nextx1] + x2
											* inmat[nextz1][prevy][nextx2])
									+ y0
									* (xn * inmat[nextz1][ic][prevx] + x0
											* inmat[nextz1][ic][jc] + x1
											* inmat[nextz1][ic][nextx1] + x2
											* inmat[nextz1][ic][nextx2])
									+ y1
									* (xn * inmat[nextz1][nexty1][prevx] + x0
											* inmat[nextz1][nexty1][jc] + x1
											* inmat[nextz1][nexty1][nextx1] + x2
											* inmat[nextz1][nexty1][nextx2]) + y2
									* (xn * inmat[nextz1][nexty2][prevx] + x0
											* inmat[nextz1][nexty2][jc] + x1
											* inmat[nextz1][nexty2][nextx1] + x2
											* inmat[nextz1][nexty2][nextx2]));

					tmpv += z2
							* (yn
									* (xn * inmat[nextz2][prevy][prevx] + x0
											* inmat[nextz2][prevy][jc] + x1
											* inmat[nextz2][prevy][nextx1] + x2
											* inmat[nextz2][prevy][nextx2])
									+ y0
									* (xn * inmat[nextz2][ic][prevx] + x0
											* inmat[nextz2][ic][jc] + x1
											* inmat[nextz2][ic][nextx1] + x2
											* inmat[nextz2][ic][nextx2])
									+ y1
									* (xn * inmat[nextz2][nexty1][prevx] + x0
											* inmat[nextz2][nexty1][jc] + x1
											* inmat[nextz2][nexty1][nextx1] + x2
											* inmat[nextz2][nexty1][nextx2]) + y2
									* (xn * inmat[nextz2][nexty2][prevx] + x0
											* inmat[nextz2][nexty2][jc] + x1
											* inmat[nextz2][nexty2][nextx1] + x2
											* inmat[nextz2][nexty2][nextx2]));

					outmat[knew][inew][jnew] = tmpv;

				}
			}
		}
		return out;
	}
}
